class TeamspeakInfo expands ReplicationInfo;

// ---------------------------------------------------------------------------------
// TeamSpeak Mutator v03b
// ---------------------------------------------------------------------------------
// Enables a player to connect to a teamspeak server ingame using the commands:
// "mutate teamspeak" to connect to their respective team-subchannel
// "mutate tsb" to connect to the blueteam-subchannel
// "mutate tsr" to connect to the redteam-subchannel
// "mutate tst" to connect to the together-subchannel
// "mutate tss" to connect to the spectator-subchannel
// "mutate tch channelname" to connect to the channel "channelname"
//
// Changes by smaankerezz since v3a
// - settings from the ini file are properly loaded, thnx rednas :)
// - two configurable welcome messages depending on whether or not bEnableCommands 
//   is set to true.
//
// Changes by smaankerezz since v2 by rednas & idefix:
// - a player can also connect to a channel of their own choice using tch
// - shows the player to which server, channel and subchannel it is connecting
// - added the playername characters {}<>`+| also to be changed into "" 
// - changed the channeling a bit 
//
// ---------------------------------------------------------------------------------

var string sURL;			// Replicated

replication
{
	reliable if ( ROLE == ROLE_Authority)
		sURL, StartTS;
}

simulated function StartTS(string sServerInfo, string sChannelInfo, string sSubChannelInfo)
{
	local PlayerPawn pp;

	if (Owner!=None)
	{
		pp = PlayerPawn(Owner);
		if (pp!=None && pp.Player!=None && pp.Player.Console !=None)
		{
			pp.ClientMessage(">> Connecting to teamspeak..");
			
			pp.ClientMessage(sServerInfo);
			pp.ClientMessage(sChannelInfo);
			if (sSubChannelInfo != "") {
				pp.ClientMessage(sSubChannelInfo);
			}

			pp.ConsoleCommand("START " $ sURL);
		}
	}

	Destroy();
}

defaultproperties
{
}
