//////////////////////////////////////////////////////////////////////////////
// uUtils - UScript Utils class
//		Feralidragon - 10-07-2013
//
//		uWebDrvX 0.1
//////////////////////////////////////////////////////////////////////////////

class uUtils extends Object 
abstract;


final static function string getPackageName(optional string ClassFullName)
{
	if (ClassFullName == "")
		ClassFullName = String(default.Class);
	return Left(ClassFullName, InStr(ClassFullName, "."));
}


final static function bool stripLeadingWhiteSpaces(out string str)
{
local string c, CR, LF, TAB;
local bool had_wspaces;

	CR = Chr(13);
	LF = Chr(10);
	TAB = Chr(9);
	c = Mid(str, 0, 1);
	while (c == " " || c == TAB || c == CR || c == LF)
	{
		str = Mid(str, 1);
		c = Mid(str, 0, 1);
		had_wspaces = True;
	}
	return had_wspaces;
}

final static function int getClosestWhiteSpacePos(string str)
{
local int pos, pos2;
	
	pos = InStr(str, " ");
	
	pos2 = InStr(str, Chr(13));
	if (pos >= 0 && pos2 >= 0)
		pos = Min(pos, pos2);
	else if (pos2 >= 0)
		pos = pos2;
	
	pos2 = InStr(str, Chr(10));
	if (pos >= 0 && pos2 >= 0)
		pos = Min(pos, pos2);
	else if (pos2 >= 0)
		pos = pos2;
		
	pos2 = InStr(str, Chr(9));
	if (pos >= 0 && pos2 >= 0)
		pos = Min(pos, pos2);
	else if (pos2 >= 0)
		pos = pos2;
		
	return pos;
}


defaultproperties
{
}


