//////////////////////////////////////////////////////////////////////////////
// uJSON - UScript JSON parser
//		Feralidragon - 02-07-2013
//
//		uWebDrvX 0.1
//////////////////////////////////////////////////////////////////////////////

class uJSON extends Object;

struct jItem 
{
	var string prop;
	var string val;
	var string type;
};
var private jItem jList[512];
var private int jListSize;
var private string jErrors[12];
var private byte jLastError;


final function bool parseJSON(string json, optional bool bStrict)
{
local string jtemp;
local bool has_next;
local int firstBrack, brackSearch, endBrack, bPos;

	if (!bStrict)
	{
		firstBrack = InStr(json, "{");
		if (firstBrack < 0)
		{
			jLastError = 2;
			return False;
		}
		json = Mid(json, firstBrack);
		
		endBrack = -1;
		do
		{
			bPos = Len(json) - 1 - brackSearch;
			if (Mid(json, bPos, 1) != "}")
				brackSearch++;
			else
				endBrack = bPos;
		}
		until (endBrack >= 0 || brackSearch >= 64)

		if (endBrack >= 0)
			json = Mid(json, 0, bPos + 1);
	}

	if (json == "{}")
	{
		jLastError = 1;
		return False;
	}
	if (Len(json) < 7 || Mid(json, 0, 1) != "{" || Mid(json, Len(json)-1, 1) != "}")
	{
		jLastError = 2;
		return False;
	}

	jtemp = Mid(json, 1);
	cleanAll();
	do {has_next = processJNext(jtemp);}
	until (!has_next || jLastError > 0)
	
	return (jLastError > 0);
}


final function string getJSONString(optional bool escapeSlashes1, optional bool escapeSlashes2)
{
	return getJSONStrObj(,,, escapeSlashes1, escapeSlashes2);
}


final function string getJSONStrObj(optional string backprop, optional string prop, optional out int fromIndex, 
optional bool escapeSlashes1, optional bool escapeSlashes2)
{
local string dqt, jsonstr, jprop, objprop, val, backprop2;
local string arr_name, arr_cmpname, arr_elem, arr_cmpelem, sep;
local int i, j, size, pos_dot, pos_arrcount, arr_size;

	jsonstr = "{";
	dqt = chr(34);
	size = Min(jListSize, ArrayCount(jList));
	for (i = fromIndex; i < size; i++)
	{
		if ((Len(backprop) > 0 && InStr(jList[i].prop, backprop$".") < 0) || (Len(prop) > 0 && InStr(jList[i].prop, prop$".") < 0))
		{
			fromIndex = i - 1;
			return (jsonstr $ "}");
		}
		
		if (i > fromIndex)
			jsonstr = jsonstr $ ",";
		if (Len(prop) > 0)
			jprop = Mid(jList[i].prop, Len(backprop) + int(Len(backprop) > 0) + Len(prop) + 1);
		else
			jprop = jList[i].prop;

		pos_dot = InStr(jprop, ".");
		if (jList[i].type ~= "array")
		{
			arr_size = int(jList[i].val);
			pos_arrcount = InStr(Caps(jprop), ".COUNT()");
			if (pos_arrcount < 0)
			{
				jLastError = 12;
				return "";
			}
			
			if (Len(prop) > 0)
			{
				if (Len(backprop) > 0)
					backprop2 = backprop $ "." $ prop;
				else
					backprop2 = prop;
			}
			arr_name = Mid(jprop, 0, pos_arrcount);
			if (Len(backprop2) > 0)
				arr_cmpname = backprop2 $ "." $ arr_name;
			else
				arr_cmpname = arr_name;
			
			j = 0;
			i++;
			arr_elem = arr_name$"["$j$"]";
			arr_cmpelem = arr_cmpname$"["$j$"]";
			jsonstr = jsonstr $ dqt $ arr_name $ dqt $ ":" $ "[";
			while (j < arr_size && InStr(jList[i].prop, arr_cmpelem) == 0)
			{
				if (j == 0)
					sep = "";
				else
					sep = ",";
				
				pos_dot = -1;
				if (InStr(jList[i].prop, arr_cmpelem$".") == 0)
				{
					jsonstr = jsonstr $ sep $ getJSONStrObj(backprop2, arr_elem, i, escapeSlashes1, escapeSlashes2);
					if (jLastError > 0)
						return "";
				}
				else
				{
					val = jList[i].val;
					sanitizeJSONVal(val, escapeSlashes1, escapeSlashes2);
					if (jList[i].type ~= "string" || jList[i].type ~= "mixed")
						val = dqt $ val $ dqt;
					jsonstr = jsonstr $ sep $ val;
				}
				
				i++;
				if (InStr(jList[i].prop, arr_cmpelem) != 0)
				{
					j++;
					arr_elem = arr_name$"["$j$"]";
					arr_cmpelem = arr_cmpname$"["$j$"]";
				}
			}
			i--;
			jsonstr = jsonstr $ "]";
		}
		else if (pos_dot > 0)
		{
			objprop = Mid(jprop, 0, pos_dot);
			if (Len(prop) > 0)
			{
				if (Len(backprop) > 0)
					backprop2 = backprop $ "." $ prop;
				else
					backprop2 = prop;
			}
			jsonstr = jsonstr $ dqt $ objprop $ dqt $ ":" $ getJSONStrObj(backprop2, objprop, i, escapeSlashes1, escapeSlashes2);
			if (jLastError > 0)
				return "";
		}
		else
		{
			val = jList[i].val;
			sanitizeJSONVal(val, escapeSlashes1, escapeSlashes2);
			if (jList[i].type ~= "string" || jList[i].type ~= "mixed")
				val = dqt $ val $ dqt;
			jsonstr = jsonstr $ dqt $ jprop $ dqt $ ":" $ val;
		}
		
		fromIndex = i;
	}
	
	return (jsonstr $ "}");
}


final function string getJSONProp(string prop, optional out int sIndex, optional out string type)
{
local int i, size;

	type = "NULL";
	if (prop == "")
	{
		sIndex = -1;
		return "";
	}

	size = Min(jListSize, ArrayCount(jList));
	for (i = sIndex; i < size; i++)
	{
		if (jList[i].prop ~= prop)
		{
			sIndex = i;
			type = jList[i].type;
			return jList[i].val;
		}
	}
	sIndex = -1;
	return "";
}


final function bool updateInJList(string prop, string val, optional string type)
{
local int index;
local string type2;

	getJSONProp(prop, index, type2);
	if (index < 0)
		return False;
	if (type == "")
		type = type2;
	return setInJList(index, prop, val, type);
}


final function cleanAll()
{
local int i;

	for (i = 0; i < jListSize; i++)
	{
		jList[i].prop = "";
		jList[i].val = "";
		jList[i].type = "";
	}
	jListSize = 0;
}


final function bool processJNext(out string json, optional string prop)
{
local string dqt, c, cx, cx2, val, CR, LF, TAB, cws, type, prop_array;
local int pos, spointer, i;
local bool hasNext, is_array_end;

	//Check first "
	Class'uUtils'.static.stripLeadingWhiteSpaces(json);
	dqt = chr(34);
	if (Mid(json, 0, 1) != dqt)
	{
		jLastError = 4;
		return False;
	}
	
	//Check property "prop"
	json = Mid(json, 1);
	pos = InStr(json, dqt);
	if (pos <= 0)
	{
		jLastError = 4;
		return False;
	}
	if (Len(prop) > 0)
		prop = prop$"."$Mid(json, 0, pos);
	else
		prop = Mid(json, 0, pos);
	
	//Check property end :
	json = Mid(json, pos + 1);
	Class'uUtils'.static.stripLeadingWhiteSpaces(json);
	if (Mid(json, 0, 1) != ":")
	{
		jLastError = 4;
		return False;
	}
	
	//Handle property value
	json = Mid(json, 1);
	Class'uUtils'.static.stripLeadingWhiteSpaces(json);
	c = Mid(json, 0, 1);
	if (c == "[") //Array
	{
		json = Mid(json, 1);
		Class'uUtils'.static.stripLeadingWhiteSpaces(json);
		cx = Mid(json, 0, 1);
		spointer = jListSize;
		jListSize++;
		i = 0;
		if (cx != "]")
		{
			do
			{
				prop_array = prop$"["$i$"]";
				if (cx == "{")
				{
					json = Mid(json, 1);
					Class'uUtils'.static.stripLeadingWhiteSpaces(json);
					cx2 = Mid(json, 0, 1);
					if (cx2 != "}")
					{
						do {hasNext = processJNext(json, prop_array);}
						until (!hasNext || jLastError > 0)
					}
					type = "OBJECT";
				}
				else if (cx == "0" || cx == "-" || byte(cx) >= 1)
				{
					val = getJVal(json, "float");
					if (InStr(val, ".") >= 0)
						type = "FLOAT";
					else
						type = "INT";
				}
				else if (cx ~= "t" || cx ~= "f")
				{
					val = getJVal(json, "bool");
					type = "BOOL";
				}
				else if (cx ~= "n") //Null value
				{
					val = getJVal(json, "null");
					type = "NULL";
				}
				else if (cx == dqt)
				{
					val = getJVal(json, "string");
					type = "STRING";
				}
				else
				{
					jLastError = 5;
					return False;
				}
				
				if (jLastError > 0)
					return False;
				
				if (type != "OBJECT")
					addToJList(prop_array, val, type);
				Class'uUtils'.static.stripLeadingWhiteSpaces(json);
				cx = Mid(json, 0, 1);
				i++;
				if (cx == ",")
				{
					json = Mid(json, 1);
					Class'uUtils'.static.stripLeadingWhiteSpaces(json);
					cx = Mid(json, 0, 1);
				}
				else
					is_array_end = True;
			}
			until (is_array_end)
		}
		
		if (cx != "]")
		{
			jLastError = 10;
			return False;
		}
		setInJList(spointer, prop$".count()", string(i), "ARRAY");
		json = Mid(json, 1);
	}
	else if (c == "{") //Object
	{
		json = Mid(json, 1);
		Class'uUtils'.static.stripLeadingWhiteSpaces(json);
		cx2 = Mid(json, 0, 1);
		if (cx2 != "}")
		{
			do {hasNext = processJNext(json, prop);}
			until (!hasNext || jLastError > 0)
		}
	}
	else if (c == "0" || c == "-" || byte(c) >= 1) //Number 
	{
		val = getJVal(json, "float");
		if (InStr(val, ".") >= 0)
			addToJList(prop, val, "FLOAT");
		else
			addToJList(prop, val, "INT");
	}
	else if (c ~= "t" || c ~= "f") //Boolean
	{
		val = getJVal(json, "bool");
		addToJList(prop, val, "BOOL");
	}
	else if (c ~= "n") //Null value
	{
		val = getJVal(json, "null");
		addToJList(prop, val, "NULL");
	}
	else if (c == dqt) //String
	{
		val = getJVal(json, "string");
		addToJList(prop, val, "STRING");
	}
	else //Unknown type (error)
	{
		jLastError = 5;
		return False;
	}
	
	if (jLastError > 0)
		return False;
	
	Class'uUtils'.static.stripLeadingWhiteSpaces(json);
	c = Mid(json, 0, 1);
	if (c == "," || c == "}")
	{
		json = Mid(json, 1);
		Class'uUtils'.static.stripLeadingWhiteSpaces(json);
		return (c == ",");
	}
	jLastError = 6;
	return False;
}


final function stripEndingWhiteSpaces(out string json)
{
local string c, CR, LF, TAB, cws;

	CR = Chr(13);
	LF = Chr(10);
	TAB = Chr(9);
	c = Mid(json, 0, 1);
	while (c != " " && c != TAB && c != CR && c != LF && c != "")
	{
		cws = cws $ c;
		json = Mid(json, 1);
		c = Mid(json, 0, 1);
	}
	json = cws;
}


final function string getJVal(out string json, string type)
{
local int pos, pinit, i, paux;
local string val, c, c2, dqt, eSlsh, jtemp, jtemp2;
local bool foundDecPoint, is_strend;

	dqt = chr(34);
	eSlsh = chr(92);
	jtemp = json;
	if (type ~= "string")
	{
		jtemp = Mid(jtemp, 1);
		pinit = InStr(jtemp, dqt);
		do 
		{
			pos = InStr(jtemp, eSlsh$dqt);
			if (pos >= 0 && pos == (pinit-1))
				jtemp = Mid(jtemp, pos + 2);
			else
				is_strend = true;
			pinit = InStr(jtemp, dqt);
		}
		until (is_strend);

		pos = pinit + 1;
		jtemp2 = Mid(jtemp, pos);
		Class'uUtils'.static.stripLeadingWhiteSpaces(jtemp2);
		c = Mid(jtemp2, 0, 1);
		if (c != "," && c != "]" && c != "}")
			pos = -1;
	}
	else
	{
		Class'uUtils'.static.stripLeadingWhiteSpaces(jtemp);
		pos = InStr(jtemp, ",");
		paux = InStr(jtemp, "]");
		if (pos < 0)
			pos = paux;
		else if (paux >= 0)
			pos = Min(pos, paux);
		paux = InStr(jtemp, "}");
		if (pos < 0)
			pos = paux;
		else if (paux >= 0)
			pos = Min(pos, paux);
	}
	
	if (pos < 0)
	{
		jLastError = 6;
		return "";
	}
	
	pos += (Len(json) - Len(jtemp));
	val = Mid(json, 0, pos);
	if (!(type ~= "string"))
		stripEndingWhiteSpaces(val);
	if (type ~= "float")
	{
		for (i = 0; i < Len(val); i++)
		{
			c = Mid(val, i, 1);
			if (c != "0" && byte(c) < 1 && (i > 0 || c != "-") && (foundDecPoint || c != "."))
			{
				jLastError = 7;
				return "";
			}
			else if (c == ".")
				foundDecPoint = True;
		}
	}
	else if (type ~= "bool")
	{
		if (!(val ~= "TRUE" || val ~= "FALSE"))
		{
			jLastError = 8;
			return "";
		}
	}
	else if (type ~= "null")
	{
		if (!(val ~= "NULL"))
		{
			jLastError = 11;
			return "";
		}
	}
	else if (type ~= "string")
	{
		c = Mid(val, 0, 1);
		c2 = Mid(val, Len(val)-1, 1);
		if (c != dqt || c2 != dqt)
		{
			jLastError = 9;
			return "";
		}
		val = Mid(val, 1, Len(val)-2);
	}
	else
	{
		jLastError = 5;
		return "";
	}
	
	json = Mid(json, Len(val));
	if (type ~= "string")
	{
		json = Mid(json, 2);
		escapeSlashes(val);
	}
	return val;
}


final function escapeSlashes(out string val)
{
	stripEscapesStr(chr(34), val);
	stripEscapesStr(chr(47), val);
	stripEscapesStr(chr(92), val);
}

final function sanitizeJSONVal(out string val, optional bool escapeSlashes1, optional bool escapeSlashes2)
{
	addEscapesStr(chr(34), val);
	if (escapeSlashes1)
		addEscapesStr(chr(47), val);
	if (escapeSlashes2)
		addEscapesStr(chr(92), val);
}


final function stripEscapesStr(string c, out string S)
{
local string newS;
local int pos;

	if (c == "" || S == "")
		return;
	
	c = chr(92)$c;
	pos = InStr(S, c);
	while (pos >= 0)
	{
		newS = newS $ Mid(S, 0, pos);
		S = Mid(S, pos + 1);
		pos = InStr(S, c);
	}
	S = newS $ S;
}


final function addEscapesStr(string c, out string S)
{
local string newS;
local int pos;

	if (c == "" || S == "")
		return;
	
	pos = InStr(S, c);
	while (pos >= 0)
	{
		newS = newS $ Mid(S, 0, pos) $ chr(92) $ c;
		S = Mid(S, pos + 1);
		pos = InStr(S, c);
	}
	S = newS $ S;
}


final function bool setInJList(int index, string prop, string val, optional string type)
{
	if (index >= ArrayCount(jList))
	{
		jLastError = 3;
		return False;
	}
	type = Caps(type);
	if (type == "")
		type = "MIXED";
	jList[index].prop = prop;
	jList[index].val = val;
	jList[index].type = type;
	return True;
}


final function bool addToJList(string prop, string val, optional string type)
{
	if (jListSize >= ArrayCount(jList))
	{
		jLastError = 3;
		return False;
	}
	type = Caps(type);
	if (type == "")
		type = "MIXED";
	jList[jListSize].prop = prop;
	jList[jListSize].val = val;
	jList[jListSize].type = type;
	jListSize++;
	return True;
}


final function string getLastErrorMsg()
{
	if (jLastError >= 0)
		return jErrors[jLastError-1];
	return "";
}

final function int getLastErrorCode()
{
	return jLastError;
}

final function logJSONDump()
{
local int i, size;

	log("-----------------------------------------------------------------------------------------------");
	size = Min(jListSize, ArrayCount(jList));
	log("JSON Size = "$size);
	for (i = 0; i < size; i++)
		log(i$" => "$jList[i].prop$" = '"$jList[i].val$"' ("$jList[i].type$")");
	log("-----------------------------------------------------------------------------------------------");
}


defaultproperties
{
	jErrors(0)="Empty JSON received"
	jErrors(1)="Invalid JSON received"
	jErrors(2)="JSON register overflow"
	jErrors(3)="Malformed JSON: cannot find next property"
	jErrors(4)="Malformed JSON: property unknown format"
	jErrors(5)="Malformed JSON: no ending '}', ']' or ',' found"
	jErrors(6)="Malformed JSON: bad number value"
	jErrors(7)="Malformed JSON: bad boolean value"
	jErrors(8)="Malformed JSON: bad string value"
	jErrors(9)="Malformed JSON: malformed array"
	jErrors(10)="Malformed JSON: bad null value"
	jErrors(11)="Malformed JSON structure: cannot turn into JSON string"
}


