//////////////////////////////////////////////////////////////////////////////
// uDBSTable - UScript Database System Table
//		Feralidragon - 09-07-2013
//
//		uWebDrvX 0.1
//////////////////////////////////////////////////////////////////////////////

class uDBSTable extends Object config(uDBS)
abstract;

var() config int TotalSavedRows;
var int loadedSavedRows, colsSize;
var class<uDBS> uDBSClass;

struct uCol
{
	var() name ColClassName;
	var() name ColName;
	var() bool bUnique, bNotEmpty;
	var class<uDBSTCol> ColClass[16];
	var string ColQName;
};
var() uCol Cols[32];
var() byte HashMapCol;

enum EShardMode
{
	SM_None,
	SM_Linear,
	SM_HashMap,
};
var() EShardMode ShardMode;

enum EShardSize
{
	SSZ_128,
	SSZ_512,
	SSZ_2048,
};
var() EShardSize ShardSize;
var int shSize;


final static function int getColsSize()
{
	return default.colsSize;
}

final static function name getColsName(int n)
{
	if (n >= default.colsSize)
		return '';
	return default.Cols[n].ColName;
}

final static function string getColsQName(int n)
{
	if (n >= default.colsSize)
		return "";
	return default.Cols[n].ColQName;
}

final static function bool loadTable(class<uDBS> DBClass)
{
local int i, j, tSavedRows;
local string Pkg, FClass;

	default.uDBSClass = DBClass;
	if (default.uDBSClass == None)
		return False;
	default.loadedSavedRows = default.TotalSavedRows;
	default.colsSize = 0;
	default.shSize = int((2**(default.ShardSize*2)) * 128);
	for (i = 0; i < ArrayCount(default.Cols); i++)
	{
		if (default.Cols[i].ColName != '')
		{
			for (j = i + 1; j < ArrayCount(default.Cols); j++)
			{
				if (default.Cols[j].ColName != '' && default.Cols[j].ColName == default.Cols[i].ColName)
				{
					log("ERROR: Table could not be loaded: duplicated column name for '"$default.Cols[i].ColName$"'.", default.uDBSClass.default.DatabaseName);
					return False;
				}
			}
		}
	}
	
	Pkg = Class'uUtils'.static.getPackageName(String(default.Class));
	for (i = 0; i < ArrayCount(default.Cols); i++)
	{
		if (default.Cols[i].ColClassName != '')
		{
			if (default.Cols[i].ColName == '')
			{
				log("WARNING: No column name found for '"$default.Cols[i].ColClassName$"'.", default.uDBSClass.default.DatabaseName);
				default.Cols[i].ColName = default.Cols[i].ColClassName;
			}
			
			FClass = Pkg$"."$default.Cols[i].ColClassName;
			default.Cols[i].ColQName = Caps(String(default.Cols[i].ColName));
			if (default.ShardMode == SM_None)
				default.Cols[i].ColClass[0] = class<uDBSTCol>(DynamicLoadObject(FClass, class'Class'));
			else
			{
				for (j = 0; j < 16; j++)
				{
					default.Cols[i].ColClass[j] = class<uDBSTCol>(DynamicLoadObject(FClass$"_"$Caps(Class'uHash'.default.HEX_CHARS[j]), class'Class'));
					if (default.Cols[i].ColClass[j] == None)
					{
						log("ERROR: Table could not be loaded: shard "$j$" for column '"$default.Cols[i].ColClassName$"' not found.", default.uDBSClass.default.DatabaseName);
						return False;
					}
					else if (j > 0 && default.Cols[i].ColClass[j].static.getType() != default.Cols[i].ColClass[0].static.getType())
					{
						log("ERROR: Table could not be loaded: shard "$j$" for column '"$default.Cols[i].ColClassName$"' type mismatch.", default.uDBSClass.default.DatabaseName);
						return False;
					}
					else if (j > 0 && default.Cols[i].ColClass[j].static.getRealSize() != default.Cols[i].ColClass[0].static.getRealSize())
					{
						log("ERROR: Table could not be loaded: shard "$j$" for column '"$default.Cols[i].ColClassName$"' real size mismatch.", default.uDBSClass.default.DatabaseName);
						return False;
					}
				}
			}
		}
		
		if (default.Cols[i].ColClass[0] == None)
		{
			if (default.Cols[i].ColClassName != '')
			{
				log("ERROR: Table could not be loaded: column class name for '"$default.Cols[i].ColClassName$"' not found.", default.uDBSClass.default.DatabaseName);
				return False;
			}
			default.colsSize = i;
			break;
		}
		
		if (i == (ArrayCount(default.Cols) - 1))
			default.colsSize = i + 1;
	}
	
	for (i = 0; i < default.colsSize; i++)
	{
		if (default.Cols[i].ColClass[0].static.getRealSize() != default.shSize)
		{
			log("ERROR: Table could not be loaded: column size mismatch with table: "$
				"Expected="$default.shSize$"; "$
				"Detected="$default.Cols[i].ColClass[0].static.getRealSize()$".", default.uDBSClass.default.DatabaseName);
			return False;
		}
		else if (default.ShardMode == SM_None)
		{
			if (!default.Cols[i].ColClass[0].static.loadCol(default.uDBSClass, default.Class))
			{
				log("ERROR: Table could not be loaded: failed to load data for column '"$default.Cols[i].ColName$"'.", default.uDBSClass.default.DatabaseName);
				return False;
			}
			tSavedRows = default.Cols[i].ColClass[0].static.getSize();
		}
		else
		{
			for (j = 0; j < 16; j++)
			{
				if (!default.Cols[i].ColClass[j].static.loadCol(default.uDBSClass, default.Class))
				{
					log("ERROR: Table could not be loaded: failed to load shard "$j$" data for column '"$default.Cols[i].ColName$"'.", default.uDBSClass.default.DatabaseName);
					return False;
				}
				tSavedRows += default.Cols[i].ColClass[j].static.getSize();
			}
		}
	}
	
	if (tSavedRows != default.loadedSavedRows)
	{
		log("ERROR: Table could not be loaded: saved rows mismatch (possible data corruption): "$
			"Expected="$default.loadedSavedRows$"; "$
			"Detected="$tSavedRows$".", default.uDBSClass.default.DatabaseName);
		return False;
	}
	
	return True;
}


defaultproperties
{
	ShardMode=SM_None
	ShardSize=SSZ_128
	HashMapCol=0
	Cols(0)=(ColClassName="uDBSTCol",ColName="MyColumn",bUnique=False,bNotEmpty=True)
}


