//Windows exclusive headers
#include <windows.h>
#include <string>
#include <process.h>
#include <iostream>
#include <fstream>
#include <zip.h>
#include <unzip.h>
using namespace std;

//Cross-platform headers
#include <curl.h>
#include <sqlite3.h>

//UEngine and project headers
#include <Engine.h>
#include <UnRender.h>
#define OMPCORE_API DLL_EXPORT
#include "OMPCoreClasses.h"

// This is some necessary C++/UnrealScript glue logic.
// If you forget this, you get a VC++ linker errors like:
// SampleClass.obj : error LNK2001: unresolved external symbol "class FName SAMPLENATIVEPACKAGE_SampleEvent" (?SAMPLENATIVEPACKAGE_SampleEvent@@3VFName@@A)
#define NAMES_ONLY
#define AUTOGENERATE_NAME(name) OMPCORE_API FName OMPCORE_##name=FName(UTEXT(#name),FNAME_Intrinsic);
#define AUTOGENERATE_FUNCTION(cls,idx,name)
#include "OMPCoreClasses.h"
#undef AUTOGENERATE_FUNCTION
#undef AUTOGENERATE_NAME
#undef NAMES_ONLY


//Implementation
IMPLEMENT_PACKAGE(OMPCore);
IMPLEMENT_CLASS(AOMPActor);
IMPLEMENT_CLASS(AOMPMut);
