
#include <OMPRender.h>

void UOMPRender::Init(UEngine* InEngine)
{
	UClass* NewRenderClass = UObject::StaticLoadClass(URender::StaticClass(), NULL, UTEXT("Render.Render"), NULL, LOAD_None, NULL); 
	Render = (URender*)UObject::StaticConstructObject(NewRenderClass);  
	Render->SetFlags(RF_Load);  
	Render->Init(InEngine);

	Super::Init(InEngine);

	debugf(NAME_Init, UTEXT("OMP Base Render is %s"), GetFullName());
}

UBOOL UOMPRender::Exec(const TCHAR* Cmd, FOutputDevice& Ar)
{
	return Render->Exec(Cmd, Ar);
}

void UOMPRender::PreRender(FSceneNode* Frame)
{
	Render->PreRender(Frame);
}

void UOMPRender::PostRender(FSceneNode* Frame)
{	
	Render->PostRender(Frame);
}

FSceneNode* UOMPRender::CreateMasterFrame(UViewport* Viewport, FVector Location, FRotator Rotation, FScreenBounds* Bounds)
{
	return Render->CreateMasterFrame(Viewport,Location,Rotation,Bounds);
}

FSceneNode* UOMPRender::CreateChildFrame(FSceneNode* Parent, FSpanBuffer* Span, ULevel* Level, INT iSurf, INT iZone, FLOAT Mirror, const FPlane& NearClip, const FCoords& Coords, FScreenBounds* Bounds)
{
	return Render->CreateChildFrame(Parent,Span,Level,iSurf,iZone,Mirror,NearClip,Coords,Bounds);
}

void UOMPRender::FinishMasterFrame()
{
	Render->FinishMasterFrame();
}

void UOMPRender::DrawWorld(FSceneNode* Frame)
{
	Render->DrawWorld(Frame);

	if (Frame->Viewport->RenDev->IsA(UOMPRenderDevice::StaticClass())){
		INT i = 0;
		UOMPRenderDevice* rDev = (UOMPRenderDevice*)Frame->Viewport->RenDev;
		rDev->prepareVertexBatchDrawing(Frame);
		UClass* AOMPActorClass = AOMPActor::StaticClass();
		for (INT i = 0; i < Frame->Level->Actors.Num(); i++){
			AActor* A = Frame->Level->Actors(i);
			if (A && !A->IsPendingKill() && A->IsA(AOMPActorClass))
				rDev->drawVertexBatchedActor(Frame, A);
		}
		rDev->finishVertexBatchDrawing(Frame);
	}
}

void UOMPRender::DrawActor(FSceneNode* Frame, AActor* Actor)
{
	Render->DrawActor(Frame, Actor);
}

UBOOL UOMPRender::Project(FSceneNode* Frame, const FVector &V, FLOAT &ScreenX, FLOAT &ScreenY, FLOAT* Scale)
{
	return Render->Project(Frame, V, ScreenX, ScreenY, Scale);
}

UBOOL UOMPRender::Deproject(FSceneNode* Frame, INT ScreenX, INT ScreenY, FVector& V)
{
	return Render->Deproject(Frame, ScreenX, ScreenY, V);
}

UBOOL UOMPRender::BoundVisible(FSceneNode* Frame, FBox* Bound, FSpanBuffer* SpanBuffer, FScreenBounds& Results)
{
	return Render->BoundVisible(Frame,Bound,SpanBuffer,Results);
}

void UOMPRender::GetVisibleSurfs(UViewport* Viewport, TArray<INT>& iSurfs)
{
	Render->GetVisibleSurfs(Viewport,iSurfs);
}

void UOMPRender::GlobalLighting(UBOOL Realtime, AActor* Owner, FLOAT& Brightness, FPlane& Color)
{
	Render->GlobalLighting(Realtime,Owner,Brightness,Color);
}

void UOMPRender::Precache(UViewport* Viewport)
{
	Render->Precache(Viewport);
}

void UOMPRender::DrawCircle(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector& Location, FLOAT Radius, UBOOL bScaleRadiusByZoom)
{
	Render->DrawCircle(Frame,Color,LineFlags,Location,Radius,bScaleRadiusByZoom);
}

void UOMPRender::DrawBox(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector Min, FVector Max)
{
	Render->DrawBox(Frame,Color,LineFlags,Min,Max);
}

void UOMPRender::DrawCylinder(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector& Location, FLOAT Radius, FLOAT Height)
{
	Render->DrawCylinder(Frame,Color,LineFlags,Location,Radius,Height);
}