/*=============================================================================
	UOMPRender.h: Rendering package header.
=============================================================================*/

//Windows exclusive headers
#include <windows.h>
#include <string>
#include <process.h>
#include <iostream>
#include <fstream>

//UEngine and project headers
#define OMPCORE_API DLL_IMPORT
#include <OMPCore.h>
#include <RenderPrivate.h>
#define OMPRENDER_API DLL_EXPORT

/*----------------------------------------------------------------------------
	API.
----------------------------------------------------------------------------*/

#ifndef OMPRENDER_API
	#define OMPRENDER_API DLL_IMPORT
#endif


class OMPRENDER_API UOMPRender : public UOMPRenderBase
{
	DECLARE_CLASS(UOMPRender, UOMPRenderBase, CLASS_Config, OMPRender)
	NO_DEFAULT_CONSTRUCTOR(UOMPRender);

public:
	URender* Render;

	// URenderBase interface.
	virtual void Init(UEngine* InEngine);
	virtual UBOOL Exec(const TCHAR* Cmd, FOutputDevice& Ar = *GLog);

	virtual void PreRender(FSceneNode* Frame);
	virtual void PostRender(FSceneNode* Frame);
	virtual void DrawWorld(FSceneNode* Frame);

	virtual UBOOL Deproject(FSceneNode* Frame, INT ScreenX, INT ScreenY, FVector& V);
	virtual UBOOL Project(FSceneNode* Frame, const FVector& V, FLOAT& ScreenX, FLOAT& ScreenY, FLOAT* Scale);

	virtual void DrawActor(FSceneNode* Frame, AActor* Actor);

	virtual void GetVisibleSurfs(UViewport* Viewport, TArray<INT>& iSurfs);

	virtual UBOOL BoundVisible(FSceneNode* Frame, FBox* Bound, FSpanBuffer* SpanBuffer, FScreenBounds& Results);
	virtual void GlobalLighting(UBOOL Realtime, AActor* Owner, FLOAT& Brightness, FPlane& Color );

	virtual FSceneNode* CreateMasterFrame(UViewport* Viewport, FVector Location, FRotator Rotation, FScreenBounds* Bounds);
	virtual FSceneNode* CreateChildFrame(FSceneNode* Frame, FSpanBuffer* Span, ULevel* Level, INT iSurf, INT iZone, FLOAT Mirror, const FPlane& NearClip, const FCoords& Coords, FScreenBounds* Bounds);
	virtual void FinishMasterFrame();

	virtual void DrawCircle(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector& Location, FLOAT Radius, UBOOL bScaleRadiusByZoom=0);
	virtual void DrawBox(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector Min, FVector Max);
	virtual void DrawCylinder(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector& Location, FLOAT Radius, FLOAT Height);

	virtual void Precache(UViewport* Viewport);
};

IMPLEMENT_PACKAGE(OMPRender);
IMPLEMENT_CLASS(UOMPRender);
