/*=============================================================================
	OpenGL1Funcs.h: OpenGL 1.x function declaration macros.

	Created 2010.

	Revision history:

=============================================================================*/

//OpenGL 1.x functions
GL1_PROC(void,glAlphaFunc,(GLenum,GLclampf))
GL1_PROC(void,glArrayElement,(GLint))
GL1_PROC(void,glBegin,(GLenum))
GL1_PROC(void,glBindTexture,(GLenum,GLuint))
GL1_PROC(void,glBlendFunc,(GLenum,GLenum))
GL1_PROC(void,glClear,(GLbitfield))
GL1_PROC(void,glClearColor,(GLclampf,GLclampf,GLclampf,GLclampf))
GL1_PROC(void,glClearDepth,(GLclampd))
GL1_PROC(void,glClearStencil,(GLint))
GL1_PROC(void,glClipPlane,(GLenum,const GLdouble*))
GL1_PROC(void,glColor3f,(GLfloat,GLfloat,GLfloat))
GL1_PROC(void,glColor3fv,(const GLfloat*))
GL1_PROC(void,glColor3ub,(GLubyte,GLubyte,GLubyte))
GL1_PROC(void,glColor3ubv,(const GLubyte*))
GL1_PROC(void,glColor4f,(GLfloat,GLfloat,GLfloat,GLfloat))
GL1_PROC(void,glColor4fv,(const GLfloat*))
GL1_PROC(void,glColor4ub,(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha))
GL1_PROC(void,glColor4ubv,(const GLubyte *v))
GL1_PROC(void,glColorMask,(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha))
GL1_PROC(void,glColorPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL1_PROC(void,glCopyPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum type))
GL1_PROC(void,glCopyTexImage1D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLint border))
GL1_PROC(void,glCopyTexImage2D,(GLenum target, GLint level, GLenum internalFormat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border))
GL1_PROC(void,glCopyTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width))
GL1_PROC(void,glCopyTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height))
GL1_PROC(void,glCullFace,(GLenum mode))
GL1_PROC(void,glDeleteTextures,(GLsizei n, const GLuint *textures))
GL1_PROC(void,glDepthFunc,(GLenum func))
GL1_PROC(void,glDepthMask,(GLboolean flag))
GL1_PROC(void,glDepthRange,(GLclampd zNear, GLclampd zFar))
GL1_PROC(void,glDisable,(GLenum cap))
GL1_PROC(void,glDisableClientState,(GLenum array))
GL1_PROC(void,glDrawArrays,(GLenum mode, GLint first, GLsizei count))
GL1_PROC(void,glDrawBuffer,(GLenum mode))
GL1_PROC(void,glDrawElements,(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices))
GL1_PROC(void,glEnable,(GLenum cap))
GL1_PROC(void,glEnableClientState,(GLenum array))
GL1_PROC(void,glEnd,(void))
GL1_PROC(void,glFinish,(void))
GL1_PROC(void,glFlush,(void))
GL1_PROC(void,glFogf,(GLenum pname, GLfloat param))
GL1_PROC(void,glFogfv,(GLenum pname, const GLfloat *params))
GL1_PROC(void,glFogi,(GLenum pname, GLint param))
GL1_PROC(void,glFogiv,(GLenum pname, const GLint *params))
GL1_PROC(void,glFrontFace,(GLenum mode))
GL1_PROC(void,glFrustum,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GL1_PROC(void,glGenTextures,(GLsizei n, GLuint *textures))
GL1_PROC(void,glGetBooleanv,(GLenum pname, GLboolean *params))
GL1_PROC(void,glGetClipPlane,(GLenum plane, GLdouble *equation))
GL1_PROC(void,glGetDoublev,(GLenum pname, GLdouble *params))
GL1_PROC(GLenum,glGetError,(void))
GL1_PROC(void,glGetFloatv,(GLenum pname, GLfloat *params))
GL1_PROC(void,glGetIntegerv,(GLenum pname, GLint *params))
GL1_PROC(void,glGetPointerv,(GLenum pname, GLvoid* *params))
GL1_PROC(const GLubyte *,glGetString,(GLenum name))
GL1_PROC(void,glGetTexEnvfv,(GLenum target, GLenum pname, GLfloat *params))
GL1_PROC(void,glGetTexEnviv,(GLenum target, GLenum pname, GLint *params))
GL1_PROC(void,glGetTexImage,(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels))
GL1_PROC(void,glGetTexLevelParameterfv,(GLenum target, GLint level, GLenum pname, GLfloat *params))
GL1_PROC(void,glGetTexLevelParameteriv,(GLenum target, GLint level, GLenum pname, GLint *params))
GL1_PROC(void,glGetTexParameterfv,(GLenum target, GLenum pname, GLfloat *params))
GL1_PROC(void,glGetTexParameteriv,(GLenum target, GLenum pname, GLint *params))
GL1_PROC(void,glHint,(GLenum target, GLenum mode))
GL1_PROC(GLboolean,glIsEnabled,(GLenum cap))
GL1_PROC(GLboolean,glIsTexture,(GLuint texture))
GL1_PROC(void,glLoadIdentity,(void))
GL1_PROC(void,glLoadMatrixf,(const GLfloat *m))
GL1_PROC(void,glMatrixMode,(GLenum mode))
GL1_PROC(void,glMultMatrixf,(const GLfloat *m))
GL1_PROC(void,glNormal3f,(GLfloat nx, GLfloat ny, GLfloat nz))
GL1_PROC(void,glNormal3fv,(const GLfloat *v))
GL1_PROC(void,glNormalPointer,(GLenum type, GLsizei stride, const GLvoid *pointer))
GL1_PROC(void,glOrtho,(GLdouble left, GLdouble right, GLdouble bottom, GLdouble top, GLdouble zNear, GLdouble zFar))
GL1_PROC(void,glPixelStoref,(GLenum pname, GLfloat param))
GL1_PROC(void,glPixelStorei,(GLenum pname, GLint param))
GL1_PROC(void,glPointSize,(GLfloat size))
GL1_PROC(void,glPolygonMode,(GLenum face, GLenum mode))
GL1_PROC(void,glPolygonOffset,(GLfloat factor, GLfloat units))
GL1_PROC(void,glReadBuffer,(GLenum mode))
GL1_PROC(void,glReadPixels,(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels))
GL1_PROC(void,glScalef,(GLfloat x, GLfloat y, GLfloat z))
GL1_PROC(void,glScissor,(GLint x, GLint y, GLsizei width, GLsizei height))
GL1_PROC(void,glShadeModel,(GLenum mode))
GL1_PROC(void,glStencilFunc,(GLenum func, GLint ref, GLuint mask))
GL1_PROC(void,glStencilMask,(GLuint mask))
GL1_PROC(void,glStencilOp,(GLenum fail, GLenum zfail, GLenum zpass))
GL1_PROC(void,glTexCoord1f,(GLfloat s))
GL1_PROC(void,glTexCoord1fv,(const GLfloat *v))
GL1_PROC(void,glTexCoord2f,(GLfloat s, GLfloat t))
GL1_PROC(void,glTexCoord2fv,(const GLfloat *v))
GL1_PROC(void,glTexCoord3f,(GLfloat s, GLfloat t, GLfloat r))
GL1_PROC(void,glTexCoord3fv,(const GLfloat *v))
GL1_PROC(void,glTexCoord4f,(GLfloat s, GLfloat t, GLfloat r, GLfloat q))
GL1_PROC(void,glTexCoord4fv,(const GLfloat *v))
GL1_PROC(void,glTexCoordPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL1_PROC(void,glTexEnvf,(GLenum target, GLenum pname, GLfloat param))
GL1_PROC(void,glTexEnvfv,(GLenum target, GLenum pname, const GLfloat *params))
GL1_PROC(void,glTexEnvi,(GLenum target, GLenum pname, GLint param))
GL1_PROC(void,glTexEnviv,(GLenum target, GLenum pname, const GLint *params))
GL1_PROC(void,glTexImage1D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
GL1_PROC(void,glTexImage2D,(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels))
GL1_PROC(void,glTexParameterf,(GLenum target, GLenum pname, GLfloat param))
GL1_PROC(void,glTexParameterfv,(GLenum target, GLenum pname, const GLfloat *params))
GL1_PROC(void,glTexParameteri,(GLenum target, GLenum pname, GLint param))
GL1_PROC(void,glTexParameteriv,(GLenum target, GLenum pname, const GLint *params))
GL1_PROC(void,glTexSubImage1D,(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels))
GL1_PROC(void,glTexSubImage2D,(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels))
GL1_PROC(void,glVertex2f,(GLfloat x, GLfloat y))
GL1_PROC(void,glVertex2fv,(const GLfloat *v))
GL1_PROC(void,glVertex3f,(GLfloat x, GLfloat y, GLfloat z))
GL1_PROC(void,glVertex3fv,(const GLfloat *v))
GL1_PROC(void,glVertex4f,(GLfloat x, GLfloat y, GLfloat z, GLfloat w))
GL1_PROC(void,glVertex4fv,(const GLfloat *v))
GL1_PROC(void,glVertexPointer,(GLint size, GLenum type, GLsizei stride, const GLvoid *pointer))
GL1_PROC(void,glViewport,(GLint x, GLint y, GLsizei width, GLsizei height))

#ifdef WIN32
//Win32 wgl functions
GL1_PROC(BOOL,wglCopyContext,(HGLRC,HGLRC,UINT))
GL1_PROC(HGLRC,wglCreateContext,(HDC))
GL1_PROC(HGLRC,wglCreateLayerContext,(HGLRC))
GL1_PROC(BOOL,wglDeleteContext,(HGLRC))
GL1_PROC(HGLRC,wglGetCurrentContext,(VOID))
GL1_PROC(HDC,wglGetCurrentDC,(VOID))
GL1_PROC(PROC,wglGetProcAddress,(LPCSTR))
GL1_PROC(BOOL,wglMakeCurrent,(HDC, HGLRC))
GL1_PROC(BOOL,wglShareLists,(HGLRC,HGLRC))
#endif

/*-----------------------------------------------------------------------------
	The End.
-----------------------------------------------------------------------------*/
