#include <OMPCorePrivate.h>

IMPLEMENT_CLASS(UOMPUtils);

//Java based hash code algorithm
UINT UOMPUtils::getHashCode(TCHAR* inSTR, UINT max){
	if (!inSTR)
		return 0;
	UINT i = 0, h = 0;
	while (inSTR[i] != NULL)
		h = 31U * h + inSTR[i++];
	return (max > 0 ? h%max : h);
}

UINT UOMPUtils::getHashCode(FString inSTR, UINT max){
	return (inSTR ? UOMPUtils::getHashCode((TCHAR*)inSTR.GetCharArray().GetData(), max) : 0);
}

FRotator UOMPUtils::getViewRotation(AActor* A){
	if (!A)
		return FRotator();
	APlayerPawn* PP = Cast<APlayerPawn>(A);
	if (!PP)
		return A->Rotation;
	if (PP->ViewTarget)
		return PP->ViewTarget->Rotation;
	return PP->ViewRotation;
}