#include <OMPCorePrivate.h>

// This is some necessary C++/UnrealScript glue logic.
// If you forget this, you get a VC++ linker errors like:
// SampleClass.obj : error LNK2001: unresolved external symbol "class FName SAMPLENATIVEPACKAGE_SampleEvent" (?SAMPLENATIVEPACKAGE_SampleEvent@@3VFName@@A)
#define NAMES_ONLY
#define AUTOGENERATE_NAME(name) OMPCORE_API FName OMPCORE_##name=FName(UTEXT(#name),FNAME_Intrinsic);
#define AUTOGENERATE_FUNCTION(cls,idx,name)
#include <OMPCoreClasses.h>
#undef AUTOGENERATE_FUNCTION
#undef AUTOGENERATE_NAME
#undef NAMES_ONLY

IMPLEMENT_PACKAGE(OMPCore);
IMPLEMENT_CLASS(AOMPActor);
IMPLEMENT_CLASS(AOMPMut);
IMPLEMENT_CLASS(UOMPRenderBase);
IMPLEMENT_CLASS(UOMPRenderDevice);


static size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp)
{
    ((std::string*)userp)->append((char*)contents, size * nmemb);
    return size * nmemb;
}



void AOMPActor::execgetHTTPRequest( FFrame& Stack, RESULT_DECL )
{
	guard(AOMPActor::execgetHTTPRequest);

	P_GET_STR(s);
	P_FINISH;

	CURL *curl;
	CURLcode res;

	std::string readBuffer;
 
	curl = curl_easy_init();
	debugf(UTEXT("Trying to retrieve %s"), s);
	FString r = UTEXT("CURL not initialized");

	INT s_len = s.GetCharArray().Num();
	TCHAR * http_url = new TCHAR[s_len + 1];
	http_url[s_len] = NULL;
	appMemcpy(http_url, s.GetCharArray().GetData(), s.GetCharArray().Num()*sizeof(TCHAR));

	debugf(UTEXT("Passed std string %s"), http_url);
	if(curl) {
		curl_easy_setopt(curl, CURLOPT_URL, TCHAR_TO_ANSI(http_url));
		curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 1L);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &readBuffer);
		res = curl_easy_perform(curl);
		r = (res != CURLE_OK ? FString::Printf(ANSI_TO_TCHAR("CURL ERROR: %s"), ANSI_TO_TCHAR(curl_easy_strerror(res))) : UTEXT("curl_easy_perform() OK"));
		curl_easy_cleanup(curl);
	}

	*(FString*)Result = r;

	unguard;
}
IMPLEMENT_FUNCTION(AOMPActor,3000,execgetHTTPRequest);




struct resp_omp {
	FString * s;
	AOMPActor * A;
};
resp_omp global_romp;

void testThread(void *param)
{
	debugf(UTEXT("Sleeping for 1 second"));
    Sleep(1000); // sleep for 1 second

	CURL *curl;
	CURLcode res;

	std::string readBuffer;
 
	curl = curl_easy_init();
	resp_omp o = *static_cast<resp_omp*>(param);

	FString s = *(o.s);
	AOMPActor * A = o.A;
	debugf(UTEXT("Trying to retrieve threaded %s"), s);
	FString r = UTEXT("CURL not initialized");

	INT s_len = s.GetCharArray().Num();
	TCHAR * http_url = new TCHAR[s_len + 1];
	http_url[s_len] = NULL;
	appMemcpy(http_url, s.GetCharArray().GetData(), s.GetCharArray().Num()*sizeof(TCHAR));

	debugf(UTEXT("Passed threaded std string %s"), http_url);
	if(curl) {
		curl_easy_setopt(curl, CURLOPT_URL, TCHAR_TO_ANSI(http_url));
		curl_easy_setopt(curl, CURLOPT_FOLLOWLOCATION, 1L);
		curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
		curl_easy_setopt(curl, CURLOPT_WRITEDATA, &readBuffer);
		res = curl_easy_perform(curl);
		r = (res != CURLE_OK ? FString::Printf(ANSI_TO_TCHAR("CURL threaded ERROR: %s"), ANSI_TO_TCHAR(curl_easy_strerror(res))) : UTEXT("threaded curl_easy_perform() OK"));
		curl_easy_cleanup(curl);
	}
	debugf(UTEXT("%s"), r);

	
	unsigned char * response = new unsigned char[readBuffer.length()];
	memcpy(response, readBuffer.c_str(), readBuffer.size()*sizeof(char));
	//A->eventrecHTTPRequest(res, FString(ANSI_TO_TCHAR(response)));
	A->eventrecHTTPRequest(res, FString(ANSI_TO_TCHAR("BMP")));


	//appSaveStringToFile(FString(ANSI_TO_TCHAR(response)), ANSI_TO_TCHAR("C:\\UnrealTournament\\http_test.json"));
	//debugf(UTEXT("Saved to: %s"), ANSI_TO_TCHAR("C:\\UnrealTournament\\http_test.json"));


	ofstream myfile;
	myfile.open("C:\\UnrealTournament\\http_test.bmp", ios::binary);
	myfile << readBuffer;
	myfile.close();


	HZIP hz = CreateZip(ANSI_TO_TCHAR("C:\\UnrealTournament\\http_test.zip"), NULL);
	ZipAdd(hz, ANSI_TO_TCHAR("http_test.bmp"), ANSI_TO_TCHAR("C:\\UnrealTournament\\http_test.bmp"));
	CloseZip(hz);


	sqlite3 * db;
	sqlite3_stmt *statement;
	sqlite3_open("db_test.db", &db);
	if(sqlite3_prepare_v2(db, "CREATE TABLE a (b INTEGER, c INTEGER);", -1, &statement, 0) == SQLITE_OK)
	{
		int cols = sqlite3_column_count(statement);
		int result = 0;
		do
		{
			result = sqlite3_step(statement);
			for(int col = 0; col < cols; col++)
			{
				string s = (char*)sqlite3_column_text(statement, col);
				//do something with it
			}
		}
		while (result == SQLITE_ROW);

		sqlite3_finalize(statement);
	}

	delete response;

	debugf(UTEXT("Ended threaded HTTP request"));

    _endthread();
}


void AOMPActor::execgetThreadedHTTPRequest( FFrame& Stack, RESULT_DECL )
{
	guard(AOMPActor::execgetThreadedHTTPRequest);

	P_GET_STR(s);
	P_FINISH;

	debugf(UTEXT("Starting thread"));
	global_romp.s = new FString(s);
	global_romp.A = this;
	_beginthread(testThread, 0, (void*)&global_romp);

	*(FString*)Result = UTEXT("Thread was started and is running");

	unguard;
}
IMPLEMENT_FUNCTION(AOMPActor,3001,execgetThreadedHTTPRequest);




UPalette* getClonedPalette(UPalette* P){
	return CastChecked<UPalette>(UObject::StaticAllocateObject(UPalette::StaticClass(), P->GetTransientPackage(), NAME_None, 0UL, P));
	//return CastChecked<UPalette>(UObject::StaticConstructObject(UPalette::StaticClass(), P->GetTransientPackage(), NAME_None, RF_Transient, P));
}

UTexture* getClonedTexture(UTexture* T){
	return CastChecked<UTexture>(UObject::StaticAllocateObject(UTexture::StaticClass(), T->GetTransientPackage(), NAME_None, 0UL, T));
	//return CastChecked<UTexture>(UObject::StaticConstructObject(UTexture::StaticClass(), T->GetTransientPackage(), NAME_None, RF_Transient, T));
}


void AOMPActor::execinitOngoingTest( FFrame& Stack, RESULT_DECL )
{
	guard(AOMPActor::execinitOngoingTest);

	TCHAR* test;
	test = UTEXT("stuff");
	debugf(UTEXT("Hash code for %s is %u"), test, UOMPUtils::getHashCode(test));
	test = UTEXT("OMPCore.MeshAst0");
	debugf(UTEXT("Hash code for %s is %u"), test, UOMPUtils::getHashCode(test));
	test = UTEXT("Hello world");
	debugf(UTEXT("Hash code for %s is %u"), test, UOMPUtils::getHashCode(test));
	test = UTEXT("UNREAL TOURNAMENT $&/");
	debugf(UTEXT("Hash code for %s is %u"), test, UOMPUtils::getHashCode(test));
	test = UTEXT("Welcome to Tutorialspoint.com");
	debugf(UTEXT("Hash code for %s is %u"), test, UOMPUtils::getHashCode(test));

	P_FINISH;

	/*AActor* A = this;

	UObject* loadedPkg = UObject::LoadPackage(NULL, ANSI_TO_TCHAR("C:\\UnrealTournament\\LoadTest\\IonEnergy.utx"), LOAD_None);
	if (loadedPkg)
		debugf(UTEXT("LOAD TEST: Loaded IonEnergy.utx as loadedPkg=%s"), loadedPkg->GetFullName());
	else
		debugf(UTEXT("LOAD TEST: Couldn't load IonEnergy.utx"));

	if (A && A->Mesh && loadedPkg){

		UTexture* loadT = CastChecked<UTexture>(UObject::StaticLoadObject(UTexture::StaticClass(),NULL, 
			ANSI_TO_TCHAR("IonEnergy.IonEnergyPan"), NULL, LOAD_None, NULL));

		if (loadT){
			debugf(UTEXT("CLONE TEST: Trying to clone texture %s"), loadT->GetFullName());
			UTexture* T = getClonedTexture(loadT);
			if (T){
				debugf(UTEXT("CLONE TEST: Cloned %s ok as %s"), loadT->GetFullName(), T->GetFullName());
				if (T->Palette)
					debugf(UTEXT("CLONE TEST: Texture %s has palette %s"), T->GetFullName(), T->Palette->GetFullName());

				if (T->Palette){
					UPalette* P = getClonedPalette(T->Palette);
					if (P){
						T->Palette = P;
						debugf(UTEXT("CLONE TEST: Texture %s has now palette %s"), T->GetFullName(), P->GetFullName());
						debugf(UTEXT("CLONE TEST: Original texture %s: Mips=%i"), loadT->GetFullName(), loadT->Mips.Num());
						debugf(UTEXT("CLONE TEST: Texture %s: Mips=%i"), T->GetFullName(), T->Mips.Num());
						FLOAT f = appFrand();
						for (INT i = 0; i < T->Palette->Colors.Num(); i++){
							if (f < 0.333f){
								T->Palette->Colors(i).B = 0;
							} else if (f < 0.666f) {
								T->Palette->Colors(i).R = 0;
							} else {
								T->Palette->Colors(i).G = 255;
							}
						}
						debugf(UTEXT("CLONE TEST: Texture %s: Init(%i, %i)"), T->GetFullName(), T->USize, T->VSize);
						A->Skin = T;
						debugf(UTEXT("CLONE TEST: OK"));
					} else {
						debugf(UTEXT("CLONE TEST: Palette not cloned"));
					}
					P = NULL;
				} else {
					debugf(UTEXT("CLONE TEST: No texture palette"));
				}
				T = NULL;
			} else {
				debugf(UTEXT("CLONE TEST: Not cloned"));
			}
			loadT = NULL;
		}*/

		/*FVector * mVerts = new FVector[A->Mesh->FrameVerts];
		ULodMesh* LM = Cast<ULodMesh>(A->Mesh);
		if (LM){
			INT LQ = LM->FrameVerts;
			LM->GetFrame(mVerts, sizeof(FVector), GMath.UnitCoords, A, LQ);
		} else {
			A->Mesh->GetFrame(mVerts, sizeof(FVector), GMath.UnitCoords, A);
		}
		A->Mesh->SetScale(DrawScale3D);*/

		//for (INT i = 0; i < Mesh->FrameVerts; i++)
			//mVerts[i] *= DrawScale3D;
		//delete mVerts;
		
		//else
			//debugf(UTEXT("execinitOngoingTest: not going to work out bro..."));
	//}

	unguard;
}
IMPLEMENT_FUNCTION(AOMPActor,3002,execinitOngoingTest);




void AOMPMut::execDraw2DLine( FFrame& Stack, RESULT_DECL )
{
	guard(AOMPMut::execDraw2DLine);

	P_GET_OBJECT(UCanvas, dCanvas)
	P_GET_STRUCT(FColor,dColor)
	P_GET_VECTOR(v1);
	P_GET_VECTOR(v2);
	P_GET_UBOOL_OPTX(bClearZ, false);
	P_FINISH;

	if (dCanvas && dCanvas->Frame && dCanvas->Viewport && dCanvas->Viewport->RenDev){
		//dCanvas->Viewport->RenDev->Draw2DLine(dCanvas->Frame, dColor.Plane(), 0, v1, v2);
		dCanvas->Viewport->RenDev->Draw2DPoint(dCanvas->Frame, dColor.Plane(), 0, v1.X, v1.Y, v2.X, v2.Y, dCanvas->Z);
	}

	unguard;
}
IMPLEMENT_FUNCTION(AOMPMut,3500,execDraw2DLine);


void AOMPMut::execDraw3DLine( FFrame& Stack, RESULT_DECL )
{
	guard(AOMPMut::execDraw3DLine);

	P_GET_OBJECT(UCanvas, dCanvas)
	P_GET_STRUCT(FColor,dColor)
	P_GET_VECTOR(v1);
	P_GET_VECTOR(v2);
	P_GET_UBOOL_OPTX(bClearZ, false);
	P_FINISH;

	if (dCanvas && dCanvas->Frame && dCanvas->Viewport && dCanvas->Viewport->RenDev){
		if (bClearZ)
			dCanvas->Viewport->RenDev->ClearZ(dCanvas->Frame);
		dCanvas->Viewport->RenDev->Draw3DLine(dCanvas->Frame, dColor.Plane(), 0, v1, v2);
	}

	unguard;
}
IMPLEMENT_FUNCTION(AOMPMut,3501,execDraw3DLine);


void AOMPMut::execDraw2DCircle( FFrame& Stack, RESULT_DECL )
{
	guard(AOMPMut::execDraw2DCircle);

	P_GET_OBJECT(UCanvas, dCanvas)
	P_GET_STRUCT(FColor,dColor)
	P_GET_VECTOR(vLoc);
	P_GET_FLOAT(cRadius);
	P_GET_UBOOL_OPTX(bClearZ, false);
	P_FINISH;

	if (dCanvas && dCanvas->Frame && dCanvas->Viewport && dCanvas->Viewport->Actor && dCanvas->Viewport->Actor->XLevel && 
	dCanvas->Viewport->Actor->XLevel->Engine && dCanvas->Viewport->Actor->XLevel->Engine->Render && cRadius){
		if (bClearZ && dCanvas->Viewport->RenDev)
			dCanvas->Viewport->RenDev->ClearZ(dCanvas->Frame);
		dCanvas->Viewport->Actor->XLevel->Engine->Render->DrawCircle(dCanvas->Frame, dColor.Plane(), 0, vLoc, cRadius);
	}

	unguard;
}
IMPLEMENT_FUNCTION(AOMPMut,3502,execDraw2DCircle);