/*=============================================================================
	UOMPRenderDevice.h: Rendering Device header interface.
=============================================================================*/

class OMPCORE_API UOMPRenderDevice : public URenderDevice
{
	DECLARE_ABSTRACT_CLASS(UOMPRenderDevice, URenderDevice, CLASS_Config, OMPCore)

	UBOOL hasInitOMPDevice;

	//New render device OMP methods
	virtual void initOMPDevice(UViewport* InViewport, INT NewX, INT NewY, INT NewColorBytes, UBOOL Fullscreen)=0;
	virtual void exitOMPDevice()=0;
	virtual void flushOMPDevice()=0;

	virtual UBOOL hasVertexBatchedActor(AActor* A)=0;
	virtual UBOOL registerVertexBatchedActor(FSceneNode* Frame, AActor* A)=0;
	virtual UBOOL unRegisterVertexBatchedActor(AActor* A)=0;

	virtual UBOOL hasVertexBatchedMesh(UMesh* M)=0;
	virtual UBOOL registerVertexBatchedMesh(FSceneNode* Frame, UMesh* M)=0;
	virtual UBOOL unRegisterVertexBatchedMesh(UMesh* M)=0;

	virtual void flushVertexBatchedActors()=0;
	virtual void flushVertexBatchedMeshes()=0;
	virtual void drawVertexBatchedActor(FSceneNode* Frame, AActor* A)=0;
	virtual void prepareVertexBatchDrawing(FSceneNode* Frame)=0;
	virtual void finishVertexBatchDrawing(FSceneNode* Frame)=0;
};
