/*=============================================================================
	UOMPRenderBase.h: Rendering header interface.
=============================================================================*/

class OMPCORE_API UOMPRenderBase : public URenderBase
{
	DECLARE_CLASS(UOMPRenderBase, URenderBase, CLASS_Config, OMPCore)
	NO_DEFAULT_CONSTRUCTOR(UOMPRenderBase);

public:
	// Standard UnrealEngine URenderBase interface.
	virtual void Init(UEngine* InEngine){};
	virtual UBOOL Exec(const TCHAR* Cmd, FOutputDevice& Ar = *GLog){return 0;}

	virtual void PreRender(FSceneNode* Frame){};
	virtual void PostRender(FSceneNode* Frame){};
	virtual void DrawWorld(FSceneNode* Frame){};

	virtual UBOOL Deproject(FSceneNode* Frame, INT ScreenX, INT ScreenY, FVector& V){return 0;}
	virtual UBOOL Project(FSceneNode* Frame, const FVector& V, FLOAT& ScreenX, FLOAT& ScreenY, FLOAT* Scale){return 0;}

	virtual void DrawActor(FSceneNode* Frame, AActor* Actor){};

	virtual void GetVisibleSurfs(UViewport* Viewport, TArray<INT>& iSurfs){};

	virtual UBOOL BoundVisible(FSceneNode* Frame, FBox* Bound, FSpanBuffer* SpanBuffer, FScreenBounds& Results){return 0;}
	virtual void GlobalLighting(UBOOL Realtime, AActor* Owner, FLOAT& Brightness, FPlane& Color ){};

	virtual FSceneNode* CreateMasterFrame(UViewport* Viewport, FVector Location, FRotator Rotation, FScreenBounds* Bounds){return NULL;};
	virtual FSceneNode* CreateChildFrame(FSceneNode* Frame, FSpanBuffer* Span, ULevel* Level, INT iSurf, INT iZone, FLOAT Mirror, const FPlane& NearClip, const FCoords& Coords, FScreenBounds* Bounds){return NULL;};
	virtual void FinishMasterFrame(){};

	virtual void DrawCircle(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector& Location, FLOAT Radius, UBOOL bScaleRadiusByZoom=0){};
	virtual void DrawBox(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector Min, FVector Max){};
	virtual void DrawCylinder(FSceneNode* Frame, FPlane Color, DWORD LineFlags, FVector& Location, FLOAT Radius, FLOAT Height){};

	virtual void Precache(UViewport* Viewport){};
};
