//////////////////////////////////////////////////////////////
//				Feralidragon (02-02-2014)
//
// NW3 ULTIMA PROTOS BUILD 1.00
//////////////////////////////////////////////////////////////

class UltimaSolOversFXE expands TheOversColoredFX;

#exec MESH IMPORT MESH=UltDebFrag01 ANIVFILE=MODELS\UltDebFrag01_a.3d DATAFILE=MODELS\UltDebFrag01_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag01 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag01 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag01 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag01 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag01 MESH=UltDebFrag01
#exec MESHMAP SCALE MESHMAP=UltDebFrag01 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag01 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag02 ANIVFILE=MODELS\UltDebFrag02_a.3d DATAFILE=MODELS\UltDebFrag02_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag02 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag02 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag02 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag02 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag02 MESH=UltDebFrag02
#exec MESHMAP SCALE MESHMAP=UltDebFrag02 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag02 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag03 ANIVFILE=MODELS\UltDebFrag03_a.3d DATAFILE=MODELS\UltDebFrag03_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag03 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag03 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag03 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag03 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag03 MESH=UltDebFrag03
#exec MESHMAP SCALE MESHMAP=UltDebFrag03 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag03 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag04 ANIVFILE=MODELS\UltDebFrag04_a.3d DATAFILE=MODELS\UltDebFrag04_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag04 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag04 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag04 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag04 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag04 MESH=UltDebFrag04
#exec MESHMAP SCALE MESHMAP=UltDebFrag04 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag04 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag05 ANIVFILE=MODELS\UltDebFrag05_a.3d DATAFILE=MODELS\UltDebFrag05_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag05 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag05 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag05 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag05 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag05 MESH=UltDebFrag05
#exec MESHMAP SCALE MESHMAP=UltDebFrag05 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag05 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag06 ANIVFILE=MODELS\UltDebFrag06_a.3d DATAFILE=MODELS\UltDebFrag06_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag06 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag06 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag06 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag06 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag06 MESH=UltDebFrag06
#exec MESHMAP SCALE MESHMAP=UltDebFrag06 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag06 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag07 ANIVFILE=MODELS\UltDebFrag07_a.3d DATAFILE=MODELS\UltDebFrag07_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag07 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag07 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag07 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag07 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag07 MESH=UltDebFrag07
#exec MESHMAP SCALE MESHMAP=UltDebFrag07 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag07 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag08 ANIVFILE=MODELS\UltDebFrag08_a.3d DATAFILE=MODELS\UltDebFrag08_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag08 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag08 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag08 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag08 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag08 MESH=UltDebFrag08
#exec MESHMAP SCALE MESHMAP=UltDebFrag08 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag08 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag09 ANIVFILE=MODELS\UltDebFrag09_a.3d DATAFILE=MODELS\UltDebFrag09_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag09 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag09 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag09 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag09 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag09 MESH=UltDebFrag09
#exec MESHMAP SCALE MESHMAP=UltDebFrag09 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag09 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag10 ANIVFILE=MODELS\UltDebFrag10_a.3d DATAFILE=MODELS\UltDebFrag10_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag10 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag10 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag10 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag10 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag10 MESH=UltDebFrag10
#exec MESHMAP SCALE MESHMAP=UltDebFrag10 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag10 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag11 ANIVFILE=MODELS\UltDebFrag11_a.3d DATAFILE=MODELS\UltDebFrag11_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag11 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag11 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag11 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag11 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag11 MESH=UltDebFrag11
#exec MESHMAP SCALE MESHMAP=UltDebFrag11 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag11 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag12 ANIVFILE=MODELS\UltDebFrag12_a.3d DATAFILE=MODELS\UltDebFrag12_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag12 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag12 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag12 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag12 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag12 MESH=UltDebFrag12
#exec MESHMAP SCALE MESHMAP=UltDebFrag12 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag12 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag13 ANIVFILE=MODELS\UltDebFrag13_a.3d DATAFILE=MODELS\UltDebFrag13_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag13 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag13 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag13 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag13 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag13 MESH=UltDebFrag13
#exec MESHMAP SCALE MESHMAP=UltDebFrag13 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag13 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=UltDebFrag14 ANIVFILE=MODELS\UltDebFrag14_a.3d DATAFILE=MODELS\UltDebFrag14_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=UltDebFrag14 STRENGTH=0.1
#exec MESH ORIGIN MESH=UltDebFrag14 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=UltDebFrag14 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=UltDebFrag14 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=UltDebFrag14 MESH=UltDebFrag14
#exec MESHMAP SCALE MESHMAP=UltDebFrag14 X=0.001 Y=0.001 Z=0.002
#exec MESHMAP SETTEXTURE MESHMAP=UltDebFrag14 NUM=1 TEXTURE=DefaultTexture


var() mesh FragMeshes[14];
var UltimaSolOversFXE NextFX, PrevFX;
var UltimaSolOversFXA FXMaster;
var float mDist, curOrbY, orbRateY;
var rotator debRRate, curDebR;

simulated function PostBeginPlay()
{
	Mesh = FragMeshes[Rand(ArrayCount(FragMeshes))];
	Super.PostBeginPlay();
}

simulated function initOversFXE(UltimaSolOversFXA master, float scale, float startOrb, float orbRate, rotator rNRate)
{
	FXMaster = master;
	mDist = VSize(Location - master.Location);
	DrawScale = scale;
	BaseDScale = scale;
	curOrbY = startOrb;
	orbRateY =  orbRate;
	debRRate = rNRate;
	curDebR = RotRand(True);
}

simulated function Tick(float Delta)
{
	curOrbY += (orbRateY * Delta);
	curDebR += (debRRate * Delta);
	Super.Tick(Delta);
}

simulated function UpdateCoords(vector newLoc, rotator newRot)
{
local rotator R;

	if (NextFX != None)
		NextFX.UpdateCoords(newLoc, newRot);
	R.Yaw = int(curOrbY);
	SetLocation(newLoc + (((mDist * vect(1,0,0)) >> R) >> newRot));
	SetRotation(newRot + curDebR);
}

simulated function renderOnCanvas(canvas Canvas)
{
	if (NextFX != None)
		NextFX.renderOnCanvas(Canvas);
	Super.renderOnCanvas(Canvas);
}

simulated function SetDestroy()
{
	if (NextFX != None)
		NextFX.SetDestroy();
	Destroy();
}

simulated function Destroyed()
{
	if (NextFX != None)
		NextFX.PrevFX = PrevFX;
	if (PrevFX != None)
		PrevFX.NextFX = NextFX;
	else if (FXMaster != None)
		FXMaster.DebFXList = NextFX;
	NextFX = None;
	PrevFX = None;
	FXMaster = None;
	
	Super.Destroyed();
}

defaultproperties
{
	DrawType=DT_Mesh
	MultiSkins(1)=UltimaSolOrbUltDebFragDefTex
	bUnlit=True
	Style=STY_Normal
	
	renderOnTop=False
	DrawScale=1.000000
	ScaleGlow=0.350000
	LifeSpan=6.000000

	fadeInTime=0.000000
	fadeOutTime=0.850000
	
	enableScaling=True
	scaleInTime=0.200000
	scaleOutTime=0.100000
	
	FragMeshes(0)=UltDebFrag01
	FragMeshes(1)=UltDebFrag02
	FragMeshes(2)=UltDebFrag03
	FragMeshes(3)=UltDebFrag04
	FragMeshes(4)=UltDebFrag05
	FragMeshes(5)=UltDebFrag06
	FragMeshes(6)=UltDebFrag07
	FragMeshes(7)=UltDebFrag08
	FragMeshes(8)=UltDebFrag09
	FragMeshes(9)=UltDebFrag10
	FragMeshes(10)=UltDebFrag11
	FragMeshes(11)=UltDebFrag12
	FragMeshes(12)=UltDebFrag13
	FragMeshes(13)=UltDebFrag14
}
