//////////////////////////////////////////////////////////////
//				Feralidragon (31-03-2012)
//
// NW3 RAZORED TRANSLOCATOR BUILD 1.00
//////////////////////////////////////////////////////////////

class RTTransOV expands NaliTrail;

//===========================================================================

//OV TOP
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVTop ANIVFILE=MODELS\RTTransOVTop_a.3d DATAFILE=MODELS\RTTransOVTop_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVTop STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVTop X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVTop SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVTop SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTop SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTop SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTop SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTop SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVTop SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVTop MESH=RTTransOVTop
#exec MESHMAP SCALE MESHMAP=RTTransOVTop X=0.04 Y=0.04 Z=0.08

//OV TOP A
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVTopA ANIVFILE=MODELS\RTTransOVTopA_a.3d DATAFILE=MODELS\RTTransOVTopA_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVTopA STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVTopA X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVTopA SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVTopA SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopA SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopA SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopA SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopA SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVTopA SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVTopA MESH=RTTransOVTopA
#exec MESHMAP SCALE MESHMAP=RTTransOVTopA X=0.04 Y=0.04 Z=0.08

//OV TOP B
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVTopB ANIVFILE=MODELS\RTTransOVTopB_a.3d DATAFILE=MODELS\RTTransOVTopB_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVTopB STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVTopB X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVTopB SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVTopB SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopB SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopB SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopB SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopB SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVTopB SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVTopB MESH=RTTransOVTopB
#exec MESHMAP SCALE MESHMAP=RTTransOVTopB X=0.04 Y=0.04 Z=0.08

//OV TOP C
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVTopC ANIVFILE=MODELS\RTTransOVTopC_a.3d DATAFILE=MODELS\RTTransOVTopC_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVTopC STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVTopC X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVTopC SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVTopC SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopC SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopC SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopC SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopC SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVTopC SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVTopC MESH=RTTransOVTopC
#exec MESHMAP SCALE MESHMAP=RTTransOVTopC X=0.04 Y=0.04 Z=0.08

//OV TOP D
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVTopD ANIVFILE=MODELS\RTTransOVTopD_a.3d DATAFILE=MODELS\RTTransOVTopD_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVTopD STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVTopD X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVTopD SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVTopD SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopD SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopD SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopD SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopD SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVTopD SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVTopD MESH=RTTransOVTopD
#exec MESHMAP SCALE MESHMAP=RTTransOVTopD X=0.04 Y=0.04 Z=0.08

//OV TOP E
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVTopE ANIVFILE=MODELS\RTTransOVTopE_a.3d DATAFILE=MODELS\RTTransOVTopE_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVTopE STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVTopE X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVTopE SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVTopE SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopE SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopE SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopE SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopE SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVTopE SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVTopE MESH=RTTransOVTopE
#exec MESHMAP SCALE MESHMAP=RTTransOVTopE X=0.04 Y=0.04 Z=0.08

//OV TOP F
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVTopF ANIVFILE=MODELS\RTTransOVTopF_a.3d DATAFILE=MODELS\RTTransOVTopF_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVTopF STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVTopF X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVTopF SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVTopF SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopF SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVTopF SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopF SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVTopF SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVTopF SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVTopF MESH=RTTransOVTopF
#exec MESHMAP SCALE MESHMAP=RTTransOVTopF X=0.04 Y=0.04 Z=0.08

//===========================================================================

//OV BOTTOM
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVBottom ANIVFILE=MODELS\RTTransOVBottom_a.3d DATAFILE=MODELS\RTTransOVBottom_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVBottom STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVBottom X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVBottom SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVBottom SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottom SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottom SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottom SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottom SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVBottom SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVBottom MESH=RTTransOVBottom
#exec MESHMAP SCALE MESHMAP=RTTransOVBottom X=0.04 Y=0.04 Z=0.08

//OV BOTTOM A
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVBottomA ANIVFILE=MODELS\RTTransOVBottomA_a.3d DATAFILE=MODELS\RTTransOVBottomA_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVBottomA STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVBottomA X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVBottomA SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVBottomA SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomA SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomA SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomA SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomA SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVBottomA SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVBottomA MESH=RTTransOVBottomA
#exec MESHMAP SCALE MESHMAP=RTTransOVBottomA X=0.04 Y=0.04 Z=0.08

//OV BOTTOM B
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVBottomB ANIVFILE=MODELS\RTTransOVBottomB_a.3d DATAFILE=MODELS\RTTransOVBottomB_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVBottomB STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVBottomB X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVBottomB SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVBottomB SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomB SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomB SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomB SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomB SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVBottomB SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVBottomB MESH=RTTransOVBottomB
#exec MESHMAP SCALE MESHMAP=RTTransOVBottomB X=0.04 Y=0.04 Z=0.08

//OV BOTTOM C
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVBottomC ANIVFILE=MODELS\RTTransOVBottomC_a.3d DATAFILE=MODELS\RTTransOVBottomC_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVBottomC STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVBottomC X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVBottomC SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVBottomC SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomC SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomC SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomC SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomC SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVBottomC SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVBottomC MESH=RTTransOVBottomC
#exec MESHMAP SCALE MESHMAP=RTTransOVBottomC X=0.04 Y=0.04 Z=0.08

//OV BOTTOM D
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVBottomD ANIVFILE=MODELS\RTTransOVBottomD_a.3d DATAFILE=MODELS\RTTransOVBottomD_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVBottomD STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVBottomD X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVBottomD SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVBottomD SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomD SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomD SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomD SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomD SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVBottomD SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVBottomD MESH=RTTransOVBottomD
#exec MESHMAP SCALE MESHMAP=RTTransOVBottomD X=0.04 Y=0.04 Z=0.08

//OV BOTTOM E
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVBottomE ANIVFILE=MODELS\RTTransOVBottomE_a.3d DATAFILE=MODELS\RTTransOVBottomE_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVBottomE STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVBottomE X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVBottomE SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVBottomE SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomE SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomE SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomE SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomE SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVBottomE SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVBottomE MESH=RTTransOVBottomE
#exec MESHMAP SCALE MESHMAP=RTTransOVBottomE X=0.04 Y=0.04 Z=0.08

//OV BOTTOM F
//*******************************************************

#exec MESH IMPORT MESH=RTTransOVBottomF ANIVFILE=MODELS\RTTransOVBottomF_a.3d DATAFILE=MODELS\RTTransOVBottomF_d.3d X=0 Y=0 Z=0 UNMIRROR=1
#exec MESH LODPARAMS MESH=RTTransOVBottomF STRENGTH=0.1
#exec MESH ORIGIN MESH=RTTransOVBottomF X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=RTTransOVBottomF SEQ=All STARTFRAME=0 NUMFRAMES=35
#exec MESH SEQUENCE MESH=RTTransOVBottomF SEQ=Razored STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomF SEQ=Normal STARTFRAME=5 NUMFRAMES=1
#exec MESH SEQUENCE MESH=RTTransOVBottomF SEQ=RazorOff STARTFRAME=0 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomF SEQ=RazorOn STARTFRAME=5 NUMFRAMES=6 RATE=5.0
#exec MESH SEQUENCE MESH=RTTransOVBottomF SEQ=SpinOnce STARTFRAME=10 NUMFRAMES=25 RATE=24.0
#exec MESH SEQUENCE MESH=RTTransOVBottomF SEQ=SpinLoop STARTFRAME=10 NUMFRAMES=24 RATE=23.0

#exec MESHMAP NEW MESHMAP=RTTransOVBottomF MESH=RTTransOVBottomF
#exec MESHMAP SCALE MESHMAP=RTTransOVBottomF X=0.04 Y=0.04 Z=0.08

//===========================================================================

//FX Skins
#exec TEXTURE IMPORT NAME=RTOV_Red FILE=SKINS\RTOV_Red.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=RTOV_Blue FILE=SKINS\RTOV_Blue.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=RTOV_Green FILE=SKINS\RTOV_Green.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=RTOV_Yellow FILE=SKINS\RTOV_Yellow.bmp GROUP=Skins LODSET=2

#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVTop NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVTopA NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVTopB NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVTopC NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVTopD NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVTopE NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVTopF NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVBottom NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVBottomA NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVBottomB NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVBottomC NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVBottomD NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVBottomE NUM=1 TEXTURE=RTOV_Red
#exec MESHMAP SETTEXTURE MESHMAP=RTTransOVBottomF NUM=1 TEXTURE=RTOV_Red

//===========================================================================


var() mesh MeshTop[6], MeshBottom[6];
var() mesh MeshMainTop, MeshMainBottom;
var() texture GlowTex[4];
var() float MaxGlow;

var byte glowID;
var float curRadOffset, timeCycle, tCount;
var bool isDisrupted;

replication
{
	reliable if (Role == ROLE_Authority)
		glowID, timeCycle, tCount, isDisrupted;
}

function setOV(byte id, bool isTop, optional bool isMain)
{
	if (id >= ArrayCount(MeshTop))
		id = 0;

	if (isMain)
	{
		if (isTop)
			Mesh = MeshMainTop;
		else
			Mesh = MeshMainBottom;
	}
	else if (isTop)
		Mesh = MeshTop[id];
	else
		Mesh = MeshBottom[id];
}

function SetDisruption()
{
	isDisrupted = True;
}

function setTeam(byte team)
{
	if (team < 4)
		MultiSkins[1] = GlowTex[team];
}

function setOVAngleOffset(float rad)
{
	curRadOffset = rad;
	tCount = rad/(2*PI) * timeCycle;
}

function setOVTimeCycle(float tmc, optional bool adjustAngleOffset)
{
	timeCycle = tmc;
	if (adjustAngleOffset)
		setOVAngleOffset(curRadOffset);
}

function setGlowType(byte t)
{
	glowID = t;
}

simulated function Tick(float Delta)
{
	if (Level.NetMode != NM_DedicatedServer)
	{
		if (isDisrupted)
			ScaleGlow = FRand()*MaxGlow;
		else
		{
			tCount += Delta;
			if (tCount > timeCycle)
				tCount -= timeCycle;
			
			if (glowID == 0)
			{
				if (tCount < timeCycle/2)
					ScaleGlow = (Sin(tCount/timeCycle*4*PI - PI/2) + 1)/2 * MaxGlow;
				else
					ScaleGlow = 0.0;
			}
			else if (glowID == 1)
				ScaleGlow = (Sin(tCount/timeCycle*2*PI) + 1)/2 * MaxGlow;
			else if (glowID == 2)
			{
				if (tCount < timeCycle/4)
					ScaleGlow = (Sin(tCount/timeCycle*4*PI - PI/2) + 1)/2 * MaxGlow;
				else
					ScaleGlow = (Cos((tCount - (timeCycle/4))/(timeCycle/4*3)*PI) + 1)/2 * MaxGlow;
			}
		}
	}
}

defaultproperties
{
	DrawType=DT_Mesh
	Mesh=RTTransOVTop
	Style=STY_Translucent
	ScaleGlow=0.000000
	bUnlit=True
	timeCycle=1.000000
	MaxGlow=1.750000
	bAnimByOwner=True
	
	GlowTex(0)=RTOV_Red
	GlowTex(1)=RTOV_Blue
	GlowTex(2)=RTOV_Green
	GlowTex(3)=RTOV_Yellow

	MeshMainTop=RTTransOVTop
	MeshMainBottom=RTTransOVBottom
	MeshTop(0)=RTTransOVTopA
	MeshTop(1)=RTTransOVTopB
	MeshTop(2)=RTTransOVTopC
	MeshTop(3)=RTTransOVTopD
	MeshTop(4)=RTTransOVTopE
	MeshTop(5)=RTTransOVTopF
	MeshBottom(0)=RTTransOVBottomA
	MeshBottom(1)=RTTransOVBottomB
	MeshBottom(2)=RTTransOVBottomC
	MeshBottom(3)=RTTransOVBottomD
	MeshBottom(4)=RTTransOVBottomE
	MeshBottom(5)=RTTransOVBottomF
}
