//////////////////////////////////////////////////////////////
//				Feralidragon (24-08-2013)
//
// NW3 GRAVITON BUILD 1.00
//////////////////////////////////////////////////////////////

class GravVtxFrag expands Projectile;

#exec MESH IMPORT MESH=GravVtxWFrag01 ANIVFILE=MODELS\GravVtxWFrag01_a.3d DATAFILE=MODELS\GravVtxWFrag01_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GravVtxWFrag01 STRENGTH=0.1
#exec MESH ORIGIN MESH=GravVtxWFrag01 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=GravVtxWFrag01 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GravVtxWFrag01 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=GravVtxWFrag01 MESH=GravVtxWFrag01
#exec MESHMAP SCALE MESHMAP=GravVtxWFrag01 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=GravVtxWFrag01 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=GravVtxWFrag02 ANIVFILE=MODELS\GravVtxWFrag02_a.3d DATAFILE=MODELS\GravVtxWFrag02_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GravVtxWFrag02 STRENGTH=0.1
#exec MESH ORIGIN MESH=GravVtxWFrag02 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=GravVtxWFrag02 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GravVtxWFrag02 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=GravVtxWFrag02 MESH=GravVtxWFrag02
#exec MESHMAP SCALE MESHMAP=GravVtxWFrag02 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=GravVtxWFrag02 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=GravVtxWFrag03 ANIVFILE=MODELS\GravVtxWFrag03_a.3d DATAFILE=MODELS\GravVtxWFrag03_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GravVtxWFrag03 STRENGTH=0.1
#exec MESH ORIGIN MESH=GravVtxWFrag03 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=GravVtxWFrag03 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GravVtxWFrag03 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=GravVtxWFrag03 MESH=GravVtxWFrag03
#exec MESHMAP SCALE MESHMAP=GravVtxWFrag03 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=GravVtxWFrag03 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=GravVtxWFrag04 ANIVFILE=MODELS\GravVtxWFrag04_a.3d DATAFILE=MODELS\GravVtxWFrag04_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GravVtxWFrag04 STRENGTH=0.1
#exec MESH ORIGIN MESH=GravVtxWFrag04 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=GravVtxWFrag04 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GravVtxWFrag04 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=GravVtxWFrag04 MESH=GravVtxWFrag04
#exec MESHMAP SCALE MESHMAP=GravVtxWFrag04 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=GravVtxWFrag04 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=GravVtxWFrag05 ANIVFILE=MODELS\GravVtxWFrag05_a.3d DATAFILE=MODELS\GravVtxWFrag05_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GravVtxWFrag05 STRENGTH=0.1
#exec MESH ORIGIN MESH=GravVtxWFrag05 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=GravVtxWFrag05 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GravVtxWFrag05 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=GravVtxWFrag05 MESH=GravVtxWFrag05
#exec MESHMAP SCALE MESHMAP=GravVtxWFrag05 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=GravVtxWFrag05 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=GravVtxWFrag06 ANIVFILE=MODELS\GravVtxWFrag06_a.3d DATAFILE=MODELS\GravVtxWFrag06_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GravVtxWFrag06 STRENGTH=0.1
#exec MESH ORIGIN MESH=GravVtxWFrag06 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=GravVtxWFrag06 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GravVtxWFrag06 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=GravVtxWFrag06 MESH=GravVtxWFrag06
#exec MESHMAP SCALE MESHMAP=GravVtxWFrag06 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=GravVtxWFrag06 NUM=1 TEXTURE=DefaultTexture

#exec MESH IMPORT MESH=GravVtxWFrag07 ANIVFILE=MODELS\GravVtxWFrag07_a.3d DATAFILE=MODELS\GravVtxWFrag07_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=GravVtxWFrag07 STRENGTH=0.1
#exec MESH ORIGIN MESH=GravVtxWFrag07 X=0 Y=0 Z=0
#exec MESH SEQUENCE MESH=GravVtxWFrag07 SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=GravVtxWFrag07 SEQ=Still STARTFRAME=0 NUMFRAMES=1
#exec MESHMAP NEW MESHMAP=GravVtxWFrag07 MESH=GravVtxWFrag07
#exec MESHMAP SCALE MESHMAP=GravVtxWFrag07 X=0.1 Y=0.1 Z=0.2
#exec MESHMAP SETTEXTURE MESHMAP=GravVtxWFrag07 NUM=1 TEXTURE=DefaultTexture

var() mesh GravVtxWFragMeshes[7];
var() float PullForce;
var() float FlowRotational;

simulated function PostBeginPlay()
{
local rotator r;
local vector FlowDir;

	r = Rotation;
	r.Roll = Rand(16384)*4;
	SetRotation(r);
	
	RotationRate.Pitch = (Rand(20000) - 5000) * 8;
	RotationRate.Yaw = (Rand(20000) - 5000) * 8;
	
	Mesh = GravVtxWFragMeshes[Rand(ArrayCount(GravVtxWFragMeshes))];
	if (Owner != None)
	{
		DrawScale = FMin(20, VSize(Location - Owner.Location)/200);
		FlowDir = (Normal(Owner.Location - Location) >> (FlowRotational*rot(0,1,0)));
		Velocity = PullForce * vector(Rotation);
	}
	
	SetTimer(0.1, True);
}

simulated function Timer()
{
local vector FlowDir;
local float oldVelMag;

	if (Owner != None && !Owner.bDeleteMe)
	{
		FlowDir = (Normal(Owner.Location - Location) >> (FlowRotational*rot(0,1,0)));
		oldVelMag = VSize(Velocity);
		Velocity += (PullForce * FlowDir);
		Velocity = Normal(Velocity) * oldVelMag;
		if (VSize(Owner.Location - Location) <= 200)
			Destroy();
	}
	else
		Destroy();
}

simulated singular function TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType);

simulated function HitWall (vector HitNormal, actor Wall)
{
	Velocity = (VRand()*0.5 + HitNormal) * PullForce;
}

defaultproperties
{
    DrawType=DT_Mesh
    Mesh=GravVtxWFrag01
	
    bNetTemporary=False
    Physics=PHYS_Falling
    RemoteRole=ROLE_SimulatedProxy
    LifeSpan=10.000000
    CollisionRadius=0.000000
    CollisionHeight=0.000000
	bProjTarget=True
    bBounce=True
    bFixedRotationDir=True
    NetPriority=1.400000
	
	GravVtxWFragMeshes(0)=GravVtxWFrag01
	GravVtxWFragMeshes(1)=GravVtxWFrag02
	GravVtxWFragMeshes(2)=GravVtxWFrag03
	GravVtxWFragMeshes(3)=GravVtxWFrag04
	GravVtxWFragMeshes(4)=GravVtxWFrag05
	GravVtxWFragMeshes(5)=GravVtxWFrag06
	GravVtxWFragMeshes(6)=GravVtxWFrag07
	
	PullForce=1500.000000
	FlowRotational=-12000.000000
}
