//////////////////////////////////////////////////////////////
//	Nali Weapons III Flame Tracker Flames
//				Feralidragon (21-07-2010)
//
// NW3 FLAME TRACKER BUILD 1.00
//////////////////////////////////////////////////////////////

class FlamesT expands NaliDynColorProjectile;

//Red Component
#exec TEXTURE IMPORT NAME=FlamesTRed01A FILE=FlamesTRed\FlamesTRed01A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed02A FILE=FlamesTRed\FlamesTRed02A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed03A FILE=FlamesTRed\FlamesTRed03A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed04A FILE=FlamesTRed\FlamesTRed04A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed05A FILE=FlamesTRed\FlamesTRed05A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed06A FILE=FlamesTRed\FlamesTRed06A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed07A FILE=FlamesTRed\FlamesTRed07A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed08A FILE=FlamesTRed\FlamesTRed08A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed09A FILE=FlamesTRed\FlamesTRed09A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed10A FILE=FlamesTRed\FlamesTRed10A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed11A FILE=FlamesTRed\FlamesTRed11A.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed12A FILE=FlamesTRed\FlamesTRed12A.bmp GROUP=FlamesRed FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTRed01B FILE=FlamesTRed\FlamesTRed01B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed02B FILE=FlamesTRed\FlamesTRed02B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed03B FILE=FlamesTRed\FlamesTRed03B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed04B FILE=FlamesTRed\FlamesTRed04B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed05B FILE=FlamesTRed\FlamesTRed05B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed06B FILE=FlamesTRed\FlamesTRed06B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed07B FILE=FlamesTRed\FlamesTRed07B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed08B FILE=FlamesTRed\FlamesTRed08B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed09B FILE=FlamesTRed\FlamesTRed09B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed10B FILE=FlamesTRed\FlamesTRed10B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed11B FILE=FlamesTRed\FlamesTRed11B.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed12B FILE=FlamesTRed\FlamesTRed12B.bmp GROUP=FlamesRed FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTRed01C FILE=FlamesTRed\FlamesTRed01C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed02C FILE=FlamesTRed\FlamesTRed02C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed03C FILE=FlamesTRed\FlamesTRed03C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed04C FILE=FlamesTRed\FlamesTRed04C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed05C FILE=FlamesTRed\FlamesTRed05C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed06C FILE=FlamesTRed\FlamesTRed06C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed07C FILE=FlamesTRed\FlamesTRed07C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed08C FILE=FlamesTRed\FlamesTRed08C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed09C FILE=FlamesTRed\FlamesTRed09C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed10C FILE=FlamesTRed\FlamesTRed10C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed11C FILE=FlamesTRed\FlamesTRed11C.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed12C FILE=FlamesTRed\FlamesTRed12C.bmp GROUP=FlamesRed FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTRed01D FILE=FlamesTRed\FlamesTRed01D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed02D FILE=FlamesTRed\FlamesTRed02D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed03D FILE=FlamesTRed\FlamesTRed03D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed04D FILE=FlamesTRed\FlamesTRed04D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed05D FILE=FlamesTRed\FlamesTRed05D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed06D FILE=FlamesTRed\FlamesTRed06D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed07D FILE=FlamesTRed\FlamesTRed07D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed08D FILE=FlamesTRed\FlamesTRed08D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed09D FILE=FlamesTRed\FlamesTRed09D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed10D FILE=FlamesTRed\FlamesTRed10D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed11D FILE=FlamesTRed\FlamesTRed11D.bmp GROUP=FlamesRed FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTRed12D FILE=FlamesTRed\FlamesTRed12D.bmp GROUP=FlamesRed FLAGS=2

//Green Component
#exec TEXTURE IMPORT NAME=FlamesTGreen01A FILE=FlamesTGreen\FlamesTGreen01A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen02A FILE=FlamesTGreen\FlamesTGreen02A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen03A FILE=FlamesTGreen\FlamesTGreen03A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen04A FILE=FlamesTGreen\FlamesTGreen04A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen05A FILE=FlamesTGreen\FlamesTGreen05A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen06A FILE=FlamesTGreen\FlamesTGreen06A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen07A FILE=FlamesTGreen\FlamesTGreen07A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen08A FILE=FlamesTGreen\FlamesTGreen08A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen09A FILE=FlamesTGreen\FlamesTGreen09A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen10A FILE=FlamesTGreen\FlamesTGreen10A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen11A FILE=FlamesTGreen\FlamesTGreen11A.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen12A FILE=FlamesTGreen\FlamesTGreen12A.bmp GROUP=FlamesGreen FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTGreen01B FILE=FlamesTGreen\FlamesTGreen01B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen02B FILE=FlamesTGreen\FlamesTGreen02B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen03B FILE=FlamesTGreen\FlamesTGreen03B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen04B FILE=FlamesTGreen\FlamesTGreen04B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen05B FILE=FlamesTGreen\FlamesTGreen05B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen06B FILE=FlamesTGreen\FlamesTGreen06B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen07B FILE=FlamesTGreen\FlamesTGreen07B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen08B FILE=FlamesTGreen\FlamesTGreen08B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen09B FILE=FlamesTGreen\FlamesTGreen09B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen10B FILE=FlamesTGreen\FlamesTGreen10B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen11B FILE=FlamesTGreen\FlamesTGreen11B.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen12B FILE=FlamesTGreen\FlamesTGreen12B.bmp GROUP=FlamesGreen FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTGreen01C FILE=FlamesTGreen\FlamesTGreen01C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen02C FILE=FlamesTGreen\FlamesTGreen02C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen03C FILE=FlamesTGreen\FlamesTGreen03C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen04C FILE=FlamesTGreen\FlamesTGreen04C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen05C FILE=FlamesTGreen\FlamesTGreen05C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen06C FILE=FlamesTGreen\FlamesTGreen06C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen07C FILE=FlamesTGreen\FlamesTGreen07C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen08C FILE=FlamesTGreen\FlamesTGreen08C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen09C FILE=FlamesTGreen\FlamesTGreen09C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen10C FILE=FlamesTGreen\FlamesTGreen10C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen11C FILE=FlamesTGreen\FlamesTGreen11C.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen12C FILE=FlamesTGreen\FlamesTGreen12C.bmp GROUP=FlamesGreen FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTGreen01D FILE=FlamesTGreen\FlamesTGreen01D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen02D FILE=FlamesTGreen\FlamesTGreen02D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen03D FILE=FlamesTGreen\FlamesTGreen03D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen04D FILE=FlamesTGreen\FlamesTGreen04D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen05D FILE=FlamesTGreen\FlamesTGreen05D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen06D FILE=FlamesTGreen\FlamesTGreen06D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen07D FILE=FlamesTGreen\FlamesTGreen07D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen08D FILE=FlamesTGreen\FlamesTGreen08D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen09D FILE=FlamesTGreen\FlamesTGreen09D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen10D FILE=FlamesTGreen\FlamesTGreen10D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen11D FILE=FlamesTGreen\FlamesTGreen11D.bmp GROUP=FlamesGreen FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTGreen12D FILE=FlamesTGreen\FlamesTGreen12D.bmp GROUP=FlamesGreen FLAGS=2

//Blue Component
#exec TEXTURE IMPORT NAME=FlamesTBlue01A FILE=FlamesTBlue\FlamesTBlue01A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue02A FILE=FlamesTBlue\FlamesTBlue02A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue03A FILE=FlamesTBlue\FlamesTBlue03A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue04A FILE=FlamesTBlue\FlamesTBlue04A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue05A FILE=FlamesTBlue\FlamesTBlue05A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue06A FILE=FlamesTBlue\FlamesTBlue06A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue07A FILE=FlamesTBlue\FlamesTBlue07A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue08A FILE=FlamesTBlue\FlamesTBlue08A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue09A FILE=FlamesTBlue\FlamesTBlue09A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue10A FILE=FlamesTBlue\FlamesTBlue10A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue11A FILE=FlamesTBlue\FlamesTBlue11A.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue12A FILE=FlamesTBlue\FlamesTBlue12A.bmp GROUP=FlamesBlue FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTBlue01B FILE=FlamesTBlue\FlamesTBlue01B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue02B FILE=FlamesTBlue\FlamesTBlue02B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue03B FILE=FlamesTBlue\FlamesTBlue03B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue04B FILE=FlamesTBlue\FlamesTBlue04B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue05B FILE=FlamesTBlue\FlamesTBlue05B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue06B FILE=FlamesTBlue\FlamesTBlue06B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue07B FILE=FlamesTBlue\FlamesTBlue07B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue08B FILE=FlamesTBlue\FlamesTBlue08B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue09B FILE=FlamesTBlue\FlamesTBlue09B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue10B FILE=FlamesTBlue\FlamesTBlue10B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue11B FILE=FlamesTBlue\FlamesTBlue11B.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue12B FILE=FlamesTBlue\FlamesTBlue12B.bmp GROUP=FlamesBlue FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTBlue01C FILE=FlamesTBlue\FlamesTBlue01C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue02C FILE=FlamesTBlue\FlamesTBlue02C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue03C FILE=FlamesTBlue\FlamesTBlue03C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue04C FILE=FlamesTBlue\FlamesTBlue04C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue05C FILE=FlamesTBlue\FlamesTBlue05C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue06C FILE=FlamesTBlue\FlamesTBlue06C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue07C FILE=FlamesTBlue\FlamesTBlue07C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue08C FILE=FlamesTBlue\FlamesTBlue08C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue09C FILE=FlamesTBlue\FlamesTBlue09C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue10C FILE=FlamesTBlue\FlamesTBlue10C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue11C FILE=FlamesTBlue\FlamesTBlue11C.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue12C FILE=FlamesTBlue\FlamesTBlue12C.bmp GROUP=FlamesBlue FLAGS=2

#exec TEXTURE IMPORT NAME=FlamesTBlue01D FILE=FlamesTBlue\FlamesTBlue01D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue02D FILE=FlamesTBlue\FlamesTBlue02D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue03D FILE=FlamesTBlue\FlamesTBlue03D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue04D FILE=FlamesTBlue\FlamesTBlue04D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue05D FILE=FlamesTBlue\FlamesTBlue05D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue06D FILE=FlamesTBlue\FlamesTBlue06D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue07D FILE=FlamesTBlue\FlamesTBlue07D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue08D FILE=FlamesTBlue\FlamesTBlue08D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue09D FILE=FlamesTBlue\FlamesTBlue09D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue10D FILE=FlamesTBlue\FlamesTBlue10D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue11D FILE=FlamesTBlue\FlamesTBlue11D.bmp GROUP=FlamesBlue FLAGS=2
#exec TEXTURE IMPORT NAME=FlamesTBlue12D FILE=FlamesTBlue\FlamesTBlue12D.bmp GROUP=FlamesBlue FLAGS=2

var() texture RedFlamesA[12], RedFlamesB[12], RedFlamesC[12], RedFlamesD[12];
var() texture GreenFlamesA[12], GreenFlamesB[12], GreenFlamesC[12], GreenFlamesD[12];
var() texture BlueFlamesA[12], BlueFlamesB[12], BlueFlamesC[12], BlueFlamesD[12];

var float FlamesRate, FlameFrameC;
var byte FlameIndex, FlameType;
var float HurtCount;
var int maxNotInflamableClasses;

var() float MinDrawScale, MaxDrawScale;

function BeginPlay()
{
	LoadLists();
	if (Class'FlameTracker'.default.FlamesOutSpeed > 0)
	{
		speed = Class'FlameTracker'.default.FlamesOutSpeed;
		MaxSpeed = speed * default.MaxSpeed / default.speed;
	}
	Super.BeginPlay();
}

simulated function PostBeginPlay()
{
local byte t;

	FlamesRate = LifeSpan / ArrayCount(RedFlamesA);
	FlameFrameC = FlamesRate;
	FlameType = Rand(4);
	
	if (FlameType == 0)
	{
		RedCompTex[0] = RedFlamesA[0];
		GreenCompTex[0] = GreenFlamesA[0];
		BlueCompTex[0] = BlueFlamesA[0];
	}
	else if (FlameType == 1)
	{
		RedCompTex[0] = RedFlamesB[0];
		GreenCompTex[0] = GreenFlamesB[0];
		BlueCompTex[0] = BlueFlamesB[0];
	}
	else if (FlameType == 2)
	{
		RedCompTex[0] = RedFlamesC[0];
		GreenCompTex[0] = GreenFlamesC[0];
		BlueCompTex[0] = BlueFlamesC[0];
	}
	else
	{
		RedCompTex[0] = RedFlamesD[0];
		GreenCompTex[0] = GreenFlamesD[0];
		BlueCompTex[0] = BlueFlamesD[0];
	}
	
	Super.PostBeginPlay();
}

function LoadLists()
{
local int i;

	maxNotInflamableClasses = ArrayCount(class'FlameTracker'.default.NotInflamableObject);
	if (Class'FlameTracker'.default.bOptimizeLists)
	{
		for (i = 0; i < ArrayCount(class'FlameTracker'.default.NotInflamableObject); i++)
		{
			if (class'FlameTracker'.default.NotInflamableObject[i] == '')
			{
				maxNotInflamableClasses = i;
				break;
			}
		}
	}
}

simulated function Tick(float Delta)
{
	Super.Tick(Delta);
	
	DrawScale = (Default.LifeSpan - LifeSpan) * (MaxDrawScale - MinDrawScale) / Default.LifeSpan + MinDrawScale;
	if (Role == ROLE_Authority)
	{
		MomentumTransfer = Int(LifeSpan * Default.MomentumTransfer / Default.LifeSpan);
		Damage = LifeSpan * Default.Damage / Default.LifeSpan;
		DmgRadius = 31 * DrawScale;
		
		HurtCount -= Delta;
		if (HurtCount <= 0)
		{
			if (Class'FlameTracker'.default.FlamesDamageRate > 0)
				HurtCount = 1/Class'FlameTracker'.default.FlamesDamageRate;
			else
				HurtCount = 0.2;
			CheckClientCarcasses(DmgRadius * FMax(1.0, Splasher));
			HurtRadiusX(FMax(Damage * FMax(1.0,MoreDamage), 1), DmgRadius * FMax(1.0, Splasher), MyDamageType, MomentumTransfer * (KickBack + 1), Location);
		}
	}
	
	if (greenComp != None)
		greenComp.DrawScale = DrawScale;
	if (blueComp != None)
		blueComp.DrawScale = DrawScale;
	
	if (bUpdating && Level.NetMode != NM_DedicatedServer)
	{
		FlameFrameC -= Delta;
		BaseScaleGlow -= (Delta/Default.LifeSpan);
		if (FlameFrameC <= 0)
		{
			FlameFrameC = FlamesRate;
			FlameIndex++;
			SetFlameFrame(FlameIndex);
		}
	}
}

simulated function CheckClientCarcasses( float Radius)
{
local Carcass c;

	if (Level.NetMode != NM_StandAlone && Level.NetMode != NM_DedicatedServer)
	{
		ForEach VisibleCollidingActors(Class'Carcass', c, Radius)
		{
			if (!c.bShadowCast)
			{
				Spawn(Class'NWFlameController', c,, c.Location);
				c.bShadowCast = True;
			}
		}
	}
}

simulated function SetFlameFrame(byte i)
{
	if (i < ArrayCount(RedFlamesA))
	{
		if (FlameType == 0)
		{
			Texture = RedFlamesA[i];
		
			if (greenComp != None)
				greenComp.Texture = GreenFlamesA[i];
			if (blueComp != None)
				blueComp.Texture = BlueFlamesA[i];
		}
		else if (FlameType == 1)
		{
			Texture = RedFlamesB[i];
		
			if (greenComp != None)
				greenComp.Texture = GreenFlamesB[i];
			if (blueComp != None)
				blueComp.Texture = BlueFlamesB[i];
		}
		else if (FlameType == 2)
		{
			Texture = RedFlamesC[i];
		
			if (greenComp != None)
				greenComp.Texture = GreenFlamesC[i];
			if (blueComp != None)
				blueComp.Texture = BlueFlamesC[i];
		}
		else
		{
			Texture = RedFlamesD[i];
		
			if (greenComp != None)
				greenComp.Texture = GreenFlamesD[i];
			if (blueComp != None)
				blueComp.Texture = BlueFlamesD[i];
		}
	}
}

simulated function HitWall (vector HitNormal, actor Wall)
{
local Decal d;
local vector Dir, FinalDir;

    if ( Role == ROLE_Authority )
    {
        if ( (Mover(Wall) != None) && Mover(Wall).bDamageTriggered )
            Wall.TakeDamage( Damage * FMax(1.0,MoreDamage), instigator, Location, MomentumTransfer * Normal(Velocity) * (KickBack + 1), '');
    }
	
	Dir = vector(Rotation);
	
	if ((Dir dot (-HitNormal)) > 0.95)
	{
		FinalDir.Z = 2*FRand() - 1;
		FinalDir.Y = 2*FRand() - 1;
		FinalDir.X = 1;
		
		FinalDir = Normal((FinalDir >> rotator(-HitNormal)));
	}
	else
	{
		FinalDir = ((Dir cross HitNormal) cross HitNormal);
		if ((FinalDir dot Dir) < 0)
			FinalDir = -FinalDir;
	}
	
	Move(HitNormal*3);
	Velocity = 1.25 * speed * FinalDir;
	Acceleration = FinalDir * ProjAccel;
	
	if (LifeSpan < Default.LifeSpan / 2)
		bNeverHurtInstigator = !Class'FlameTracker'.default.bBurnInstigator;
}

function bool ProcessHurtRadiusVictim( Actor Victim)
{
local bool bHurt;
local FlameTCorpseAttach ftc;
local ZoneInfo VictZone;

	VictZone = Victim.Region.Zone;
	if (VictZone.bWaterZone && !VictZone.IsA('LavaZone') && VictZone.DamageType != 'Burned')
		return True;
	
	if (LifeSpan < 0.25)
		return True;

	if (Victim.IsA('CreatureChunks') || Victim.IsA('UTCreatureChunks'))
	{
		if (!Victim.bShadowCast)
		{
			Spawn(Class'NWFlameController', Victim,, Victim.Location);
			Victim.bShadowCast = True;
		}
		
		return True;
	}
	else if (Victim.Mesh != None && (!Victim.bHidden || Victim.IsA('Vehicle')) && CheckInflamableActor(Victim))
	{
		bHurt = True;
		
		if (Pawn(Victim) != None)
			bHurt = bHurt && !noHurtThisPawn(Pawn(Victim));
		
		if (!Victim.bShadowCast && bHurt)
		{
			ftc = Spawn(Class'FlameTCorpseAttach', Victim,, Victim.Location);
			ftc.MoreDamage = MoreDamage;
			ftc.HealthGiver = HealthGiver;
			Victim.bShadowCast = True;
		}
		
		if (Victim.IsA('Carcass'))
			return True;
	}
	
	return False;
}

function bool CheckInflamableActor( Actor A)
{
local int i;

	if (class'FlameTracker'.default.bInvertListsProcessing)
	{
		for (i = maxNotInflamableClasses-1; i >= 0; i--)
		{
			if (class'FlameTracker'.default.NotInflamableObject[i] != '' && A.IsA(class'FlameTracker'.default.NotInflamableObject[i]))
				return False;
		}
	}
	else
	{
		for (i = 0; i < maxNotInflamableClasses; i++)
		{
			if (class'FlameTracker'.default.NotInflamableObject[i] != '' && A.IsA(class'FlameTracker'.default.NotInflamableObject[i]))
				return False;
		}
	}
	
	if ((A.bStatic || A.bNoDelete) && !class'FlameTracker'.default.BurnStaticObjects)
		return False;
	
	if (A.IsA('Pawn') || A.IsA('Vehicle'))
		return True;
	
	if (A.IsA('Decoration'))
		return (!(A.IsA('Boulder') || A.IsA('CTFFlag') || A.IsA('MonkStatue') || A.IsA('Vase')));
	
	return False;
}

simulated function ZoneChange( Zoneinfo NewZone )
{
	if (NewZone.bWaterZone && !NewZone.IsA('LavaZone') && NewZone.DamageType != 'Burned')
	{
		SpawnSmoke();
		Destroy();
	}
}

simulated function SpawnSmoke()
{
local FlameTWaterSmoke s;

	if (Level.NetMode != NM_DedicatedServer)
	{
		s = Spawn(Class'FlameTWaterSmoke');
		s.DrawScale = DrawScale * 2.15;
		s.ScaleGlow = BaseScaleGlow;
	}
}

defaultproperties
{
    DrawType=DT_Sprite
	
	bUnlit=True
	DrawScale=0.250000
	ScaleGlow=1.650000
	Style=STY_Translucent
	
	bBounce=False
	bNetTemporary=True
	SpawnSound=None
	//AmbientSound=None
	//SoundRadius=52
	//SoundVolume=128
	
	//ExplosionDecal=Class'EMPDecal'
	MyDamageType=Burned
	DmgRadius=60.000000
	speed=850.000000
	MaxSpeed=1000.000000
	Damage=20.000000
	MomentumTransfer=50000
	ProjAccel=100.000000

	LightType=LT_Steady
    LightEffect=LE_NonIncidence
    LightBrightness=50
    LightHue=0
    LightSaturation=0
    LightRadius=7
	
	MinDrawScale=0.150000
	MaxDrawScale=7.400000
	bCollideActors=False
	LifeSpan=1.000000
	
	bNeverHurtInstigator=True
	bNoHurtTeam=True
	bDirectionalBlow=True
	
	RedCompTex(0)=FlamesTRed01
	GreenCompTex(0)=FlamesTGreen01
	BlueCompTex(0)=FlamesTBlue01
	
	ProjectileColor(0)=(bUseThisColor=True,ProjColor=(R=0,G=128,B=255),bFadeToNext=True,FadeTime=0.200000,LifeTime=0.200000)
	ProjectileColor(1)=(bUseThisColor=True,ProjColor=(R=255,G=255,B=0),bFadeToNext=True,FadeTime=0.150000,LifeTime=0.200000)
	ProjectileColor(2)=(bUseThisColor=True,ProjColor=(R=255,G=96,B=0),bFadeToNext=True,FadeTime=0.400000,LifeTime=0.400000)
	ProjectileColor(3)=(bUseThisColor=True,ProjColor=(R=128,G=0,B=0),LifeTime=1.000000)
	
	RedFlamesA(0)=FlamesTRed01A
	RedFlamesA(1)=FlamesTRed02A
	RedFlamesA(2)=FlamesTRed03A
	RedFlamesA(3)=FlamesTRed04A
	RedFlamesA(4)=FlamesTRed05A
	RedFlamesA(5)=FlamesTRed06A
	RedFlamesA(6)=FlamesTRed07A
	RedFlamesA(7)=FlamesTRed08A
	RedFlamesA(8)=FlamesTRed09A
	RedFlamesA(9)=FlamesTRed10A
	RedFlamesA(10)=FlamesTRed11A
	RedFlamesA(11)=FlamesTRed12A
	
	RedFlamesB(0)=FlamesTRed01B
	RedFlamesB(1)=FlamesTRed02B
	RedFlamesB(2)=FlamesTRed03B
	RedFlamesB(3)=FlamesTRed04B
	RedFlamesB(4)=FlamesTRed05B
	RedFlamesB(5)=FlamesTRed06B
	RedFlamesB(6)=FlamesTRed07B
	RedFlamesB(7)=FlamesTRed08B
	RedFlamesB(8)=FlamesTRed09B
	RedFlamesB(9)=FlamesTRed10B
	RedFlamesB(10)=FlamesTRed11B
	RedFlamesB(11)=FlamesTRed12B
	
	RedFlamesC(0)=FlamesTRed01C
	RedFlamesC(1)=FlamesTRed02C
	RedFlamesC(2)=FlamesTRed03C
	RedFlamesC(3)=FlamesTRed04C
	RedFlamesC(4)=FlamesTRed05C
	RedFlamesC(5)=FlamesTRed06C
	RedFlamesC(6)=FlamesTRed07C
	RedFlamesC(7)=FlamesTRed08C
	RedFlamesC(8)=FlamesTRed09C
	RedFlamesC(9)=FlamesTRed10C
	RedFlamesC(10)=FlamesTRed11C
	RedFlamesC(11)=FlamesTRed12C
	
	RedFlamesD(0)=FlamesTRed01D
	RedFlamesD(1)=FlamesTRed02D
	RedFlamesD(2)=FlamesTRed03D
	RedFlamesD(3)=FlamesTRed04D
	RedFlamesD(4)=FlamesTRed05D
	RedFlamesD(5)=FlamesTRed06D
	RedFlamesD(6)=FlamesTRed07D
	RedFlamesD(7)=FlamesTRed08D
	RedFlamesD(8)=FlamesTRed09D
	RedFlamesD(9)=FlamesTRed10D
	RedFlamesD(10)=FlamesTRed11D
	RedFlamesD(11)=FlamesTRed12D
	
	GreenFlamesA(0)=FlamesTGreen01A
	GreenFlamesA(1)=FlamesTGreen02A
	GreenFlamesA(2)=FlamesTGreen03A
	GreenFlamesA(3)=FlamesTGreen04A
	GreenFlamesA(4)=FlamesTGreen05A
	GreenFlamesA(5)=FlamesTGreen06A
	GreenFlamesA(6)=FlamesTGreen07A
	GreenFlamesA(7)=FlamesTGreen08A
	GreenFlamesA(8)=FlamesTGreen09A
	GreenFlamesA(9)=FlamesTGreen10A
	GreenFlamesA(10)=FlamesTGreen11A
	GreenFlamesA(11)=FlamesTGreen12A
	
	GreenFlamesB(0)=FlamesTGreen01B
	GreenFlamesB(1)=FlamesTGreen02B
	GreenFlamesB(2)=FlamesTGreen03B
	GreenFlamesB(3)=FlamesTGreen04B
	GreenFlamesB(4)=FlamesTGreen05B
	GreenFlamesB(5)=FlamesTGreen06B
	GreenFlamesB(6)=FlamesTGreen07B
	GreenFlamesB(7)=FlamesTGreen08B
	GreenFlamesB(8)=FlamesTGreen09B
	GreenFlamesB(9)=FlamesTGreen10B
	GreenFlamesB(10)=FlamesTGreen11B
	GreenFlamesB(11)=FlamesTGreen12B
	
	GreenFlamesC(0)=FlamesTGreen01C
	GreenFlamesC(1)=FlamesTGreen02C
	GreenFlamesC(2)=FlamesTGreen03C
	GreenFlamesC(3)=FlamesTGreen04C
	GreenFlamesC(4)=FlamesTGreen05C
	GreenFlamesC(5)=FlamesTGreen06C
	GreenFlamesC(6)=FlamesTGreen07C
	GreenFlamesC(7)=FlamesTGreen08C
	GreenFlamesC(8)=FlamesTGreen09C
	GreenFlamesC(9)=FlamesTGreen10C
	GreenFlamesC(10)=FlamesTGreen11C
	GreenFlamesC(11)=FlamesTGreen12C
	
	GreenFlamesD(0)=FlamesTGreen01D
	GreenFlamesD(1)=FlamesTGreen02D
	GreenFlamesD(2)=FlamesTGreen03D
	GreenFlamesD(3)=FlamesTGreen04D
	GreenFlamesD(4)=FlamesTGreen05D
	GreenFlamesD(5)=FlamesTGreen06D
	GreenFlamesD(6)=FlamesTGreen07D
	GreenFlamesD(7)=FlamesTGreen08D
	GreenFlamesD(8)=FlamesTGreen09D
	GreenFlamesD(9)=FlamesTGreen10D
	GreenFlamesD(10)=FlamesTGreen11D
	GreenFlamesD(11)=FlamesTGreen12D
	
	BlueFlamesA(0)=FlamesTBlue01A
	BlueFlamesA(1)=FlamesTBlue02A
	BlueFlamesA(2)=FlamesTBlue03A
	BlueFlamesA(3)=FlamesTBlue04A
	BlueFlamesA(4)=FlamesTBlue05A
	BlueFlamesA(5)=FlamesTBlue06A
	BlueFlamesA(6)=FlamesTBlue07A
	BlueFlamesA(7)=FlamesTBlue08A
	BlueFlamesA(8)=FlamesTBlue09A
	BlueFlamesA(9)=FlamesTBlue10A
	BlueFlamesA(10)=FlamesTBlue11A
	BlueFlamesA(11)=FlamesTBlue12A
	
	BlueFlamesB(0)=FlamesTBlue01B
	BlueFlamesB(1)=FlamesTBlue02B
	BlueFlamesB(2)=FlamesTBlue03B
	BlueFlamesB(3)=FlamesTBlue04B
	BlueFlamesB(4)=FlamesTBlue05B
	BlueFlamesB(5)=FlamesTBlue06B
	BlueFlamesB(6)=FlamesTBlue07B
	BlueFlamesB(7)=FlamesTBlue08B
	BlueFlamesB(8)=FlamesTBlue09B
	BlueFlamesB(9)=FlamesTBlue10B
	BlueFlamesB(10)=FlamesTBlue11B
	BlueFlamesB(11)=FlamesTBlue12B
	
	BlueFlamesC(0)=FlamesTBlue01C
	BlueFlamesC(1)=FlamesTBlue02C
	BlueFlamesC(2)=FlamesTBlue03C
	BlueFlamesC(3)=FlamesTBlue04C
	BlueFlamesC(4)=FlamesTBlue05C
	BlueFlamesC(5)=FlamesTBlue06C
	BlueFlamesC(6)=FlamesTBlue07C
	BlueFlamesC(7)=FlamesTBlue08C
	BlueFlamesC(8)=FlamesTBlue09C
	BlueFlamesC(9)=FlamesTBlue10C
	BlueFlamesC(10)=FlamesTBlue11C
	BlueFlamesC(11)=FlamesTBlue12C
	
	BlueFlamesD(0)=FlamesTBlue01D
	BlueFlamesD(1)=FlamesTBlue02D
	BlueFlamesD(2)=FlamesTBlue03D
	BlueFlamesD(3)=FlamesTBlue04D
	BlueFlamesD(4)=FlamesTBlue05D
	BlueFlamesD(5)=FlamesTBlue06D
	BlueFlamesD(6)=FlamesTBlue07D
	BlueFlamesD(7)=FlamesTBlue08D
	BlueFlamesD(8)=FlamesTBlue09D
	BlueFlamesD(9)=FlamesTBlue10D
	BlueFlamesD(10)=FlamesTBlue11D
	BlueFlamesD(11)=FlamesTBlue12D
}
