//////////////////////////////////////////////////////////////
//	Nali Weapons III Bolt Rifle EMP
//				Feralidragon (26-06-2010)
//
// NW3 BOLT RIFLE BUILD 1.00
//////////////////////////////////////////////////////////////

class EMPSphere expands NaliProjectile;

#exec MESH IMPORT MESH=EMPSphere ANIVFILE=MODELS\EMPSphere_a.3d DATAFILE=MODELS\EMPSphere_d.3d X=0 Y=0 Z=0
#exec MESH LODPARAMS MESH=EMPSphere STRENGTH=0.5
#exec MESH ORIGIN MESH=EMPSphere X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=EMPSphere SEQ=All STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=EMPSphere SEQ=Still STARTFRAME=0 NUMFRAMES=1

#exec MESHMAP NEW MESHMAP=EMPSphere MESH=EMPSphere
#exec MESHMAP SCALE MESHMAP=EMPSphere X=0.1 Y=0.1 Z=0.2

#exec TEXTURE IMPORT NAME=EMPCover FILE=Effects\EMPCover.bmp GROUP=Effects FLAGS=2
#exec MESHMAP SETTEXTURE MESHMAP=EMPSphere NUM=1 TEXTURE=EMPCover

#exec AUDIO IMPORT NAME="EMPAmb" FILE=SOUNDS\EMPAmb.wav GROUP="Loop"

var EMPSparks Sparks1, Sparks2, Sparks3, Sparks4;
var() name ComboDamageType;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	SpawnSparks();
}

simulated function SpawnSparks()
{
	if (Level.NetMode != NM_DedicatedServer)
	{
		Sparks1 = Spawn(Class'EMPSparks', Self);
		Sparks2 = Spawn(Class'EMPSparks', Self);
		Sparks2.ChangeMesh(1);
		Sparks3 = Spawn(Class'EMPSparks', Self);
		Sparks3.ChangeMesh(2);
		Sparks4 = Spawn(Class'EMPSparks', Self);
		Sparks4.ChangeMesh(3);
	}
}

function ExplodeX(vector HitLocation, vector HitNormal, optional actor A)
{
local EMPSparksExpl empExpl;

	Spawn(class'EMPSphereExpl',,, HitLocation);
	Spawn(class'EMPGlowExpand',,, HitLocation);
	Spawn(class'EMPLightExpl',,, HitLocation);

	Spawn(class'EMPSparksExpl',,, HitLocation);
	empExpl = Spawn(class'EMPSparksExpl',,, HitLocation);
	empExpl.ChangeMesh(1);
	empExpl = Spawn(class'EMPSparksExpl',,, HitLocation);
	empExpl.ChangeMesh(2);
	empExpl = Spawn(class'EMPSparksExpl',,, HitLocation);
	empExpl.ChangeMesh(3);
	
	Super.ExplodeX(HitLocation, HitNormal, A);
	Spawn(class'EMPFlamesCarcasses',,, HitLocation);
}

simulated function ExplodeOnWall(vector HitNormal, actor Wall)
{
	if (Level.NetMode != NM_DedicatedServer)
		Spawn(class'EMPSmokeGen',,, Location);
}

simulated function ZoneChange(Zoneinfo NewZone)
{
local rotator R;
local byte i;

	if (NewZone.bWaterZone && Class'BoltRifle'.default.bWaterConductive) 
	{
		SpawnWaterEletricalFX();
		Destroy();
	}
	else
		Super.ZoneChange(NewZone);
}

function SpawnWaterEletricalFX()
{
local rotator R;
local byte i;
local BoltWaterShock bws;

	for (i = 0; i < 4; i++)
	{
		R.Yaw = Rand(32768) * 2;
		Spawn(Class'BoltWaterSparks',,,, R);
	}
	
	bws = Spawn(Class'BoltWaterShock',,,, rot(16384,0,0));
	bws.Kickback = Kickback;
	bws.Splasher = Splasher;
	bws.MoreDamage = MoreDamage;
	bws.HealthGiver = HealthGiver;
}

simulated function Destroyed()
{
	if (Sparks1 != None)
		Sparks1.Destroy();
	if (Sparks2 != None)
		Sparks2.Destroy();
	if (Sparks3 != None)
		Sparks3.Destroy();
	if (Sparks4 != None)
		Sparks4.Destroy();
		
	Sparks1 = None;
	Sparks2 = None;
	Sparks3 = None;
	Sparks4 = None;
	
	Super.Destroyed();
}

function Combo()
{
	Spawn(class'EMPLightCombo');
	ComboEffects();
	Destroy();
}

function ComboEffects()
{
local EMPSparksExplCombo empExpl;
local byte i;

	HurtRadiusX(Damage*3 * FMax(1.0,MoreDamage), 280 * FMax(1.0, Splasher), ComboDamageType, MomentumTransfer*2.5 * (KickBack + 1), Location );

	Spawn(class'EMPCombo');
	Spawn(class'EMPGlowComboSec');
	
	Spawn(class'EMPSparksExplCombo');
	empExpl = Spawn(class'EMPSparksExplCombo');
	empExpl.ChangeMesh(1);
	empExpl = Spawn(class'EMPSparksExplCombo');
	empExpl.ChangeMesh(2);
	empExpl = Spawn(class'EMPSparksExplCombo');
	empExpl.ChangeMesh(3);
	
	for (i = 0; i < 4; i++)
		Spawn(class'BoltTracedExpl',,,, RotRand());
	
	Spawn(class'EMPComboFlamesCarcasses',,, Location);
}

defaultproperties
{
    DrawType=DT_Mesh
    Mesh=EMPSphere
	
	bFixedRotationDir=True
	RotationRate=(Pitch=500000,Yaw=500000)
	
	bUnlit=True
	DrawScale=0.250000
	ScaleGlow=0.400000
	Style=STY_Translucent
	
	bBounce=False
	bNetTemporary=False
	SpawnSound=None
	AmbientSound=EMPAmb
	SoundRadius=52
	SoundVolume=128
	
	ExplosionDecal=Class'EMPDecal'
	MyDamageType=Electrified
	ComboDamageType=ElectricCombo
	DmgRadius=150.000000
	speed=850.000000
	MaxSpeed=1000.000000
	Damage=60.000000
	MomentumTransfer=30000
	bProjTarget=True
	ProjAccel=50.000000
	
	TrailClass1=Class'EMPLightTrail'
	TrailClass2=Class'EMPGlowTrail'
	
	LightType=LT_Steady
    LightEffect=LE_NonIncidence
    LightBrightness=100
    LightHue=165
    LightSaturation=72
    LightRadius=12
	
	CollisionHeight=12.000000
	CollisionRadius=12.000000
	bProjTarget=True
	ExplosionNoise=0.950000
	
	bWaterHitFX=True
	WaterSplashType=2
}
