//=============================================================================
// BloodBurst.
//=============================================================================
class UTB_BloodHit extends UT_BloodBurst;

simulated function SpawnCloud()
{
	local Actor A;

	if ( bGreenBlood )
		A = spawn(class'UT_GreenBloodPuff');
	else
		A = spawn(class'UT_BloodPuff');
	A.RemoteRole = ROLE_None;
}

Auto State StartUp
{
	simulated function Tick(float DeltaTime)
	{
		local vector WallHit, WallNormal;
		local Actor WallActor;

		if ( Level.NetMode != NM_DedicatedServer )
		{
			if ( FRand() < 0.25 )
			{
				WallActor = Trace(WallHit, WallNormal, Location + 30 * vector(Rotation), Location, false);
				if ( WallActor != None )
				{	
					if ( bGreenBlood )
						spawn(class'GBloodSplat',,,WallHit + 20 * (WallNormal + VRand()), rotator(WallNormal));
					else
						spawn(class'RBloodSplat',,,WallHit + 20 * (WallNormal + VRand()), rotator(WallNormal));
				}
			}
		}		
		Disable('Tick');
	}
}

defaultproperties
{
}
