//-------------------------------------------------//
// MoreBlood  2011 - Mr.Loathsome                  //
// Players & Monsters bleed where they take damage //
//-------------------------------------------------//
class MB expands Mutator;

#exec TEXTURE IMPORT NAME=RDrop1 FILE=RDrop1.pcx LODSET=2
#exec TEXTURE IMPORT NAME=RDrop2 FILE=RDrop2.pcx LODSET=2
#exec TEXTURE IMPORT NAME=RDrop3 FILE=RDrop3.pcx LODSET=2
#exec TEXTURE IMPORT NAME=RDrop4 FILE=RDrop4.pcx LODSET=2
#exec TEXTURE IMPORT NAME=RDrop5 FILE=RDrop5.pcx LODSET=2
#exec TEXTURE IMPORT NAME=RDrop6 FILE=RDrop6.pcx LODSET=2
#exec TEXTURE IMPORT NAME=RDrop7 FILE=RDrop7.pcx LODSET=2
#exec TEXTURE IMPORT NAME=RDrop8 FILE=RDrop8.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat1 FILE=Splat1.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat2 FILE=Splat2.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat3 FILE=Splat3.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat4 FILE=Splat4.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat5 FILE=Splat5.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat6 FILE=Splat6.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat7 FILE=Splat7.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat8 FILE=Splat8.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat9 FILE=Splat9.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat10 FILE=Splat10.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat11 FILE=Splat11.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat12 FILE=Splat12.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat13 FILE=Splat13.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat14 FILE=Splat14.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat15 FILE=Splat15.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat16 FILE=Splat16.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat17 FILE=Splat17.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat18 FILE=Splat18.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat19 FILE=Splat19.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat20 FILE=Splat20.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat21 FILE=Splat21.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat22 FILE=Splat22.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat23 FILE=Splat23.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat24 FILE=Splat24.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat25 FILE=Splat25.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat26 FILE=Splat26.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat27 FILE=Splat27.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat28 FILE=Splat28.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat29 FILE=Splat29.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat30 FILE=Splat30.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat31 FILE=Splat31.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat32 FILE=Splat32.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat33 FILE=Splat33.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat34 FILE=Splat34.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat35 FILE=Splat35.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat36 FILE=Splat36.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat37 FILE=Splat37.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat38 FILE=Splat38.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat39 FILE=Splat39.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat40 FILE=Splat40.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat41 FILE=Splat41.pcx LODSET=2
#exec TEXTURE IMPORT NAME=Splat42 FILE=Splat42.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat1 FILE=GSplat1.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat2 FILE=GSplat2.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat3 FILE=GSplat3.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat4 FILE=GSplat4.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat5 FILE=GSplat5.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat6 FILE=GSplat6.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat7 FILE=GSplat7.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat8 FILE=GSplat8.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat9 FILE=GSplat9.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat10 FILE=GSplat10.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat11 FILE=GSplat11.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat12 FILE=GSplat12.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat13 FILE=GSplat13.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat14 FILE=GSplat14.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat15 FILE=GSplat15.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat16 FILE=GSplat16.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat17 FILE=GSplat17.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat18 FILE=GSplat18.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat19 FILE=GSplat19.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat20 FILE=GSplat20.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat21 FILE=GSplat21.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat22 FILE=GSplat22.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat23 FILE=GSplat23.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat24 FILE=GSplat24.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat25 FILE=GSplat25.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat26 FILE=GSplat26.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat27 FILE=GSplat27.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat28 FILE=GSplat28.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat29 FILE=GSplat29.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat30 FILE=GSplat30.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat31 FILE=GSplat31.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat32 FILE=GSplat32.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat33 FILE=GSplat33.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat34 FILE=GSplat34.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat35 FILE=GSplat35.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat36 FILE=GSplat36.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat37 FILE=GSplat37.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat38 FILE=GSplat38.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat39 FILE=GSplat39.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat40 FILE=GSplat40.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat41 FILE=GSplat41.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GSplat42 FILE=GSplat42.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GDrop1 FILE=GDrop1.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GDrop2 FILE=GDrop2.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GDrop3 FILE=GDrop3.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GDrop4 FILE=GDrop4.pcx LODSET=2
#exec TEXTURE IMPORT NAME=GDrop5 FILE=GDrop5.pcx LODSET=2

var bool bRandomMode;
var bool bBloodPool;
var bool bDeathEffect;
var bool bGrnBPupae;
var bool bGrnBSlith;
var int MaxBleeders;
var float BleedTime;
var float BDLifeSpan;
var float BDDrawScale;
var float SpurtLevel;
var int MaxBleedersRV;
var float BleedTimeRV;
var float BDLifeSpanRV;
var float BDDrawScaleRV;
var float SpurtLevelRV;
var float SpawnRate;
var int MBdefHealth;
var bool bInitialized, bDoSpawn;

function Timer()
{
	bDoSpawn = True;
}

simulated function ModifyPlayer(Pawn Other)
{
	local int i;
	local DecalRotator DR;
	local BSDSRotator BSDS;
 
	if (Bot(Other) == None)
	{
		i = 0;
		foreach Other.ChildActors(class'DecalRotator', DR)
		{ i++; }
		if (i == 0)
			DR = Spawn(class'DecalRotator', Other, , , );
		i = 0;
		foreach Other.ChildActors(class'BSDSRotator', BSDS)
		{ i++; }
		if (i == 0)
			BSDS = Spawn(class'BSDSRotator', Other, , , );
	}
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

simulated function PostBeginPlay()
{
	if (bInitialized) return;
	else bInitialized = True;
	Level.Game.RegisterDamageMutator(Self);

	SpawnRate = class'MoreBloodConfig'.Default.SpawnRate;
	SpawnRate = FClamp(SpawnRate, 0.025, 2.0);
	bRandomMode = class'MoreBloodConfig'.Default.bRandomMode;
	bBloodPool = class'MoreBloodConfig'.Default.bBloodPool;
	bDeathEffect = class'MoreBloodConfig'.Default.bDeathEffect;
	bGrnBPupae = class'MoreBloodConfig'.Default.bGrnBPupae;
	bGrnBSlith = class'MoreBloodConfig'.Default.bGrnBSlith;
	MaxBleeders = class'MoreBloodConfig'.Default.MaxBleeders;
	BleedTime = class'MoreBloodConfig'.Default.BleedTime;
	BDLifeSpan = class'MoreBloodConfig'.Default.BDLifeSpan;
	BDDrawScale = class'MoreBloodConfig'.Default.BDDrawScale;
	SpurtLevel = class'MoreBloodConfig'.Default.SpurtLevel;
	MBdefHealth = class'MoreBloodConfig'.Default.MBdefHealth;
	if (bRandomMode)
	{
		MaxBleedersRV = class'MoreBloodConfig'.Default.MaxBleedersRV;
		BleedTimeRV = class'MoreBloodConfig'.Default.BleedTimeRV - (class'MoreBloodConfig'.Default.BleedTimeRV / 5);
		BDLifeSpanRV = class'MoreBloodConfig'.Default.BDLifeSpanRV - (class'MoreBloodConfig'.Default.BDLifeSpanRV / 5);
		BDDrawScaleRV = class'MoreBloodConfig'.Default.BDDrawScaleRV - (class'MoreBloodConfig'.Default.BDDrawScaleRV / 5);
		SpurtLevelRV = class'MoreBloodConfig'.Default.SpurtLevelRV - (class'MoreBloodConfig'.Default.SpurtLevelRV / 5);
		MaxBleeders = (FRand() * MaxBleedersRV) + 1;
		BleedTime = (FRand() * (BleedTimeRV - (BleedTimeRV / 5))) + (BleedTimeRV / 5);
		BDLifeSpan = (FRand() * (BDLifeSpanRV - (BDLifeSpanRV / 5))) + (BDLifeSpanRV / 5);
		BDDrawScale = (FRand() * (BDDrawScaleRV - (BDDrawScaleRV / 5))) + (BDDrawScaleRV / 5);
		SpurtLevel = (FRand() * (SpurtLevelRV - (SpurtLevelRV / 5))) + (SpurtLevelRV / 5);
		Clamp(MaxBleeders, 1, 80);
		FClamp(BleedTime, 0.50, 80.0);
		FClamp(BDLifeSpan, 1.0, class'MoreBloodConfig'.Default.BDLifeSpanRV);
		FClamp(BDDrawScale, 0.125, 2.0);
		class'MoreBloodConfig'.Default.MaxBleeders = MaxBleeders;
		class'MoreBloodConfig'.Default.BleedTime = BleedTime;
		class'MoreBloodConfig'.Default.BDLifeSpan = BDLifeSpan;
		class'MoreBloodConfig'.Default.BDDrawScale = BDDrawScale;
		class'MoreBloodConfig'.Default.SpurtLevel = SpurtLevel;
		class'MoreBloodConfig'.static.StaticSaveConfig();				
		log("MaxBleeders = "$MaxBleeders$"  BleedTime = "$BleedTime$"  BDLifeSpan = "$BDLifeSpan$"  BDDrawScale = "$BDDrawScale$"  SpurtLevel = "$SpurtLevel);

	}
	else
	{
		Clamp(MaxBleeders, 1, 80);
		FClamp(BleedTime, 0.50, 80.0);
		FClamp(BDLifeSpan, 1.0, class'MoreBloodConfig'.Default.BDLifeSpanRV);
		FClamp(BDDrawScale, 0.125, 2.0);
	}
	if (bGrnBPupae) class'Pupae'.Default.bGreenBlood = True;
	if (bGrnBSlith) class'Slith'.Default.bGreenBlood = True;
	bDoSpawn = True;
	Super.PostBeginPlay();
}

function MutatorTakeDamage(out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	local BleederEffectSpawner BES;
	local class<Effects> EffS;
	local int j, nb, rv;
	local string s;

	if (((Victim.Health - ActualDamage) <= 0) && (bDoSpawn))
		{
			if ((bBloodPool) || (bDeathEffect))
			{
				if ((bBloodPool) && (ScriptedPawn(Victim) == None) && (ActualDamage < 60))
					{
						Spawn(class'UTB_BloodPool', Victim, , Victim.Location, );
					}
				if (bDeathEffect) { DeathEffect(Victim); SetTimer((SpawnRate*2), False); bDoSpawn = False; }
			}
		}
	else
	{
	if ((ActualDamage > 0) && (bDoSpawn) && (HitLocation != vect(0,0,0)))
		{
			nb = NumBleeders(Victim);
			if ((nb < MaxBleeders) && (nb <= (Victim.health * 0.10)))
			{
				BES = Spawn(class'BleederEffectSpawner', Victim, , HitLocation, Victim.Rotation);
				if (BES != None)
				{
					j = ActualDamage * BleedTime;
					BES.InitSpawner();
					if ((ScriptedPawn(Victim) != None) && (ScriptedPawn(Victim).bGreenBlood))
					{
						rv = (FRand()*6);
						Switch(rv)
						{
							case 5:
								EffS = class'GBloodDrop3';
								break;
							case 4:
								EffS = class'GBloodDrop2';
								break;
							case 3:
								EffS = class'GBloodDrop2';
								break;
							case 2:
								EffS = class'GreenBlob';
								break;
							case 1:
								EffS = class'GreenBloodPuff';
								break;
							case 0:
								EffS = class'GreenBloodSpray';
								break;
						}
					}
					else
					{
						rv = (FRand()*9);
						Switch(rv)
						{
							case 8:
								EffS = class'BloodDrop2';
								break;
							case 7:
								EffS = class'UTB_BloodDrop3';
								break;
							case 6:
								EffS = class'BloodDrop2';
								break;
							case 5:
								EffS = class'UTB_BloodHit';
								break;
							case 4:
								EffS = class'UT_BloodBurst';
								break;
							case 3:
								EffS = class'UTB_BloodDrop3';
								break;
							case 2:
								EffS = class'UT_BloodPuff';
								break;
							case 1:
								EffS = class'BloodDrop2';
								break;
							case 0:
								EffS = class'UTB_BloodDrop2';
								break;
						}
					}
					BES.SetSpawnProperties(((FRand() * SpawnRate) + 0.5), FMin(j, 255), EffS, MBdefHealth);
//					BES = None;
					SetTimer(SpawnRate, False);
					bDoSpawn = False;
				}
			}
		}
	}
	Super.MutatorTakeDamage(ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
}

function int NumBleeders(Pawn Other)
{
	local BleederEffectSpawner BES;
	local int nb;

	nb = 0;
	foreach Other.ChildActors(class'BleederEffectSpawner', BES)
	{
		nb++;
	}
	return nb;
}

function DeathEffect(Pawn Other)
{
	local DeathEffectSpawner DES;
	local class<Effects> EffS;

	DES = Spawn(class'DeathEffectSpawner', Other, , Other.Location, Other.Rotation);
	if (DES != None)
	{
		if ((ScriptedPawn(Other) != None) && (ScriptedPawn(Other).bGreenBlood))
			EffS = class'GBloodSpew';
		else
			{
				if (FRand() < 0.33) Spawn(class'Botpack.UT_BloodTrail', Other, , Other.Location, Other.Rotation);
				EffS = class'BloodSpew';
			}
		DES.SetSpawnProperties(SpurtLevel, EffS);
	}
}

defaultproperties
{
     bRandomMode=True
     bBloodPool=True
     bDeathEffect=False
     MaxBleeders=5
     BleedTime=2.5
     BDLifeSpan=32.0
     BDDrawScale=0.35000
     SpurtLevel=64
     MaxBleedersRV=8
     BleedTimeRV=3.0
     BDLifeSpanRV=64.0
     BDDrawScaleRV=0.40000
     SpurtLevelRV=128
     SpawnRate=0.25
     MBdefHealth=100
}
