//=============================================================================
// BloodSpew.
//=============================================================================
class BloodSpew extends Blood2;

simulated function PostBeginPlay()
{
	local int i;
	local string s;
	
	i = Rand(8)+1;
	s = "MoreBloodOS.RDrop"$String(i);
	Texture =  texture(DynamicLoadObject(s, class'texture'));
	i = Rand(class'MoreBloodConfig'.Default.SpurtLevel) + 30;
	Velocity.Z += i + ((i * 8) * FRand());
	i = Rand(i) + 128;
	Velocity.X += (i / 3) * FRand();
	Velocity.X -= (i * 1.5 / 3) * FRand();
	Velocity.Y += (i / 5) * FRand();
	Velocity.Y -= (i * 1.5 / 5) * FRand();
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	local actor a;

	if (Level.NetMode != NM_DedicatedServer)
	{
		if ( FRand() < 0.25 )
			Spawn(class'RBloodSplat',,,Self.Location,rotator(HitNormal));
		if ( FRand() < 0.45 )
		{
			a = Spawn(class'BloodDrop2',,,Self.Location,rotator(HitNormal));
			if (a != None)
			{
				a.Drawscale = (FRand()*class'MoreBloodConfig'.default.BDDrawScale) + 0.0075;
				a.LifeSpan = (FRand()*class'MoreBloodConfig'.default.BDLifeSpan) + class'MoreBloodConfig'.default.BDLifeSpan;
			}
		}
	}
	Destroy();
}

defaultproperties
{
     bHighDetail=True
     Physics=PHYS_Falling
     bStatic=False
     LifeSpan=3.500000
     Style=STY_Masked
     DrawType=DT_Sprite
     DrawScale=0.250000
     bCollideWorld=True
     bBounce=True
     NetPriority=2.000000
}
