//=============================================================================
// utb_BloodDrop2.   Bouncy drops
//=============================================================================
class UTB_BloodDrop2 extends Blood2;

var int r, g;
var vector prevloc;

simulated function PostBeginPlay()
{
	local string s;

	g = (128 * FRand()) + 10;
	r = (class'MoreBloodConfig'.default.SpurtLevel * FRand()) + 1;
	Velocity.x = r;
	r = (class'MoreBloodConfig'.default.SpurtLevel * FRand()) + 1;
	Velocity.y = r;
	r = (class'MoreBloodConfig'.default.SpurtLevel * FRand()) + 1;
	Velocity.z = r;
	r = Rand(8)+1;
	s = "MoreBloodOS.RDrop"$String(r);
	Texture = texture(DynamicLoadObject(s, class'texture'));
	prevloc = Self.Location;
}

simulated function HitWall( vector HitNormal, actor Wall )
{
   if (Level.NetMode != NM_DedicatedServer)
      {
	if ((prevloc.x != Self.Location.x) && (prevloc.y != Self.Location.y))
	{
	  	if (Velocity.z >= -255.0)
		{
			Velocity.z += g;
			g = g + g;
			Velocity.z *= -1;
		}
		prevloc = Self.Location;
	}
      }
}

defaultproperties
{
     bHighDetail=True
     Physics=PHYS_Falling
     bStatic=False
     LifeSpan=3.500000
     DrawType=DT_Sprite
     Style=STY_Masked
     bCollideWorld=True
     bBounce=True
     NetPriority=2.000000
}
