//-----------------------//
// DeathEffectSpawner    //
//-----------------------//

class DeathEffectSpawner extends Actor;

var int SpawnsLeft;
var class<Effects> EffectToSpawn;

function SetSpawnProperties(optional int SL, optional class<Effects> E)
{
	SpawnsLeft = Min(SL, 512);
	EffectToSpawn = E;
}

function tick(float dt)
{
	local actor a;
	local int j;

	if ((Owner == None) || (SpawnsLeft <= 0))
	{
		Destroy();
	}
	else {
	for (j=0; j<=8; j++)
	{
		if (Owner == None) Destroy();
		a = Spawn(EffectToSpawn, Self, , Owner.Location, Owner.Rotation);
		if (a != None)
		{
			a.Drawscale = (FRand()*class'MoreBloodConfig'.default.BDDrawScale) + 0.0075;
			a.LifeSpan = (FRand()*class'MoreBloodConfig'.default.BDLifeSpan) + class'MoreBloodConfig'.default.BDLifeSpan;
		}
		SpawnsLeft--;
	} }
}

defaultproperties
{
	bHidden=True
}
