//-----------------------//
// BleederEffectSpawner  //
//-----------------------//

class BleederEffectSpawner extends Actor;

var float SpawnDelay;
var int SpawnsLeft, PDHealth;
var vector RelLocation;
var class<Effects> EffectToSpawn;

function InitSpawner()
{
	RelLocation = Location - Owner.Location;
}

function SetSpawnProperties(optional float SD, optional int SL, optional class<Effects> E, optional int defH)
{
	SpawnDelay = FMin(SD, 5.0);
	SpawnsLeft = Min(SL, 512);
	EffectToSpawn = E;
	PDHealth = defH;
	SetTimer(SpawnDelay, true);
}

function Timer()
{
	local actor a;

	if (Owner != None)
	{
		SpawnsLeft--;
		if ((SpawnsLeft <= 0) || (Pawn(Owner).health == PDHealth) || (Pawn(Owner).bHidden))
		{
			SetTimer(0.0, false);
			Destroy();
		}
		a = Spawn(EffectToSpawn, Self, , RelLocation + Owner.Location, Owner.Rotation);
		if (a != None)
		{
			a.Drawscale = (FRand()*class'MoreBloodConfig'.default.BDDrawScale) + 0.025;
			a.LifeSpan = (FRand()*class'MoreBloodConfig'.default.BDLifeSpan) + class'MoreBloodConfig'.default.BDLifeSpan;
		}
	} else Destroy();
}

defaultproperties
{
	bHidden=True
}
