//=========================================================================================
// MoreGore Plus Mutator by Mr.Loathsome.  Based on MoreGore2 by shiftre from Clan 404
//=========================================================================================
class MG expands Mutator;

var int goreLevel;
var float SpawnRate, GibRate;
var bool DigDugMode;
var rotator splatRotator;
var bool bInitialized, bDoSpawn;

function PostBeginPlay()
{
	if (bInitialized) return; else bInitialized = true;
	bDoSpawn = True;
	splatRotator.Pitch = 16384;
	Level.Game.RegisterDamageMutator(Self);
	
	goreLevel = class'MoreGore2ClientWindow'.Default.goreLevel;
	SpawnRate = class'MoreGore2ClientWindow'.Default.SpawnRate;
	GibRate = class'MoreGore2ClientWindow'.Default.GibRate;
	DigDugMode = class'MoreGore2ClientWindow'.Default.DigDugMode;
	Super.PostBeginPlay();
}

function Timer()
{
	bDoSpawn = True;
}

function ScoreKill(Pawn Killer, Pawn Other)
{
	local GibSpawn g;

	//Set up player explode on death if DigDugMode on
	if (DigDugMode)
	{
		Other.HidePlayer();
		Other.Fatness = 128;
		Other.Health = -100;
	}
	
	//check whether victim is at gib status
	if ((bDoSpawn) && ((Other.Health < -40) || ((Other.Health < -10) && (FRand() < 0.5))))
	{
		g = Spawn(class'GibSpawn', Other);
		if (g != None)
		{
			Other.HidePlayer();
			if ((ScriptedPawn(Other) != None) && (ScriptedPawn(Other).CarcassType != None))
				{ g.SetLevel(goreLevel, (Other.Health-5), Other.Location, GibRate, ScriptedPawn(Other).CarcassType, True); }
			else {
			    if ((Bot(Other) != None) && (Bot(Other).CarcassType != None))
				{ g.SetLevel(goreLevel, Other.Health, Other.Location, GibRate, Bot(Other).CarcassType, False); }
			    else
				{ g.SetLevel(goreLevel, Other.Health, Other.Location, GibRate, class'CowCarcass', False); }
			     }
			SetTimer(SpawnRate, False);
			bDoSpawn = False;
		}
	}
	//Call next mutator down the line
	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Other);
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, 
						out Vector Momentum, name DamageType)
{
	local vector Mo;

	//Increase size of victim when hit if DigDugMode on
	if (DigDugMode) {
		if ((Victim.Fatness+ActualDamage)>255)
			Victim.Fatness = 255;
		else
			Victim.Fatness = Victim.Fatness+ActualDamage;
	}
	
	//Drop blood on hit & add more blood spray
	if (HitLocation != vect(0,0,0))
	{
		Mo = Momentum;
		if ( Mo.Z > 0 )
			Mo.Z *= (0.9);
		if ((ScriptedPawn(Victim) != None) && (ScriptedPawn(Victim).bGreenBlood))
		{
			if (FRand() < 0.25)
				spawn(class'GreenBloodSpray', , , HitLocation, rotator(Mo));
		}
		else
		{
			if (FRand() < 0.25)
				spawn( class'BloodSpray', , , HitLocation, rotator(Mo));
			if (FRand() < 0.10)
				spawn(class'BloodSplat', , , Victim.Location, splatRotator);
		}
	}
	if ( NextDamageMutator != None)
		NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );	
}

defaultproperties
{
}
