class XBotsConfigUTBotsClient expands XBotsConfigBotsClient;

var ChallengeBotInfo BotInfo;
var XBotsChallengeBotInfo XBotsInfo;

function LoadBotClasses()
{
	local String NextBotClass, NextBotDesc;

	NumClasses = 0;
	GetPlayerOwner().GetNextIntDesc("Bot", 0, NextBotClass, NextBotDesc); 
	while ( (NextBotClass != "") && (NumClasses < 64) )
	{
		AvailableClasses[NumClasses] = NextBotClass;
		AvailableDescriptions[NumClasses] = NextBotDesc;
		NumClasses++;
		GetPlayerOwner().GetNextIntDesc("Bot", NumClasses, NextBotClass, NextBotDesc); 
	}
}

function LoadBots()
{
	local class<ChallengeBotInfo> C;
	local int i;
	local int NumBots;

	C = class<ChallengeBotInfo>(DynamicLoadObject("Botpack.ChallengeBotInfo", class'Class'));
	BotInfo = GetEntryLevel().Spawn(C);
	XBotsInfo = GetEntryLevel().Spawn(class'XBotsChallengeBotInfo');

	NumBots = 32;

	// Add the bots into the combo
	for(i=0;i<NumBots;i++)
		BotCombo.AddItem(BotWord@string(i+1), String(i));	
}

function Close(optional bool bByParent)
{
	Super.Close(bByParent);
	if(BotInfo!=None)
	{
		BotInfo.SaveConfig();
		BotInfo.Destroy();
	}
	XBotsInfo.SaveConfig();
	XBotsInfo.Destroy();
	BotInfo = None;
	XBotsInfo=none;
}

simulated function VoiceChanged()
{
	local class<ChallengeVoicePack> VoicePackClass;
	local ChallengeVoicePack V;

	if(Initialized)
	{
		if(!ClassChanging)
		{
			VoicePackClass = class<ChallengeVoicePack>(DynamicLoadObject(VoicePackCombo.GetValue2(), class'Class'));
			V = GetPlayerOwner().spawn(VoicePackClass,GetPlayerOwner(),,GetPlayerOwner().Location);
			V.ClientInitialize(GetPlayerOwner().PlayerReplicationInfo,GetPlayerOwner().PlayerReplicationInfo,'ACK', Rand(VoicePackClass.Default.NumAcks));
		}
		BotInfo.VoiceType[ConfigureBot] = VoicePackCombo.GetValue2();
	}
}

function NameChanged()
{
	if (Initialized)
		BotInfo.SetBotName(NameEdit.GetValue(), ConfigureBot);
}

function FavouriteWeaponChanged()
{
	local string NewWeapon;

	if (Initialized)
	{
		NewWeapon = FavoriteWeaponCombo.GetValue2();
		if(NewWeapon == "None")
			BotInfo.FavoriteWeapon[ConfigureBot] = "";
		else
			BotInfo.FavoriteWeapon[ConfigureBot] = NewWeapon;
	}
}

function CampingChanged()
{
	if (Initialized)
		BotInfo.Camping[ConfigureBot] = (CampingSlider.GetValue() / 100);
}

function StrafingAbilityChanged()
{
	if (Initialized)
		BotInfo.StrafingAbility[ConfigureBot] = (StrafingAbilitySlider.GetValue() / 4) - 1;
}

function JumpyChanged()
{
	if (Initialized)
	{
		if(JumpyCheck.bChecked)
			BotInfo.BotJumpy[ConfigureBot] = 1;
		else
			BotInfo.BotJumpy[ConfigureBot] = 0;
	}
}

function AlertnessChanged()
{
	if (Initialized)
		BotInfo.Alertness[ConfigureBot] = (AlertnessSlider.GetValue() / 100) - 1;
}

function AccuracyChanged()
{
	if (Initialized)
		BotInfo.BotAccuracy[ConfigureBot] = (AccuracySlider.GetValue() / 100) - 1;
}

function CombatStyleChanged()
{
	if (Initialized)
		BotInfo.CombatStyle[ConfigureBot] = float(CombatStyleCombo.GetValue2());
}

function SkillChanged()
{
	if (Initialized)
		BotInfo.BotSkills[ConfigureBot] = SkillSlider.GetValue() - 3;
}

function UseSelected()
{
	if (Initialized)
	{
		// store the stuff in the required botinfo
		BotInfo.SetBotClass(ClassCombo.GetValue2(), ConfigureBot);
		BotInfo.SetBotSkin(SkinCombo.GetValue2(), ConfigureBot);
		BotInfo.SetBotFace(FaceCombo.GetValue2(), ConfigureBot);
		BotInfo.SetBotTeam(Int(TeamCombo.GetValue2()), ConfigureBot);
	}

	// setup the mesh window appropriately
	MeshWindow.SetMeshString(NewPlayerClass.Default.SelectionMesh);
	MeshWindow.ClearSkins();
	NewPlayerClass.static.SetMultiSkin(MeshWindow.MeshActor, SkinCombo.GetValue2(), FaceCombo.GetValue2(), Int(TeamCombo.GetValue2()));
}

function LoadCurrent()
{
	local int i;
	local string Voice;

	NameEdit.SetValue(BotInfo.GetBotName(ConfigureBot));
	i = TeamCombo.FindItemIndex2(string(BotInfo.BotTeams[ConfigureBot]));
	if(i == -1)
		i = 255;
	TeamCombo.SetSelectedIndex(i);
	ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex2(BotInfo.GetBotClassName(ConfigureBot), True), 0));
	SkinCombo.SetSelectedIndex(Max(SkinCombo.FindItemIndex2(BotInfo.GetBotSkin(ConfigureBot), True), 0));
	FaceCombo.SetSelectedIndex(Max(FaceCombo.FindItemIndex2(BotInfo.BotFaces[ConfigureBot], True), 0));
	FavoriteWeaponCombo.SetSelectedIndex(Max(FavoriteWeaponCombo.FindItemIndex2(BotInfo.FavoriteWeapon[ConfigureBot], True), 0));
	AccuracySlider.SetValue(100*(BotInfo.BotAccuracy[ConfigureBot]+1));
	AlertnessSlider.SetValue(100*(BotInfo.Alertness[ConfigureBot]+1));
	CampingSlider.SetValue(100*(BotInfo.Camping[ConfigureBot]));
	StrafingAbilitySlider.SetValue(4*(BotInfo.StrafingAbility[ConfigureBot]+1));
	CombatStyleCombo.SetSelectedIndex(Max(CombatStyleCombo.FindItemIndex2(string(BotInfo.CombatStyle[ConfigureBot]), False), 0));
	JumpyCheck.bChecked = BotInfo.BotJumpy[ConfigureBot] != 0;
	SkillSlider.SetValue(BotInfo.BotSkills[ConfigureBot] + 3);

	UseThisBot.bChecked = XBotsInfo.slotUsed[ConfigureBot] != 0;

	ClassChanging = True;
	IterateVoices();
	i= VoicePackCombo.FindItemIndex2(BotInfo.VoiceType[ConfigureBot], True);
	if(i != -1)
		VoicePackCombo.SetSelectedIndex(i);
	else
		VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(class<Bot>(NewPlayerClass).default.VoiceType, True), 0));
	ClassChanging = False;
}

function ResetBots()
{
	local class<ChallengeBotInfo> C;
	C = BotInfo.Class;
	BotInfo.Destroy();
	class'ChallengeBotInfo'.static.ResetConfig();
	BotInfo = GetEntryLevel().Spawn(C);

	Initialized = False;
	ConfigureBot = 0;
	BotCombo.SetSelectedIndex(0);
	ActivateAllBots();
	LoadCurrent();
	UseSelected();
	Initialized = True;
}

function ActivateAllBots()
{
	local int i;

	for(i=0;i<32;i++)
		XBotsInfo.slotUsed[i]=1;
	UseThisBot.bChecked = true;
}

function DeactivateAllBots()
{
	local int i;

	for(i=0;i<32;i++)
		XBotsInfo.slotUsed[i]=1;
	UseThisBot.bChecked = false;
}

function BotChanged()
{
	if (Initialized)
	{
		Initialized = False;
		ConfigureBot = BotCombo.GetSelectedIndex();
		LoadCurrent();
		UseSelected();
		Initialized = True;
	}
}

function UseThisBotChanged()
{
	if (Initialized)
	{
		if(UseThisBot.bChecked)
			XBotsInfo.SlotUsed[ConfigureBot] = 1;
		else
			XBotsInfo.slotUsed[ConfigureBot] = 0;
	}
}

function SaveConfigs()
{
	Super.SaveConfigs();
	if(BotInfo != None)
		BotInfo.SaveConfig();
}

defaultproperties
{
}
