class XBotsConfigBotsClient expands UMenuPlayerSetupClient;

var string AvailableClasses[64], AvailableDescriptions[64], NextBotClass;
var int NumClasses;

var XBotsBotInfo BotInfo;

// VoicePack
var UWindowHSliderControl SkillSlider;
var localized string SkillText;
var localized string SkillHelp;

var UWindowComboControl VoicePackCombo;
var localized string VoicePackText;
var localized string VoicePackHelp;

var UWindowComboControl FavoriteWeaponCombo;
var localized string FavoriteWeaponText;
var localized string FavoriteWeaponHelp;
var localized string NoFavoriteWeapon;

var UWindowHSliderControl AccuracySlider;
var localized string AccuracyText;
var localized string AccuracyHelp;

var UWindowHSliderControl AlertnessSlider;
var localized string AlertnessText;
var localized string AlertnessHelp;

var UWindowHSliderControl CampingSlider;
var localized string CampingText;
var localized string CampingHelp;

var UWindowHSliderControl StrafingAbilitySlider;
var localized string StrafingAbilityText;
var localized string StrafingAbilityHelp;

var UWindowComboControl CombatStyleCombo;
var localized string CombatStyleText;
var localized string CombatStyleHelp;
var localized float CombatStyleValues[10];
var localized string CombatStyleNames[10];

var UWindowCheckbox JumpyCheck;
var localized string JumpyText;
var localized string JumpyHelp;

var int ConfigureBot;

var UWindowComboControl BotCombo;
var localized string BotText;
var localized string BotHelp;
var localized string BotWord;

var UWindowSmallButton DefaultsButton;
var localized string DefaultsText;
var localized string DefaultsHelp;

var UWindowCheckBox UseThisBot;
var localized string UseThisBotText;
var localized string UseThisBotHelp;

var UWindowSmallButton ActivateAllButton;
var localized string ActivateAllText;
var localized string ActivateAllHelp;

var UWindowSmallButton DeactivateAllButton;
var localized string DeactivateAllText;
var localized string DeactivateAllHelp;

var bool ClassChanging;

function Created()
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;
	local int i;

	ControlWidth = WinWidth/3;
	ControlLeft = (WinWidth/2 - ControlWidth)/2;
	ControlRight = WinWidth/2 + ControlLeft;

	CenterWidth = (WinWidth/4)*3;
	CenterPos = (WinWidth - CenterWidth)/2;

	DefaultsButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 30, 10, 48, 16));
	DefaultsButton.SetText(DefaultsText);
	DefaultsButton.SetFont(F_Normal);
	DefaultsButton.SetHelpText(DefaultsHelp);

	BotCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CenterPos, ControlOffset, CenterWidth, 1));
	BotCombo.SetButtons(True);
	BotCombo.SetText(BotText);
	BotCombo.SetHelpText(BotHelp);
	BotCombo.SetFont(F_Normal);
	BotCombo.SetEditable(False);
	LoadBotClasses();
	LoadBots();
	BotCombo.SetSelectedIndex(0);
	ConfigureBot = 0;
	ControlOffset += 25;

	Super.Created();

	ControlOffset += 25;
	SkillSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', CenterPos, ControlOffset, CenterWidth, 1));
	SkillSlider.bNoSlidingNotify = True;
	SkillSlider.SetRange(0, 6, 1);
	SkillSlider.SetText(SkillText);
	SkillSlider.SetHelpText(SkillHelp);
	SkillSlider.SetFont(F_Normal);

	ControlOffset += 25;
	VoicePackCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CenterPos, ControlOffset, CenterWidth, 1));
	VoicePackCombo.SetText(VoicePackText);
	VoicePackCombo.SetHelpText(VoicePackHelp);
	VoicePackCombo.SetFont(F_Normal);
	VoicePackCombo.SetEditable(False);

	ControlOffset += 25;
	FavoriteWeaponCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CenterPos, ControlOffset, CenterWidth, 1));
	FavoriteWeaponCombo.SetText(FavoriteWeaponText);
	FavoriteWeaponCombo.SetHelpText(FavoriteWeaponHelp);
	FavoriteWeaponCombo.SetFont(F_Normal);
	FavoriteWeaponCombo.SetEditable(False);
	LoadWeapons();

	ControlOffset += 25;
	AccuracySlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', CenterPos, ControlOffset, CenterWidth, 1));
	AccuracySlider.bNoSlidingNotify = True;
	AccuracySlider.SetRange(0, 200, 5);
	AccuracySlider.SetText(AccuracyText);
	AccuracySlider.SetHelpText(AccuracyHelp);
	AccuracySlider.SetFont(F_Normal);

	ControlOffset += 25;
	AlertnessSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', CenterPos, ControlOffset, CenterWidth, 1));
	AlertnessSlider.bNoSlidingNotify = True;
	AlertnessSlider.SetRange(0, 200, 5);
	AlertnessSlider.SetText(AlertnessText);
	AlertnessSlider.SetHelpText(AlertnessHelp);
	AlertnessSlider.SetFont(F_Normal);

	ControlOffset += 25;
	CampingSlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', CenterPos, ControlOffset, CenterWidth, 1));
	CampingSlider.bNoSlidingNotify = True;
	CampingSlider.SetRange(0, 100, 10);
	CampingSlider.SetText(CampingText);
	CampingSlider.SetHelpText(CampingHelp);
	CampingSlider.SetFont(F_Normal);

	ControlOffset += 25;
	StrafingAbilitySlider = UWindowHSliderControl(CreateControl(class'UWindowHSliderControl', CenterPos, ControlOffset, CenterWidth, 1));
	StrafingAbilitySlider.bNoSlidingNotify = True;
	StrafingAbilitySlider.SetRange(0, 8, 1);
	StrafingAbilitySlider.SetText(StrafingAbilityText);
	StrafingAbilitySlider.SetHelpText(StrafingAbilityHelp);
	StrafingAbilitySlider.SetFont(F_Normal);

	ControlOffset += 25;
	CombatStyleCombo = UWindowComboControl(CreateControl(class'UWindowComboControl', CenterPos, ControlOffset, CenterWidth, 1));
	CombatStyleCombo.SetText(CombatStyleText);
	CombatStyleCombo.SetHelpText(CombatStyleHelp);
	CombatStyleCombo.SetFont(F_Normal);
	CombatStyleCombo.SetEditable(False);
	for(i=0;i<10 && CombatStyleNames[i] != "";i++)
		CombatStyleCombo.AddItem(CombatStyleNames[i], string(CombatStyleValues[i]));

	ControlOffset += 25;
	JumpyCheck = UWindowCheckbox(CreateControl(class'UWindowCheckbox', CenterPos, ControlOffset, CenterWidth, 1));
	JumpyCheck.SetText(JumpyText);
	JumpyCheck.SetHelpText(JumpyHelp);
	JumpyCheck.SetFont(F_Normal);
	JumpyCheck.Align = TA_Left;

	ControlOffset += 25;
	UseThisBot=UWindowCheckbox(CreateControl(class'UWindowCheckbox',CenterPos,ControlOffset,CenterWidth,1));
	UseThisBot.SetText(UseThisBotText);
	UseThisBot.SetHelpText(UseThisBotHelp);
	UseThisBot.SetFont(F_Normal);
	UseThisBot.Align=TA_Left;

	ControlOffset += 25;
	ActivateAllButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 30, ControlOffset, 60, 16));
	ActivateAllButton.SetText(ActivateAllText);
	ActivateAllButton.SetFont(F_Normal);
	ActivateAllButton.SetHelpText(ActivateAllHelp);

	DeActivateAllButton = UWindowSmallButton(CreateControl(class'UWindowSmallButton', 100, ControlOffset, 70, 16));
	DeActivateAllButton.SetText(DeActivateAllText);
	DeActivateAllButton.SetFont(F_Normal);
	DeActivateAllButton.SetHelpText(DeActivateAllHelp);
}

function LoadBotClasses()
{
	local String NextBotClass, NextBotDesc;

	NumClasses = 0;
	GetPlayerOwner().GetNextIntDesc("Bot", 0, NextBotClass, NextBotDesc); 
	while ( (NextBotClass != "") && (NumClasses < 64) )
	{
		AvailableClasses[NumClasses] = NextBotClass;
		AvailableDescriptions[NumClasses] = NextBotDesc;
		NumClasses++;
		GetPlayerOwner().GetNextIntDesc("Bot", NumClasses, NextBotClass, NextBotDesc); 
	}
}

function LoadBots()
{
	local int i;
	local int NumBots;

	BotInfo = GetEntryLevel().Spawn(XBotsConfigClient(OwnerWindow).EditList);

	NumBots = 32;

	// Add the bots into the combo
	for(i=0;i<NumBots;i++)
		BotCombo.AddItem(BotWord@string(i+1), String(i));	
}

function ResetBots()
{
//	local class<XBotsBotInfo> C;
//	C = BotInfo.Class;
//	BotInfo.Destroy();
//	class'XBotsBotInfo'.static.ResetConfig();
//	BotInfo = GetEntryLevel().Spawn(C);

//	Initialized = False;
//	ConfigureBot = 0;
//	BotCombo.SetSelectedIndex(0);
//	LoadCurrent();
//	UseSelected();
//	Initialized = True;
}

function LoadWeapons()
{
	local int NumWeaponClasses;
	local string NextWeapon, NextDesc;
	local string WeaponBaseClass;

	WeaponBaseClass = "TournamentWeapon";

	FavoriteWeaponCombo.AddItem(NoFavoriteWeapon, "None");

	GetPlayerOwner().GetNextIntDesc(WeaponBaseClass, 0, NextWeapon, NextDesc);
	while( (NextWeapon != "") && (NumWeaponClasses < 64) )
	{
		FavoriteWeaponCombo.AddItem(NextDesc, NextWeapon);
		NumWeaponClasses++;
		GetPlayerOwner().GetNextIntDesc(WeaponBaseClass, NumWeaponClasses, NextWeapon, NextDesc);
	}
	FavoriteWeaponCombo.Sort();
}

function LoadClasses()
{
	local int i;
	local int SortWeight;

	for(i=0;i<NumClasses;i++)
	{
//		if(!(AvailableClasses[i] ~= "Botpack.TBossBot") || class'Ladder'.Default.HasBeatenGame)
		ClassCombo.AddItem(AvailableDescriptions[i], AvailableClasses[i], SortWeight);
	}
	ClassCombo.Sort();
}

function Notify(UWindowDialogControl C, byte E)
{
	Super.Notify(C, E);

	switch(E)
	{
	case DE_Click:
		switch(C)
		{
			case DefaultsButton:
				ResetBots();
			break;
			case ActivateAllButton:
				ActivateAllBots();
			break;
			case DeactivateAllButton:
				DeactivateAllBots();
			break;
		}
	break;
	case DE_Change:
		switch(C)
		{
			case BotCombo:
				BotChanged();
			break;
			case SkillSlider:
				SkillChanged();
			break;
			case FavoriteWeaponCombo:
				FavouriteWeaponChanged();
			break;
			case CampingSlider:
				CampingChanged();
			break;
			case StrafingAbilitySlider:
				StrafingAbilityChanged();
			break;
			case AlertnessSlider:
				AlertnessChanged();
			break;
			case AccuracySlider:
				AccuracyChanged();
			break;
			case CombatStyleCombo:
				CombatStyleChanged();
			break;
			case JumpyCheck:
				JumpyChanged();
			break;
			case VoicePackCombo:
				VoiceChanged();
			break;
			case UseThisBot:
				UseThisBotChanged();
			break;
		}
	break;
	}
}

function Close(optional bool bByParent)
{
	Super.Close(bByParent);
	BotInfo.SaveConfig();
	BotInfo.Destroy();
	BotInfo = None;
}

function ActivateAllBots()
{
	local int i;

	for(i=0;i<32;i++)
		BotInfo.slotUsed[i]=1;
	UseThisBot.bChecked = true;
}

function DeactivateAllBots()
{
	local int i;

	for(i=0;i<32;i++)
		BotInfo.slotUsed[i]=0;
	UseThisBot.bChecked = false;
}

function BotChanged()
{
	if (Initialized)
	{
		Initialized = False;
		ConfigureBot = BotCombo.GetSelectedIndex();
		LoadCurrent();
		UseSelected();
		Initialized = True;
	}
}

function ClassChanged()
{
	Super.ClassChanged();

	if(Initialized)
	{
		ClassChanging = True;
		IterateVoices();
		VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(class<Bot>(NewPlayerClass).default.VoiceType, True), 0));
		ClassChanging = False;
	}
}

function IterateVoices()
{
	local int NumVoices;
	local string NextVoice, NextDesc;
	local string VoicepackMetaClass;
	local bool OldInitialized;

	OldInitialized = Initialized;
	Initialized = False;
	VoicePackCombo.Clear();
	Initialized = OldInitialized;

	if(ClassIsChildOf(NewPlayerClass, class'Bot'))
		VoicePackMetaClass = class<Bot>(NewPlayerClass).default.VoicePackMetaClass;
	else
		VoicePackMetaClass = "Botpack.ChallengeVoicePack";

	// Load the base class into memory to prevent GetNextIntDesc crashing as the class isn't loadded.
	DynamicLoadObject(VoicePackMetaClass, class'Class');

	GetPlayerOwner().GetNextIntDesc(VoicePackMetaClass, 0, NextVoice, NextDesc);
	while( (NextVoice != "") && (NumVoices < 64) )
	{
		if(!(NextVoice ~= "Botpack.VoiceBoss") || class'Ladder'.Default.HasBeatenGame)
		{
			if(NextVoice ~=  "Botpack.VoiceBoss")
				VoicePackCombo.AddItem(NextDesc, "Botpack.VoiceBotBoss", 0);
			else
				VoicePackCombo.AddItem(NextDesc, NextVoice, 0);
		}

		NumVoices++;
		GetPlayerOwner().GetNextIntDesc(VoicePackMetaClass, NumVoices, NextVoice, NextDesc);
	}

	VoicePackCombo.Sort();
}

function LoadCurrent()
{
	local int i;
	local string Voice;

	NameEdit.SetValue(BotInfo.GetBotName(ConfigureBot));
	i = TeamCombo.FindItemIndex2(string(BotInfo.BotTeams[ConfigureBot]));
	if(i == -1)
		i = 255;
	TeamCombo.SetSelectedIndex(i);
	ClassCombo.SetSelectedIndex(Max(ClassCombo.FindItemIndex2(BotInfo.GetBotClassName(ConfigureBot), True), 0));
	SkinCombo.SetSelectedIndex(Max(SkinCombo.FindItemIndex2(BotInfo.GetBotSkin(ConfigureBot), True), 0));
	FaceCombo.SetSelectedIndex(Max(FaceCombo.FindItemIndex2(BotInfo.BotFaces[ConfigureBot], True), 0));
	FavoriteWeaponCombo.SetSelectedIndex(Max(FavoriteWeaponCombo.FindItemIndex2(BotInfo.FavoriteWeapon[ConfigureBot], True), 0));
	AccuracySlider.SetValue(100*(BotInfo.BotAccuracy[ConfigureBot]+1));
	AlertnessSlider.SetValue(100*(BotInfo.Alertness[ConfigureBot]+1));
	CampingSlider.SetValue(100*(BotInfo.Camping[ConfigureBot]));
	StrafingAbilitySlider.SetValue(4*(BotInfo.StrafingAbility[ConfigureBot]+1));
	CombatStyleCombo.SetSelectedIndex(Max(CombatStyleCombo.FindItemIndex2(string(BotInfo.CombatStyle[ConfigureBot]), False), 0));
	JumpyCheck.bChecked = BotInfo.BotJumpy[ConfigureBot] != 0;
	SkillSlider.SetValue(BotInfo.BotSkills[ConfigureBot] + 3);

	UseThisBot.bChecked = BotInfo.slotUsed[ConfigureBot] != 0;

	ClassChanging = True;
	IterateVoices();
	i= VoicePackCombo.FindItemIndex2(BotInfo.VoiceType[ConfigureBot], True);
	if(i != -1)
		VoicePackCombo.SetSelectedIndex(i);
	else
		VoicePackCombo.SetSelectedIndex(Max(VoicePackCombo.FindItemIndex2(class<Bot>(NewPlayerClass).default.VoiceType, True), 0));
	ClassChanging = False;
}

function JumpyChanged()
{
	if (Initialized)
	{
		if(JumpyCheck.bChecked)
			BotInfo.BotJumpy[ConfigureBot] = 1;
		else
			BotInfo.BotJumpy[ConfigureBot] = 0;
	}
}

function UseThisBotChanged()
{
	if (Initialized)
	{
		if(UseThisBot.bChecked)
			BotInfo.SlotUsed[ConfigureBot] = 1;
		else
			BotInfo.slotUsed[ConfigureBot] = 0;
	}
}

simulated function VoiceChanged()
{
	local class<ChallengeVoicePack> VoicePackClass;
	local ChallengeVoicePack V;

	if(Initialized)
	{
		if(!ClassChanging)
		{
			VoicePackClass = class<ChallengeVoicePack>(DynamicLoadObject(VoicePackCombo.GetValue2(), class'Class'));
			V = GetPlayerOwner().spawn(VoicePackClass,GetPlayerOwner(),,GetPlayerOwner().Location);
			V.ClientInitialize(GetPlayerOwner().PlayerReplicationInfo,GetPlayerOwner().PlayerReplicationInfo,'ACK', Rand(VoicePackClass.Default.NumAcks));
		}
		BotInfo.VoiceType[ConfigureBot] = VoicePackCombo.GetValue2();
	}
}

function NameChanged()
{
	if (Initialized)
		BotInfo.SetBotName(NameEdit.GetValue(), ConfigureBot);
}

function FavouriteWeaponChanged()
{
	local string NewWeapon;

	if (Initialized)
	{
		NewWeapon = FavoriteWeaponCombo.GetValue2();
		if(NewWeapon == "None")
			BotInfo.FavoriteWeapon[ConfigureBot] = "";
		else
			BotInfo.FavoriteWeapon[ConfigureBot] = NewWeapon;
	}
}

function CampingChanged()
{
	if (Initialized)
		BotInfo.Camping[ConfigureBot] = (CampingSlider.GetValue() / 100);
}

function StrafingAbilityChanged()
{
	if (Initialized)
		BotInfo.StrafingAbility[ConfigureBot] = (StrafingAbilitySlider.GetValue() / 4) - 1;
}

function AlertnessChanged()
{
	if (Initialized)
		BotInfo.Alertness[ConfigureBot] = (AlertnessSlider.GetValue() / 100) - 1;
}

function AccuracyChanged()
{
	if (Initialized)
		BotInfo.BotAccuracy[ConfigureBot] = (AccuracySlider.GetValue() / 100) - 1;
}

function CombatStyleChanged()
{
	if (Initialized)
		BotInfo.CombatStyle[ConfigureBot] = float(CombatStyleCombo.GetValue2());
}

function SkillChanged()
{
	if (Initialized)
		BotInfo.BotSkills[ConfigureBot] = SkillSlider.GetValue() - 3;
}

function UseSelected()
{
	if (Initialized)
	{
		// store the stuff in the required botinfo
		BotInfo.SetBotClass(ClassCombo.GetValue2(), ConfigureBot);
		BotInfo.SetBotSkin(SkinCombo.GetValue2(), ConfigureBot);
		BotInfo.SetBotFace(FaceCombo.GetValue2(), ConfigureBot);
		BotInfo.SetBotTeam(Int(TeamCombo.GetValue2()), ConfigureBot);
	}

	// setup the mesh window appropriately
	MeshWindow.SetMeshString(NewPlayerClass.Default.SelectionMesh);
	MeshWindow.ClearSkins();
	NewPlayerClass.static.SetMultiSkin(MeshWindow.MeshActor, SkinCombo.GetValue2(), FaceCombo.GetValue2(), Int(TeamCombo.GetValue2()));
}

function SaveConfigs()
{
	Super.SaveConfigs();
	if(BotInfo != None)
		BotInfo.SaveConfig();
}

function BeforePaint(Canvas C, float X, float Y)
{
	local int ControlWidth, ControlLeft, ControlRight;
	local int CenterWidth, CenterPos;
	local float W;

	W = Min(WinWidth, 220);

	ControlWidth = W/3;
	ControlLeft = (W/2 - ControlWidth)/2;
	ControlRight = W/2 + ControlLeft;

	CenterWidth = (W/7)*6;
	CenterPos = (W - CenterWidth)/2;

	DefaultsButton.AutoWidth(C);
	DefaultsButton.WinLeft = CenterPos + CenterWidth - DefaultsButton.WinWidth;

	Super.BeforePaint(C, X, Y);

	BotCombo.SetSize(CenterWidth, 1);
	BotCombo.WinLeft = CenterPos;
	BotCombo.EditBoxWidth = 105;

	FavoriteWeaponCombo.SetSize(CenterWidth, 1);
	FavoriteWeaponCombo.WinLeft = CenterPos;
	FavoriteWeaponCombo.EditBoxWidth = 105;

	AccuracySlider.SetSize(CenterWidth, 1);
	AccuracySlider.WinLeft = CenterPos;
	AccuracySlider.SliderWidth = 105;

	SkillSlider.SetSize(CenterWidth, 1);
	SkillSlider.WinLeft = CenterPos;
	SkillSlider.SliderWidth = 105;

	AlertnessSlider.SetSize(CenterWidth, 1);
	AlertnessSlider.WinLeft = CenterPos;
	AlertnessSlider.SliderWidth = 105;

	CampingSlider.SetSize(CenterWidth, 1);
	CampingSlider.WinLeft = CenterPos;
	CampingSlider.SliderWidth = 105;

	StrafingAbilitySlider.SetSize(CenterWidth, 1);
	StrafingAbilitySlider.WinLeft = CenterPos;
	StrafingAbilitySlider.SliderWidth = 105;

	CombatStyleCombo.SetSize(CenterWidth, 1);
	CombatStyleCombo.WinLeft = CenterPos;
	CombatStyleCombo.EditBoxWidth = 105;

	JumpyCheck.SetSize(CenterWidth-105+16, 1);
	JumpyCheck.WinLeft = CenterPos;

	UseThisBot.SetSize(CenterWidth-105+16, 1);
	UseThisBot.WinLeft=CenterPos;

	VoicePackCombo.SetSize(CenterWidth, 1);
	VoicePackCombo.WinLeft = CenterPos;
	VoicePackCombo.EditBoxWidth = 105;
}

defaultproperties
{
     SkillText="Skill Adjust"
     SkillHelp="Adjust this bot's skill up or down, from the base skill level."
     VoicePackText="Voice"
     VoicePackHelp="Choose a voice for your player's taunts and commands."
     FavoriteWeaponText="Favorite Weapon:"
     FavoriteWeaponHelp="Select this bot's favorite weapon."
     NoFavoriteWeapon="(no favorite)"
     AccuracyText="Accuracy:"
     AccuracyHelp="Change this bot's weapon accuracy.  The cental position is normal, far left is low accuracy, far right is high accuracy."
     AlertnessText="Alertness:"
     AlertnessHelp="Change this bot's alertness.  The central position is normal."
     CampingText="Camping:"
     CampingHelp="Change this bot's willingness to camp."
     StrafingAbilityText="Strafing:"
     StrafingAbilityHelp="Change the amount this bot likes to strafe."
     CombatStyleText="Combat Style:"
     CombatStyleHelp="Select this bot's combat style."
     CombatStyleValues(1)=0.500000
     CombatStyleValues(2)=1.000000
     CombatStyleValues(3)=-0.500000
     CombatStyleValues(4)=-1.000000
     CombatStyleNames(0)="Normal"
     CombatStyleNames(1)="Aggressive"
     CombatStyleNames(2)="Berserk"
     CombatStyleNames(3)="Cautious"
     CombatStyleNames(4)="Avoidant"
     JumpyText="Jumpy Behavior:"
     JumpyHelp="This bot is inclined to jump excessively around the level, like some players do."
     BotText="Bot:"
     BotHelp="Select the bot you wish to configure."
     BotWord="Bot"
     DefaultsText="Reset"
     DefaultsHelp="Reset all bot configurations to their default settings."
     UseThisBotText="Enable Bot:"
     UseThisBotHelp="This bot will be picked from."
     ActivateAllText="Activate All"
     ActivateAllHelp="Activate all bots in this list."
     DeactivateAllText="Deactivate All"
     DeactivateAllHelp="Deactivate all bots in this list."
     ControlOffset=35
     PlayerBaseClass="Bots"
     NameHelp="Set this bot's name."
     TeamText="Color:"
     TeamHelp="Select the team color for this bot."
     ClassHelp="Select this bot's class."
     SkinHelp="Choose a skin for this bot."
     FaceHelp="Choose a face for this bot."
}
