// ============================================================
// XBots9b.XBotsBotRandomInfo 
//  (c) 2010 Mr.Loathsome aka Scott Armitage
//
// Fixes the broken UT Auto Adjust Bot Skill option.
//
// You may NOT modify this code without written permission from
// the author. You are free to use and distribute this code,
// as long as there is no money charged for it.
// ============================================================

class XBotsBotRandomInfo extends XBotsBotInfo config(XBotsRandom);

var XBotsBotInfoL01 List01;
var XBotsBotInfoL02 List02;
var XBotsBotInfoL03 List03;
var XBotsBotInfoL04 List04;
var XBotsBotInfoL05 List05;
var XBotsBotInfoL06 List06;
var XBotsBotInfoL07 List07;
var XBotsBotInfoL08 List08;
var XBotsBotInfoL09 List09;
var ChallengeBotInfo defaultBotInfo;
var XBotsConfigStore ConfigsInfo;
var bool bInitialized;
var bool bSilentMode;
var float MaxBotSkill;

function AdjustSkill(Bot B, bool bWinner)
{
	local float BotSkill, RV, RV2;
	local byte Bsk, Bsk2;

	if (!bInitialized)
	{
		bInitialized = True;
		MaxBotSkill = class'AdjustoBotsConfig'.Default.MaxBotSkill;
		bSilentMode = class'AdjustoBotsConfig'.Default.bSilentMode;
	}
	RV = FRand();
	BotSkill = B.Skill;
	if (( !B.bThreePlus ) && ( !B.bNovice ))
		BotSkill += 4;
	BotSkill=FMin(BotSkill, MaxBotSkill);
	Bsk2 = BotSkill;
	if ( bWinner )
	{
		PlayerKills += 1;
		AdjustedDifficulty = FMax(0, AdjustedDifficulty - 2/Min(PlayerKills, 10));
		if ( BotSkill > AdjustedDifficulty )
			B.Skill = AdjustedDifficulty;
	}
	else
	{
		PlayerDeaths += 1;
		AdjustedDifficulty += FMin(MaxBotSkill, 2/Min(PlayerDeaths, 10));
		if ( BotSkill < AdjustedDifficulty )
			B.Skill = AdjustedDifficulty;
	}
	if (AdjustedDifficulty != BotSkill)
	{
//		BroadcastMessage("AdustedDifficulty = "@AdjustedDifficulty);
		if ( AdjustedDifficulty > MaxBotSkill )
		{
			if ( !bSilentMode )
				BroadcastMessage("Bot Skills Capped at: "@class'ChallengeBotInfo'.default.Skills[MaxBotSkill]);
		}
		if ((AdjustedDifficulty >= MaxBotSkill) && ((PlayerDeaths + PlayerKills) > 3))
		{
			RV = RV + 0.5;
			if (!bWinner)
			{
				RV2 = FMin(RV, 0.85);
				AdjustedDifficulty = abs((AdjustedDifficulty - (AdjustedDifficulty * RV)) - RV2);
				B.Skill = abs(B.Skill - RV2);
				PlayerDeaths -= 1;
			}
			else
			{
				AdjustedDifficulty = abs(AdjustedDifficulty - (AdjustedDifficulty * RV));
				B.Skill = abs(B.Skill - (RV));
				PlayerKills -= 1;
			}
		}
		if ( B.Skill > MaxBotSkill ) B.Skill = MaxBotSkill;
		B.bThreePlus = false;
		if ( B.Skill < 4 )
		{
			B.bNovice = true;
			if ( B.Skill > 3 )
			{
				B.Skill = 3;
				B.bThreePlus = true;
			}
		}
		else
		{
			B.Skill -= 4;
			B.bNovice = false;
		}
		Bsk=B.Skill;
		SetBSkills(B);
		if (( !B.bThreePlus ) && ( !B.bNovice ) && ( Bsk <= 3 ))
			Bsk += 4;
		Difficulty = Bsk;
		DeathMatchPlus(Level.Game).Difficulty = Difficulty;
		if (( !bSilentMode ) && ( Bsk != Bsk2 ))
			BroadcastMessage("Bot Skill Adjustment Detected.  "$B.GetHumanName()$" - "$class'ChallengeBotInfo'.default.Skills[Bsk2]$", Now "$class'ChallengeBotInfo'.default.Skills[Bsk]);
	}
}

function SetBSkills(Bot B)
{
		B.Accuracy = 0.3 * B.Skill;
		B.BaseAlertness = 0.3 * B.Skill;
		B.StrafingAbility = 0.3 * B.Skill;
		B.BaseAggressiveness = 0.3 * B.Skill;
		B.Aggressiveness = 0.3 * B.Skill;
		if (( B.bNovice ) && ( B.Skill <= 3 ))
		{
			if (B.Skill >= 2.50)
			{
				B.CombatStyle = 1.000;
				B.bJumpy = true;
			}
			else if (B.Skill >= 1.50)
			{
				B.CombatStyle = 0.500;
				B.bJumpy = true;
			}
			else
			{
				B.CombatStyle = 0.000;
				B.bJumpy = false;
			}
		}
		B.bLeadTarget = ( !B.bNovice || B.bThreePlus );
		B.PreSetMovement();
		if ( B.bNovice )
			B.ReFireRate = B.Default.ReFireRate;
		else
			B.ReFireRate = B.Default.ReFireRate * (1 - 0.25 * B.Skill);
}

function int botsAvail()
{
	local int i;
	local int returns;

	returns=0;
	for(i=0;i<32;i++)
	{
		if(ConfigsInfo.list01used&&(List01.slotUsed[i]==1)) returns++;
		if(ConfigsInfo.list02used&&(List02.slotUsed[i]==1)) returns++;
		if(ConfigsInfo.list03used&&(List03.slotUsed[i]==1)) returns++;
		if(ConfigsInfo.list04used&&(List04.slotUsed[i]==1)) returns++;
		if(ConfigsInfo.list05used&&(List05.slotUsed[i]==1)) returns++;
		if(ConfigsInfo.list06used&&(List06.slotUsed[i]==1)) returns++;
		if(ConfigsInfo.list07used&&(List07.slotUsed[i]==1)) returns++;
		if(ConfigsInfo.list08used&&(List08.slotUsed[i]==1)) returns++;
		if(ConfigsInfo.list09used&&(List09.slotUsed[i]==1)) returns++;
	}
	return returns;
}

function SeedList()
{
	local int i;

	List01=Spawn(class'XBotsBotInfoL01');
	List02=Spawn(class'XBotsBotInfoL02');
	List03=Spawn(class'XBotsBotInfoL03');
	List04=Spawn(class'XBotsBotInfoL04');
	List05=Spawn(class'XBotsBotInfoL05');
	List06=Spawn(class'XBotsBotInfoL06');
	List07=Spawn(class'XBotsBotInfoL07');
	List08=Spawn(class'XBotsBotInfoL08');
	List09=Spawn(class'XBotsBotInfoL09');
	defaultBotInfo=Spawn(class'ChallengeBotInfo');
	ConfigsInfo=Spawn(class'XBotsConfigStore');
	i=botsAvail();
	if(i==0) setToDefault();
	if((i>0)&&(i<=32)) fillWithDefault();
	if(i>32) randomSet();
	List01.Destroy();
	List02.Destroy();
	List03.Destroy();
	List04.Destroy();
	List05.Destroy();
	List06.Destroy();
	List07.Destroy();
	List08.Destroy();
	List09.Destroy();
	Super.SaveConfig();
	SaveConfig();
}

function setToDefault()
{
	local int i;

	for(i=0;i<32;i++)
	{
			VoiceType[i]=defaultBotInfo.VoiceType[i];
			BotFaces[i]=defaultBotInfo.BotFaces[i];
			BotNames[i]=defaultBotInfo.BotNames[i];
			BotTeams[i]=defaultBotInfo.BotTeams[i];
			BotAccuracy[i]=defaultBotInfo.BotAccuracy[i];
			CombatStyle[i]=defaultBotInfo.CombatStyle[i];
			Alertness[i]=defaultBotInfo.Alertness[i];
			Camping[i]=defaultBotInfo.Camping[i];
			StrafingAbility[i]=defaultBotInfo.StrafingAbility[i];
			FavoriteWeapon[i]=defaultBotInfo.FavoriteWeapon[i];
			BotClasses[i]=defaultBotInfo.BotClasses[i];
			BotSkins[i]=defaultBotInfo.BotSkins[i];
			BotJumpy[i]=defaultBotInfo.BotJumpy[i];
	}
	defaultBotInfo.destroy();
}

function fillWithDefault()
//there isn't 32 bot configs, so fill rest with UT's list
{
	local int i,j,k;
	local XBotsBotInfo templist;
	local bool tempuse;
	local int randoms;
	local int randoms2;

	k=0;
	for(i=0;i<32;i++)
	{
		defaultBotInfo.ConfigUsed[i]=0;
	}
	for(i=1;i<=9;i++)
	{
		switch(i)
		{
			case 1:
				templist=List01;
				tempuse=ConfigsInfo.list01used;
				break;
			case 2:
				templist=List02;
				tempuse=ConfigsInfo.list02used;
				break;
			case 3:
				templist=List03;
				tempuse=ConfigsInfo.list03used;
				break;
			case 4:
				templist=List04;
				tempuse=ConfigsInfo.list04used;
				break;		
			case 5:
				templist=List05;
				tempuse=ConfigsInfo.list05used;
				break;
			case 6:
				templist=List06;
				tempuse=ConfigsInfo.list06used;
				break;
			case 7:
				templist=List07;
				tempuse=ConfigsInfo.list07used;
				break;
			case 8:
				templist=List08;
				tempuse=ConfigsInfo.list08used;
				break;		
			case 9:
				templist=List09;
				tempuse=ConfigsInfo.list09used;
				break;
		}
		for(j=0;j<32;j++)
		{
			if((tempuse)&&(templist.slotUsed[j]==1))
			{
				VoiceType[k]=templist.VoiceType[j];
				BotFaces[k]=templist.BotFaces[j];
				BotNames[k]=templist.BotNames[j];
				BotTeams[k]=templist.BotTeams[j];
				BotAccuracy[k]=templist.BotAccuracy[j];
				CombatStyle[k]=templist.CombatStyle[j];
				Alertness[k]=templist.Alertness[j];
				Camping[k]=templist.Camping[j];
				StrafingAbility[k]=templist.StrafingAbility[j];
				FavoriteWeapon[k]=templist.FavoriteWeapon[j];
				BotClasses[k]=templist.BotClasses[j];
				BotSkins[k]=templist.BotSkins[j];
				BotJumpy[k]=templist.BotJumpy[j];
				k++;
			}
		}
	}
	while(k<32)
	{
		randoms2=rand(32);
		if(defaultBotInfo.ConfigUsed[randoms2]==0)
		{
			VoiceType[k]=defaultBotInfo.VoiceType[randoms2];
			BotFaces[k]=defaultBotInfo.BotFaces[randoms2];
			BotNames[k]=defaultBotInfo.BotNames[randoms2];
			BotTeams[k]=defaultBotInfo.BotTeams[randoms2];
			BotAccuracy[k]=defaultBotInfo.BotAccuracy[randoms2];
			CombatStyle[k]=defaultBotInfo.CombatStyle[randoms2];
			Alertness[k]=defaultBotInfo.Alertness[randoms2];
			Camping[k]=defaultBotInfo.Camping[randoms2];
			StrafingAbility[k]=defaultBotInfo.StrafingAbility[randoms2];
			FavoriteWeapon[k]=defaultBotInfo.FavoriteWeapon[randoms2];
			BotClasses[k]=defaultBotInfo.BotClasses[randoms2];
			BotSkins[k]=defaultBotInfo.BotSkins[randoms2];
			BotJumpy[k]=defaultBotInfo.BotJumpy[randoms2];
			k++;
			defaultBotInfo.ConfigUsed[randoms2]=1;	
		}
	}
	defaultBotInfo.destroy();
}

function randomSet()
{
	local int i;
	local int randoms;
	local int randoms2;
	local bool tempUse;
	local ChallengeBotInfo templist;

	for(i=0;i<32;i++)
	{
		list01.ConfigUsed[i]=0;
		list02.ConfigUsed[i]=0;
		list03.ConfigUsed[i]=0;
		list04.ConfigUsed[i]=0;
		list05.ConfigUsed[i]=0;
		list06.ConfigUsed[i]=0;
		list07.ConfigUsed[i]=0;
		list08.ConfigUsed[i]=0;
		list09.ConfigUsed[i]=0;
		defaultBotInfo.ConfigUsed[i]=0;
	}
	i=0;
	while(i<32)
	{
		if(ConfigsInfo.listUTused)
			randoms=rand(10)+1;
		else
			randoms=rand(9)+1;
		randoms2=rand(32);
		switch(randoms)
		{
			case 1:
				templist=List01;
				tempuse=ConfigsInfo.list01used&&(List01.slotUsed[randoms2]==1);
				break;
			case 2:
				templist=List02;
				tempuse=ConfigsInfo.list02used&&(List02.slotUsed[randoms2]==1);
				break;
			case 3:
				templist=List03;
				tempuse=ConfigsInfo.list03used&&(List03.slotUsed[randoms2]==1);
				break;
			case 4:
				templist=List04;
				tempuse=ConfigsInfo.list04used&&(List04.slotUsed[randoms2]==1);
				break;		
			case 5:
				templist=List05;
				tempuse=ConfigsInfo.list05used&&(List05.slotUsed[randoms2]==1);
				break;
			case 6:
				templist=List06;
				tempuse=ConfigsInfo.list06used&&(List06.slotUsed[randoms2]==1);
				break;
			case 7:
				templist=List07;
				tempuse=ConfigsInfo.list07used&&(List07.slotUsed[randoms2]==1);
				break;
			case 8:
				templist=List08;
				tempuse=ConfigsInfo.list08used&&(List08.slotUsed[randoms2]==1);
				break;		
			case 9:
				templist=List09;
				tempuse=ConfigsInfo.list09used&&(List09.slotUsed[randoms2]==1);
				break;
			case 10:
				templist=defaultBotInfo;
				tempuse=ConfigsInfo.listUTused;
				break;			
		}
		if((tempuse)&&(templist.ConfigUsed[randoms2]==0))
		{
			VoiceType[i]=templist.VoiceType[randoms2];
			BotFaces[i]=templist.BotFaces[randoms2];
			BotNames[i]=templist.BotNames[randoms2];
			BotTeams[i]=templist.BotTeams[randoms2];
			BotAccuracy[i]=templist.BotAccuracy[randoms2];
			CombatStyle[i]=templist.CombatStyle[randoms2];
			Alertness[i]=templist.Alertness[randoms2];
			Camping[i]=templist.Camping[randoms2];
			StrafingAbility[i]=templist.StrafingAbility[randoms2];
			FavoriteWeapon[i]=templist.FavoriteWeapon[randoms2];
			BotClasses[i]=templist.BotClasses[randoms2];
			BotSkins[i]=templist.BotSkins[randoms2];
			BotJumpy[i]=templist.BotJumpy[randoms2];
			templist.ConfigUsed[randoms2]=1;
			i++;
		}
	}
}

defaultproperties
{
}
