//=============================================================================
// BSInfoTeamScoreBoard (c) 2010 Mr.Loathsome AKA Scott Armitage
//=============================================================================
class BSInfoTeamScoreBoard extends TeamScoreBoard config(BSInfo);

var config bool bDebugMode;
var byte Difficulty, CurMaxSkill;

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
	local float XL, YL, XL2, YL2, YB;
	local BotReplicationInfo BRI;
	local String S, O, L, botskill;
	local Font CanvasFont;
	local bool bAdminPlayer;
	local PlayerPawn PlayerOwner;
	local int Time;
	local Bot B;
	local Pawn P;
	local byte Bsk, Bsk2;

	PlayerOwner = PlayerPawn(Owner);

	bAdminPlayer = PRI.bAdmin;

	// Draw Name
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		Canvas.DrawColor = GoldColor;

	if ( bAdminPlayer )
		Canvas.DrawColor = WhiteColor;

	Canvas.SetPos(XOffset, YOffset);
	Canvas.DrawText(PRI.PlayerName, False);
	Canvas.StrLen(PRI.PlayerName, XL, YB);

	if ( Canvas.ClipX > 512 )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';
		Canvas.DrawColor = WhiteColor;

		if (Level.NetMode != NM_Standalone)
		{
			if ( !bCompressed || (Canvas.ClipX > 640) )
			{
				// Draw Time
				Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
				Canvas.StrLen(TimeString$":     ", XL, YL);
				Canvas.SetPos(XOffset - XL - 6, YOffset);
				Canvas.DrawText(TimeString$":"@Time, false);
			}

			// Draw Ping
			Canvas.StrLen(PingString$":     ", XL2, YL2);
			Canvas.SetPos(XOffset - XL2 - 6, YOffset + (YL+1));
			Canvas.DrawText(PingString$":"@PRI.Ping, false);
		}
		Canvas.Font = CanvasFont;
	}

	// Draw Score
	if (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName)
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = TeamColor[PRI.Team];
	DrawScore(Canvas, PRI.Score, XOffset, YOffset);

	if (Canvas.ClipX < 512)
		return;

	// Draw Order, Current Bot Skill & Location
	if ( !bCompressed )
	{
		CanvasFont = Canvas.Font;
		Canvas.Font = Font'SmallFont';
		if  (PRI.Team == OwnerInfo.Team) 
		{
			O = OwnerGame.GetOrderString(PRI);
			if (O != "")
			{
				O = OrdersString@O;
				Canvas.StrLen(O, XL2, YL2);
				Canvas.SetPos(XOffset, YOffset + YB);
				Canvas.DrawText(O, False);
			}
		}
		if ( PRI.bIsABot )
		{
			L = "";
			for ( P=Level.PawnList; P!=None; P=P.nextPawn )
				if ( P.PlayerReplicationInfo.PlayerID == PRI.PlayerID )
				{
					B=Bot(P);
					Bsk=B.Skill;
					if (( !B.bThreePlus ) && ( !B.bNovice ) && ( Bsk <=3 ))
						Bsk +=4;
					Bsk = Min(Bsk, 7);
					Bsk2 = Min(Bsk, 7);
					CurMaxSkill = Max(CurMaxSkill, Bsk2);
					L="Current Skill:"@class'ChallengeBotInfo'.default.Skills[Bsk];
					if ( bDebugMode )
					{
						L=L$" "@B.Skill;
						if ( B.bNovice ) L=L$" Novice";
						if ( B.bThreePlus ) L=L$" ThreePlus";
					}
					break;
				}

			L = L@botskill;
			if  (PRI.Team == OwnerInfo.Team) 
				Canvas.SetPos(XOffset, YOffset + YB + YL2 + YL2);
			else
				Canvas.SetPos(XOffset, YOffset + YB);
			Canvas.DrawText(L, False);
		}
		if ((PRI.Team == OwnerInfo.Team ) && (PRI.PlayerLocation != None ))
			L = InString@PRI.PlayerLocation.LocationName;
		else if (( PRI.Team == OwnerInfo.Team ) && (PRI.PlayerZone != None ))
				L = InString@PRI.PlayerZone.ZoneName;
		else
			L = "";
		if ( L != "Location: " )
		{
			Canvas.SetPos(XOffset, YOffset + YB + YL2);
			Canvas.DrawText(L, False);
		}

		Canvas.Font = CanvasFont;
	}
}


function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;
	local byte  Bsk, Bsk2;

	Canvas.bCenter = true;
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = WhiteColor;
	PlayerOwner = PlayerPawn(Owner);

	Bsk = Level.Game.Difficulty;
	Bsk2 = Min(Bsk, 7);
	Canvas.SetPos(0, Canvas.ClipY - 3 * YL);
	Canvas.DrawColor = GreenColor;
	Canvas.DrawText("Current Difficulty Value: "@class'ChallengeBotInfo'.default.Skills[Bsk2]$" = "@Bsk$"  -  Current Max Skill Level Achieved: "@class'ChallengeBotInfo'.default.Skills[CurMaxSkill], True);
	Canvas.SetPos(0, Canvas.ClipY - 2 * YL);
	Canvas.DrawColor = WhiteColor;
	Canvas.DrawText(PlayerOwner.GameReplicationInfo.GameName@MapTitle@Level.Title, true);
	Canvas.SetPos(0, Canvas.ClipY - YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.StrLen("Test", XL, YL);
		Canvas.SetPos(0, Canvas.ClipY - Min(YL*6, Canvas.ClipY * 0.1));
		Canvas.DrawColor = GreenColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

defaultproperties
{
	bDebugMode=False
}
