
//#exec AUDIO IMPORT FILE="Sounds\GrappleHit.WAV" NAME="GrappleHit" GROUP="Weapons"

class USW_GrappleHook expands UniversalSoldiersWeapon config(UniversalSoldiers);

var Weapon  PreviousWeapon;
var Grapple Grapple;
var bool bManualShot;
var bool bShooting;
var() config bool bUseExtra0;
var() config bool bUseExtra1;

/*
replication 
{
    // Things the server should send to the clients 
		reliable if( Role == ROLE_Authority)
			bUseExtra0, bUseExtra1;
    reliable if(Role< ROLE_Authority)
      	FireHook, bShooting, bManualShot;
      	  
    // Functions clients can call 
    //unreliable if( Role < ROLE_Authority)
    //    FireHook, Grapple, bManualShot, bShooting;
}

simulated function FireHook()
{
		PlayerPawn(Owner).ClientMessage("Grapple is: " $ grapple $ " and bShooting is: " $ bShooting $ " and bExtra1 is: " $ PlayerPawn(Owner).bExtra1);
		if(bShooting || grapple!=none)
			return;
		GotoState('NormalFire');
		PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
  	bPointing = True;
  	PlayFiring();
  	if ((!bRapidFire) && (FiringSpeed > 0))
		 	Pawn(Owner).PlayRecoil(FiringSpeed);
		bShooting=true;
  	Owner.AmbientSound=sound'CGrapple.Weapons.GrappleHit';
	  Grapple = Grapple(ProjectileFire(ProjectileClass,2000,bWarnTarget));
  	Grapple.setMaster(Self);
  	
  	if (Owner.bHidden)
		 		CheckVisibility();
}

simulated function Tick(float deltatime)
{
	
	if(PlayerPawn(Owner) != None &&  
				bShooting==false && 
				Grapple == none && 
				PlayerPawn(Owner).bExtra1 != 0 
				&& bUseExtra1==true)
	{
		PlayerPawn(Owner).ClientMessage("I'm here.. I shouldn't be most likely.");
		FireHook();
	} 
	else if(bShooting==true && Grapple != none && PlayerPawn(Owner).bExtra1 != 0 && bUseExtra1)
	{
		PlayerPawn(Owner).ClientMessage("I got to where I'm supposed to go.");
		bShooting=false;	
		if(grapple != none)
		{
			grapple.destroy();
		}
	}
	
  if (PlayerPawn(Owner) != None && bManualShot==false && PlayerPawn(Owner).bExtra1 == 0 && bUseExtra1)
  { 
  	if((bUseExtra0 && PlayerPawn(Owner).bExtra0==0) || !bUseExtra0 ){
  		bShooting=false;
  		if(grapple != none)
  		{
	   		Grapple.Destroy();
  			Grapple=none;
	  	}
	  }
  }
  
  if(PlayerPawn(Owner) != None && Grapple == none && bShooting==false && PlayerPawn(Owner).bExtra0 != 0 && bUseExtra0)
	{
		FireHook();
	}
		
  if (PlayerPawn(Owner) != None && bManualShot==false && PlayerPawn(Owner).bExtra0 == 0 && bUseExtra0)
  { 
  	if( (bUseExtra1 && PlayerPawn(Owner).bExtra1==0) || !bUseExtra1 ){
  		bShooting=false;
  		if(grapple!=none){
  			Grapple.Destroy();
  			Grapple=none;
  		}
  	}
  }
  

}
*/
 
function Destroyed()
{ 
  if (Grapple != none)
  {
    Grapple.Destroy();
    Grapple = none;
  }
  Super.Destroyed();
} 

function setHand(float Hand)
{
  if (Hand != 2)
  {
	if (Hand == 0)
		Hand = 1;
	else
		Hand *= -1;

	if (Hand == -1)
		Mesh = mesh(DynamicLoadObject("Botpack.TranslocR", class'Mesh'));
	else
		Mesh = mesh'Botpack.Transloc';
  }
  Super.SetHand(Hand);
}

function DropFrom(vector StartLocation)
{
  if (Grapple != none)
  {
    Grapple.Destroy();
    Grapple = none;
  }
  Super.DropFrom(StartLocation);
}
function BringUp()
{
  PreviousWeapon = none;
  Super.BringUp();
}

function RaiseUp(Weapon OldWeapon)
{
  if (OldWeapon == Self)
	  PreviousWeapon = none;
  else
	  PreviousWeapon = OldWeapon;
  Super.BringUp();
}

simulated function PlayFiring()
{
  //PlayOwnedSound('CGrapple.Weapons.GrappleHit',SLOT_Misc,10); //4 * Pawn(Owner).SoundDampening);	
  
  PlayAnim('Throw',1.0,0.1);
}

function Fire(float Value)
{
  GotoState('NormalFire');
  if (PlayerPawn(Owner) != none)
	  PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
  bPointing = True;
  PlayFiring();
  if ((!bRapidFire) && (FiringSpeed > 0))
	  Pawn(Owner).PlayRecoil(FiringSpeed);
  if (Grapple == none){
  		//Owner.PlaySound(sound'CGrapple.Weapons.GrappleHit',SLOT_Misc,10); 
  		Owner.AmbientSound=sound'GrappleHit';
  		bManualShot=true;
  	  Grapple = Grapple(ProjectileFire(ProjectileClass,2000,bWarnTarget));
  	  Grapple.setMaster(Self);
  }
  if (Owner.bHidden)
	  CheckVisibility();
}

function AltFire(float Value)
{
  GotoState('AltFiring');
}

///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////
state NormalFire
{
	function Fire(float F) 
	{
	}
	
	function AltFire(float F) 
	{
	}
	
	function EndState()
	{

    }
	
Begin:
	FinishAnim();
	Finish();
}

state AltFiring
{
	function Fire(float F) 
	{
	}
	
	function AltFire(float F) 
	{
	}
	
	function EndState()
	{
		bManualShot=false;
	  if (Grapple != none)
	  {
	    Grapple.Destroy();
	    Grapple = none;
	  }
	}
	
Begin:
	FinishAnim();
	Finish();
}

state Idle
{
	function AnimEnd()
	{
	  PlayIdleAnim();
	}

	function bool PutDown()
	{
	  GotoState('DownWeapon');
	  return True;
	}

Begin:
	
	bPointing = False;
	Disable('AnimEnd');
	PlayIdleAnim();
}

function Finish()
{
  local Pawn PawnOwner;

  if (bChangeWeapon)
  {
	GotoState('DownWeapon');
	return;
  }

  PawnOwner = Pawn(Owner);
  if (PlayerPawn(Owner) == none)
  {
	PawnOwner.StopFiring();
	GotoState('Idle');
	return;
  }
  else 
	 GotoState('Idle');
}

defaultproperties
{
    FireOffset=(X=115.00,Y=15.00,Z=2.00),
    ProjectileClass=Class'Grapple'
    AltProjectileClass=Class'Grapple'
    RefireRate=0.10
    bRotatingPickup=False
    ItemName="GrappleHook"
    PlayerViewOffset=(X=5.00,Y=-4.00,Z=-7.00),
    PlayerViewMesh=LodMesh'Botpack.Transloc'
    PickupViewMesh=LodMesh'Botpack.Trans3loc'
    ThirdPersonMesh=LodMesh'Botpack.Trans3loc'
    StatusIcon=Texture'Botpack.Icons.UseTrans'
    Mass=10.00
}
