class USW_barret50 expands UniversalSoldiersWeapon;

#exec MESH IMPORT MESH=Barret50 ANIVFILE=Barret50\Barret50_a.3d DATAFILE=Barret50\Barret50_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Barret50 X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=Barret50 SEQ=All    STARTFRAME=0 NUMFRAMES=30
#exec MESH SEQUENCE MESH=Barret50 SEQ=down   STARTFRAME=0 NUMFRAMES=10  RATE=15
#exec MESH SEQUENCE MESH=Barret50 SEQ=Fire   STARTFRAME=10 NUMFRAMES=10 RATE=100
#exec MESH SEQUENCE MESH=Barret50 SEQ=select STARTFRAME=20 NUMFRAMES=10 RATE=15
#exec MESH SEQUENCE MESH=barret50 SEQ=Still  STARTFRAME=30 NUMFRAMES=1

#exec TEXTURE IMPORT NAME=JBarret3rd1 FILE=Barret50\Barret501.BMP GROUP=Skins FLAGS=2 // JBarret501

#exec MESHMAP NEW   MESHMAP=Barret50 MESH=Barret50
#exec MESHMAP SCALE MESHMAP=Barret50 X=0.1 Y=0.1 Z=0.2

//#exec MESHMAP SETTEXTURE MESHMAP=Barret50 NUM=1 TEXTURE=JBarret501

/////////////////////////////////Pickup Mesh///////////////////////////////

/*
#exec MESH IMPORT MESH=BarretPickup ANIVFILE=Barret50\BarretPickup_a.3d DATAFILE=Barret50\BarretPickup_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=BarretPickup X=0 Y=0 Z=0

#exec MESH SEQUENCE MESH=BarretPickup SEQ=All          STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=BarretPickup SEQ=Barretpickup STARTFRAME=0 NUMFRAMES=1

//#exec TEXTURE IMPORT NAME=JBarretPickup FILE=Barret50\BarretPickup.PCX GROUP=Skins FLAGS=2

#exec MESHMAP NEW   MESHMAP=BarretPickup MESH=BarretPickup
#exec MESHMAP SCALE MESHMAP=BarretPickup X=0.1 Y=0.1 Z=0.2

#exec MESHMAP SETTEXTURE MESHMAP=BarretPickup NUM=0 TEXTURE=JBarretPickup
*/

///////////////////////////////ThirdPerson Mesh////////////////////////////


#exec MESH IMPORT MESH=Barret3rd ANIVFILE=Barret50\Barret3rd_a.3d DATAFILE=Barret50\Barret3rd_d.3d X=0 Y=0 Z=0
#exec MESH ORIGIN MESH=Barret3rd X=-125 Y=0 Z=-30

#exec MESH SEQUENCE MESH=Barret3rd SEQ=All       STARTFRAME=0 NUMFRAMES=1
#exec MESH SEQUENCE MESH=Barret3rd SEQ=Barret3rd STARTFRAME=0 NUMFRAMES=1

//#exec TEXTURE IMPORT NAME=JBarret3rd1 FILE=Barret50\Barret3rd1.PCX GROUP=Skins FLAGS=2 // 01 - Default

#exec MESHMAP NEW   MESHMAP=Barret3rd MESH=Barret3rd
#exec MESHMAP SCALE MESHMAP=Barret3rd X=0.1 Y=0.1 Z=0.2

//#exec MESHMAP SETTEXTURE MESHMAP=Barret3rd NUM=1 TEXTURE=JBarret3rd1

#exec texture IMPORT NAME=BarretScope FILE=Barret50\BarretScope.pcx FLAGS=2 MIPS=OFF
//#exec texture IMPORT NAME=USEFHG FILE=Barret50\USEFHG.pcx FLAGS=2 MIPS=OFF

///////////////////////////////////////////////////////////////////////////
var int NumFire;
var name FireAnims[5];
var vector OwnerLocation;
var float StillTime, StillStart;
var bool bZoom;

simulated function PostRender( canvas Canvas )
{
     local PlayerPawn P;
     local float Scale;

	P = PlayerPawn(Owner);
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
	{		
		bOwnsCrossHair = true;
		Canvas.Style = ERenderStyle.STY_Translucent;

		Scale = (Canvas.ClipX/640);
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
		Canvas.Style = ERenderStyle.STY_Translucent;
		Canvas.DrawIcon(Texture'BarretScope', Scale); //Reticle
		Canvas.SetPos(0.5 * Canvas.ClipX + 64 * Scale, 0.5 * Canvas.ClipY + 96 * Scale );
		Canvas.DrawColor = 15 * ChallengeHUD(PlayerPawn(Owner).myhud).CrosshairColor;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.DrawText("X"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
      
    }
	else
		bOwnsCrossHair = false;
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

simulated function PlayFiring()
{
	local int r;

	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*1.0);
	PlayAnim(FireAnims[Rand(5)],0.5 + 0.5 * FireAdjust, 0.05);

	if ( (PlayerPawn(Owner) != None) 
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
}


simulated function bool ClientAltFire( float Value )
{
	GotoState('Zooming');
	return true;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

///////////////////////////////////////////////////////
state NormalFire
{
	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}
		
Begin:
	FlashCount++;
	ProjectileFire(ProjectileClass, ProjectileSpeed, bWarnTarget);
	PlayFiring();
	FinishAnim();
        Finish();
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 0.95;
	P = Pawn(Owner);
	if ( P == None )
	{
		GotoState('');
		return;
	}
	if ( VSize(P.Location - OwnerLocation) < 6 )
		StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

	else
		StillTime = 0;
	StillStart = Level.TimeSeconds;
	OwnerLocation = P.Location;
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(P, 200, FireDir);
	}
	else 
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		if ( (P.bFire == 0) && (P.bAltFire == 0) )
			bPointing = false;
	}
}	

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
local vector SmokeLocation,DVector;
	local rotator SmokeRotation;
	local float NumPoints;

	SmokeLocation = Owner.Location + CalcDrawOffset() + FireOffset.X * X + FireOffset.Y * 3.3 * Y + FireOffset.Z * Z * 3.0;
	DVector = HitLocation - SmokeLocation;
	NumPoints = VSize(DVector)/70.0;
	SmokeLocation += DVector/NumPoints;
	SmokeRotation = rotator(HitLocation-Owner.Location);
	if (NumPoints>15) NumPoints=15;

	if (Other == Level)
 	;

		else if ( (Other != self) && (Other != Owner) && (Other != None) )
	{
		if ( Other.bIsPawn ) {
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		}

		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight)
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(100, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else

	        Other.TakeDamage(80, Pawn(Owner), HitLocation, 30000 * X, myDamageType);

	}
}

function Projectile ProjectileFire(class<projectile> ProjClass, float ProjSpeed, bool bWarn)
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local int LinuxSpeed;
	local float dist;


	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(owner).ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + pawn(owner).Eyeheight * Z;
	ProjSpeed = 100.0000;
	AdjustedAim = pawn(owner).AdjustAim(ProjSpeed, StartTrace, 2*AimError, False, False);
	X = vector(AdjustedAim);
	EndTrace = StartTrace + 5000 * X; // was 10000
	AimDir = vector(AdjustedAim);


	LinuxSpeed = 0;


	return Spawn(class'BarretProj',,, StartTrace,AdjustedAim);
}

function SpawnEffect(Vector DVector, int NumPoints, rotator SmokeRotation, vector SmokeLocation)
{
	local BarretWave Smoke;

	Smoke = Spawn(class'Barretwave',,,SmokeLocation,SmokeRotation);
	Smoke.MoveAmount = DVector/NumPoints;
	Smoke.NumPuffs = NumPoints;
}

function Finish()
{
	if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
		Timer();
	Super.Finish();
}
state Idle
{
	function Fire( float Value )
	{
		if ( AmmoType == None )
		{
			// ammocheck
			GiveAmmo(Pawn(Owner));
		}
		if (AmmoType.UseAmmo(1))
		{
			GotoState('NormalFire');
			bCanClientFire = true;
			bPointing=True;
			if ( Owner.IsA('Bot') )
			{
				// simulate bot using zoom
				if ( Bot(Owner).bSniping && (FRand() < 0.65) )
					AimError = AimError/FClamp(StillTime, 1.0, 8.0);
				else if ( VSize(Owner.Location - OwnerLocation) < 6 )
					AimError = AimError/FClamp(0.5 * StillTime, 1.0, 3.0);
				else
					StillTime = 0;
			}
			Pawn(Owner).PlayRecoil(FiringSpeed);
			TraceFire(0.0);
			AimError = Default.AimError;
			ClientFire(Value);
		}
	}


	function BeginState()
	{
		bPointing = false;
		SetTimer(0.4 + 1.6 * FRand(), false);
		Super.BeginState();
	}

	function EndState()
	{	
		SetTimer(0.0, false);
		Super.EndState();
	}
	
Begin:
	bPointing=False;
	if ( AmmoType.AmmoAmount<=0 ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	Disable('AnimEnd');
	PlayIdleAnim();
}

/////////////////////Pure HUD//////////////////////////
simulated event PostNetBeginPlay()
{
	local BarretHUD BarretScope;
	local PlayerPawn HUDOwner;

	Super.PostNetBeginPlay();

	HUDOwner = PlayerPawn(Owner);
	if (HUDOwner != None && HUDOwner.IsA('bbPlayer') && HUDOwner.myHUD != None)
	{
		ForEach AllActors(Class'BarretHUD',BarretScope)
		break;
		if (BarretScope == None)
		{
			BarretScope = Spawn(Class'BarretHUD', Owner);
			BarretScope.RegisterHUDMutator();
			BarretScope.HUDOwner = HUDOwner;
		}
	}
}
///////////////////////////////////////////////////////
state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			if ( (PlayerPawn(Owner) != None) && PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).StopZoom();
			SetTimer(0.0,False);
			GoToState('Idle');
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).ToggleZoom();
			SetTimer(0.2,True);
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}



///////////////////////////////////////////////////////////
simulated function PlayIdleAnim()
{
	if ( Mesh != PickupViewMesh )
		PlayAnim('Still',1.0, 0.05);
}

defaultproperties
{
    FireAnims(0)=Fire
    FireAnims(1)=Fire
    FireAnims(2)=Fire
    FireAnims(3)=Fire
    FireAnims(4)=Fire
    WeaponDescription="Barret Rifle"
    AmmoName=Class'US_Ammo'
    PickupAmmoCount=50
    bInstantHit=True
    bAltInstantHit=True
    FiringSpeed=0.10
    ProjectileClass=Class'BarretProj'
    MyDamageType=shot
    AltDamageType=Decapitated
    shakemag=400.00
    shaketime=0.15
    shakevert=8.00
    AIRating=0.54
    RefireRate=1.00
    AltRefireRate=0.90
    FireSound=Sound'UnrealShare.General.Expl04'
    DeathMessage="%k blew up %o with his Barret!"
    NameColor=(R=0,G=0,B=255,A=0),
    bDrawMuzzleFlash=True
    MuzzleScale=1.00
    FlashY=0.11
    FlashO=0.01
    FlashC=0.03
    FlashLength=0.01
    FlashS=256
    MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
    AutoSwitchPriority=9
    InventoryGroup=9
    PickupMessage="You got the Barret Rifle!!"
    ItemName="Barret 50"
    PlayerViewOffset=(X=3.00,Y=-1.50,Z=-0.90),
    PlayerViewMesh=LodMesh'Barret50'
    PlayerViewScale=0.20
    BobDamping=0.98
    PickupViewMesh=LodMesh'Barret50'
    PickupViewScale=1.50
    ThirdPersonMesh=LodMesh'Barret3rd'
    bMuzzleFlashParticles=True
    MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
    MuzzleFlashScale=0.10
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy3'
    Icon=Texture'USEFHG'
    Rotation=(Pitch=0,Yaw=0,Roll=-1536),
    Mesh=LodMesh'Barret3rd'
    bNoSmooth=False
    SoundRadius=0
    SoundVolume=244
    CollisionRadius=32.00
    CollisionHeight=8.00
    MultiSkins(0)=Texture'JBarret3rd1'
    PickupSound=Sound'HomerPickup'
    HUDname="Barret"
    HUDcolor=(R=255,G=255,B=0)
}
