
class USW_AutoMag extends UniversalSoldiersWeapon;

var() int hitdamage;
var  float AltAccuracy;
var int ClipCount;

function AltFire( float Value )
{
	bPointing=True;
	AltAccuracy = 0.4;
	CheckVisibility();
	if (AmmoType.AmmoAmount>0)
	{
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		PlayAnim('T1', 1.3, 0.05);
		GotoState('AltFiring');
	}
}

function PlayFiring()
{
	ClipCount++;
	Owner.PlaySound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
}

// set which hand is holding weapon
function setHand(float Hand)
{
	Super.SetHand(Hand);
	if ( Hand == 1 )
		Mesh = mesh'AutoMagL';
	else
		Mesh = mesh'AutoMagR';
}

///////////////////////////////////////////////////////
state NormalFire
{
Begin:
	if (AnimSequence!='Shoot0') 
	{
		PlayAnim('Shoot',2.5, 0.02);
		FinishAnim();
	}
	PlayAnim('Shoot0',0.26, 0.04);	
	FinishAnim();
	if (ClipCount>15) Owner.PlaySound(Misc1Sound, SLOT_None, 3.5*Pawn(Owner).SoundDampening);	
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( (AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	else if (ClipCount>=20) GoToState('NewClip');
	else if ( Pawn(Owner).bFire!=0 ) Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )Global.AltFire(0);		
	PlayAnim('Shoot2',0.8, 0.0);	
	FinishAnim();
	GoToState('Idle');
}


////////////////////////////////////////////////////////
state NewClip
{
ignores Fire, AltFire;
Begin:
	PlayAnim('Eject',1.5,0.05);
	Owner.PlaySound(Misc2Sound, SLOT_None,1.0*Pawn(Owner).SoundDampening);	
	FinishAnim();
	PlayAnim('Down',1.2,0.05);
	FinishAnim();
	ClipCount = 0;
	Owner.PlaySound(SelectSound, SLOT_None,1.0*Pawn(Owner).SoundDampening);	
	PlayAnim('Select',1.6,0.07);
	FinishAnim();
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);	
	else GotoState('Idle');
}

////////////////////////////////////////////////////////
state AltFiring
{
ignores Fire, AltFire;

Begin:
	FinishAnim();
	PlayAnim('Shot2a', 1.2, 0.05);	
	FinishAnim();
Repeater:	
	if (AmmoType.UseAmmo(1)) 
	{
		if ( PlayerPawn(Owner) != None )
			PlayerPawn(Owner).ShakeView(ShakeTime, ShakeMag, ShakeVert);
		ClipCount++;	
		TraceFire(AltAccuracy);
		PlayAltFiring();	
		FinishAnim();
	}
	if ( AltAccuracy < 3 ) 
		AltAccuracy += 0.5;
	if (ClipCount>15) Owner.PlaySound(Misc1Sound, SLOT_None, 3.5*Pawn(Owner).SoundDampening);		
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( Pawn(Owner).Weapon != Self )
		GotoState('Idle');		
	else if ( /*bAltFireMem ||*/ (Pawn(Owner).bAltFire!=0) 
		&& AmmoType.AmmoAmount>0 && ClipCount<20)
	{
		if ( PlayerPawn(Owner) == None )
			Pawn(Owner).bAltFire = int( FRand() < AltReFireRate );
		//bFireMem = false;
		//bAltFireMem = false; 
		Goto('Repeater');	
	}
	PlayAnim('Shot2c', 0.7, 0.05);	
	FinishAnim();	
	PlayAnim('T2', 0.9, 0.05);	
	FinishAnim();
	Finish();
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local shellcase s;
	local vector realLoc;

	realLoc = Owner.Location + CalcDrawOffset();
	s = Spawn(class'ShellCase',Pawn(Owner), '', realLoc + 20 * X + FireOffset.Y * Y + Z);
	if ( s != None )
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	if (Other == Level) 
		Spawn(class'WallHitEffect',,, HitLocation+HitNormal*9, Rotator(HitNormal));
	else if ((Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( FRand() < 0.2 )
			X *= 5;
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 3000.0*X, 'shot');
		if ( !Other.IsA('Pawn') && !Other.IsA('Carcass') )
			spawn(class'SpriteSmokePuff',,,HitLocation+HitNormal*9);
	}		
}

function PlayPostSelect()
{
	ClipCount = 0;
}

function Finish()
{
	if ( bChangeWeapon )
		GotoState('DownWeapon');
	else if ( PlayerPawn(Owner) == None )
		Super.Finish();
	else if ( (AmmoType.AmmoAmount<=0) || (Pawn(Owner).Weapon != self) )
		GotoState('Idle');
	else if (ClipCount>=20) GoToState('NewClip');
	else if ( /*bFireMem ||*/ Pawn(Owner).bFire!=0 )
		Global.Fire(0);
	else if ( /*bAltFireMem ||*/ Pawn(Owner).bAltFire!=0 )
		Global.AltFire(0);
	else 
		GotoState('Idle');
}

function PlayAltFiring()
{
	Owner.PlaySound(FireSound, SLOT_None,2.0*Pawn(Owner).SoundDampening);
	PlayAnim('Shot2b', 0.4, 0.05);
}

state Idle
{
	function AnimEnd()
	{
		PlayIdleAnim();
	}

	function bool PutDown()
	{
		GotoState('DownWeapon');
		return True;
	}
	
	function Timer()
	{
		if (FRand()>0.8) PlayAnim('Twiddle',0.6,0.3);
		else if (AnimSequence == 'Twiddle') LoopAnim('Sway1',0.02, 0.3);
	}

Begin:
	bPointing=False;
	if ( (AmmoType != None) && (AmmoType.AmmoAmount<=0) ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	Disable('AnimEnd');
	LoopAnim('Sway1',0.02, 0.1);
	SetTimer(1.5,True);
	if ( /*bFireMem ||*/ Pawn(Owner).bFire!=0 ) Global.Fire(0.0);
	if ( /*bAltFireMem ||*/ Pawn(Owner).bAltFire!=0 ) Global.AltFire(0.0);	
}

defaultproperties
{
     hitdamage=17
     AmmoName=Class'US_Ammo'
     PickupAmmoCount=20
     bInstantHit=True
     bAltInstantHit=True
     FireOffset=(Y=-10.000000,Z=-4.000000)
     shakemag=200.000000
     shakevert=4.000000
     AIRating=0.200000
     RefireRate=0.700000
     AltRefireRate=0.900000
     FireSound=Sound'UnrealShare.AutoMag.shot'
     AltFireSound=Sound'UnrealShare.AutoMag.shot'
     CockingSound=Sound'UnrealShare.AutoMag.Cocking'
     SelectSound=Sound'UnrealShare.AutoMag.Cocking'
     Misc1Sound=Sound'UnrealShare.flak.Click'
     Misc2Sound=Sound'UnrealShare.AutoMag.Reload'
     DeathMessage="%o got gatted by %k's %w."
     AutoSwitchPriority=2
     InventoryGroup=2
     PickupMessage="You got the AutoMag"
     ItemName="Automag"
     PlayerViewOffset=(X=4.800000,Y=-1.700000,Z=-2.700000)
     PlayerViewMesh=LodMesh'UnrealShare.AutoMagL'
     PickupViewMesh=LodMesh'UnrealShare.AutoMagPickup'
     ThirdPersonMesh=LodMesh'UnrealShare.auto3rd'
     PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
     Mesh=LodMesh'UnrealShare.AutoMagPickup'
     bNoSmooth=False
     CollisionRadius=25.000000
     CollisionHeight=10.000000
     Mass=15.000000
     HUDname="Automag"
     HUDcolor=(R=0,G=255,B=0)
}
