class Pickup_Soul extends UniversalSoldiersPickup;

#exec obj load file=..\Textures\SGTech1.utx package=SGTech1

#exec mesh import mesh=Cross anivfile=Models\Cross_a.3d datafile=Models\Cross_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Cross x=0 y=0 z=0
#exec mesh sequence mesh=Cross seq=All startframe=0 numframes=1

#exec meshmap new meshmap=Cross mesh=Cross
#exec meshmap scale meshmap=Cross x=0.12500 y=0.12500 z=0.25000

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

auto state Pickup
{	
	function Touch( actor Other )
	{
		local US_PRI IPRI;

		if ( ValidTouch(Other) && Other.IsA('PlayerPawn') && Claimer == PlayerPawn(Other).PlayerReplicationInfo.PlayerName ) 
			{
			US_PRI(PlayerPawn(Other).PlayerReplicationInfo).Souls += 1;
			PlayPickupMessage(PlayerPawn(Other));
			PlaySound (PickupSound,,2.5);
			Other.MakeNoise(0.2);		
			SetRespawn();	
			}
	

	}
}


defaultproperties
{
LifeTime=60
DrawType=DT_Mesh
Mesh=Mesh'Cross'
CollisionRadius=26.00000
CollisionHeight=32.00000
MultiSkins(0)=Texture'SGTech1.Trim.SGcontrim_nbolt'
PickupMessage="You picked up a soul"
ItemName="Soul"
RespawnTime=0.000000
PickupViewMesh=Mesh'Cross'
PickupSound=Sound'UnrealShare.Generic.RespawnSound'
ScaleGlow=2.000000
bCollideWhenPlacing=True
bRotatingPickup=True
RotationRate=(Roll=12500)
RotationRate=(Pitch=12250)
RotationRate=(Yaw=12000)
}
