//=============================================================================
//
//=============================================================================
class BarretWave extends RingExplosion;

var vector MoveAmount;
var int NumPuffs;

replication
{
	// Things the server should send to the client.
	unreliable if( Role==ROLE_Authority )
		MoveAmount, NumPuffs;
}

simulated function Tick( float DeltaTime )
{
	if ( Level.NetMode != NM_DedicatedServer )
	{
		ScaleGlow = (Lifespan/Default.Lifespan)*1.2;
		AmbientGlow = ScaleGlow * 210;
	}
}


simulated function PostBeginPlay()
{
	if ( Level.NetMode != NM_DedicatedServer )
	{
		PlayAnim  ( 'Explosion', 0.1 );
		SetTimer(0.06, false);
	}
}

simulated function Timer()
{
	local BarretWave r;

	if (NumPuffs>0)
	{
		r = Spawn(class'BarretWave',,,Location+MoveAmount);
		r.RemoteRole = ROLE_None;
		r.NumPuffs = NumPuffs -1;
		r.MoveAmount = MoveAmount;
	}
}

defaultproperties
{
    LifeSpan=0.37
    AmbientSound=Sound'UnrealI.Generic.Teleport2'
    Skin=FireTexture'UnrealShare.Effect50.fireeffect50'
    DrawScale=0.08
    SoundRadius=64
    SoundVolume=200
}
