//=============================================================================
// Barret HitWall/object class
//=============================================================================
class BarretShock extends ShockrifleWave;

#exec TEXTURE IMPORT NAME=HitWave FILE=Barret50\HitWave.PCX  GROUP="Skins"
#exec MESHMAP SETTEXTURE MESHMAP=ShockRWM NUM=1 TEXTURE=HitWave


simulated function PostBeginPlay()
{
	super.PostBeginPlay();
	if ( !Level.bHighDetailMode || Level.bDropDetail )
		LightType = LT_None;
}

simulated function Tick( float DeltaTime )
{
	local float ShockSize;

	ShockSize = 1.2/(ScaleGlow+0.05);
	if ( Level.NetMode != NM_DedicatedServer )
	{
		ScaleGlow = (Lifespan/Default.Lifespan);
		AmbientGlow = ScaleGlow * 255;
		DrawScale = ShockSize;
	}
}

defaultproperties
{
    LifeSpan=1.50
    MultiSkins(1)=Texture'Skins.HitWave'
    LightHue=135
    LightRadius=16
}
