// ============================================================================
// JBMoveMonstersBack
// ============================================================================

class JBMoveMonstersBack expands Trigger;

// this one is for moving the Monsters back to their cells
// after they finished their job with the prisoners 

var() vector DestLocation;  // Location to respawn
var() rotator DestRotation; // Rotation to respawn with
var() ScriptedPawn Monster;  // Monster to take back

replication {
  reliable if(RemoteRole == ROLE_DumbProxy)
    MonsterBack;
}

function Trigger(actor Other, pawn EventInstigator) {
  Instigator = EventInstigator;
  gotostate('JBMonsterBackTrigger');
}

function MonsterBack(ScriptedPawn Monster) {
  if(Monster.IsA('JBSquid'))
    JBSquid(Monster).MoveMonsterTo(DestLocation, DestRotation);
  else if(Monster.IsA('JBDevilfish'))
    JBDevilfish(Monster).MoveMonsterTo(DestLocation, DestRotation);
}

state() JBMonsterBackTrigger {
  Begin:
    disable('Trigger');
    MonsterBack(Monster);
    enable('Trigger');
}

defaultproperties {
  InitialState=JBMonsterBackTrigger
}