// ============================================================================
// JBKillOneWorkaround
// ============================================================================

class JBKillOneWorkaround expands Trigger;

// This is a workaround for a jailbreak issue

var() int JailedTeam;

// ===========================
// copied from class JailBreak
// ===========================

function JBPRI getJBPRIfor(pawn Other) {
	local JBPRI pri;
	if (other.playerreplicationinfo==none) return none;
	foreach allactors(class'JBPRI',pri) {
		if (pri.PRI==Other.PlayerReplicationInfo) return pri;
	}
}

function Trigger(actor Other, pawn EventInstigator) {
  Instigator = EventInstigator;
  gotostate('JBKillOneWorkaround');
}

function KillOne(pawn Instigator) {
  local Pawn Sacrifice, P;
  local JBPRI pri;

  Sacrifice = None;

  for(P=Level.PawnList; P!=None; P=P.NextPawn)
    if(P.IsA('Bot')) {
      pri=getjbprifor(P);
      if(pri.isJailed && P.PlayerReplicationInfo.Team == JailedTeam)
        Sacrifice = P;
      }

  if(Sacrifice!=None) {
    Sacrifice.GibbedBy(Sacrifice);
  }     
}

state() JBKillOneWorkaround{
  Begin:
    disable('Trigger');
    KillOne(Instigator);
    enable('Trigger');
}

defaultproperties {
  InitialState=JBKillOneWorkaround
}