//================================================================================
// StarterBoltTIW.
//================================================================================
class StarterBoltTIW extends PBoltTIW;

var float OldError;
var float NewError;
var float StartError;
var float aimerror;
var Rotator AimRotation;
var float AnimTime;

replication
{
	un?reliable if ( Role == 4 )
		NewError,aimerror,AimRotation;
}

simulated function PostBeginPlay ()
{
	Super.PostBeginPlay();
	if ( Instigator == None )
	{
		return;
	}
	if ( Instigator.IsA('Bot') && Bot(Instigator).bNovice )
	{
		aimerror=2200.00 + (3 - Instigator.Skill) * 300;
	} else {
		aimerror=1000.00 + (3 - Instigator.Skill) * 400;
	}
	if ( FRand() < 0.50 )
	{
		aimerror *= -1;
	}
}

simulated function Tick (float DeltaTime)
{
	local Vector X;
	local Vector Y;
	local Vector Z;
	local Vector AimSpot;
	local Vector DrawOffset;
	local Vector AimStart;
	local int YawErr;
	local float dAdjust;
	local Bot MyBot;

	AnimTime += DeltaTime;
	if ( AnimTime > 0.05 )
	{
		AnimTime -= 0.05;
		SpriteFrame++;
		if ( SpriteFrame == 5 )
		{
			SpriteFrame=0;
		}
		Skin=SpriteAnim[SpriteFrame];
	}
	if ( Instigator != None )
	{
		if ( (Level.NetMode == 3) && ( !Instigator.IsA('PlayerPawn') || (PlayerPawn(Instigator).Player == None)) )
		{
			SetRotation(AimRotation);
			Instigator.ViewRotation=AimRotation;
			DrawOffset=0.01 * Class'PulseGun'.Default.PlayerViewOffset >> Rotation;
			DrawOffset += Instigator.EyeHeight * vect(0.00,0.00,1.00);
		} else {
			MyBot=Bot(Instigator);
			if ( MyBot != None )
			{
				if ( Instigator.Target == None )
				{
					Instigator.Target=Instigator.Enemy;
				}
				if ( Instigator.Target == Instigator.Enemy )
				{
					if ( MyBot.bNovice )
					{
						dAdjust=DeltaTime * (4 + Instigator.Skill) * 0.08;
					} else {
						dAdjust=DeltaTime * (4 + Instigator.Skill) * 0.12;
					}
					if ( OldError > NewError )
					{
						OldError=FMax(OldError - dAdjust,NewError);
					} else {
						OldError=FMin(OldError + dAdjust,NewError);
					}
					if ( OldError == NewError )
					{
						NewError=FRand() - 0.50;
					}
					if ( StartError > 0 )
					{
						StartError -= DeltaTime;
					} else {
						if ( MyBot.bNovice && (Level.TimeSeconds - MyBot.LastPainTime < 0.20) )
						{
							StartError=MyBot.LastPainTime;
						} else {
							StartError=0.00;
						}
					}
					AimSpot=1.25 * Instigator.Target.Velocity + 0.75 * Instigator.Velocity;
					if ( Abs(AimSpot.Z) < 120 )
					{
						AimSpot.Z *= 0.25;
					} else {
						AimSpot.Z *= 0.50;
					}
					if ( Instigator.Target.Physics == 2 )
					{
						AimSpot=Instigator.Target.Location - 0.00 * aimerror * OldError * AimSpot;
					} else {
						AimSpot=Instigator.Target.Location - 0.00 * aimerror * OldError * AimSpot;
					}
					if ( (Instigator.Physics == 2) && (Instigator.Velocity.Z > 0) )
					{
						AimSpot=AimSpot - 0.00 * aimerror * OldError * AimSpot;
					}
					AimStart=Instigator.Location + FireOffset.X * X + FireOffset.Y * Y + (1.20 * FireOffset.Z - 2) * Z;
					if ( FastTrace(AimSpot - vect(0.00,0.00,10.00),AimStart) )
					{
						AimSpot=AimSpot - vect(0.00,0.00,10.00);
					}
					GetAxes(Instigator.Rotation,X,Y,Z);
					AimRotation=rotator(AimSpot - AimStart);
					AimRotation.Yaw=AimRotation.Yaw + (OldError + StartError) * 0.75 * aimerror;
					YawErr=AimRotation.Yaw - (Instigator.Rotation.Yaw & 65535) & 65535;
					if ( (YawErr > 3000) && (YawErr < 62535) )
					{
						if ( YawErr < 32768 )
						{
							AimRotation.Yaw=Instigator.Rotation.Yaw + 3000;
						} else {
							AimRotation.Yaw=Instigator.Rotation.Yaw - 3000;
						}
					}
				} else {
					if ( Instigator.Target != None )
					{
						AimRotation=rotator(Instigator.Target.Location - Instigator.Location);
					} else {
						AimRotation=Instigator.ViewRotation;
					}
				}
				Instigator.ViewRotation=AimRotation;
				SetRotation(AimRotation);
			} else {
				AimRotation=Instigator.ViewRotation;
				SetRotation(AimRotation);
			}
			DrawOffset=Instigator.Weapon.CalcDrawOffset();
		}
		GetAxes(Instigator.ViewRotation,X,Y,Z);
		if ( bCenter )
		{
			FireOffset.Z=Default.FireOffset.Z * 1.50;
			FireOffset.Y=0.00;
		} else {
			FireOffset.Z=Default.FireOffset.Z;
			if ( bRight )
			{
				FireOffset.Y=Default.FireOffset.Y;
			} else {
				FireOffset.Y=-1.00 * Default.FireOffset.Y;
			}
		}
		SetLocation(Instigator.Location + DrawOffset + FireOffset.X * X + FireOffset.Y * Y + FireOffset.Z * Z);
	} else {
		GetAxes(Rotation,X,Y,Z);
	}
	CheckBeam(X,DeltaTime);
}

simulated function CheckBeam (Vector X, float DeltaTime)
{
	local Actor HitActor;
	local Vector HitLocation;
	local Vector HitNormal;

	HitActor=Trace(HitLocation,HitNormal,Location + BeamSize * X,Instigator.Location,True);
	if ( (HitActor != None) && (HitActor != Instigator) && (HitActor.bProjTarget || (HitActor == Level) || HitActor.bBlockActors && HitActor.bBlockPlayers) && ((Pawn(HitActor) == None) || Pawn(HitActor).AdjustHitLocation(HitLocation,Velocity)) )
	{
		if ( Level.NetMode != 3 )
		{
			if ( DamagedActor == None )
			{
				AccumulatedDamage=FMin(0.50 * (Level.TimeSeconds - LastHitTime),0.10);
				HitActor.TakeDamage(Damage * AccumulatedDamage,Instigator,HitLocation,MomentumTransfer * X * AccumulatedDamage,MyDamageType);
				AccumulatedDamage=0.00;
			} else {
				if ( DamagedActor != HitActor )
				{
					DamagedActor.TakeDamage(Damage * AccumulatedDamage,Instigator,HitLocation,MomentumTransfer * X * AccumulatedDamage,MyDamageType);
					AccumulatedDamage=0.00;
				}
			}
			LastHitTime=Level.TimeSeconds;
			DamagedActor=HitActor;
			AccumulatedDamage += DeltaTime;
			if ( AccumulatedDamage > 0.22 )
			{
				if ( DamagedActor.IsA('Carcass') && (FRand() < 0.09) )
				{
					AccumulatedDamage=35.00 / Damage;
				}
				DamagedActor.TakeDamage(Damage * AccumulatedDamage,Instigator,HitLocation,MomentumTransfer * X * AccumulatedDamage,MyDamageType);
				AccumulatedDamage=0.00;
			}
		}
		if ( HitActor.bIsPawn && Pawn(HitActor).bIsPlayer )
		{
			if ( WallEffect != None )
			{
				WallEffect.Destroy();
			}
		} else {
			if ( (WallEffect == None) || WallEffect.bDeleteMe )
			{
				WallEffect=Spawn(Class'PlasmaHit',,,HitLocation - 5 * X);
			} else {
				if (  !WallEffect.IsA('PlasmaHit') )
				{
					WallEffect.Destroy();
					WallEffect=Spawn(Class'PlasmaHit',,,HitLocation - 5 * X);
				} else {
					WallEffect.SetLocation(HitLocation - 5 * X);
				}
			}
		}
		if ( (WallEffect != None) && (Level.NetMode != 1) )
		{
			Spawn(ExplosionDecal,,,HitLocation,rotator(HitNormal));
		}
		if ( PlasmaBeam != None )
		{
			AccumulatedDamage += PlasmaBeam.AccumulatedDamage;
			PlasmaBeam.Destroy();
			PlasmaBeam=None;
		}
		return;
	} else {
		if ( (Level.NetMode != 3) && (DamagedActor != None) )
		{
			DamagedActor.TakeDamage(Damage * AccumulatedDamage,Instigator,DamagedActor.Location - X * 1.20 * DamagedActor.CollisionRadius,MomentumTransfer * X * AccumulatedDamage,MyDamageType);
			AccumulatedDamage=0.00;
			DamagedActor=None;
		}
	}
	if ( Position >= 9 )
	{
		if ( (WallEffect == None) || WallEffect.bDeleteMe )
		{
			WallEffect=Spawn(Class'PlasmaCap',,,Location + (BeamSize - 4) * X);
		} else {
			if ( WallEffect.IsA('PlasmaHit') )
			{
				WallEffect.Destroy();
				WallEffect=Spawn(Class'PlasmaCap',,,Location + (BeamSize - 4) * X);
			} else {
				WallEffect.SetLocation(Location + (BeamSize - 4) * X);
			}
		}
	} else {
		if ( WallEffect != None )
		{
			WallEffect.Destroy();
			WallEffect=None;
		}
		if ( PlasmaBeam == None )
		{
			PlasmaBeam=Spawn(Class'PBoltTIW',,,Location + BeamSize * X);
			PlasmaBeam.Position=Position + 1;
		} else {
			PlasmaBeam.UpdateBeam(self,X,DeltaTime);
		}
	}
}

defaultproperties
{
    StartError=0.50
    SpriteAnim(0)=Texture'Botpack.Skins.sbolt0'
    SpriteAnim(1)=Texture'Botpack.Skins.sbolt1'
    SpriteAnim(2)=Texture'Botpack.Skins.sbolt2'
    SpriteAnim(3)=Texture'Botpack.Skins.sbolt3'
    SpriteAnim(4)=Texture'Botpack.Skins.sbolt4'
    RemoteRole=2
    LightType=1
    LightEffect=13
    LightBrightness=255
    LightHue=83
    LightSaturation=50
    LightRadius=5
}