//================================================================================
// Minigun2TIW.
//================================================================================
class Minigun2TIW extends minigun2;

var config int TracerInterval;
var float bullettime;
var float bulletcount;
var float miniprimpower;
var float minisecpower;
var bool firstbullet;
var int TracerCounter;
var float MiniPrimPowerFactor;
var float MiniSecondPowerFactor;

simulated event RenderTexture (ScriptedTexture Tex)
{
	local Color C;
	local string temp;

	if ( AmmoType != None )
	{
		temp=string(AmmoType.AmmoAmount);
	}
JL0020:
	if ( Len(temp) < 3 )
	{
		temp="0" $ temp;
		goto JL0020;
	}
	C.R=255;
	C.G=0;
	C.B=0;
	Tex.DrawColoredText(2.00,10.00,temp,Font'LEDFont2',C);
}

function TraceFire (float Accuracy)
{
	local Vector HitLocation;
	local Vector HitNormal;
	local Vector StartTrace;
	local Vector EndTrace;
	local Vector X;
	local Vector Y;
	local Vector Z;
	local Vector AimDir;
	local Actor Other;

	Owner.MakeNoise(Pawn(Owner).SoundDampening);
	GetAxes(Pawn(Owner).ViewRotation,X,Y,Z);
	StartTrace=Owner.Location + CalcDrawOffset() + FireOffset.Y * Y + FireOffset.Z * Z;
	AdjustedAim=Pawn(Owner).AdjustAim(1000000.00,StartTrace,2.75 * aimerror,False,False);
	EndTrace=StartTrace + Accuracy * (FRand() - 0.50) * Y * 1000 + Accuracy * (FRand() - 0.50) * Z * 1000;
	AimDir=AdjustedAim;
	EndTrace += 10000 * AimDir;
	Other=Pawn(Owner).TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	TracerCounter++;
	if ( TracerCounter == TracerInterval )
	{
		TracerCounter=0;
		if ( VSize(HitLocation - StartTrace) > 250 )
		{
			Spawn(Class'MTracer',,,StartTrace + 96 * AimDir,rotator(EndTrace - StartTrace));
		}
	}
	ProcessTraceHit(Other,HitLocation,HitNormal,AdjustedAim,Y,Z);
}

state NormalFire extends NormalFire
{
	function Tick (float DeltaTime)
	{
		if ( Owner == None )
		{
			AmbientSound=None;
		}
		bullettime += DeltaTime;
		bulletcount=Default.miniprimpower * MiniPrimPowerFactor;
	JL0030:
		if ( bullettime > bulletcount )
		{
			bullettime -= bulletcount;
			GenerateBullet();
			goto JL0030;
		}
	}
	
Begin:
	bullettime=0.00;
	bulletcount=Default.miniprimpower * MiniPrimPowerFactor;
bb2:
	Sleep(0.00);
	goto ('bb2');
}

state AltFiring extends AltFiring
{
	function Tick (float DeltaTime)
	{
		if ( Owner == None )
		{
			AmbientSound=None;
			GotoState('Pickup');
		}
		if ( bFiredShot && ((Pawn(Owner).bAltFire == 0) || bOutOfAmmo) )
		{
			GotoState('FinishFire');
		} else {
			bullettime += DeltaTime;
	JL005F:
			if ( bullettime > bulletcount )
			{
				bullettime -= bulletcount;
				firstbullet=True;
				GenerateBullet();
				goto JL005F;
			}
		}
	}
	
Begin:
	bulletcount=0.10;
	bullettime=0.00;
	firstbullet=False;
BB:
	Sleep(0.00);
	if ( AnimSequence == 'Shoot2' )
	{
		goto ('FastShoot');
	}
	goto ('BB');
FastShoot:
	if ( firstbullet )
	{
		bulletcount=Default.minisecpower * MiniSecondPowerFactor;
	}
	Sleep(0.00);
	goto ('FastShoot');
}

defaultproperties
{
    TracerInterval=5
    bulletcount=0.10
    miniprimpower=0.10
    minisecpower=0.07
    MiniPrimPowerFactor=1.00
    MiniSecondPowerFactor=1.00
    PickupMessage="You got the Minigun"
}