//================================================================================
// Menu_TabWindow.
//================================================================================
class Menu_TabWindow extends UWindowDialogClientWindow
	Localized;

var UMenuPageControl Pages;
var UWindowSmallCloseButton CloseButton;
var Menu_IconWindow IconWindow;
var Menu_FontWindow FontWindow;
var Menu_ChatboxWindow ChatboxWindow;
var Menu_CrosshairWindow CrosshairWindow;
var localized string FontTab;
var localized string IconTab;
var localized string ChatBoxTab;
var localized string CrosshairTab;
var localized string TweakTab;
var localized string ClientTab;

function Created ()
{
	Pages=UMenuPageControl(CreateWindow(Class'UMenuPageControl',0.00,0.00,WinWidth,WinHeight - 48));
	Pages.SetMultiLine(True);
	FontWindow=Menu_FontWindow(Menu_FontScrollWindow(Pages.AddPage(FontTab,Class'Menu_FontScrollWindow').Page).FirstChildWindow);
	IconWindow=Menu_IconWindow(Pages.AddPage(IconTab,Class'Menu_IconWindow').Page);
	ChatboxWindow=Menu_ChatboxWindow(Pages.AddPage(ChatBoxTab,Class'Menu_ChatboxWindow').Page);
	CrosshairWindow=Menu_CrosshairWindow(Pages.AddPage(CrosshairTab,Class'Menu_CrosshairWindow').Page);
	Pages.AddPage(TweakTab,Class'Menu_TweakScrollWindow');
	Pages.AddPage(ClientTab,Class'Menu_ClientWindow');
	CloseButton=UWindowSmallCloseButton(CreateControl(Class'UWindowSmallCloseButton',WinWidth - 56,WinHeight - 24,48.00,16.00));
	FontWindow.MyIconWindow=IconWindow;
	FontWindow.MyChatboxWindow=ChatboxWindow;
	FontWindow.MyCrossHairWindow=CrosshairWindow;
	IconWindow.MyFontWindow=FontWindow;
	Super.Created();
}

function Resized ()
{
	Pages.WinWidth=WinWidth;
	Pages.WinHeight=WinHeight - 24;
	CloseButton.WinLeft=WinWidth - 52;
	CloseButton.WinTop=WinHeight - 20;
}

function Paint (Canvas C, float X, float Y)
{
	local Texture t;

	t=GetLookAndFeelTexture();
	DrawUpBevel(C,0.00,LookAndFeel.TabUnselectedM.H,WinWidth,WinHeight - LookAndFeel.TabUnselectedM.H,t);
}

function GetDesiredDimensions (out float W, out float H)
{
	Super(UWindowWindow).GetDesiredDimensions(W,H);
	H += 30;
}

defaultproperties
{
    FontTab="Messages"
    IconTab="Icons/Colors"
    ChatBoxTab="ChatBox"
    CrosshairTab="CrossHair"
    TweakTab="Tweaks"
    ClientTab="HUD Options"
}