//================================================================================
// Menu_CrossHairAssignWindow.
//================================================================================
class Menu_CrossHairAssignWindow extends UWindowDialogClientWindow;

var UMenuLabelControl Label;
var UWindowEditControl Ch[21];

function Created ()
{
	local int ControlWidth;
	local int CenterWidth;
	local int CenterPos;
	local int ControlOffset;
	local int CID;
	local int installedCH;

	Super.Created();
	ControlWidth=WinWidth / 5 * 4;
	CenterWidth=WinWidth / 4 * 3;
	CenterPos=(WinWidth - CenterWidth) / 4;
	ControlOffset=16;
	Label=UMenuLabelControl(CreateControl(Class'UMenuLabelControl',CenterPos,ControlOffset,ControlWidth,1.00));
	Label.SetText("ID       CrossHair Texture               Opaque Layer Texture");
	Label.SetFont(1);
	ControlOffset += 25;
	installedCH=Class'ChallengeHUD'.Default.CrosshairCount;
	if ( installedCH > 20 )
	{
		installedCH=20;
	}
	CID=0;
JL0113:
	if ( CID < installedCH )
	{
		Ch[CID]=UWindowEditControl(CreateControl(Class'UWindowEditControl',CenterPos,ControlOffset,ControlWidth,1.00));
		if ( Class'ChallengeHUD'.Default.CrossHairs[CID] == "" )
		{
			Class'ChallengeHUD'.Default.CrossHairs[CID]="None";
		}
		if ( CID < 10 )
		{
			Ch[CID].SetText("" @ string(CID) @ "      " @ Class'ChallengeHUD'.Default.CrossHairs[CID]);
		} else {
			Ch[CID].SetText(string(CID) @ "     " @ Class'ChallengeHUD'.Default.CrossHairs[CID]);
		}
		if ( Class'HUD'.Default.Crosshair != CID )
		{
			Ch[CID].SetFont(0);
		} else {
			Ch[CID].SetFont(1);
		}
		Ch[CID].Align=0;
		Ch[CID].EditBoxWidth=128.00;
		Ch[CID].SetMaxLength(32);
		Ch[CID].SetNumericOnly(False);
		Ch[CID].SetDelayedNotify(True);
		Ch[CID].SetValue(Class'LeagueAS_HUD'.Default.OpaqueCrossHairs[CID]);
		ControlOffset += 16;
		CID++;
		goto JL0113;
	}
	Ch[0].HideWindow();
	Ch[0].ShowWindow();
}

function Notify (UWindowDialogControl C, byte E)
{
	local int chID;

	chID=0;
JL0007:
	if ( chID < 20 )
	{
		switch (E)
		{
			case 1:
			switch (C)
			{
				case Ch[chID]:
				Class'LeagueAS_HUD'.Default.OpaqueCrossHairs[chID]=Ch[chID].GetValue();
				Class'LeagueAS_HUD'.StaticSaveConfig();
				default:
			}
			default:
		}
		chID++;
		goto JL0007;
	}
}