//================================================================================
// Menu_ChatboxWindow.
//================================================================================
class Menu_ChatboxWindow extends UWindowPageWindow;

var UWindowComboControl FScheme;
var UWindowCheckbox AutoFont;
var UWindowCheckbox AutoChat;
var UMenuLabelControl Label;
var UWindowEditControl MinChat;
var UWindowEditControl MaxChat;
var UWindowEditControl MinChatEndgame;
var UWindowEditControl MaxChatEndgame;
var string FSchemes[7];
var bool bAutoFont;
var bool bDoNotify;

function Created ()
{
	local int ControlWidth;
	local int CenterPos;
	local int ControlOffset;
	local int Z;

	Super.Created();
	ControlWidth=WinWidth / 3 * 2;
	CenterPos=(WinWidth - ControlWidth) / 2;
	ControlOffset=30;
	FScheme=UWindowComboControl(CreateControl(Class'UWindowComboControl',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	FScheme.SetText("Font Scheme:");
	FScheme.SetFont(0);
	FScheme.SetEditable(False);
	FScheme.EditBoxWidth=80.00;
	Z=0;
JL00C4:
	if ( Z < 7 )
	{
		FScheme.AddItem(FSchemes[Z]);
		Z++;
		goto JL00C4;
	}
	FScheme.SetValue(GetScheme(Class'LeagueAS_HUD'.Default.FontScheme));
	ControlOffset += 30;
	AutoFont=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	AutoFont.SetText("Auto adjust Font size to Resolution:");
	AutoFont.SetFont(0);
	AutoFont.Align=0;
	if ( Class'LeagueAS_HUD'.Default.FontScheme != 0 )
	{
		bAutoFont=True;
	} else {
		bAutoFont=False;
	}
	AutoFont.bChecked=bAutoFont;
	ControlOffset += 25;
	AutoChat=UWindowCheckbox(CreateControl(Class'UWindowCheckbox',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	AutoChat.SetText("Auto adjust Chatbox size to Resolution:");
	AutoChat.SetFont(0);
	AutoChat.Align=0;
	AutoChat.bChecked=Class'LeagueAS_HUD'.Default.bAutoAdjustDefaultChatboxSizeToResolution;
	ControlOffset += 30;
	Label=UMenuLabelControl(CreateControl(Class'UMenuLabelControl',CenterPos,ControlOffset,ControlWidth + 3,1.00));
	Label.SetText("Custom Chatbox:");
	Label.SetFont(1);
	ControlOffset += 30;
	MinChat=UWindowEditControl(CreateControl(Class'UWindowEditControl',CenterPos,ControlOffset,ControlWidth,1.00));
	MinChat.SetText("Mid Game Chatbox Size:");
	MinChat.SetFont(0);
	MinChat.Align=0;
	MinChat.EditBoxWidth=26.00;
	MinChat.SetMaxLength(4);
	MinChat.SetNumericOnly(True);
	MinChat.SetDelayedNotify(True);
	MinChat.SetValue(string(Class'LeagueAS_HUD'.Default.DefaultExpandChatboxMidgame));
	ControlOffset += 25;
	MaxChat=UWindowEditControl(CreateControl(Class'UWindowEditControl',CenterPos,ControlOffset,ControlWidth,1.00));
	MaxChat.SetText("Mid Game Chatbox Expand Size:");
	MaxChat.SetFont(0);
	MaxChat.Align=0;
	MaxChat.EditBoxWidth=26.00;
	MaxChat.SetMaxLength(4);
	MaxChat.SetNumericOnly(True);
	MaxChat.SetDelayedNotify(True);
	MaxChat.SetValue(string(Class'LeagueAS_HUD'.Default.MaxExpandChatboxMidgame));
	ControlOffset += 30;
	MinChatEndgame=UWindowEditControl(CreateControl(Class'UWindowEditControl',CenterPos,ControlOffset,ControlWidth,1.00));
	MinChatEndgame.SetText("End Game Chatbox Size:");
	MinChatEndgame.SetFont(0);
	MinChatEndgame.Align=0;
	MinChatEndgame.EditBoxWidth=26.00;
	MinChatEndgame.SetMaxLength(4);
	MinChatEndgame.SetNumericOnly(True);
	MinChatEndgame.SetDelayedNotify(True);
	MinChatEndgame.SetValue(string(Class'LeagueAS_HUD'.Default.DefaultExpandChatboxEndgame));
	ControlOffset += 25;
	MaxChatEndgame=UWindowEditControl(CreateControl(Class'UWindowEditControl',CenterPos,ControlOffset,ControlWidth,1.00));
	MaxChatEndgame.SetText("End Game Chatbox Expand Size:");
	MaxChatEndgame.SetFont(0);
	MaxChatEndgame.Align=0;
	MaxChatEndgame.EditBoxWidth=26.00;
	MaxChatEndgame.SetMaxLength(4);
	MaxChatEndgame.SetNumericOnly(True);
	MaxChatEndgame.SetDelayedNotify(True);
	MaxChatEndgame.SetValue(string(Class'LeagueAS_HUD'.Default.MaxExpandChatboxEndgame));
	ControlOffset += 30;
	UpdateMenus();
}

function UpdateMenus ()
{
	bDoNotify=False;
	if ( FScheme.GetValue() != "Manual" )
	{
		AutoFont.bChecked=True;
		AutoChat.ShowWindow();
	} else {
		AutoFont.bChecked=False;
		AutoChat.bChecked=False;
		AutoChat.HideWindow();
		Class'LeagueAS_HUD'.Default.bAutoAdjustDefaultChatboxSizeToResolution=AutoChat.bChecked;
		Class'LeagueAS_HUD'.StaticSaveConfig();
	}
	if (  !AutoChat.bChecked )
	{
		Label.ShowWindow();
		MinChat.ShowWindow();
		MaxChat.ShowWindow();
		MinChatEndgame.ShowWindow();
		MaxChatEndgame.ShowWindow();
	} else {
		Label.HideWindow();
		MinChat.HideWindow();
		MaxChat.HideWindow();
		MinChatEndgame.HideWindow();
		MaxChatEndgame.HideWindow();
	}
	AutoFont.HideWindow();
	AutoFont.ShowWindow();
	bDoNotify=True;
}

function Paint (Canvas C, float X, float Y)
{
	local int ControlLeft;
	local int ControlHeight;
	local Texture t;
	local Texture Tex;

	ControlLeft=436 / 2;
	ControlHeight=(WinHeight - 380 - 40) / 2 + 380;
	Super.Paint(C,X,Y);
	C.Style=1;
	C.DrawColor.R=255;
	C.DrawColor.G=255;
	C.DrawColor.B=255;
	t=GetLookAndFeelTexture();
	Tex=Texture'CSHPShield';
	DrawUpBevel(C,ControlLeft - 32 - 6,ControlHeight - 6,64.00 + 12,64.00 + 12,t);
	DrawStretchedTexture(C,ControlLeft - 32 - 3,ControlHeight - 3,64.00 + 6,64.00 + 6,Texture'BlackTexture');
	DrawStretchedTexture(C,ControlLeft - 32,ControlHeight,64.00,64.00,Tex);
	C.Style=1;
	C.DrawColor.R=0;
	C.DrawColor.G=0;
	C.DrawColor.B=0;
	C.Font=Font(DynamicLoadObject("UWindowFonts.TahomaB10",Class'Font'));
	ClipText(C,ControlLeft - 80,ControlHeight + 64 + 12 + 4,"Copyright  2004 utassault.net");
	ClipText(C,ControlLeft - 50,ControlHeight + 64 + 12 + 4 + 12,"All Rights Reserved.");
}

function string GetScheme (int schemeID)
{
	local string FStype;

	switch (schemeID)
	{
		case 0:
		FStype="Manual";
		break;
		case 1:
		FStype="Auto";
		break;
		case 2:
		FStype="AutoSmallest";
		break;
		case 3:
		FStype="AutoSmall";
		break;
		case 4:
		FStype="AutoMedium";
		break;
		case 5:
		FStype="AutoBig";
		break;
		case 6:
		FStype="AutoHuge";
		break;
		default:
	}
	return FStype;
}

function Notify (UWindowDialogControl C, byte E)
{
	if ( bDoNotify )
	{
		switch (E)
		{
			case 1:
			switch (C)
			{
				case FScheme:
				switch (FScheme.GetSelectedIndex())
				{
					case 0:
					Class'LeagueAS_HUD'.Default.FontScheme=0;
					break;
					case 1:
					Class'LeagueAS_HUD'.Default.FontScheme=1;
					break;
					case 2:
					Class'LeagueAS_HUD'.Default.FontScheme=2;
					break;
					case 3:
					Class'LeagueAS_HUD'.Default.FontScheme=3;
					break;
					case 4:
					Class'LeagueAS_HUD'.Default.FontScheme=4;
					break;
					case 5:
					Class'LeagueAS_HUD'.Default.FontScheme=5;
					break;
					case 6:
					Class'LeagueAS_HUD'.Default.FontScheme=6;
					break;
					default:
				}
				UpdateMenus();
				Class'LeagueAS_HUD'.StaticSaveConfig();
				break;
				case AutoFont:
				if (  !AutoFont.bChecked )
				{
					Class'LeagueAS_HUD'.Default.FontScheme=0;
					FScheme.SetValue("Manual");
					AutoChat.bChecked=False;
				} else {
					Class'LeagueAS_HUD'.Default.FontScheme=1;
					FScheme.SetValue("Auto");
				}
				Class'LeagueAS_HUD'.Default.bAutoAdjustDefaultChatboxSizeToResolution=AutoChat.bChecked;
				Class'LeagueAS_HUD'.StaticSaveConfig();
				UpdateMenus();
				break;
				case AutoChat:
				Class'LeagueAS_HUD'.Default.bAutoAdjustDefaultChatboxSizeToResolution=AutoChat.bChecked;
				Class'LeagueAS_HUD'.StaticSaveConfig();
				UpdateMenus();
				break;
				case MinChat:
				if ( int(MinChat.GetValue()) < 64 )
				{
					MinChat.SetValue("64");
				}
				if ( int(MinChat.GetValue()) > 1200 )
				{
					MinChat.SetValue("1200");
				}
				Class'LeagueAS_HUD'.Default.DefaultExpandChatboxMidgame=int(MinChat.GetValue());
				Class'LeagueAS_HUD'.StaticSaveConfig();
				break;
				case MaxChat:
				if ( int(MaxChat.GetValue()) < 64 )
				{
					MaxChat.SetValue("64");
				}
				if ( int(MaxChat.GetValue()) > 1200 )
				{
					MaxChat.SetValue("1200");
				}
				Class'LeagueAS_HUD'.Default.MaxExpandChatboxMidgame=int(MaxChat.GetValue());
				Class'LeagueAS_HUD'.StaticSaveConfig();
				break;
				case MinChatEndgame:
				if ( int(MinChatEndgame.GetValue()) < 64 )
				{
					MinChatEndgame.SetValue("64");
				}
				if ( int(MinChatEndgame.GetValue()) > 1200 )
				{
					MinChatEndgame.SetValue("1200");
				}
				Class'LeagueAS_HUD'.Default.DefaultExpandChatboxEndgame=int(MinChatEndgame.GetValue());
				Class'LeagueAS_HUD'.StaticSaveConfig();
				break;
				case MaxChatEndgame:
				if ( int(MaxChatEndgame.GetValue()) < 64 )
				{
					MaxChatEndgame.SetValue("64");
				}
				if ( int(MaxChatEndgame.GetValue()) > 1200 )
				{
					MaxChatEndgame.SetValue("1200");
				}
				Class'LeagueAS_HUD'.Default.MaxExpandChatboxEndgame=int(MaxChatEndgame.GetValue());
				Class'LeagueAS_HUD'.StaticSaveConfig();
				break;
				default:
				return;
			}
			default:
		}
	}
}

defaultproperties
{
    FSchemes(0)="Manual"
    FSchemes(1)="Auto"
    FSchemes(2)="AutoSmallest"
    FSchemes(3)="AutoSmall"
    FSchemes(4)="AutoMedium"
    FSchemes(5)="AutoBig"
    FSchemes(6)="AutoHuge"
}