//================================================================================
// LeagueAssault.
//================================================================================
class LeagueAssault extends LeagueAS_LAAbstract;

var string Overlord;
var() config bool bngStatsCompatibility;
var() config bool bEnableCSHP;
var() config bool bAttackOnly;
var() config bool bMatchMode;
var() config bool bPracticeMode;
var() config bool bStandardise;
var() config bool bAuthorisePlayers;
var() config bool bAdminNameScore;
var() config bool bServerNameScore;
var() config bool bServerNameGameType;
var() config bool bCheckServername;
var() config bool bAutoPausing;
var() config bool bNoSuicidePenalties;
var() config int MaxPauseTime;
var() config int PauseTimeRemaining[2];
var() config int MaxPauseCount;
var() config int PauseCountRemaining[2];
var() config int MaxPausePerMapCount;
var() config int PauseLeadInOutTime;
var() config int TeamScore[2];
var() config int MapsLeft;
var() config int MatchLength;
var() config int FirstMapStartTime;
var() config int SubsequentMapStartTime;
var() config string TeamNameRed;
var() config string TeamNameBlue;
var() config string MapsWon[2];
var() config string Matchlog;
var() config private string ModeratorPassword;
var() config private string MatchPasswordRed;
var() config private string MatchPasswordBlue;
var() config private string MatchPasswordSpec;
var() config string PrivateString;
var() config string PublicString;
var() config bool bImprovedTeamBalance;
var() config int TeamBalanceDelayTime;
var() config bool bPreventMapChangeKick;
var() config int PreventMapChangeKickTime;
var() config string AuthModuleClass;
var() config string EntryActorClassString;
var() config string AntiBanPasswords;
var() config bool bIPsCollected;
var() config int SavedPlayerCount;
var() config int SavedSpecCount;
var() config string SavedPlayerIPs[16];
var() config string SavedSpecIPs[4];
var() config bool bCleanShutdown;
var() config bool brecovering;
var() config string recallmutatorlist;
var() config string recallmap;
var() config int lastobjcompletiontime;
var() config string nextexpectedmap;
var() config bool bcrashrecovery;
var() config bool bDisableTIW;
var string VersionStr;
var string SubVersionStr;
var string OldServerName;
var string PackageName;
var LeagueAS_GameReplicationInfo LeagueASGameReplicationInfo;
var private PlayerPawn ModList[12];
var bool bMapStarted;
var bool bMapEnded;
var bool ServerHasPass;
var float TeamChangeTime;
var LeagueAS_SSDAbstract ServerSetupDataLink;
var LeagueAS_SSMAbstract ServerSideModule;
var HackProtection CSHP;
var LeagueAS_AutoPauser AutoPauser;
var LeagueAS_AuthAbstract AuthModule;
var int FreePlayerSlots;
var int FreeSpecSlots;

function SetPassword (int Team, string Pass)
{
	if ( Team == 0 )
	{
		MatchPasswordRed=Pass;
	} else {
		if ( Team == 1 )
		{
			MatchPasswordBlue=Pass;
		} else {
			if ( Team == 2 )
			{
				ModeratorPassword=Pass;
			} else {
				if ( Team == 3 )
				{
					MatchPasswordSpec=Pass;
				}
			}
		}
	}
}

function SetScoreStrings (string InScore)
{
	local string Prefix;
	local string Suffix;
	local bool ISiAS;
	local bool IS2v2;
	local Mutator M;
	local bool wasRemoved;

	LeagueASGameReplicationInfo.MatchScore=InScore;
	if ( bAdminNameScore )
	{
		LeagueASGameReplicationInfo.AdminName=LeagueASGameReplicationInfo.MatchScore;
	}
	if ( OldServerName == "" )
	{
		OldServerName=LeagueASGameReplicationInfo.ServerName;
	}
	if ( bServerNameScore )
	{
		Suffix=" [" $ LeagueASGameReplicationInfo.MatchScore $ "]";
	} else {
		Suffix="";
	}
	if ( bServerNameGameType )
	{
		ISiAS=False;
		M=BaseMutator;
JL00A9:
		if ( M != None )
		{
			if ( M.IsA('InstaGibDM') || M.IsA('iAS') )
			{
				ISiAS=True;
			}
			if ( M.IsA('AntiHammerLaunch') )
			{
				IS2v2=True;
			}
			M=M.NextMutator;
			goto JL00A9;
		}
		if ( ISiAS )
		{
			Prefix=" | iAS | ";
		} else {
			if ( IS2v2 && (MaxPlayers == 4) )
			{
				Prefix=" | 2v2AS | ";
			} else {
				if ( FriendlyFireScale == 1 )
				{
					Prefix=" | ProAS | ";
				} else {
					Prefix=" | StdAS | ";
				}
			}
		}
	} else {
		Prefix="";
	}
	if ( bCheckServername )
	{
		wasRemoved=RemoveSubString(OldServerName," | iAS | ") || wasRemoved;
		wasRemoved=RemoveSubString(OldServerName," | 2v2AS | ") || wasRemoved;
		wasRemoved=RemoveSubString(OldServerName," | ProAS | ") || wasRemoved;
		wasRemoved=RemoveSubString(OldServerName," | StdAS | ") || wasRemoved;
		wasRemoved=RemoveSubString(OldServerName," [" $ PrivateString $ "]") || wasRemoved;
		wasRemoved=RemoveSubString(OldServerName," [" $ PublicString $ "]") || wasRemoved;
		if ( wasRemoved )
		{
			LeagueASGameReplicationInfo.ServerName=OldServerName;
			LeagueASGameReplicationInfo.SaveConfig();
		}
	}
	LeagueASGameReplicationInfo.ServerName=Prefix $ OldServerName $ Suffix;
}

function bool RemoveSubString (out string myString, string Remove)
{
	local int pos;
	local bool bRemoved;

	pos=InStr(myString,Remove);
JL0012:
	if ( pos >= 0 )
	{
		myString=Left(myString,pos) $ Mid(myString,pos + Len(Remove));
		bRemoved=True;
		pos=InStr(myString,Remove);
		goto JL0012;
	}
	return bRemoved;
}

function int GetWinningTeam ()
{
	if ( bDefenseSet )
	{
		if ( bAssaultWon )
		{
			return Attacker.TeamIndex;
		} else {
			if (  !bTiePartOne )
			{
				return Defender.TeamIndex;
			} else {
				return -1;
			}
		}
	} else {
		return -1;
	}
}

function AddModerator (PlayerPawn Moderator, string Password)
{
	local int i;

	if ( ModeratorPassword == "" )
	{
		return;
	}
	if (  !IsAModerator(Moderator) && (Password == ModeratorPassword) )
	{
		Log(Moderator.PlayerReplicationInfo.PlayerName @ "became a server moderator.",'LeagueAssault');
		BroadcastMessage(Moderator.PlayerReplicationInfo.PlayerName @ "became a server moderator.");
		i=0;
JL00AD:
		if ( i < 12 )
		{
JL00B9:
			if ( ModList[i] == None )
			{
				ModList[i]=Moderator;
				return;
				goto JL00B9;
			}
			i++;
			goto JL00AD;
		}
	}
}

function bool IsAModerator (PlayerPawn Moderator)
{
	local int i;

	if ( Moderator == None )
	{
		return False;
	}
	i=0;
JL0014:
	if ( i < 12 )
	{
		if ( ModList[i] == Moderator )
		{
			return True;
		}
		i++;
		goto JL0014;
	}
	return False;
}

function RemoveModerator (PlayerPawn Moderator)
{
	local int i;

	i=0;
JL0007:
	if ( i < 12 )
	{
		if ( ModList[i] == Moderator )
		{
			ModList[i]=None;
			Log(Moderator.PlayerReplicationInfo.PlayerName @ "gave up moderator abilities.",'LeagueAssault');
			BroadcastMessage(Moderator.PlayerReplicationInfo.PlayerName @ "gave up moderator abilities.");
		}
		i++;
		goto JL0007;
	}
}

function float DistanceFrom (Actor P1, Actor P2)
{
	local float DistanceX;
	local float DistanceY;
	local float DistanceZ;
	local float ADistance;

	DistanceX=P1.Location.X - P2.Location.X;
	DistanceY=P1.Location.Y - P2.Location.Y;
	DistanceZ=P1.Location.Z - P2.Location.Z;
	ADistance=Sqrt(Square(DistanceX) + Square(DistanceY) + Square(DistanceZ));
	return ADistance;
}

function string NearestObj (PlayerPawn Sender)
{
	local FortStandard F;
	local FortStandard NearestFort;
	local float DistToNearestFort;
	local float ThisFortDist;

	DistToNearestFort=0.00;
	foreach AllActors(Class'FortStandard',F)
	{
		ThisFortDist=DistanceFrom(Sender,F);
		if ( (DistToNearestFort == 0) || (ThisFortDist < DistToNearestFort) )
		{
			NearestFort=F;
			DistToNearestFort=ThisFortDist;
		}
	}
	if ( NearestFort == None )
	{
		return "None";
	}
	if ( NearestFort.FortName == "Assault Target" )
	{
		return string(NearestFort);
	} else {
		if ( (NearestFort.FortName == "") || (NearestFort.FortName == " ") )
		{
			return string(NearestFort);
		} else {
			return NearestFort.FortName;
		}
	}
}

function string NearestTeamMate (PlayerPawn Sender)
{
	local PlayerPawn PP;
	local PlayerPawn NearestPP;
	local float DistToNearestPP;
	local float ThisPPDist;

	DistToNearestPP=0.00;
	foreach AllActors(Class'PlayerPawn',PP)
	{
		ThisPPDist=DistanceFrom(Sender,PP);
		if ( (PP != Sender) && (PP.PlayerReplicationInfo.Team == Sender.PlayerReplicationInfo.Team) && ((DistToNearestPP == 0) || (ThisPPDist < DistToNearestPP)) )
		{
			NearestPP=PP;
			DistToNearestPP=ThisPPDist;
		}
	}
	if ( NearestPP != None )
	{
		return NearestPP.PlayerReplicationInfo.PlayerName;
	} else {
		return "<NO TEAM MATES>";
	}
}

function int GetArmourAmount (Pawn P)
{
	local int ArmorAmount;
	local Inventory Inv;

	ArmorAmount=0;
	Inv=P.Inventory;
JL001B:
	if ( Inv != None )
	{
		if ( Inv.bIsAnArmor )
		{
			ArmorAmount += Inv.Charge;
		}
		Inv=Inv.Inventory;
		goto JL001B;
	}
	return ArmorAmount;
}

function string ProcessAdvancedSay (string Text, PlayerPawn Sender)
{
	local string TagName;
	local string FinalText;
	local string LocationStr;
	local string C;
	local bool StartTag;
	local int i;

	i=0;
JL0007:
	if ( i < Len(Text) )
	{
		C=Mid(Text,i,1);
		if ( C == "%" )
		{
			if ( StartTag )
			{
				if ( TagName ~= "LOCATION" )
				{
					if ( Sender.PlayerReplicationInfo.PlayerLocation != None )
					{
						LocationStr=Sender.PlayerReplicationInfo.PlayerLocation.LocationName;
					} else {
						if ( Sender.PlayerReplicationInfo.PlayerZone != None )
						{
							LocationStr=Sender.PlayerReplicationInfo.PlayerZone.ZoneName;
						} else {
							LocationStr="Near" @ NearestObj(Sender);
						}
					}
					if ( LocationStr == "" )
					{
						LocationStr="Near" @ NearestObj(Sender);
					}
					FinalText=FinalText $ LocationStr;
				} else {
					if ( TagName ~= "HEALTH" )
					{
						FinalText=FinalText $ string(Sender.Health);
					} else {
						if ( (TagName ~= "ARMOUR") || (TagName ~= "ARMOR") )
						{
							FinalText=FinalText $ string(GetArmourAmount(Sender));
						} else {
							if ( TagName ~= "WEAPON" )
							{
								if ( Sender.Weapon != None )
								{
									FinalText=FinalText $ Sender.Weapon.ItemName;
								}
							} else {
								if ( TagName ~= "AMMO" )
								{
									if ( (Sender.Weapon != None) && (Sender.Weapon.AmmoType != None) )
									{
										FinalText=FinalText $ string(Sender.Weapon.AmmoType.AmmoAmount);
									}
								} else {
									if ( TagName ~= "MYNAME" )
									{
										FinalText=FinalText $ Sender.PlayerReplicationInfo.PlayerName;
									} else {
										if ( TagName ~= "MYTEAM" )
										{
											FinalText=FinalText $ TeamColor[Sender.PlayerReplicationInfo.Team];
										} else {
											if ( TagName ~= "ENEMYTEAM" )
											{
												if ( Sender.PlayerReplicationInfo.Team == 0 )
												{
													FinalText=FinalText $ TeamColor[1];
												} else {
													FinalText=FinalText $ TeamColor[0];
												}
											} else {
												if ( TagName ~= "OBJECTIVE" )
												{
													FinalText=FinalText $ NearestObj(Sender);
												} else {
													if ( TagName ~= "NEARESTTEAMMATE" )
													{
														FinalText=FinalText $ NearestTeamMate(Sender);
													} else {
														FinalText=FinalText $ "%" $ TagName $ "%";
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				TagName="";
			}
			StartTag= !StartTag;
		} else {
			if ( StartTag )
			{
				TagName=TagName $ C;
			} else {
				FinalText=FinalText $ C;
			}
		}
		i++;
		goto JL0007;
	}
	if ( StartTag )
	{
		FinalText=FinalText $ "%" $ TagName;
	}
	return FinalText;
}

function PEFThrowArmour (int ArmourType, PlayerPawn Sender)
{
	local Vector X;
	local Vector Y;
	local Vector Z;
	local Inventory Inv;

	if ( (ArmourType < 1) || (ArmourType > 3) )
	{
		Inv=Sender.FindInventoryType(Class'ThighPads');
		if ( Inv == None )
		{
			Inv=Sender.FindInventoryType(Class'Armor2');
		}
		if ( Inv == None )
		{
			Inv=Sender.FindInventoryType(Class'UT_ShieldBelt');
		}
		if ( Inv != None )
		{
			Inv.Velocity=Sender.ViewRotation * 500 + vect(0.00,0.00,220.00);
			Inv.bTossedOut=True;
			GetAxes(Sender.Rotation,X,Y,Z);
			Inv.DropFrom(Sender.Location + 0.80 * Sender.CollisionRadius * X +  -0.50 * Sender.CollisionRadius * Y);
			if ( Inv.IsA('UT_ShieldBelt') )
			{
				UT_ShieldBelt(Inv).MyEffect.Destroy();
			}
		}
	} else {
		Inv=Sender.Inventory;
JL018D:
		if ( Inv != None )
		{
			if ( Inv.IsA('ThighPads') && (ArmourType == 1) || Inv.IsA('Armor2') && (ArmourType == 2) || Inv.IsA('UT_ShieldBelt') && (ArmourType == 3) )
			{
				Inv.Velocity=Sender.ViewRotation * 500 + vect(0.00,0.00,220.00);
				Inv.bTossedOut=True;
				GetAxes(Sender.Rotation,X,Y,Z);
				Inv.DropFrom(Sender.Location + 0.80 * Sender.CollisionRadius * X +  -0.50 * Sender.CollisionRadius * Y);
				if ( Inv.IsA('UT_ShieldBelt') )
				{
					UT_ShieldBelt(Inv).MyEffect.Destroy();
				}
			}
			Inv=Inv.Inventory;
			goto JL018D;
		}
	}
}

function PEFChangeTeams (PlayerPawn Sender)
{
	if (  !bMatchMode )
	{
		if ( (Sender.PlayerReplicationInfo.Team < MaxAllowedTeams) && (Level.TimeSeconds > TeamChangeTime) )
		{
			if ( Sender.PlayerReplicationInfo.Team == Attacker.TeamIndex )
			{
				Sender.ChangeTeam(Defender.TeamIndex);
			} else {
				Sender.ChangeTeam(Attacker.TeamIndex);
			}
			TeamChangeTime=Level.TimeSeconds + 2;
		}
	}
}

function PEFResetTeamNames ()
{
	TeamNameRed="Red";
	TeamNameBlue="Blue";
	TeamColor[0]="Red";
	TeamColor[1]="Blue";
	Teams[0].TeamName="Red";
	Teams[1].TeamName="Blue";
	BroadcastMessage("TEAM NAMES RESET!");
	SaveConfig();
}

function PEFTogglePracticeMode ()
{
	local Pawn P;

	bPracticeMode= !bPracticeMode;
	if ( bPracticeMode )
	{
		BroadcastMessage("PRACTICE MODE ENABLED!");
	} else {
		BroadcastMessage("PRACTICE MODE DISABLED!");
	}
	SaveConfig();
	if ( bPracticeMode )
	{
		P=Level.PawnList;
JL0078:
		if ( P != None )
		{
			if ( P.IsA('PlayerPawn') )
			{
				P.ReducedDamageType='All';
			}
			P=P.nextPawn;
			goto JL0078;
		}
	} else {
		P=Level.PawnList;
JL00D9:
		if ( P != None )
		{
			if ( P.IsA('PlayerPawn') )
			{
				P.ReducedDamageType='None';
			}
			P=P.nextPawn;
			goto JL00D9;
		}
	}
}

function PEFStartMatch (PlayerPawn Sender)
{
	local Mutator mut;
	local Actor A;

	if ( bMatchMode )
	{
		Sender.ClientMessage("Match in progress, please end current match before starting new one.");
		return;
	}
	if (  !bTournament )
	{
		Sender.ClientMessage("Tourent mode must be active to start a match!");
		return;
	}
	if ( bMapStarted )
	{
		Sender.ClientMessage("Cannot start a match after game has started!");
		return;
	}
	TeamColor[0]=TeamNameRed;
	TeamColor[1]=TeamNameBlue;
	Teams[0].TeamName=TeamNameRed;
	Teams[1].TeamName=TeamNameBlue;
	TeamChangeMessage="Match in progress. Team Changing Disabled!";
	LeagueASGameReplicationInfo.StartTimeRemaining=FirstMapStartTime;
	bMatchMode=True;
	LeagueASGameReplicationInfo.bMatchModeEnabled=True;
	BroadcastMessage("Starting Match Countdown...",True);
	TeamScore[0]=0;
	TeamScore[1]=0;
	MapsWon[0]="";
	MapsWon[1]="";
	PauseTimeRemaining[0]=MaxPauseTime;
	PauseTimeRemaining[1]=MaxPauseTime;
	PauseCountRemaining[0]=MaxPauseCount;
	PauseCountRemaining[1]=MaxPauseCount;
	if ( AutoPauser != None )
	{
		AutoPauser.PausePerMapCountRemaining[0]=0;
		AutoPauser.PausePerMapCountRemaining[1]=0;
	}
	SetScoreStrings(TeamColor[0] @ "0 - 0" @ TeamColor[1]);
	MapsLeft=MatchLength + 1;
	bPracticeMode=False;
	RemainingTime=120;
	SavedTime=120.00;
	bDefenseSet=True;
	recallmutatorlist="";
	brecovering=False;
	foreach AllActors(Class'Mutator',mut)
	{
		if (  !mut.IsA('LeagueAS_AuthAbstract') &&  !mut.IsA('LeagueAS_Mutator') &&  !mut.IsA('HackProtection') )
		{
			recallmutatorlist=recallmutatorlist $ string(mut.Class) $ ",";
		}
	}
	if ( bcrashrecovery )
	{
		Log("recallmutators is:" @ recallmutatorlist);
	}
	recallmap=Left(string(self),InStr(string(self),"."));
	if ( bcrashrecovery )
	{
		Log("recallmap is:" @ recallmap);
	}
	bCleanShutdown=False;
	SaveConfig();
	foreach AllActors(Class'Actor',A)
	{
		if ( string(A.Class) ~= "LeagueAS-Reporter.UTReporterController" )
		{
			Log("Sending new matchstart to UTReporter...",'LeagueAssault');
			A.GetItemName(":MATCHSTART:");
		}
	}
	if ( AuthModule != None )
	{
		AuthModule.EventMatchStart();
	}
}

function PEFEndMatch ()
{
	local Pawn P;

	BroadcastMessage("Match will terminate after current map is complete!",True);
	MapsLeft=1;
	P=Level.PawnList;
JL0057:
	if ( P != None )
	{
		if ( P.IsA('TournamentPlayer') )
		{
			return;
		}
		P=P.nextPawn;
		goto JL0057;
	}
	BroadcastMessage("Server is empty. Finishing match now.",True);
	bDefenseSet=True;
	bAssaultWon=False;
	bTiePartOne=True;
	EndGame("Server Empty");
}

function PEFSetTeamScore (PlayerPawn Sender, int TeamNum, int Score)
{
	TeamScore[TeamNum]=Score;
	MapsLeft=MatchLength - TeamScore[0] - TeamScore[1];
	SaveConfig();
	Sender.ClientMessage("Score Set!");
	PEFShowScores(Sender);
}

function PEFShowScores (PlayerPawn Sender)
{
	Sender.ClientMessage(TeamColor[0] @ " -" @ string(TeamScore[0]));
	Sender.ClientMessage(TeamColor[1] @ " -" @ string(TeamScore[1]));
	if ( MapsLeft == 0 )
	{
		Sender.ClientMessage("THE MATCH HAS ENDED!");
	} else {
		if ( MapsLeft == 1 )
		{
			Sender.ClientMessage("1 MAP REMAINING...");
		} else {
			Sender.ClientMessage(string(MapsLeft) @ "MAPS REMAINING...");
		}
	}
}

function PEFForceMatchStart ()
{
	local PlayerPawn PP;

	if ( bRequireReady && (CountDown > 0) && (LeagueASGameReplicationInfo.StartTimeRemaining > 0) )
	{
		bNetReady=False;
		bRequireReady=False;
		StartMatch();
		return;
	}
	if (  !bMatchMode && bRequireReady )
	{
		CountDown=0;
		foreach AllActors(Class'PlayerPawn',PP)
		{
			PP.bReadyToPlay=True;
			PP.ClientMessage("Admin has forced a game start!");
		}
		bNetReady=False;
		bRequireReady=False;
		StartMatch();
	}
}

event PreLogin (string Options, string Address, out string Error, out string FailCode)
{
	local string InPassword;
	local string OvClass;
	local string PName;
	local string pktls;
	local string pktlg;
	local string S;
	local string t;
	local int i;
	local bool Found;
	local bool bnopass;
	local string GmPassword;
	local string AdPassword;
	local string oldfail;

	bnopass=False;
	oldfail=FailCode;
	Error="";
	Super.PreLogin("","NoPassword:test",Error,FailCode);
	if ( Error == "" )
	{
		bnopass=True;
	}
	Error="";
	FailCode=oldfail;
	Super.PreLogin(Options,Address,Error,FailCode);
	InPassword=ParseOption(Options,"Password");
	OvClass=ParseOption(Options,"OverrideClass");
	Found=False;
	if ( bnopass && (AntiBanPasswords != "") )
	{
		if (  !CheckIPPolicy(Address) )
		{
			if ( InPassword == "" )
			{
				Error="Your IP has been banned from server. Request antibanpassword.";
				FailCode="WRONGPW";
			} else {
				S=AntiBanPasswords;
				i=InStr(S,"/");
JL0167:
				if ( i != -1 )
				{
					t=Left(S,i);
					S=Mid(S,i + 1);
					if ( t ~= InPassword )
					{
						Found=True;
					} else {
						i=InStr(S,"/");
						goto JL0167;
					}
				}
				if ( S ~= InPassword )
				{
					Found=True;
				}
				if ( Found )
				{
					Log("AntiBanPW used: " @ InPassword @ "by" @ Address);
					Error="";
					FailCode=oldfail;
				} else {
					Error="Your IP has been banned from server. Request antibanpassword.";
					FailCode="WRONGPW";
				}
			}
		}
	} else {
		if (  !CheckIPPolicy(Address) )
		{
			Error=IPBanned;
		}
	}
	if ( bMatchMode && (MatchPasswordRed != "") && (MatchPasswordBlue != "") )
	{
		if ( Caps(InPassword) == Caps(MatchPasswordRed) )
		{
			if ( Teams[0].Size < MaxPlayers / 2 )
			{
				Error="";
				FailCode="";
			} else {
				Error=MaxedOutMessage;
				FailCode="TEAMFULL";
			}
		} else {
			if ( Caps(InPassword) == Caps(MatchPasswordBlue) )
			{
				if ( Teams[1].Size < MaxPlayers / 2 )
				{
					Error="";
					FailCode="";
				} else {
					Error=MaxedOutMessage;
					FailCode="TEAMFULL";
				}
			}
		}
	} else {
		if ( (ModeratorPassword != "") && (Caps(InPassword) == Caps(ModeratorPassword)) )
		{
			Error="";
			FailCode="";
		}
	}
	if ( (Caps(OvClass) == "BOTPACK.CHSPECTATOR") && bMatchMode && (MatchPasswordSpec != "") )
	{
		if ( Caps(InPassword) == Caps(MatchPasswordSpec) )
		{
			Error="";
			FailCode="";
		} else {
			Error=WrongPassword;
			FailCode="WRONGPW";
		}
	}
	if (  !Found && ( !bMatchMode || Class'HackProtection'.Default.bMMBan) )
	{
		if (  !CheckIPPolicy(Address) )
		{
			Error=IPBanned;
		}
	}
	if (  !bMatchMode &&  !bPracticeMode && bPreventMapChangeKick && (Level.NetMode == 1) )
	{
		if ( Level.TimeSeconds < PreventMapChangeKickTime )
		{
			if ( (Caps(OvClass) == "BOTPACK.CHSPECTATOR") && (SavedSpecCount > 0) )
			{
				if (  !isIPInSpecList(IPOnly(Address)) )
				{
					if ( FreeSpecSlots > 0 )
					{
						FreeSpecSlots--;
					} else {
						Error="PreventMapChangeKick";
						FailCode="PreventMapChangeKick";
					}
				}
			}
			if (  !(Caps(OvClass) == "BOTPACK.CHSPECTATOR") && (SavedPlayerCount > 0) )
			{
				if (  !isIPInPlayerList(IPOnly(Address)) )
				{
					if ( FreePlayerSlots > 0 )
					{
						FreePlayerSlots--;
					} else {
						Error="PreventMapChangeKick";
						FailCode="PreventMapChangeKick";
					}
				}
			}
		}
	}
	pktls=ParseOption(Options,"pktloss");
	pktlg=ParseOption(Options,"pktlag");
	if ( (pktls != "") && (pktls != "0") || (pktlg != "") && (pktlg != "0") )
	{
		PName=ParseOption(Options,"name");
		CSHP.xxILog("Simulated LAG detected - PktLag/PktLoss:" @ pktlg @ "/" @ pktls @ " - Player/IP:" @ PName @ "/" @ Address,1);
	}
}

function bool isIPInSpecList (string IP)
{
	local int i;

	i=0;
JL0007:
	if ( i < SavedSpecCount )
	{
		if ( SavedSpecIPs[i] ~= IP )
		{
			return True;
		}
		i++;
		goto JL0007;
	}
	return False;
}

function bool isIPInPlayerList (string IP)
{
	local int i;

	i=0;
JL0007:
	if ( i < SavedPlayerCount )
	{
		if ( SavedPlayerIPs[i] ~= IP )
		{
			return True;
		}
		i++;
		goto JL0007;
	}
	return False;
}

function string IPOnly (string IP)
{
	local int i;

	i=InStr(IP,":");
	if ( i != -1 )
	{
		return Left(IP,i);
	} else {
		return IP;
	}
}

event PlayerPawn Login (string Portal, string Options, out string Error, Class<PlayerPawn> SpawnClass)
{
	local PlayerPawn NewPlayer;
	local string InPassword;
	local string ModOptions;
	local string Pair;
	local string Key;
	local string Value;
	local int NewTeam;
	local LeagueAS_CustomReplicationInfo cRI;

	if ( ClassIsChildOf(SpawnClass,Class'Commander') )
	{
		return None;
	}
	InPassword=ParseOption(Options,"Password");
	ModOptions="";
	if ( bMatchMode && (MatchPasswordRed != "") && (MatchPasswordBlue != "") )
	{
		if ( (Caps(InPassword) == Caps(MatchPasswordRed)) && (Teams[0].Size >= MaxPlayers / 2) || (Caps(InPassword) == Caps(MatchPasswordBlue)) && (Teams[1].Size >= MaxPlayers / 2) )
		{
			Error=MaxedOutMessage;
			return None;
		}
	}
	if ( bMatchMode && (MatchPasswordRed != "") && (MatchPasswordBlue != "") &&  !ClassIsChildOf(SpawnClass,Class'Spectator') )
	{
		if ( Caps(InPassword) == Caps(MatchPasswordRed) )
		{
JL011B:
			if ( GrabOption(Options,Pair) )
			{
				GetKeyValue(Pair,Key,Value);
				if ( Key ~= "Team" )
				{
					ModOptions=ModOptions $ "?Team=0";
				} else {
					ModOptions=ModOptions $ "?" $ Pair;
				}
				goto JL011B;
			}
		} else {
			if ( Caps(InPassword) == Caps(MatchPasswordBlue) )
			{
JL019C:
				if ( GrabOption(Options,Pair) )
				{
					GetKeyValue(Pair,Key,Value);
					if ( Key ~= "Team" )
					{
						ModOptions=ModOptions $ "?Team=1";
					} else {
						ModOptions=ModOptions $ "?" $ Pair;
					}
					goto JL019C;
				}
			} else {
				ModOptions=Options;
			}
		}
	} else {
		ModOptions=Options;
	}
	Options=ModOptions;
	ModOptions="";
	if (  !bMatchMode &&  !bPracticeMode && bPlayersBalanceTeams && bImprovedTeamBalance )
	{
		if (  !bDefenseSet || (Level.TimeSeconds > TeamBalanceDelayTime) )
		{
			if ( (Attacker != None) && (Defender != None) )
			{
				if ( Defender.Size >= Attacker.Size )
				{
					NewTeam=Attacker.TeamIndex;
				} else {
					NewTeam=Defender.TeamIndex;
				}
JL02EE:
				if ( GrabOption(Options,Pair) )
				{
					GetKeyValue(Pair,Key,Value);
					if ( Key ~= "Team" )
					{
						ModOptions=ModOptions $ "?Team=" $ string(NewTeam);
					} else {
						ModOptions=ModOptions $ "?" $ Pair;
					}
					goto JL02EE;
				}
			}
		}
	}
	if ( ModOptions == "" )
	{
		ModOptions=Options;
	}
	Log("Modified Options - " $ ModOptions,'LeagueAssault');
	if ( ClassIsChildOf(SpawnClass,Class'TournamentPlayer') )
	{
		SpawnClass.Default.PlayerReplicationInfoClass=Class'LeagueAS_ExtPlayerReplicationInfo';
	}
	NewPlayer=Super.Login(Portal,ModOptions,Error,SpawnClass);
	if ( ClassIsChildOf(SpawnClass,Class'TournamentPlayer') )
	{
		SpawnClass.Default.PlayerReplicationInfoClass=Class'PlayerReplicationInfo';
	}
	if ( NewPlayer != None )
	{
		if ( NewPlayer.PlayerReplicationInfo.IsA('LeagueAS_ExtPlayerReplicationInfo') )
		{
			LeagueAS_ExtPlayerReplicationInfo(NewPlayer.PlayerReplicationInfo).bIsABot=False;
		}
		if ( NewPlayer.IsA('TournamentPlayer') )
		{
			cRI=Spawn(Class'LeagueAS_CustomReplicationInfo',NewPlayer,,NewPlayer.Location);
			LeagueAS_ExtPlayerReplicationInfo(NewPlayer.PlayerReplicationInfo).cRI=cRI;
		}
		if ( bPracticeMode )
		{
			NewPlayer.ReducedDamageType='All';
		}
		if ( (AuthModule != None) && NewPlayer.IsA('TournamentPlayer') )
		{
			AuthModule.PlayerJoined(NewPlayer);
		}
		if ( bMatchMode )
		{
			NewPlayer.bAdmin=False;
		} else {
			if ( (ModeratorPassword != "") && (Caps(InPassword) == Caps(ModeratorPassword)) )
			{
				AddModerator(NewPlayer,InPassword);
			}
		}
	}
	return NewPlayer;
}

event PostLogin (PlayerPawn NewPlayer)
{
	Super.PostLogin(NewPlayer);
	NewPlayer.PlayerReplicationInfo.bAdmin=NewPlayer.bAdmin;
	if ( NewPlayer.IsA('Spectator') )
	{
		Log("****************Spectator Joined*****************",'LeagueAssault');
	} else {
		Log("******************Player Joined******************",'LeagueAssault');
	}
	Log("Player name :" @ NewPlayer.PlayerReplicationInfo.PlayerName,'LeagueAssault');
	Log("IP Address  :" @ NewPlayer.GetPlayerNetworkAddress(),'LeagueAssault');
	Log("*************************************************",'LeagueAssault');
	NewPlayer.ClientMessage("*********************************************************");
	NewPlayer.ClientMessage(GameName @ "(Version" @ VersionStr $ SubVersionStr $ ")");
	NewPlayer.ClientMessage("Incorporating" @ CSHP.VersionStr);
	NewPlayer.ClientMessage("Website: http://www.utassault.net/leagueas");
	NewPlayer.ClientMessage("**********************************************************");
	NewPlayer.ClientMessage("Standard League Assault Commands:");
	NewPlayer.ClientMessage("ChangeTeams: switch teams.");
	NewPlayer.ClientMessage("ToggleMute: Mute messages.");
	NewPlayer.ClientMessage("ShowMatchScore: View the score during a match.");
	NewPlayer.ClientMessage("ToggleExtendedHUD: Enable/disable the extended HUD.");
	NewPlayer.ClientMessage("**********************************************************");
	NewPlayer.ClientMessage("For a complete list of commands and features visit the website!");
	NewPlayer.ClientMessage("**********************************************************");
	NewPlayer.ClientMessage(" ");
	NewPlayer.ClientMessage(" ");
	NewPlayer.ClientMessage(" ");
	NewPlayer.ClientMessage(" ");
	if ( NewPlayer.IsA('TournamentPlayer') )
	{
		LeagueAS_ExtPlayerReplicationInfo(NewPlayer.PlayerReplicationInfo).LoadOptionsFromFile();
	}
}

function bool AddBot ()
{
	local Bot NewBot;
	local NavigationPoint StartSpot;
	local NavigationPoint OldStartSpot;
	local int DesiredTeam;
	local int i;
	local int MinSize;

	Class'Bot'.Default.PlayerReplicationInfoClass=Class'LeagueAS_ExtPlayerReplicationInfo';
	NewBot=SpawnBot(StartSpot);
	Class'Bot'.Default.PlayerReplicationInfoClass=Class'BotReplicationInfo';
	if ( NewBot == None )
	{
		Log("Failed to spawn bot");
		return False;
	}
	if ( bBalanceTeams &&  !bRatedGame )
	{
		MinSize=Teams[0].Size;
		DesiredTeam=0;
		i=1;
JL0097:
		if ( i < MaxTeams )
		{
			if ( Teams[i].Size < MinSize )
			{
				MinSize=Teams[i].Size;
				DesiredTeam=i;
			}
			i++;
			goto JL0097;
		}
	} else {
		DesiredTeam=NewBot.PlayerReplicationInfo.Team;
	}
	NewBot.PlayerReplicationInfo.Team=255;
	if ( (DesiredTeam == 255) ||  !ChangeTeam(NewBot,DesiredTeam) )
	{
		ChangeTeam(NewBot,NextBotTeam);
		NextBotTeam++;
		if ( NextBotTeam >= MaxTeams )
		{
			NextBotTeam=0;
		}
	}
	if ( bSpawnInTeamArea )
	{
		OldStartSpot=StartSpot;
		StartSpot=FindPlayerStart(NewBot,255);
		if ( StartSpot != None )
		{
			NewBot.SetLocation(StartSpot.Location);
			NewBot.SetRotation(StartSpot.Rotation);
			NewBot.ViewRotation=StartSpot.Rotation;
			NewBot.SetRotation(NewBot.Rotation);
			StartSpot.PlayTeleportEffect(NewBot,True);
		} else {
			StartSpot=OldStartSpot;
		}
	}
	StartSpot.PlayTeleportEffect(NewBot,True);
	SetBotOrders(NewBot);
	if ( LocalLog != None )
	{
		LocalLog.LogPlayerConnect(NewBot);
		LocalLog.FlushLog();
	}
	if ( WorldLog != None )
	{
		WorldLog.LogPlayerConnect(NewBot);
		WorldLog.FlushLog();
	}
	return True;
}

function Logout (Pawn Exiting)
{
	local LeagueAS_CustomReplicationInfo cRI;
	local LeagueAS_Inventory Inv;

	Super.Logout(Exiting);
	if ( Exiting.IsA('TournamentPlayer') )
	{
		if ( AuthModule != None )
		{
			AuthModule.PlayerLeft(PlayerPawn(Exiting));
		}
		RemoveModerator(PlayerPawn(Exiting));
	}
	foreach AllActors(Class'LeagueAS_CustomReplicationInfo',cRI)
	{
		if ( Exiting == cRI.Owner )
		{
			cRI.Destroy();
		}
	}
	foreach AllActors(Class'LeagueAS_Inventory',Inv)
	{
		if (  !Inv.bDeleteMe )
		{
			Inv.PlayerLeft();
		}
	}
}

function NavigationPoint FindSpawnPoint (Pawn Player, optional byte InTeam, optional string incomingName)
{
	local PlayerStart Dest;
	local PlayerStart Candidate[16];
	local PlayerStart Best;
	local float Score[16];
	local float BestScore;
	local float NextDist;
	local Pawn OtherPlayer;
	local int i;
	local int Num;
	local Teleporter Tel;
	local NavigationPoint N;
	local byte Team;

	if ( bStartMatch && (Player != None) && Player.IsA('TournamentPlayer') && (Level.NetMode == 0) && (TournamentPlayer(Player).StartSpot != None) )
	{
		return TournamentPlayer(Player).StartSpot;
	}
	if ( (Player != None) && (Player.PlayerReplicationInfo != None) )
	{
		Team=Player.PlayerReplicationInfo.Team;
	} else {
		Team=InTeam;
	}
	if ( incomingName != "" )
	{
		foreach AllActors(Class'Teleporter',Tel)
		{
			if ( string(Tel.Tag) ~= incomingName )
			{
				return Tel;
			}
		}
	}
	if ( Team == 255 )
	{
		Team=0;
	}
	N=Level.NavigationPointList;
JL0127:
	if ( N != None )
	{
		Dest=PlayerStart(N);
		if ( (Dest != None) && Dest.bEnabled && ( !bSpawnInTeamArea || (Team == Dest.TeamNumber)) )
		{
			if ( Num < 16 )
			{
				Candidate[Num]=Dest;
			} else {
				if ( Rand(Num) < 16 )
				{
					Candidate[Rand(16)]=Dest;
				}
			}
			Num++;
		}
		N=N.nextNavigationPoint;
		goto JL0127;
	}
	if ( Num == 0 )
	{
		Log("Didn't find any player starts in list for team" @ string(Team) @ "!!!");
		foreach AllActors(Class'PlayerStart',Dest)
		{
			if ( Num < 16 )
			{
				Candidate[Num]=Dest;
			} else {
				if ( Rand(Num) < 16 )
				{
					Candidate[Rand(16)]=Dest;
				}
			}
			Num++;
		}
		if ( Num == 0 )
		{
			return None;
		}
	}
	if ( Num > 16 )
	{
		Num=16;
	}
	i=0;
JL02B1:
	if ( i < Num )
	{
		if ( Candidate[i] == LastStartSpot )
		{
			Score[i]=-6000.00;
		} else {
			Score[i]=4000.00 * FRand();
		}
		i++;
		goto JL02B1;
	}
	OtherPlayer=Level.PawnList;
JL031C:
	if ( OtherPlayer != None )
	{
		if ( OtherPlayer.bIsPlayer && (OtherPlayer.Health > 0) &&  !OtherPlayer.IsA('Spectator') )
		{
			i=0;
JL036E:
			if ( i < Num )
			{
				if ( OtherPlayer.Region.Zone == Candidate[i].Region.Zone )
				{
					NextDist=VSize(OtherPlayer.Location - Candidate[i].Location);
					if ( NextDist < Candidate[i].CollisionRadius + Candidate[i].CollisionHeight )
					{
						Score[i] -= 1000000.00;
					}
				}
				i++;
				goto JL036E;
			}
		}
		OtherPlayer=OtherPlayer.nextPawn;
		goto JL031C;
	}
	BestScore=Score[0];
	Best=Candidate[0];
	i=1;
JL0462:
	if ( i < Num )
	{
		if ( Score[i] > BestScore )
		{
			BestScore=Score[i];
			Best=Candidate[i];
		}
		i++;
		goto JL0462;
	}
	LastStartSpot=Best;
	return Best;
}

function NavigationPoint FindPlayerStart (Pawn Player, optional byte InTeam, optional string incomingName)
{
	local Pawn P;
	local int i;
	local int D;
	local byte Team;

	if ( (Player != None) && (Player.PlayerReplicationInfo != None) )
	{
		Team=Player.PlayerReplicationInfo.Team;
	} else {
		Team=InTeam;
	}
	if ( Team != 255 )
	{
		if ( Team > 1 )
		{
			Team=0;
		}
		if ( Defender == None )
		{
			Log("Setting up Teams...",'LeagueAssault');
			D=CurrentDefender;
			if ( (D != 0) && (D != 1) )
			{
				D=0;
			}
			Log("Team " $ string(D) $ " is defending.",'LeagueAssault');
			Defender=Teams[D];
			if ( D == 0 )
			{
				Log("Team 1 is attacking.",'LeagueAssault');
				Attacker=Teams[1];
			} else {
				Log("Team 0 is attacking.",'LeagueAssault');
				Attacker=Teams[0];
			}
			P=Level.PawnList;
JL016D:
			if ( P != None )
			{
				if ( P.IsA('StationaryPawn') )
				{
					StationaryPawn(P).SetTeam(Defender.TeamIndex);
				}
				P=P.nextPawn;
				goto JL016D;
			}
			if ( WorldLog != None )
			{
				WorldLog.LogSpecialEvent("assault_defender",string(Defender.TeamIndex));
				WorldLog.LogSpecialEvent("assault_attacker",string(Attacker.TeamIndex));
			}
			if ( LocalLog != None )
			{
				LocalLog.LogSpecialEvent("assault_defender",string(Defender.TeamIndex));
				LocalLog.LogSpecialEvent("assault_attacker",string(Attacker.TeamIndex));
			}
		}
		if ( Teams[Team] == Defender )
		{
			Team=0;
		} else {
			Team=1;
		}
	}
	return FindSpawnPoint(None,Team,incomingName);
}

function RestartGame ()
{
	local int i;

	if ( bDontRestart )
	{
		return;
	}
	if (  !bGameEnded || (EndTime > Level.TimeSeconds) )
	{
		return;
	}
	if ( bDefenseSet )
	{
		Log("Map Change Initiated...",'LeagueAssault');
		if ( bAttackOnly )
		{
			Log("ATTACK ONLY MODE! Defending team remains the same.",'LeagueAssault');
			CurrentDefender=Defender.TeamIndex;
		} else {
			if ( GetWinningTeam() != -1 )
			{
				Log("Team " $ string(GetWinningTeam()) $ " won the round.",'LeagueAssault');
				if ( GetWinningTeam() == 1 )
				{
					CurrentDefender=0;
				} else {
					CurrentDefender=1;
				}
				Log("Setting Team " $ string(CurrentDefender) $ " as the defending team for the next map.",'LeagueAssault');
			} else {
				CurrentDefender=0;
			}
		}
		SaveConfig();
		Default.bDefenseSet=False;
		Default.Part=1;
		Default.SavedTime=0.00;
		Default.NumDefenses=0;
		Default.GameCode="";
		Default.bTiePartOne=False;
		Default.CurrentDefender=CurrentDefender;
		StaticSaveConfig();
		Super(DeathMatchPlus).RestartGame();
	} else {
		bDontRestart=True;
		if ( Defender.TeamIndex == 1 )
		{
			CurrentDefender=0;
		} else {
			CurrentDefender=1;
		}
		bDefenseSet=True;
		Part=2;
		SavedTime=TimeLimit * 60 - RemainingTime;
		SaveConfig();
		Level.ServerTravel("?Restart",False);
	}
}

function RemoveFort (FortStandard F, Pawn Instigator)
{
	local int i;
	local Pawn P;
	local string Str;

	if (  !bMapEnded )
	{
		if ( (Instigator != None) && Instigator.IsA('Pawn') && (Instigator.PlayerReplicationInfo != None) )
		{
			Str=Instigator.PlayerReplicationInfo.PlayerName;
		} else {
			Str="N/A";
		}
		i=0;
JL0074:
		if ( i < 19 )
		{
			if ( LeagueASGameReplicationInfo != None )
			{
				if ( (LeagueASGameReplicationInfo.FortName[i] == F.FortName) || (LeagueASGameReplicationInfo.FortName[i] == string(F)) )
				{
					LeagueASGameReplicationInfo.FortCompleted[i]="Completed! - by" @ Str;
				}
			}
			i++;
			goto JL0074;
		}
		Super.RemoveFort(F,Instigator);
		P=Level.PawnList;
JL012E:
		if ( P != None )
		{
			if ( P.IsA('MessagingSpectator') )
			{
				P.ClientMessage("Completed by" @ Str,'CriticalEvent');
			}
			P=P.nextPawn;
			goto JL012E;
		}
	}
}

function AddDefaultInventory (Pawn PlayerPawn)
{
	local Inventory i;
	local enforcer SecondEnforcer;

	i=PlayerPawn.FindInventoryType(Class'LeagueAS_Inventory');
	if ( i == None )
	{
		i=Spawn(Class'LeagueAS_Inventory',PlayerPawn);
	} else {
		i.Destroy();
		i=Spawn(Class'LeagueAS_Inventory',PlayerPawn);
	}
	if ( i != None )
	{
		i.bHeldItem=True;
		i.GiveTo(PlayerPawn);
		if (  !PlayerPawn.PlayerReplicationInfo.bWaitingPlayer || PlayerPawn.PlayerReplicationInfo.bIsSpectator )
		{
			LeagueAS_Inventory(i).ActivateSpawnProtection();
		}
	}
	if (  !PlayerPawn.IsA('Spectator') &&  !bRequireReady && (CountDown > 0) )
	{
		Super(GameInfo).AddDefaultInventory(PlayerPawn);
		GiveWeapon(PlayerPawn,"BotPack.Enforcer");
		i=PlayerPawn.FindInventoryType(Class'enforcer');
		if ( i != None )
		{
			enforcer(i).AmmoType.UseAmmo(28);
		}
		SecondEnforcer=Spawn(Class'enforcer',PlayerPawn);
		if ( SecondEnforcer != None )
		{
			PlayerPawn.Inventory.HandlePickupQuery(SecondEnforcer);
			SecondEnforcer.Destroy();
		}
	}
}

function bool SetEndCams (string Reason)
{
	local int WinningTeam;
	local Pawn P;

	Super.SetEndCams(Reason);
	P=Level.PawnList;
JL001F:
	if ( P != None )
	{
		if ( CSHP.zzPtool != None )
		{
			CSHP.zzPtool.EndgameProbe(PlayerPawn(P));
		}
		P=P.nextPawn;
		goto JL001F;
	}
	if ( bDefenseSet && bMatchMode )
	{
		if (  !MapsLeft > MatchLength )
		{
			WinningTeam=GetWinningTeam();
			if ( WinningTeam != -1 )
			{
				TeamScore[WinningTeam]++;
				if ( MapsWon[WinningTeam] == "" )
				{
					MapsWon[WinningTeam]=Left(string(self),InStr(string(self),"."));
				} else {
					MapsWon[WinningTeam]=MapsWon[WinningTeam] $ "," @ Left(string(self),InStr(string(self),"."));
				}
			}
		}
		MapsLeft--;
		if ( (TeamScore[0] > TeamScore[1] + MapsLeft) || (TeamScore[1] > TeamScore[0] + MapsLeft) )
		{
			MapsLeft=0;
		}
		SetScoreStrings(TeamColor[0] @ string(TeamScore[0]) @ "-" @ string(TeamScore[1]) @ TeamColor[1]);
		LeagueASGameReplicationInfo.GameEndedComments=LeagueASGameReplicationInfo.GameEndedComments @ LeagueASGameReplicationInfo.MatchScore;
		P=Level.PawnList;
JL01CD:
		if ( P != None )
		{
			if ( P.IsA('PlayerPawn') )
			{
				P.ClientGameEnded();
				P.GotoState('GameEnded');
			}
			P=P.nextPawn;
			goto JL01CD;
		}
		if ( MapsLeft == 0 )
		{
			bDontRestart=True;
			bMatchMode=False;
			bTournament=False;
			LeagueASGameReplicationInfo.bMatchModeEnabled=False;
			if ( Len(Matchlog) > 128 )
			{
				Matchlog="";
			}
			Matchlog=Matchlog $ ";" @ LeagueASGameReplicationInfo.MatchScore;
		}
	}
	SaveConfig();
	bMapEnded=True;
	return True;
}

function StartMatch ()
{
	local Pawn P;
	local int i;
	local Mutator mut;
	local LeagueAS_ExtPlayerReplicationInfo epri;

	Super.StartMatch();
	bMapStarted=True;
	LeagueASGameReplicationInfo.StartTimeRemaining=-1;
	if ( bMatchMode )
	{
		P=Level.PawnList;
JL003F:
		if ( P != None )
		{
			if ( P.IsA('PlayerPawn') )
			{
				PlayerPawn(P).bAdmin=False;
				PlayerPawn(P).PlayerReplicationInfo.bAdmin=False;
				P.ReducedDamageType='None';
			}
			P=P.nextPawn;
			goto JL003F;
		}
		i=0;
JL00C5:
		if ( i < 12 )
		{
			ModList[i]=None;
			i++;
			goto JL00C5;
		}
	}
	if ( bPracticeMode )
	{
		BroadcastMessage("SERVER IS IN PRACTICE MODE");
		P=Level.PawnList;
JL0127:
		if ( P != None )
		{
			if ( P.IsA('PlayerPawn') )
			{
				P.ReducedDamageType='All';
			}
			P=P.nextPawn;
			goto JL0127;
		}
	}
	foreach AllActors(Class'LeagueAS_ExtPlayerReplicationInfo',epri)
	{
		epri.NotifyStartMap();
	}
}

function SendCountDownMessage (int Num)
{
	local Pawn P;

	P=Level.PawnList;
JL0014:
	if ( P != None )
	{
		if ( P.IsA('PlayerPawn') )
		{
			PlayerPawn(P).ReceiveLocalizedMessage(Class'LeagueAS_TimeMessage',Num);
		}
		P=P.nextPawn;
		goto JL0014;
	}
}

event Timer ()
{
	local Pawn P;
	local PlayerPawn PP;
	local bool bReady;
	local Inventory Inv;
	local LeagueAS_ExtPlayerReplicationInfo epri;
	local FortStandard F;
	local FortStandard NearestFort;
	local float DistToNearestFort;
	local float ThisFortDist;
	local Pawn ePRIOwner;
	local CSHPCheatRI cRI;
	local int i;

	Super.Timer();
	if (  !bMatchMode )
	{
		if (  !bTournament &&  !bMapStarted )
		{
			LeagueASGameReplicationInfo.StartTimeRemaining=NetWait - ElapsedTime;
			if ( LeagueASGameReplicationInfo.StartTimeRemaining < -1 )
			{
				LeagueASGameReplicationInfo.StartTimeRemaining=-1;
			}
		} else {
			LeagueASGameReplicationInfo.StartTimeRemaining=-1;
		}
	} else {
		if ( LeagueASGameReplicationInfo.StartTimeRemaining >= 0 )
		{
			LeagueASGameReplicationInfo.StartTimeRemaining--;
			if (  !bRequireReady )
			{
				LeagueASGameReplicationInfo.StartTimeRemaining=-1;
				bMatchMode=False;
				LeagueASGameReplicationInfo.bMatchModeEnabled=False;
			}
			if ( LeagueASGameReplicationInfo.StartTimeRemaining == 300 )
			{
				SendCountDownMessage(0);
			}
			if ( LeagueASGameReplicationInfo.StartTimeRemaining == 180 )
			{
				SendCountDownMessage(2);
			}
			if ( LeagueASGameReplicationInfo.StartTimeRemaining == 60 )
			{
				SendCountDownMessage(4);
			}
			if ( LeagueASGameReplicationInfo.StartTimeRemaining == 30 )
			{
				SendCountDownMessage(5);
			}
			if ( (LeagueASGameReplicationInfo.StartTimeRemaining < 11) && (LeagueASGameReplicationInfo.StartTimeRemaining > 0) )
			{
				bReady=True;
				P=Level.PawnList;
JL01A3:
				if ( P != None )
				{
					if ( P.IsA('PlayerPawn') &&  !P.IsA('Spectator') &&  !PlayerPawn(P).bReadyToPlay )
					{
						bReady=False;
					}
					P=P.nextPawn;
					goto JL01A3;
				}
				if ( NumPlayers < MaxPlayers )
				{
					bReady=False;
				}
				if (  !bReady )
				{
					CountDown=LeagueASGameReplicationInfo.StartTimeRemaining;
					SendCountDownMessage(16 - LeagueASGameReplicationInfo.StartTimeRemaining);
				}
			}
			if ( LeagueASGameReplicationInfo.StartTimeRemaining == 0 )
			{
				if (  !bGameEnded && bMatchMode && bRequireReady )
				{
					foreach AllActors(Class'PlayerPawn',PP)
					{
						PP.bReadyToPlay=True;
					}
					bNetReady=False;
					bRequireReady=False;
					StartMatch();
				}
				LeagueASGameReplicationInfo.StartTimeRemaining=-1;
			}
		}
	}
	if ( (CSHP != None) && ((CSHP.bAdminWarn == 1) && bMatchMode || (CSHP.bAdminWarn == 2)) && (Level.NetMode != 0) )
	{
		foreach AllActors(Class'PlayerPawn',PP)
		{
			if ( PP.bAdmin )
			{
				BroadcastMessage("WARNING:" @ PP.PlayerReplicationInfo.PlayerName @ "is logged in as Administrator.",True,'CriticalEvent');
			}
			if ( IsAModerator(PP) )
			{
				BroadcastMessage("WARNING:" @ PP.PlayerReplicationInfo.PlayerName @ "is logged in as Moderator.",True,'CriticalEvent');
			}
			if ( PP.ReducedDamageType != 'None' )
			{
				BroadcastMessage("WARNING:" @ PP.PlayerReplicationInfo.PlayerName @ "has God Mode enabled.",True,'CriticalEvent');
			}
		}
	}
	foreach AllActors(Class'LeagueAS_ExtPlayerReplicationInfo',epri)
	{
		ePRIOwner=Pawn(epri.Owner);
		if ( ePRIOwner != None )
		{
			epri.bMuteSay=epri.bMyMuteSay;
			epri.bMuteAll=epri.bMyMuteAll;
			foreach AllActors(Class'CSHPCheatRI',cRI)
			{
				if ( ePRIOwner == cRI.Owner )
				{
					goto JL050E;
				}
JL050E:
			}
			if ( (cRI != None) && (ePRIOwner == cRI.Owner) )
			{
				epri.NetSpeed=cRI.zzMyNetSpeed;
			}
			if ( ePRIOwner.IsA('PlayerPawn') )
			{
				epri.bModerator=IsAModerator(PlayerPawn(ePRIOwner));
			} else {
				epri.bModerator=False;
			}
			epri.bReadyToPlay=bTournament &&  !bMapStarted && ePRIOwner.IsA('PlayerPawn') && PlayerPawn(ePRIOwner).bReadyToPlay;
			epri.Armour=GetArmourAmount(ePRIOwner);
			if ( ePRIOwner.Weapon != None )
			{
				if ( ePRIOwner.Weapon.AmmoType != None )
				{
					epri.AmmoAmount=ePRIOwner.Weapon.AmmoType.AmmoAmount;
				} else {
					epri.AmmoAmount=0;
				}
			}
			if ( LeagueAS_ExtPlayerReplicationInfo(ePRIOwner.PlayerReplicationInfo).bMyShowTeamInfo )
			{
				i=0;
				P=Level.PawnList;
JL06B3:
				if ( P != None )
				{
					if ( (P.IsA('PlayerPawn') || P.IsA('Bot')) && (ePRIOwner != P) && (ePRIOwner.PlayerReplicationInfo.Team == P.PlayerReplicationInfo.Team) )
					{
						epri.cRI.PlayerName[i]=P.PlayerReplicationInfo.PlayerName;
						epri.cRI.Health[i]=P.Health;
						if ( P.Weapon != None )
						{
							epri.cRI.WeaponName[i]=P.Weapon.ItemName;
						} else {
							epri.cRI.WeaponName[i]="none";
						}
						DistToNearestFort=0.00;
						foreach AllActors(Class'FortStandard',F)
						{
							ThisFortDist=DistanceFrom(P,F);
							if ( (DistToNearestFort == 0) || (ThisFortDist < DistToNearestFort) )
							{
								NearestFort=F;
								DistToNearestFort=ThisFortDist;
							}
						}
						if ( (DistToNearestFort < 1000) && (NearestFort != None) )
						{
							if ( (NearestFort.FortName == "Assault Target") || (NearestFort.FortName == "") || (NearestFort.FortName == " ") )
							{
								epri.cRI.Location[i]="Near" @ string(NearestFort);
							} else {
								epri.cRI.Location[i]="Near" @ NearestFort.FortName;
							}
						} else {
							if ( (P.PlayerReplicationInfo != None) && (P.PlayerReplicationInfo.PlayerLocation != None) )
							{
								epri.cRI.Location[i]=P.PlayerReplicationInfo.PlayerLocation.LocationName;
							} else {
								if ( (ePRIOwner.PlayerReplicationInfo != None) && (ePRIOwner.PlayerReplicationInfo.PlayerZone != None) )
								{
									epri.cRI.Location[i]=P.PlayerReplicationInfo.PlayerZone.ZoneName;
								} else {
									epri.cRI.Location[i]="UNKNOWN";
								}
							}
						}
						if ( epri.cRI.Location[i] == "" )
						{
							epri.cRI.Location[i]="UNKNOWN";
						}
						i++;
						if ( i > 6 )
						{
							goto JL0AC3;
						}
					}
					P=P.nextPawn;
					goto JL06B3;
				}
			}
		}
	}
	LeagueASGameReplicationInfo.TimeRemaining=RemainingTime;
	if ( SavedTime > 0 )
	{
		LeagueASGameReplicationInfo.TimeElapsed=SavedTime - RemainingTime;
	} else {
		LeagueASGameReplicationInfo.TimeElapsed=TimeLimit * 60 - RemainingTime;
	}
	ServerSideModule.OnTimer();
}

event PreBeginPlay ()
{
	local int X;
	local Mutator M;
	local Mutator mut;
	local Pawn P;
	local Class<LeagueAS_SSDAbstract> SSDClass;
	local Class<LeagueAS_SSMAbstract> SSMClass;
	local Class<LeagueAS_AuthAbstract> AMClass;
	local Class<CSHPEntryActor> EntryActorClass;

	if ( Class'LeagueAssault'.Default.bEnableCSHP && (EntryActorClassString != "") )
	{
		EntryActorClass=Class<CSHPEntryActor>(DynamicLoadObject(EntryActorClassString,Class'Class'));
		if ( EntryActorClass == None )
		{
			Log("Error: failed to load EntryActorClass. Configured ClassString:" @ EntryActorClassString);
		} else {
			if (  !EntryActorClassString ~= "LeagueAS140.CSHPEntryActor" )
			{
				Log("EntryActor is:" @ EntryActorClassString);
			}
			Spawn(EntryActorClass);
		}
	}
	Super.PreBeginPlay();
	bPracticeMode=False;
	if ( bMatchMode )
	{
		bTournament=True;
	}
	if (  !bIPsCollected )
	{
		SavedPlayerCount=0;
		SavedSpecCount=0;
	} else {
		FreePlayerSlots=Level.Game.MaxPlayers - SavedPlayerCount;
		FreeSpecSlots=Level.Game.MaxSpectators - SavedSpecCount;
	}
	bIPsCollected=False;
	LeagueASGameReplicationInfo=LeagueAS_GameReplicationInfo(GameReplicationInfo);
	SSDClass=None;
	SSDClass=Class<LeagueAS_SSDAbstract>(DynamicLoadObject("LeagueAS-SP.ServerSetupDataLink",Class'Class'));
	if ( SSDClass == None )
	{
		Log("Failed to load class LeagueAS-SP.ServerSetupDataLink, data link will be unavailable.",'LeagueAssault');
		Log("##############################################################",'LeagueAssault');
		Log("# WARNING: LEAGUEAS IS NOT CORRECTLY INSTALLED",'LeagueAssault');
		Log("# WARNING: LeagueAS Version:" @ Left(string(self.Class),InStr(string(self.Class),".")),'LeagueAssault');
		Log("# WARNING: The 'LeagueAS-SP.u' is missing or wrong version!",'LeagueAssault');
		Log("##############################################################",'LeagueAssault');
		ServerSetupDataLink=Spawn(Class'LeagueAS_SSDAbstract');
	} else {
		ServerSetupDataLink=Spawn(SSDClass);
	}
	ServerSetupDataLink.Initialise();
	if ( bAuthorisePlayers )
	{
		AMClass=None;
		AMClass=Class<LeagueAS_AuthAbstract>(DynamicLoadObject(AuthModuleClass,Class'Class'));
		if ( AMClass == None )
		{
			Log("Failed to dynamic load AuthModule. Configured ClassString:" @ AuthModuleClass,'LeagueAssault');
		} else {
			AuthModule=Spawn(AMClass);
			if ( AuthModule == None )
			{
				Log("Failed to spawn AuthModule. Configured Class:" @ AuthModuleClass,'LeagueAssault');
			} else {
				Log("Authmodule loaded OK:" @ AuthModuleClass,'LeagueAssault');
			}
		}
	}
	SSMClass=None;
	SSMClass=Class<LeagueAS_SSMAbstract>(DynamicLoadObject("LeagueAS-SP.ServerSideModule",Class'Class'));
	if ( SSMClass == None )
	{
		ServerSideModule=Spawn(Class'LeagueAS_SSMAbstract');
		Log("Failed to load class LeagueAS-SP.ServerSideModule, some features will be unavailable.",'LeagueAssault');
	} else {
		ServerSideModule=Spawn(SSMClass);
	}
	ServerSideModule.LeagueAssaultGame=self;
	SubVersionStr=ServerSideModule.SubVersionStr;
	ServerSideModule.OnStart();
	Class'TeamCannon'.Default.Health=100;
	Class'MinigunCannon'.Default.Health=100;
	if ( bStandardise )
	{
		bHardCoreMode=True;
		bChallengeMode=False;
		bMultiWeaponStay=True;
		AirControl=0.35;
		SetGameSpeed(1.00);
	}
	if ( bMatchMode )
	{
		bPracticeMode=False;
		bPlayersBalanceTeams=False;
	}
	bForceRespawn=True;
	MaxCommanders=0;
}

function bool GetRule (out string Rules, out string Result)
{
	if ( Left(Rules,1) == "\" )
	{
		Result=Mid(Rules,1);
		if ( InStr(Result,"\") >= 0 )
		{
			Result=Left(Result,InStr(Result,"\"));
		}
		Rules=Mid(Rules,1);
		if ( InStr(Rules,"\") >= 0 )
		{
			Rules=Mid(Rules,InStr(Rules,"\"));
		} else {
			Rules="";
		}
		return True;
	} else {
		return False;
	}
}

event BeginPlay ()
{
	local int FortCount;
	local int i;
	local int j;
	local int LastDefPriority;
	local FortStandard F;
	local FortStandard HighestFort;
	local string ServerRules;
	local string Rule;
	local string MapName;
	local bool FortFound;

	Super.BeginPlay();
	if ( bMatchMode && bAutoPausing )
	{
		AutoPauser=Spawn(Class'LeagueAS_AutoPauser');
		AutoPauser.PausePerMapCountRemaining[0]=MaxPausePerMapCount;
		AutoPauser.PausePerMapCountRemaining[1]=MaxPausePerMapCount;
		Log("LeagueAssault: Autopauser starting: Team 0: (RemTime,RemCountMatch,RemTimeMap): (" $ string(PauseTimeRemaining[0]) $ "," $ string(PauseCountRemaining[0]) $ "," $ string(AutoPauser.PausePerMapCountRemaining[0]) $ ")");
		Log("LeagueAssault: Autopauser starting: Team 1: (RemTime,RemCountMatch,RemTimeMap): (" $ string(PauseTimeRemaining[1]) $ "," $ string(PauseCountRemaining[1]) $ "," $ string(AutoPauser.PausePerMapCountRemaining[1]) $ ")");
	}
	if ( bEnableCSHP )
	{
		CSHP=Level.Spawn(Class'HackProtection');
		CSHP.NextMutator=Level.Game.BaseMutator;
		Level.Game.BaseMutator=CSHP;
	}
	Class'PlayerPawn'.Default.MaxTimeMargin=1.00;
	Class'PlayerPawn'.StaticSaveConfig();
	if ( bMatchMode )
	{
		TeamColor[0]=TeamNameRed;
		TeamColor[1]=TeamNameBlue;
	}
	ServerRules=GetRules();
JL021F:
	if ( GetRule(ServerRules,Rule) )
	{
		if ( Rule ~= "password" )
		{
			GetRule(ServerRules,Rule);
			ServerHasPass=Rule ~= "True";
		} else {
			goto JL021F;
		}
	}
	MapName=Left(string(self),InStr(string(self),"."));
	if ( bMatchMode )
	{
		LeagueASGameReplicationInfo.StartTimeRemaining=SubsequentMapStartTime;
		SetScoreStrings(TeamColor[0] @ string(TeamScore[0]) @ "-" @ string(TeamScore[1]) @ TeamColor[1]);
		LeagueASGameReplicationInfo.bMatchModeEnabled=True;
		TeamChangeMessage="Match in progress. Team Changing Disabled!";
	} else {
		MapsLeft=0;
		LeagueASGameReplicationInfo.StartTimeRemaining=-1;
		TeamScore[0]=0;
		TeamScore[1]=0;
		if ( ServerHasPass )
		{
			SetScoreStrings(PrivateString);
		} else {
			SetScoreStrings(PublicString);
		}
		TeamChangeMessage="Type 'ChangeTeams' to change teams.";
	}
	FortCount=0;
	foreach AllActors(Class'FortStandard',F)
	{
		FortCount++;
	}
	LastDefPriority=-2147483648;
	i=0;
JL03BF:
	if ( i < FortCount )
	{
		HighestFort=None;
		foreach AllActors(Class'FortStandard',F)
		{
			if ( (HighestFort == None) || (F.DefensePriority >= HighestFort.DefensePriority) )
			{
				FortFound=False;
				j=0;
JL0424:
				if ( j < 20 )
				{
					if ( (LeagueASGameReplicationInfo.FortName[j] == F.FortName) || (LeagueASGameReplicationInfo.FortName[j] == string(F)) )
					{
						FortFound=True;
					}
					j++;
					goto JL0424;
				}
				if (  !FortFound )
				{
					HighestFort=F;
				}
			}
		}
		if ( HighestFort != None )
		{
			if ( (HighestFort.FortName == "Assault Target") || (HighestFort.FortName == "") || (HighestFort.FortName == " ") )
			{
				LeagueASGameReplicationInfo.FortName[i]=string(HighestFort);
			} else {
				LeagueASGameReplicationInfo.FortName[i]=HighestFort.FortName;
			}
			LeagueASGameReplicationInfo.FortCompleted[i]="Not Complete!";
		}
		i++;
		goto JL03BF;
	}
	SaveConfig();
}

event InitGame (string Options, out string Error)
{
	local FortStandard F;
	local name EndCamTag;

	Super.InitGame(Options,Error);
	TimeLimit=1;
	if ( bAttackOnly )
	{
		foreach AllActors(Class'FortStandard',F)
		{
			TimeLimit=Max(TimeLimit,F.DefenseTime);
			if ( F.EndCamTag != 'None' )
			{
				EndCamTag=F.EndCamTag;
			}
		}
		RemainingTime=TimeLimit * 60;
		bDefenseSet=True;
		SavedTime=0.00;
	} else {
		if ( SavedTime > 0 )
		{
			RemainingTime=SavedTime;
			foreach AllActors(Class'FortStandard',F)
			{
				if ( F.EndCamTag != 'None' )
				{
					EndCamTag=F.EndCamTag;
				}
			}
		} else {
			foreach AllActors(Class'FortStandard',F)
			{
				TimeLimit=Max(TimeLimit,F.DefenseTime);
				if ( F.EndCamTag != 'None' )
				{
					EndCamTag=F.EndCamTag;
				}
			}
			RemainingTime=TimeLimit * 60;
		}
	}
	if ( EndCamTag != 'None' )
	{
		foreach AllActors(Class'SpectatorCam',EndCam,EndCamTag)
		{
			goto JL0187;
JL0187:
		}
	}
	GoalTeamScore=0.00;
	FragLimit=0;
	bMegaSpeed=False;
	bUseTranslocator=False;
	bJumpMatch=False;
}

function PostBeginPlay ()
{
	local Mutator mut;

	Super.PostBeginPlay();
	if ( brecovering )
	{
		Log("recovered");
		brecovering=False;
		bCleanShutdown=False;
		SaveConfig();
	} else {
		if (  !bCleanShutdown )
		{
			Log("Unclean shutdown detected");
			if ( bcrashrecovery && bMatchMode )
			{
				Log("Recovering" @ recallmap @ recallmutatorlist);
				bCleanShutdown=False;
				brecovering=True;
				SaveConfig();
				Level.ServerTravel(recallmap $ ".unr" $ "?mutator=" $ recallmutatorlist,False);
			}
		} else {
			if (  !nextexpectedmap ~= (Left(string(self),InStr(string(self),".")) $ ".unr") )
			{
				Log("Crash detected during mapchange");
				Log("expected:" @ nextexpectedmap @ "Actualmap:" @ Left(string(self),InStr(string(self),".")) $ ".unr");
				if ( bcrashrecovery && bMatchMode )
				{
					Log("Recovering");
					bCleanShutdown=False;
					brecovering=True;
					SaveConfig();
					Level.ServerTravel(nextexpectedmap $ "?mutator=" $ recallmutatorlist,False);
				}
			} else {
				recallmutatorlist="";
				foreach AllActors(Class'Mutator',mut)
				{
					if (  !mut.IsA('LeagueAS_AuthAbstract') &&  !mut.IsA('LeagueAS_Mutator') &&  !mut.IsA('HackProtection') )
					{
						recallmutatorlist=recallmutatorlist $ string(mut.Class) $ ",";
					}
				}
				if ( bcrashrecovery )
				{
					Log("recallmutators is:" @ recallmutatorlist);
				}
				if ( bcrashrecovery )
				{
					Log("Old Recallmap is:" @ recallmap);
				}
				recallmap=Left(string(self),InStr(string(self),"."));
				if ( bcrashrecovery )
				{
					Log("new Recallmap is:" @ recallmap);
				}
				bCleanShutdown=False;
				SaveConfig();
			}
		}
	}
	if ( bMatchMode )
	{
		TeamColor[0]=TeamNameRed;
		TeamColor[1]=TeamNameBlue;
		Teams[0].TeamName=TeamNameRed;
		Teams[1].TeamName=TeamNameBlue;
	}
}

function PlayStartUpMessage (PlayerPawn NewPlayer)
{
	local int i;
	local Color WhiteColor;

	if ( NewPlayer.PlayerReplicationInfo.Team > 1 )
	{
		return;
	}
	NewPlayer.ClearProgressMessages();
	if ( Defender == Teams[NewPlayer.PlayerReplicationInfo.Team] )
	{
		StartUpMessage=DefendMessage;
	} else {
		StartUpMessage=AttackMessage;
	}
	NewPlayer.SetProgressMessage(GameName,i++ );
	if ( bRequireReady && (Level.NetMode != 0) )
	{
		NewPlayer.SetProgressMessage(TourneyMessage,i++ );
	} else {
		NewPlayer.SetProgressMessage(StartUpMessage,i++ );
	}
	if ( GoalTeamScore > 0 )
	{
		NewPlayer.SetProgressMessage(string(GoalTeamScore) @ gamegoal,i++ );
	}
	if ( NewPlayer.PlayerReplicationInfo.Team < 4 )
	{
		NewPlayer.SetProgressColor(Class'ChallengeTeamHUD'.Default.TeamColor[NewPlayer.PlayerReplicationInfo.Team],i);
		if ( NewPlayer.PlayerReplicationInfo.Team == Defender.TeamIndex )
		{
			NewPlayer.SetProgressMessage(StartUpTeamMessage @ Teams[NewPlayer.PlayerReplicationInfo.Team].TeamName @ "(Defending).",i++ );
		} else {
			NewPlayer.SetProgressMessage(StartUpTeamMessage @ Teams[NewPlayer.PlayerReplicationInfo.Team].TeamName @ "(Attacking).",i++ );
		}
		WhiteColor.R=255;
		WhiteColor.G=255;
		WhiteColor.B=255;
		NewPlayer.SetProgressColor(WhiteColor,i);
		if (  !bRatedGame )
		{
			NewPlayer.SetProgressMessage(TeamChangeMessage,i++ );
		}
	}
	if ( Level.NetMode == 0 )
	{
		NewPlayer.SetProgressMessage(SingleWaitingMessage,i++ );
	}
}

function SendStartMessage (PlayerPawn P)
{
	ObjectivesMessage=GameName;
	Super.SendStartMessage(P);
}

function bool ChangeTeam (Pawn Other, int NewTeam)
{
	local Projectile P;
	local Effects q;

	if ( (Other.PlayerReplicationInfo.Team != 255) && bMatchMode )
	{
		return False;
	} else {
		foreach AllActors(Class'Projectile',P)
		{
			if ( (P.Owner == Other) || (P.Instigator == Other) )
			{
				P.Destroy();
			}
		}
		foreach AllActors(Class'Effects',q)
		{
			if ( (q.Owner == Other) || (q.Instigator == Other) )
			{
				q.Destroy();
			}
		}
		return Super.ChangeTeam(Other,NewTeam);
	}
}

function InitLogging ()
{
	local Mutator M;
	local DMMutator DMM;

	if ( bLocalLog && bLoggingGame )
	{
		Log("Initiating local logging...");
		LocalLog=Spawn(StatLogClass);
		LocalLog.bWorld=False;
		LocalLog.StartLog();
		LocalLog.LogStandardInfo();
		LocalLog.LogServerInfo();
		LocalLog.LogMapParameters();
		if ( bngStatsCompatibility )
		{
			DMM=Spawn(Class'DMMutator');
			LocalLog.LogMutator(DMM);
			DMM.Destroy();
		}
		M=BaseMutator;
JL00D0:
		if ( M != None )
		{
			if (  !bngStatsCompatibility && (M.IsA('CSHPBadge') || M.IsA('LeagueAS_Mutator') || M.IsA('HackProtection') || M.IsA('AntiRocketLaunch') || M.IsA('AntiHammerLaunch') || M.IsA('MapVote') || M.IsA('LeagueAS_AuthAbstract')) )
			{
				LocalLog.LogMutator(M);
			}
			M=M.NextMutator;
			goto JL00D0;
		}
		LogGameParameters(LocalLog);
		LocalLogFileName=LocalLog.GetLogFileName();
	}
	if ( (Level.NetMode != 1) && (Level.NetMode != 2) )
	{
		return;
	}
	if ( bWorldLog && bLoggingGame )
	{
		Log("Initiating world logging...");
		WorldLog=Spawn(StatLogClass);
		WorldLog.bWorld=True;
		WorldLog.StartLog();
		WorldLog.LogStandardInfo();
		WorldLog.LogServerInfo();
		WorldLog.LogMapParameters();
		WorldLog.InitialCheck(self);
		if ( bngStatsCompatibility )
		{
			DMM=Spawn(Class'DMMutator');
			WorldLog.LogMutator(DMM);
			DMM.Destroy();
		}
		M=BaseMutator;
JL02DD:
		if ( M != None )
		{
			if (  !bngStatsCompatibility && (M.IsA('CSHPBadge') || M.IsA('LeagueAS_Mutator') || M.IsA('HackProtection') || M.IsA('AntiRocketLaunch') || M.IsA('AntiHammerLaunch') || M.IsA('MapVote') || M.IsA('LeagueAS_AuthAbstract')) )
			{
				WorldLog.LogMutator(M);
			}
			M=M.NextMutator;
			goto JL02DD;
		}
		LogGameParameters(WorldLog);
		WorldLogFileName=WorldLog.GetLogFileName();
	}
}

function LogGameParameters (StatLog StatLog)
{
	if ( StatLog == None )
	{
		return;
	}
	if ( bngStatsCompatibility )
	{
		StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "GameName" $ Chr(9) $ "Assault");
		StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "GameClass" $ Chr(9) $ "Botpack.Assault");
	} else {
		StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "GameName" $ Chr(9) $ GameName);
		StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "GameClass" $ Chr(9) $ string(Class));
	}
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "GameVersion" $ Chr(9) $ Level.EngineVersion);
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "MinNetVersion" $ Chr(9) $ Level.MinNetVersion);
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "NoMonsters" $ Chr(9) $ string(bNoMonsters));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "MuteSpectators" $ Chr(9) $ string(bMuteSpectators));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "HumansOnly" $ Chr(9) $ string(bHumansOnly));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "WeaponsStay" $ Chr(9) $ string(bCoopWeaponMode));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "ClassicDeathmessages" $ Chr(9) $ string(bClassicDeathMessages));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "LowGore" $ Chr(9) $ string(bLowGore));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "VeryLowGore" $ Chr(9) $ string(bVeryLowGore));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "TeamGame" $ Chr(9) $ string(bTeamGame));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "GameSpeed" $ Chr(9) $ string(GameSpeed * 100));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "MaxSpectators" $ Chr(9) $ string(MaxSpectators));
	StatLog.LogEventString(StatLog.GetTimeStamp() $ Chr(9) $ "game" $ Chr(9) $ "MaxPlayers" $ Chr(9) $ string(MaxPlayers));
}

function NotifySpree (Pawn Other, int Num)
{
	local Pawn P;

	if ( Num == 5 )
	{
		Num=0;
	} else {
		if ( Num == 10 )
		{
			Num=1;
		} else {
			if ( Num == 15 )
			{
				Num=2;
			} else {
				if ( Num == 20 )
				{
					Num=3;
				} else {
					if ( Num == 25 )
					{
						Num=4;
					} else {
						return;
					}
				}
			}
		}
	}
	P=Level.PawnList;
JL0087:
	if ( P != None )
	{
		if ( P.IsA('PlayerPawn') )
		{
			P.ReceiveLocalizedMessage(Class'KillingSpreeMessage',Num,Other.PlayerReplicationInfo);
		}
		P=P.nextPawn;
		goto JL0087;
	}
}

function bool RestartPlayer (Pawn aPlayer)
{
	if ( aPlayer.IsA('TournamentPlayer') )
	{
		if ( (CSHP != None) && (CSHP.zzPtool != None) )
		{
			CSHP.zzPtool.DeathProbe(PlayerPawn(aPlayer));
		}
	}
	return Super.RestartPlayer(aPlayer);
}

function ProcessServerTravel (string URL, bool bItems)
{
	local TriggeredTexture A;
	local Pawn P;
	local LeagueAS_CustomReplicationInfo cRI;
	local LeagueAS_Inventory Inv;

	Default.SavedPlayerCount=0;
	Default.SavedSpecCount=0;
	P=Level.PawnList;
JL0022:
	if ( P != None )
	{
		if ( P.bIsPlayer && (PlayerPawn(P) != None) )
		{
			if ( P.IsA('TournamentPlayer') )
			{
				if ( Default.SavedPlayerCount > 15 )
				{
					goto JL00F4;
				}
				Default.SavedPlayerIPs[Default.SavedPlayerCount]=IPOnly(PlayerPawn(P).GetPlayerNetworkAddress());
				Default.SavedPlayerCount++;
			} else {
				if ( P.IsA('CHSpectator') )
				{
					if ( Default.SavedSpecCount > 3 )
					{
						goto JL00F4;
					}
					Default.SavedSpecIPs[Default.SavedSpecCount]=IPOnly(PlayerPawn(P).GetPlayerNetworkAddress());
					Default.SavedSpecCount++;
				}
			}
		}
JL00F4:
		P=P.nextPawn;
		goto JL0022;
	}
	Default.bIPsCollected=True;
	foreach AllActors(Class'TriggeredTexture',A)
	{
		if ( A.DestinationTexture != None )
		{
			if ( ScriptedTexture(A.DestinationTexture) != None )
			{
				ScriptedTexture(A.DestinationTexture).NotifyActor=None;
			}
		}
		A.DestinationTexture=None;
	}
	foreach AllActors(Class'LeagueAS_Inventory',Inv)
	{
		Inv.KillTriggeredTextures();
	}
	Super.ProcessServerTravel(URL,bItems);
	if ( URL ~= "?Restart" )
	{
		Default.nextexpectedmap=Left(string(self),InStr(string(self),".")) $ ".unr";
	} else {
		if ( InStr(URL,"?") != -1 )
		{
			Default.nextexpectedmap=Left(URL,InStr(URL,"?"));
		} else {
			Default.nextexpectedmap=URL;
		}
		if ( InStr(Default.nextexpectedmap,".unr") == -1 )
		{
			Default.nextexpectedmap=Default.nextexpectedmap $ ".unr";
		}
	}
	Default.bCleanShutdown=True;
	StaticSaveConfig();
}

function bool AttackOnlyLocalFort (Bot aBot)
{
	local FortStandard F;
	local bool bVisible;
	local bool bPressOn;
	local byte bMultiSame;
	local float dist;

	F=AttackFort(aBot,bMultiSame);
	if ( F != None )
	{
		bPressOn=(Leader[aBot.PlayerReplicationInfo.Team] == None) ||  !Leader[aBot.PlayerReplicationInfo.Team].IsA('PlayerPawn') || aBot.Region.Zone.bWaterZone || (Leader[aBot.PlayerReplicationInfo.Team].Health <= 0) || (VSize(Leader[aBot.PlayerReplicationInfo.Team].Location - F.Location) < 1500) && Leader[aBot.PlayerReplicationInfo.Team].LineOfSightTo(F) || (aBot.Enemy != None) && (Level.TimeSeconds - aBot.LastSeenTime < 1.50);
		dist=VSize(aBot.Location - F.Location);
		if ( F.bTriggerOnly )
		{
			if ( (bMultiSame == 1) || (dist < F.ChargeDist) && (aBot.Region.Zone == F.Region.Zone) && (F.bForceRadius || aBot.LineOfSightTo(F)) )
			{
				if ( aBot.actorReachable(F) )
				{
					SetAttractionStateFor(aBot);
					aBot.MoveTarget=F;
					return True;
				} else {
					if (  !F.bForceRadius &&  !bPressOn )
					{
						return False;
					} else {
						return FindPathToFortFor(aBot,F);
					}
				}
			}
		} else {
			if ( dist < 2 * F.ChargeDist )
			{
				bVisible=aBot.LineOfSightTo(F);
				if ( F.bForceRadius || bVisible || bPressOn && ((bMultiSame == 1) || (aBot.Region.Zone == F.Region.Zone)) )
				{
					aBot.SetEnemy(F);
					if ( aBot.Enemy == F )
					{
						if ( bVisible && (dist < 1200) )
						{
							aBot.GotoState('RangedAttack');
							return True;
						} else {
							return FindPathToFortFor(aBot,F);
						}
					}
				}
			}
		}
	}
	if ( FortStandard(aBot.Enemy) != None )
	{
		aBot.Enemy=aBot.OldEnemy;
		aBot.OldEnemy=None;
		if ( FortStandard(aBot.Enemy) != None )
		{
			aBot.Enemy=None;
		}
	}
	return False;
}

function ChangeName (Pawn Other, coerce string S, bool bNameChange)
{
	local bool bAllowed;

	if ( AuthModule != None )
	{
		bAllowed=AuthModule.PlayerChangeName(Other,S,bNameChange);
		if ( bAllowed )
		{
			SuperChangeName(Other,S,bNameChange);
		}
	} else {
		SuperChangeName(Other,S,bNameChange);
	}
}

function SuperChangeName (Pawn Other, coerce string S, bool bNameChange)
{
	ChangeName(Other,S,bNameChange);
}

function AdminLogin (PlayerPawn P, string Password)
{
	Super.AdminLogin(P,Password);
	if ( P.bAdmin )
	{
		Log("Administrator logged in:" @ P.PlayerReplicationInfo.PlayerName @ P.GetPlayerNetworkAddress(),'LeagueAssault');
	}
}

function AdminLogout (PlayerPawn P)
{
	if ( P.bAdmin )
	{
		Log("Administrator logged out:" @ P.PlayerReplicationInfo.PlayerName @ P.GetPlayerNetworkAddress(),'LeagueAssault');
	}
	Super.AdminLogout(P);
}

defaultproperties
{
    bngStatsCompatibility=True
    bEnableCSHP=True
    bStandardise=True
    bAdminNameScore=True
    bServerNameGameType=True
    bCheckServername=True
    MaxPauseTime=180
    MaxPauseCount=4
    MaxPausePerMapCount=1
    PauseLeadInOutTime=5
    MatchLength=14
    FirstMapStartTime=300
    SubsequentMapStartTime=60
    TeamNameRed="Red"
    TeamNameBlue="Blue"
    PrivateString="LOCKED - PRIVATE"
    PublicString="OPEN - PUBLIC"
    bImprovedTeamBalance=True
    TeamBalanceDelayTime=60
    bPreventMapChangeKick=True
    PreventMapChangeKickTime=40
    AuthModuleClass="LeagueAS140.LeagueAS_AuthAbstract"
    EntryActorClassString="LeagueAS140.CSHPEntryActor"
    bDisableTIW=True
    VersionStr="1.40"
    PackageName="LeagueAS140"
    AttackMessage="Assault the enemy base!"
    WinMessage="and win!"
    bForceRespawn=True
    ScoreBoardType=Class'LeagueAS_Scoreboard'
    HUDType=Class'LeagueAS_HUD'
    GameName="League Assault 140"
    DeathMessageClass=Class'NewMsgDeathMessagePlus'
    MutatorClass=Class'LeagueAS_Mutator'
    GameReplicationInfoClass=Class'LeagueAS_GameReplicationInfo'
}