//================================================================================
// LeagueAS_Inventory.
//================================================================================
class LeagueAS_Inventory extends Inventory
	NoNativeReplication;

var string Overlord;
var Pawn PlayerOwner;
var LeagueAssault LeagueAssaultGame;
var bool SpawnProtectActive;
var bool Initialized;
var bool Initiated;
var Vector OwnerStartPosition;
var int Counter;
var int Count;
var() globalconfig string shortcuts[64];
var config bool bshowmaplisttoall;
var float TimeSinceLastTeleport;
var int AttackerSpawnProt;
var int DefenderSpawnProt;
var bool bTakeNextSlot;

replication
{
	reliable if ( Role == 4 )
		KillTriggeredTextures,PlayerLeft,TeleportClientSide;
	reliable if ( Role < 4 )
		MapList,ThrowArmor,ThrowArmour,SummonItem,CancelPause,RequestPause,Echo,ChangeTeams,ShowMatchScore,ForceMatchStart,Moderator,ModeratorLogout,ModeratorLogin,NumTeamView,GetPauseState,tiwdetails,tiw,istiwminienabled,isbanonmatchmodeenabled;
}

event Spawned ()
{
	PlayerOwner=Pawn(Owner);
	LeagueAssaultGame=LeagueAssault(Level.Game);
}

exec function isbanonmatchmodeenabled ()
{
	if ( Role == 4 )
	{
		PlayerPawn(PlayerOwner).ClientMessage(string(Class'HackProtection'.Default.bMMBan));
	}
}

exec function istiwminienabled ()
{
	if ( Role == 4 )
	{
		PlayerPawn(PlayerOwner).ClientMessage(string( !Class'LeagueAssault'.Default.bDisableTIW));
	}
}

exec function tiw ()
{
	if ( Role != 4 )
	{
		return;
	}
	PlayerPawn(PlayerOwner).ClientMessage("TIW Enabled:" @ string( !Class'LeagueAssault'.Default.bDisableTIW));
}

exec function tiwdetails ()
{
	if ( Role != 4 )
	{
		return;
	}
	PlayerPawn(PlayerOwner).ClientMessage("TIW Enabled:" @ string( !Class'LeagueAssault'.Default.bDisableTIW));
	if (  !Class'LeagueAssault'.Default.bDisableTIW )
	{
		LeagueAssault(Level.Game).ServerSideModule.ShowTIWDetails(PlayerPawn(PlayerOwner));
	}
}

simulated exec function Options ()
{
	local WindowConsole C;
	local Menu_FramedWindow FramedWindow;

	C=WindowConsole(PlayerPawn(Owner).Player.Console);
	if (  !C.bCreatedRoot || (C.Root == None) )
	{
		C.CreateRootWindow(None);
	}
	C.bQuickKeyEnable=True;
	C.LaunchUWindow();
	FramedWindow=Menu_FramedWindow(C.Root.CreateWindow(Class'Menu_FramedWindow',0.00,0.00,436.00,380.00,,True));
	FramedWindow.ActivateWindow(0,False);
	FramedWindow.bLeaveOnscreen=True;
}

exec function GetPauseState ()
{
	if ( (LeagueAssaultGame.AutoPauser != None) && LeagueAssaultGame.bAutoPausing && (LeagueAssaultGame.MaxPauseTime != 0) )
	{
		PlayerOwner.ClientMessage("Autopause Team 0: (RemTime,RemCountMatch,RemTimeMap): (" $ string(LeagueAssaultGame.PauseTimeRemaining[0]) $ "," $ string(LeagueAssaultGame.PauseCountRemaining[0]) $ "," $ string(LeagueAssaultGame.AutoPauser.PausePerMapCountRemaining[0]) $ ")");
		PlayerOwner.ClientMessage("Autopause Team 1: (RemTime,RemCountMatch,RemTimeMap): (" $ string(LeagueAssaultGame.PauseTimeRemaining[1]) $ "," $ string(LeagueAssaultGame.PauseCountRemaining[1]) $ "," $ string(LeagueAssaultGame.AutoPauser.PausePerMapCountRemaining[1]) $ ")");
	} else {
		PlayerOwner.ClientMessage("Autopause is disabled!");
	}
}

exec function NumTeamView ()
{
	local LeagueAS_ExtPlayerReplicationInfo epri;
	local int i;

	if ( Role != 4 )
	{
		return;
	}
	foreach AllActors(Class'LeagueAS_ExtPlayerReplicationInfo',epri)
	{
		if ( epri.bMyShowTeamInfo )
		{
			i++;
		}
	}
	PlayerOwner.ClientMessage("Number of Players that have Teamview enabled:" @ string(i));
}

exec function StartMatch ()
{
	if (  !LeagueAssaultGame.bGameEnded && (PlayerPawn(PlayerOwner).bAdmin || (Level.NetMode == 0)) )
	{
		LeagueAssaultGame.PEFStartMatch(PlayerPawn(PlayerOwner));
	}
}

exec function EndMatch ()
{
	if ( (PlayerPawn(PlayerOwner).bAdmin || (Level.NetMode == 0)) && LeagueAssaultGame.bMatchMode )
	{
		LeagueAssaultGame.PEFEndMatch();
	}
}

exec function ResetTeamNames ()
{
	if ( PlayerPawn(PlayerOwner).bAdmin || (Level.NetMode == 0) )
	{
		LeagueAssaultGame.PEFResetTeamNames();
	}
}

exec function TogglePracticeMode ()
{
	if ( PlayerPawn(PlayerOwner).bAdmin || (Level.NetMode == 0) )
	{
		LeagueAssaultGame.PEFTogglePracticeMode();
	}
}

exec function SetRedScore (int Score)
{
	if ( PlayerPawn(PlayerOwner).bAdmin || (Level.NetMode == 0) )
	{
		LeagueAssaultGame.PEFSetTeamScore(PlayerPawn(PlayerOwner),0,Score);
	}
}

exec function SetBlueScore (int Score)
{
	if ( PlayerPawn(PlayerOwner).bAdmin || (Level.NetMode == 0) )
	{
		LeagueAssaultGame.PEFSetTeamScore(PlayerPawn(PlayerOwner),1,Score);
	}
}

exec function ShowMatchLog ()
{
	if ( PlayerPawn(PlayerOwner).bAdmin || (Level.NetMode == 0) )
	{
		PlayerPawn(PlayerOwner).ClientMessage(LeagueAssaultGame.Matchlog);
	}
}

exec function ClearMatchLog ()
{
	if ( PlayerPawn(PlayerOwner).bAdmin || (Level.NetMode == 0) )
	{
		LeagueAssaultGame.Matchlog="";
		LeagueAssaultGame.SaveConfig();
	}
}

exec function ModeratorLogin (string ModPassword)
{
	if (  !LeagueAssaultGame.bMatchMode )
	{
		LeagueAssaultGame.AddModerator(PlayerPawn(PlayerOwner),ModPassword);
	}
}

exec function ModeratorLogout ()
{
	LeagueAssaultGame.RemoveModerator(PlayerPawn(PlayerOwner));
}

exec function Moderator (string CommandLine)
{
	local string Command;

	if ( LeagueAssaultGame.IsAModerator(PlayerPawn(PlayerOwner)) )
	{
		Command=Left(CommandLine,InStr(CommandLine," "));
		if ( Command ~= "servertravel" )
		{
			if ( InStr(Caps(CommandLine),"GAME=") >= 0 )
			{
				PlayerOwner.ClientMessage("You are not allowed to change the gametype!");
				return;
			}
			ConsoleCommand(CommandLine);
			Log(PlayerOwner.PlayerReplicationInfo.PlayerName @ "issued moderator command:" @ CommandLine $ ".");
		} else {
			if ( CommandLine ~= "togglepracticemode" )
			{
				LeagueAssaultGame.PEFTogglePracticeMode();
				Log(PlayerOwner.PlayerReplicationInfo.PlayerName @ "issued moderator command:" @ CommandLine $ ".");
			} else {
				if ( Command ~= "kick" )
				{
					PlayerPawn(PlayerOwner).bAdmin=True;
					PlayerPawn(PlayerOwner).Kick(Mid(CommandLine,InStr(CommandLine," ") + 1,Len(CommandLine) - InStr(CommandLine," ")));
					PlayerPawn(PlayerOwner).bAdmin=False;
					Log(PlayerOwner.PlayerReplicationInfo.PlayerName @ "issued moderator command:" @ CommandLine $ ".");
				} else {
					if ( Command ~= "summon" )
					{
						PlayerPawn(PlayerOwner).bAdmin=True;
						PlayerPawn(PlayerOwner).Summon(Mid(CommandLine,InStr(CommandLine," ") + 1,Len(CommandLine) - InStr(CommandLine," ")));
						PlayerPawn(PlayerOwner).bAdmin=False;
						Log(PlayerOwner.PlayerReplicationInfo.PlayerName @ "issued moderator command:" @ CommandLine $ ".");
					} else {
						if ( CommandLine ~= "stopcountdown" )
						{
							StopCountDown();
						} else {
							PlayerOwner.ClientMessage("Unrecognised or unauthorised command.");
						}
					}
				}
			}
		}
	}
}

exec function StopCountDown ()
{
	if (  !LeagueAssaultGame.bGameEnded && (PlayerPawn(PlayerOwner).bAdmin || LeagueAssaultGame.IsAModerator(PlayerPawn(PlayerOwner)) || (Level.NetMode == 0)) )
	{
		LeagueAssaultGame.GameReplicationInfo.bStopCountDown=True;
		LeagueAssaultGame.GameReplicationInfo.RemainingTime=0;
		LeagueAssaultGame.GameReplicationInfo.RemainingMinute=0;
		LeagueAssaultGame.TimeLimit=0;
		LeagueAssaultGame.RemainingTime=0;
		LeagueAssaultGame.SavedTime=0.00;
		LeagueAssaultGame.bDefenseSet=True;
	}
}

exec function ForceMatchStart ()
{
	if ( PlayerPawn(PlayerOwner).bAdmin )
	{
		LeagueAssaultGame.PEFForceMatchStart();
	}
}

exec function ShowMatchScore ()
{
	if ( LeagueAssaultGame.bMatchMode )
	{
		LeagueAssaultGame.PEFShowScores(PlayerPawn(PlayerOwner));
	}
}

exec function ChangeTeams ()
{
	LeagueAssaultGame.PEFChangeTeams(PlayerPawn(PlayerOwner));
}

simulated exec function ToggleMute ()
{
	local LeagueAS_ExtPlayerReplicationInfo epri;

	if ( Class'ClientOptions'.Default.bMuteSay )
	{
		if ( Class'ClientOptions'.Default.bMuteAll )
		{
			Class'ClientOptions'.Default.bMuteSay=False;
			Class'ClientOptions'.Default.bMuteAll=False;
			PlayerPawn(Owner).ClientMessage("Mute OFF.");
		} else {
			Class'ClientOptions'.Default.bMuteSay=True;
			Class'ClientOptions'.Default.bMuteAll=True;
			PlayerPawn(Owner).ClientMessage("Mute ALL Messages.");
		}
	} else {
		Class'ClientOptions'.Default.bMuteSay=True;
		Class'ClientOptions'.Default.bMuteAll=False;
		PlayerPawn(Owner).ClientMessage("Mute ENEMY Messages.");
	}
	Class'ClientOptions'.StaticSaveConfig();
	LeagueAS_ExtPlayerReplicationInfo(PlayerPawn(Owner).PlayerReplicationInfo).LoadOptionsFromFile();
}

exec function Echo (string EchoStr)
{
	PlayerPawn(PlayerOwner).ClientMessage(EchoStr);
}

exec function RequestPause ()
{
	if ( LeagueAssaultGame.bMatchMode && LeagueAssaultGame.bAutoPausing )
	{
		if ( LeagueAssaultGame.AutoPauser != None )
		{
			LeagueAssaultGame.AutoPauser.RequestPause(PlayerPawn(PlayerOwner));
		}
	}
}

exec function CancelPause ()
{
	if ( LeagueAssaultGame.bMatchMode && LeagueAssaultGame.bAutoPausing )
	{
		if ( LeagueAssaultGame.AutoPauser != None )
		{
			LeagueAssaultGame.AutoPauser.RequestCancelPause(PlayerPawn(PlayerOwner));
		}
	}
}

exec function SummonItem (string ClassName)
{
	local Class<Actor> NewClass;

	if (  !LeagueAssaultGame.bMatchMode && LeagueAssaultGame.bPracticeMode )
	{
		NewClass=Class<Actor>(DynamicLoadObject("BotPack." $ ClassName,Class'Class'));
		if ( NewClass != None )
		{
			Spawn(NewClass,,,PlayerOwner.Location + 72 * PlayerOwner.Rotation + vect(0.00,0.00,1.00) * 15);
		}
		BroadcastMessage(PlayerOwner.PlayerReplicationInfo.PlayerName @ "-> Summon" @ ClassName,True,'CriticalEvent');
	}
}

exec function ThrowArmour (int ArmourType)
{
	LeagueAssaultGame.PEFThrowArmour(ArmourType,PlayerPawn(PlayerOwner));
}

exec function ThrowArmor (int ArmourType)
{
	LeagueAssaultGame.PEFThrowArmour(ArmourType,PlayerPawn(PlayerOwner));
}

function ActivateSpawnProtection ()
{
	if ( PlayerOwner == None )
	{
		Destroy();
		return;
	}
	if ( PlayerOwner.PlayerReplicationInfo.Team == LeagueAssaultGame.Attacker.TeamIndex )
	{
		Counter=AttackerSpawnProt * 5;
	} else {
		Counter=DefenderSpawnProt * 5;
	}
	Count=Counter;
	PlayerOwner.Style=3;
	PlayerOwner.ScaleGlow=0.00;
	SpawnProtectActive=True;
	SetTimer(0.20,True);
}

function InventoryTakeDamage (out int actualDamage, Pawn Victim, Pawn instigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	if ( SpawnProtectActive && (Victim != instigatedBy) )
	{
		actualDamage=0;
		Momentum=vect(0.00,0.00,0.00);
	}
}

function Timer ()
{
	if ( PlayerOwner == None )
	{
		Destroy();
	}
	if (  !Initialized && ((Location.X != PlayerOwner.Location.X) || (Location.Y != PlayerOwner.Location.Y)) )
	{
		Initialized=True;
	}
	if ( (OwnerStartPosition.X == 0) && (OwnerStartPosition.Y == 0) )
	{
		OwnerStartPosition.X=PlayerOwner.Location.X;
		OwnerStartPosition.Y=PlayerOwner.Location.Y;
	}
	if ( (PlayerOwner.Location.X != OwnerStartPosition.X) || (PlayerOwner.Location.Y != OwnerStartPosition.Y) )
	{
		Initiated=True;
	}
	if ( SpawnProtectActive && Initialized && (Initiated == True) )
	{
		if ( Count < 0 )
		{
			PlayerOwner.ReceiveLocalizedMessage(PickupMessageClass,0,None,None,self.Class);
			SpawnProtectActive=False;
			PlayerOwner.Style=PlayerOwner.Default.Style;
			PlayerOwner.ScaleGlow=PlayerOwner.Default.ScaleGlow;
		} else {
			PlayerOwner.ScaleGlow=1.00 / Counter * (Counter - Count-- );
		}
	}
}

function Tick (float Delta)
{
	local PlayerPawn PP;

	PP=PlayerPawn(PlayerOwner);
	if ( (PP == None) ||  !PP.bIsPlayer )
	{
		return;
	}
	if (  !Initiated )
	{
		if ( Role == 4 )
		{
			if ( PP.Weapon != None )
			{
				if ( PP.Weapon.IsInState('NormalFire') || PP.Weapon.IsInState('AltFiring') )
				{
					Initiated=True;
				}
			}
		}
	}
	if ( PP.IsInState('CheatFlying') || PP.IsInState('PlayerWaiting') )
	{
		TimeSinceLastTeleport=TimeSinceLastTeleport + Delta;
		CheckForSpectatorTeleport(PP);
	}
}

function CheckForSpectatorTeleport (PlayerPawn PP)
{
	local Teleporter SourceT;
	local Teleporter DestT;

	if ( TimeSinceLastTeleport > 0.50 )
	{
		SourceT=FindCollideTeleporter(PP);
		if ( (SourceT != None) && (SourceT.URL != "") )
		{
			foreach AllActors(Class'Teleporter',DestT)
			{
				if ( (string(DestT.Tag) ~= SourceT.URL) && (DestT != SourceT) )
				{
					TimeSinceLastTeleport=0.00;
					TeleportServerSide(PP,SourceT,DestT);
					TeleportClientSide(PP,SourceT,DestT);
					return;
				}
			}
		}
	}
}

function Teleporter FindCollideTeleporter (PlayerPawn Sender)
{
	local Teleporter t;
	local float DistanceX;
	local float DistanceY;
	local float DistanceZ;
	local float ADistance;

	foreach AllActors(Class'Teleporter',t)
	{
		DistanceX=Sender.Location.X - t.Location.X;
		DistanceY=Sender.Location.Y - t.Location.Y;
		DistanceZ=Sender.Location.Z - t.Location.Z;
		ADistance=Sqrt(Square(DistanceX) + Square(DistanceY) + Square(DistanceZ));
		if ( ADistance - Sender.CollisionRadius - t.CollisionRadius <= 25 )
		{
			return t;
		}
	}
	return None;
}

function TeleportServerSide (PlayerPawn PP, Teleporter SourceT, Teleporter DestT)
{
	Accept(PP,SourceT,DestT);
}

simulated function TeleportClientSide (PlayerPawn PP, Teleporter SourceT, Teleporter DestT)
{
	Accept(PP,SourceT,DestT);
}

simulated function bool Accept (PlayerPawn Incoming, Teleporter SourceT, Teleporter DestT)
{
	local Rotator NewRot;
	local Rotator OldRot;
	local int oldYaw;
	local float mag;
	local Vector oldDir;

	NewRot=Incoming.Rotation;
	if ( DestT.bChangesYaw )
	{
		OldRot=Incoming.Rotation;
		NewRot.Yaw=DestT.Rotation.Yaw;
		NewRot.Yaw += 32768 + Incoming.Rotation.Yaw - SourceT.Rotation.Yaw;
	}
	Incoming.SetLocation(DestT.Location);
	Incoming.SetRotation(NewRot);
	Incoming.ViewRotation=NewRot;
	Incoming.MoveTimer=-1.00;
	Incoming.MoveTarget=self;
	if ( DestT.bChangesVelocity )
	{
		Incoming.Velocity=DestT.TargetVelocity;
	} else {
		if ( DestT.bChangesYaw )
		{
			if ( Incoming.Physics == 1 )
			{
				OldRot.Pitch=0;
			}
			oldDir=OldRot;
			mag=Incoming.Velocity Dot oldDir;
			Incoming.Velocity=Incoming.Velocity - mag * oldDir + mag * Incoming.Rotation;
		}
		if ( DestT.bReversesX )
		{
			Incoming.Velocity.X *= -1.00;
		}
		if ( DestT.bReversesY )
		{
			Incoming.Velocity.Y *= -1.00;
		}
		if ( DestT.bReversesZ )
		{
			Incoming.Velocity.Z *= -1.00;
		}
	}
	return True;
}

exec function MapList (string List)
{
	local int i;
	local int j;
	local int StartMap;
	local string Arrow;
	local string short;
	local ASMapList ml;
	local bool bFound;

	if ( (List == "") && (PlayerPawn(Owner).bAdmin || bshowmaplisttoall) )
	{
		i=0;
JL0037:
		if ( i < 32 )
		{
			if ( i == Class'ASMapList'.Default.MapNum )
			{
				Arrow="   <----";
			} else {
				Arrow="";
			}
			if ( Class'ASMapList'.Default.Maps[i] != "" )
			{
				PlayerPawn(self.Owner).ClientMessage(Class'ASMapList'.Default.Maps[i] @ Arrow);
			}
			i++;
			goto JL0037;
		}
		return;
	}
	if ( PlayerPawn(Owner) != None )
	{
		if (  !PlayerPawn(Owner).bAdmin )
		{
			return;
		}
	}
	if ( List ~= "gotostart" )
	{
		Level.ServerTravel(Class'ASMapList'.Default.Maps[Class'ASMapList'.Default.MapNum],False);
		return;
	}
	if ( List ~= "shortcuts" )
	{
		i=0;
JL015C:
		if ( i < 64 )
		{
			PlayerPawn(self.Owner).ClientMessage(shortcuts[i]);
			i++;
			goto JL015C;
		}
		return;
	}
	i=InStr(List," ");
	if ( Left(List,i) ~= "set" )
	{
		List=Mid(List,i + 1);
	} else {
		return;
	}
	List=List $ "/";
	ml=Spawn(Class'ASMapList');
	StartMap=-1;
	i=0;
JL0208:
	if ( Left(List,InStr(List,"/")) != "" )
	{
		short=Left(List,InStr(List,"/"));
		if ( Left(short,1) == "!" )
		{
			if ( StartMap == -1 )
			{
				StartMap=i;
			} else {
				PlayerPawn(Owner).ClientMessage("Warning: more than one map specified as current");
			}
			short=Mid(short,1);
		}
		if ( short == "" )
		{
			PlayerPawn(Owner).ClientMessage("Warning: empty string specified");
		} else {
			j=0;
JL0302:
			if ( j < 64 )
			{
				if ( short == Left(shortcuts[j],InStr(shortcuts[j]," ")) )
				{
					ml.Maps[i]=Mid(shortcuts[j],InStr(shortcuts[j]," ") + 1);
					if ( StartMap == -1 )
					{
						ml.MapNum=i;
					}
					bFound=True;
				}
				j++;
				goto JL0302;
			}
			if (  !bFound )
			{
				ml.Maps[i]=short $ ".unr";
				if ( StartMap == -1 )
				{
					ml.MapNum=i;
				}
			} else {
				bFound=False;
			}
			i++;
			if ( i == 32 )
			{
				goto JL042D;
			}
			List=Mid(List,InStr(List,"/") + 1);
			goto JL0208;
		}
	}
JL042D:
	if ( StartMap != -1 )
	{
		ml.MapNum=StartMap;
	}
	i=i;
JL045B:
	if ( i < 32 )
	{
		ml.Maps[i]="";
		i++;
		goto JL045B;
	}
	ml.SaveConfig();
	ml.Destroy();
	MapList("");
}

simulated exec function RequestNextSlot ()
{
	bTakeNextSlot=True;
	PlayerPawn(Owner).ClientMessage("Lurking for next slot...");
}

simulated function PlayerLeft ()
{
	if ( bTakeNextSlot && (Owner != None) && Owner.IsA('Spectator') )
	{
		bTakeNextSlot=False;
		PlayerPawn(Owner).UpdateURL("OverrideClass","",True);
		PlayerPawn(Owner).ConsoleCommand("Reconnect");
	}
}

simulated function KillTriggeredTextures ()
{
	local TriggeredTexture A;

	foreach AllActors(Class'TriggeredTexture',A)
	{
		if ( A.DestinationTexture != None )
		{
			if ( ScriptedTexture(A.DestinationTexture) != None )
			{
				ScriptedTexture(A.DestinationTexture).NotifyActor=None;
			}
		}
		A.DestinationTexture=None;
	}
}

defaultproperties
{
    shortcuts(0)="ast AS-Asthenosphere.unr"
    shortcuts(1)="aut AS-AutoRIP.unr"
    shortcuts(2)="bal AS-Ballistic.unr"
    shortcuts(3)="bri AS-Bridge.unr"
    shortcuts(4)="dst AS-Desertstorm.unr"
    shortcuts(5)="dso AS-Desolate][.unr"
    shortcuts(6)="fri AS-Frigate.unr"
    shortcuts(7)="gol AS-GolgothaAL.unr"
    shortcuts(8)="gua AS-Guardia.unr"
    shortcuts(9)="gal AS-GuardiaAL.unr"
    shortcuts(10)="his AS-HiSpeed.unr"
    shortcuts(11)="lav AS-Lavafort][.unr"
    shortcuts(12)="maz AS-Mazon.unr"
    shortcuts(13)="oce AS-OceanFloor.unr"
    shortcuts(14)="oal AS-OceanFloorAL.unr"
    shortcuts(15)="ove AS-Overlord.unr"
    shortcuts(16)="riv AS-RiverbedAL.unr"
    shortcuts(17)="rv3 AS-Riverbed]l[AL"
    shortcuts(18)="roo AS-Rook.unr"
    shortcuts(19)="sie AS-Siege][.unr"
    shortcuts(20)="sub AS-SubmarineBase][.unr"
    shortcuts(21)="aal AS-AsthenosphereAL.unr"
    shortcuts(22)="rse AS-RocketCommandSE.unr"
    bshowmaplisttoall=True
    AttackerSpawnProt=4
    DefenderSpawnProt=2
    PickupMessage="Spawn protection has worn off."
    PickupMessageClass=Class'Botpack.PickupMessagePlus'
    NetUpdateFrequency=1.00
}