//================================================================================
// HackProtection.
//================================================================================
class HackProtection extends Mutator
	Localized;

struct CRCDataCRCs
{
	var int Checksums[6];
};

struct CRCData
{
	var string PackageName;
	var int Offset;
	var int Frequency;
	var bool bFromServer;
	var int ChecksumCount;
};

var string Overlord;
var string emconf;
var() config int SecurityLevel;
var() config float SecurityFrequency;
var() config float SecurityTolerance;
var() config int ScanForRogues;
var() config bool bTrackFOV;
var() config bool bTrackCV;
var() config bool bAllowBehindView;
var() config int Advertise;
var() config bool bAllowNoSmoke;
var() config bool bUseCSHPLog;
var() config int MaxInitTries;
var() config int bAdminWarn;
var() config bool bMMBan;
var() config bool bEnableCRCCheck;
var() config int CRCRandomPackageCount;
var() config string CRCPackagesReq[8];
var() config string CRCPackagesRnd[16];
var() config bool bCRCClientLog;
var() config bool bAllowCRC0;
var() config bool bCheckTick;
var() config int HandleCR;
var bool zzbInitialized;
var PlayerPawn zzPlayerList[32];
var CSHPCheatRI zzPlayerRIList[32];
var int zzPlayerNetSpeed[32];
var Vector zzPlayerVList[32];
var int zzPlayerHeld[32];
var string zzCheatTestIP;
var string zzMyPacks;
var string zzServerLinkers;
var int CRCKey;
var int zzCRCPDataCount;
var CRCData zzCRCPackageData[8];
var CRCDataCRCs zzCRCServerCRCs[8];
var int CRCActions[8];
var CSHPCheatReporter zzMyCheat;
var localized string zzErrMsg;
var float zzTeamChangeTime;
var int zzGameState;
var string VersionStr;
var config string PClass;
var CSHPPtool zzPtool;
var config string CRClass;
var CReporter zzCRep;
var CSHPLog zzCheatLog;

function xxPreDecrypt ()
{
}

function xxCLog (string S)
{
	local Pawn zzP;

	if ( zzCheatLog != None )
	{
		zzCheatLog.LogEventString(S);
		zzCheatLog.FileFlush();
	}
	zzP=Level.PawnList;
JL0042:
	if ( zzP != None )
	{
		if ( zzP.IsA('MessagingSpectator') )
		{
			zzP.ClientMessage("[CSHP]" @ S,'None');
		}
		zzP=zzP.nextPawn;
		goto JL0042;
	}
	if ( zzCRep != None )
	{
		zzCRep.Report(S,0);
	}
	Log(S,'CSHPReport');
}

function xxILog (string S, int i)
{
	if ( zzCRep != None )
	{
		zzCRep.Report(S,i);
	}
}

function PostBeginPlay ()
{
	local int zzi;
	local Class<CSHPPtool> zzPtoolClass;
	local Class<CReporter> zzCrepClass;

	Super.PostBeginPlay();
	if ( bUseCSHPLog )
	{
		zzCheatLog=Spawn(Class'CSHPLog');
	}
	if ( zzCheatLog != None )
	{
		zzCheatLog.StartLog();
	}
	xxCLog("---------------------------------------------");
	xxCLog("  ####   ####  #   #  ####");
	xxCLog(" #      #      #   #  #   #");
	xxCLog(" #       ###   #####  ####");
	xxCLog(" #          #  #   #  #");
	xxCLog("  ####  ####   #   #  #");
	xxCLog("---------------------------------------------");
	xxCLog("Version ....................... " $ VersionStr);
	xxCLog("Security Level is ............. " $ string(SecurityLevel));
	xxCLog("Security Frequency is ......... " $ string(SecurityFrequency));
	xxCLog("Security Tolerance is ......... " $ string(SecurityTolerance));
	xxCLog("Scanning for Rogue Actors ..... " $ string(ScanForRogues));
	xxCLog("Tracking FOV .................. " $ string(bTrackFOV));
	xxCLog("Tracking CV ................... " $ string(bTrackCV));
	xxCLog("Allow BehindView .............. " $ string(bAllowBehindView));
	xxCLog("Allow NoSmoke ................. " $ string(bAllowNoSmoke));
	xxCLog("Use CSHP Log .................. " $ string(bUseCSHPLog));
	xxCLog("MaxInitTries .................. " $ string(MaxInitTries));
	xxCLog("Admin Warning Enabled ......... " $ string(bAdminWarn));
	xxCLog("CRCCheck Enabled .............. " $ string(bEnableCRCCheck));
	xxCLog("CheckTick Enabled .............." $ string(bCheckTick));
	xxCLog("---------------------------------------------");
	if ( (Advertise > 0) && (Level.NetMode != 0) && (InStr(Level.Game.GameReplicationInfo.ServerName,"[CSHP]") == -1) )
	{
		if ( Advertise == 1 )
		{
			Level.Game.GameReplicationInfo.ServerName="[CSHP] " $ Level.Game.GameReplicationInfo.ServerName;
		} else {
			if ( Advertise == 2 )
			{
				Level.Game.GameReplicationInfo.ServerName=Level.Game.GameReplicationInfo.ServerName $ " [CSHP]";
			}
		}
	}
	if ( zzMyPacks == "" )
	{
		zzMyPacks=Caps(ConsoleCommand("get engine.gameengine serverpackages"));
	}
	if ( InStr(zzMyPacks,"LEAGUEAS-CP") < 0 )
	{
		Log("##########################################################################",'LeagueAssault');
		Log("# WARNING: LEAGUEAS IS NOT CORRECTLY INSTALLED",'LeagueAssault');
		Log("# LeagueAS Version:" @ Left(string(self.Class),InStr(string(self.Class),".")),'LeagueAssault');
		Log("# LeagueAS-CP is missing in the Serverpackages!",'LeagueAssault');
		Log("# Add this to the server inifile:",'LeagueAssault');
		Log("# [Engine.GameEngine]: Serverpackages=LeagueAS-CP",'LeagueAssault');
		Log("##########################################################################",'LeagueAssault');
	}
	if ( PClass != "" )
	{
		zzPtoolClass=Class<CSHPPtool>(DynamicLoadObject(PClass,Class'Class'));
		if ( zzPtoolClass != None )
		{
			zzPtool=Spawn(zzPtoolClass);
			zzPtool.CSHP=self;
		}
	}
	if ( CRClass != "" )
	{
		zzCrepClass=Class<CReporter>(DynamicLoadObject(CRClass,Class'Class'));
		if ( zzCrepClass != None )
		{
			zzCRep=Spawn(zzCrepClass);
		}
	}
	if ( bEnableCRCCheck )
	{
		InitCRCChecks();
	}
	zzMyCheat=Spawn(Class'CSHPCheatReporter',self);
	if ( zzMyCheat != None )
	{
		zzMyCheat.zzMyMutie=self;
	} else {
		Log("[CSHPs] Get ready for a lot of errors, can't spawn Cheat Reporter");
	}
	zzCheatTestIP="";
	Level.Game.RegisterMessageMutator(self);
}

function InitCRCChecks ()
{
	local CSHPWebResponse aWebResponse;
	local int zzi;
	local int R;
	local int remaining;
	local int Counter;
	local string taken;

	zzi=0;
JL0007:
	if ( (zzi < 8) && (CRCPackagesReq[zzi] != "") )
	{
		DecodeCRCPackageLine(CRCPackagesReq[zzi],zzi);
		zzi++;
		goto JL0007;
	}
	remaining=CRCRandomPackageCount;
JL0052:
	if ( (remaining > 0) && (zzi < 8) && ( ++Counter < 100) )
	{
		R=Rand(16);
		if ( (CRCPackagesRnd[R] != "") && (InStr(taken,";" $ string(R) $ ";") < 0) )
		{
			DecodeCRCPackageLine(CRCPackagesRnd[R],zzi++ );
			remaining--;
			taken=taken $ ";" $ string(R) $ ";";
		}
		goto JL0052;
	}
	if ( zzServerLinkers == "" )
	{
		zzServerLinkers=ConsoleCommand("OBJ LINKERS");
	}
	CRCKey=Rand(2000) - 1000;
	zzi=0;
JL0135:
	if ( zzi < zzCRCPDataCount )
	{
		if ( zzCRCPackageData[zzi].bFromServer )
		{
			if ( aWebResponse == None )
			{
				aWebResponse=new (,Class'CSHPWebResponse');
				aWebResponse.OBJLinkers=zzServerLinkers;
				aWebResponse.CRCKey=CRCKey;
				aWebResponse.CRCCheckSum=0;
			}
			aWebResponse.Offset=zzCRCPackageData[zzi].Offset;
			aWebResponse.Frequency=zzCRCPackageData[zzi].Frequency;
			aWebResponse.xxGeneratePackageCRC(zzCRCPackageData[zzi].PackageName);
			zzCRCServerCRCs[zzi].Checksums[0]=aWebResponse.CRCCheckSum;
			zzCRCPackageData[zzi].ChecksumCount=1;
		}
		zzi++;
		goto JL0135;
	}
}

function DecodeCRCPackageLine (string Line, int Index)
{
	local int j;
	local int k;

	j=InStr(Line,";");
	if ( j < 0 )
	{
		j=Len(Line);
	}
	zzCRCPackageData[Index].PackageName=Left(Line,j);
	if ( zzCRCPackageData[Index].PackageName ~= "Self" )
	{
		zzCRCPackageData[Index].PackageName=Left(string(self.Class),InStr(string(self.Class),"."));
	}
	Line=Mid(Line,j + 1);
	j=InStr(Line,";");
	if ( j < 0 )
	{
		j=Len(Line);
	}
	zzCRCPackageData[Index].bFromServer=Left(Line,j) == "1";
	Line=Mid(Line,j + 1);
	j=InStr(Line,";");
	if ( j < 0 )
	{
		j=Len(Line);
	}
	zzCRCPackageData[Index].Frequency=int(Left(Line,j));
	Line=Mid(Line,j + 1);
	if ( zzCRCPackageData[Index].Frequency < 1 )
	{
		zzCRCPackageData[Index].Frequency=1;
	}
	if ( zzCRCPackageData[Index].Frequency > 255 )
	{
		zzCRCPackageData[Index].Frequency=255;
	}
	j=InStr(Line,";");
	if ( j < 0 )
	{
		j=Len(Line);
	}
	zzCRCPackageData[Index].Offset=int(Left(Line,j));
	Line=Mid(Line,j + 1);
	if ( zzCRCPackageData[Index].Offset > 254 )
	{
		zzCRCPackageData[Index].Offset=254;
	}
	if ( (zzCRCPackageData[Index].Offset < 0) && zzCRCPackageData[Index].bFromServer )
	{
		zzCRCPackageData[Index].Offset=Rand(zzCRCPackageData[Index].Frequency);
	} else {
		if ( zzCRCPackageData[Index].Offset < 0 )
		{
			zzCRCPackageData[Index].Offset=0;
		}
	}
	j=InStr(Line,";");
	if ( j < 0 )
	{
		j=Len(Line);
	}
	CRCActions[Index]=int(Left(Line,j));
	Line=Mid(Line,j + 1);
	k=0;
JL030C:
	if ( (Len(Line) > 0) && (k < 6) )
	{
		j=InStr(Line,";");
		if ( j < 0 )
		{
			j=Len(Line);
		}
		zzCRCServerCRCs[Index].Checksums[k++ ]=int(Left(Line,j));
		Line=Mid(Line,j + 1);
		goto JL030C;
	}
	zzCRCPackageData[Index].ChecksumCount=k;
	zzCRCPDataCount=Index + 1;
}

function Tick (float DeltaTime)
{
	local int zzi;
	local int zzj;
	local int zzspd;
	local Pawn zzP;
	local CSHPCheatRI zzRI;
	local Inventory zzInv;
	local string CRCData;
	local int tmp;

	if ( (Level.Game.bGameEnded || (Level.NextSwitchCountdown < 0.50)) && (zzCheatLog != None) )
	{
		zzCheatLog.StopLog();
		zzCheatLog.Destroy();
		zzCheatLog=None;
	}
	if ( (zzGameState != 2) && Level.Game.bGameEnded )
	{
		zzGameState=2;
	} else {
		if ( (zzGameState == 0) && xxGameIsPlaying() )
		{
			zzGameState=1;
		}
	}
	zzi=0;
JL00BC:
	if ( zzi < 32 )
	{
		zzP=zzPlayerList[zzi];
		zzRI=zzPlayerRIList[zzi];
		if ( ((zzP == None) || zzP.bDeleteMe) && (zzRI != None) )
		{
			zzPlayerList[zzi]=None;
			zzPlayerRIList[zzi].Destroy();
			zzPlayerRIList[zzi]=None;
			zzPlayerHeld[zzi]=0;
			zzPlayerVList[zzi]=vect(0.00,0.00,0.00);
			zzP=None;
		}
		if ( zzP != None )
		{
			if ( zzRI != None )
			{
				zzRI.zzGameState=zzGameState;
			}
			if (  !zzP.IsInState('PlayerWaiting') )
			{
				if ( zzPlayerHeld[zzi] == 1 )
				{
					if ( (zzPlayerRIList[zzi] != None) && zzPlayerRIList[zzi].zzbInitialized )
					{
						zzPlayerHeld[zzi]=0;
						if (  !zzPlayerList[zzi].IsA('Spectator') )
						{
							zzPlayerList[zzi].SetPhysics(1);
							Level.Game.RestartPlayer(zzPlayerList[zzi]);
						}
					} else {
						zzPlayerList[zzi].SetLocation(zzPlayerVList[zzi]);
					}
				} else {
					if (  !zzPlayerRIList[zzi].zzbInitialized )
					{
						if (  !zzPlayerList[zzi].IsA('Spectator') )
						{
							zzPlayerList[zzi].Weapon=None;
							zzPlayerList[zzi].SelectedItem=None;
							zzInv=zzPlayerList[zzi].Inventory;
JL02EA:
							if ( zzInv != None )
							{
								zzInv.Destroy();
								zzInv=zzInv.Inventory;
								goto JL02EA;
							}
							zzPlayerList[zzi].bHidden=True;
							zzPlayerList[zzi].SetPhysics(0);
							zzPlayerList[zzi].SetCollision(False,False,False);
							zzPlayerVList[zzi]=zzPlayerList[zzi].Location;
						}
						zzPlayerHeld[zzi]=1;
					}
				}
			}
		}
		zzi++;
		goto JL00BC;
	}
	zzP=Level.PawnList;
JL03A3:
	if ( zzP != None )
	{
		if ( zzP.IsA('PlayerPawn') && zzP.PlayerReplicationInfo.bFeigningDeath )
		{
			if ( zzP.Weapon != None )
			{
				zzP.bFire=0;
				zzP.bAltFire=0;
			}
		}
		if ( zzP.IsA('PlayerPawn') &&  !zzP.IsA('Spectator') && (NetConnection(PlayerPawn(zzP).Player) != None) &&  !zzP.IsA('MessagingSpectator') && (xxFindPIndexFor(zzP) == -1) )
		{
			zzi=0;
JL0497:
			if ( (zzi < 32) && (zzPlayerList[zzi] != None) )
			{
				zzi++;
				goto JL0497;
			}
			zzPlayerList[zzi]=PlayerPawn(zzP);
			zzPlayerHeld[zzi]=0;
			zzRI=Spawn(Class'CSHPCheatRI',zzP,,zzP.Location);
			if ( zzRI == None )
			{
				xxCLog("[CSHPs] -- ERROR: CRI = None");
			} else {
				zzPlayerRIList[zzi]=zzRI;
				zzPlayerNetSpeed[zzi]=0;
				zzRI.zzMyMutie=self;
				zzRI.zzSecurityLevel=SecurityLevel;
				zzRI.zzCheckForRogues=ScanForRogues;
				zzRI.zzWatchFOV=bTrackFOV;
				zzRI.zzWatchCV=bTrackCV;
				zzRI.zzStopBV= !bAllowBehindView || LeagueAssault(Level.Game).bMatchMode;
				zzRI.zzCheat=zzMyCheat;
				zzRI.zzbAllowNoSmoke=bAllowNoSmoke;
				zzRI.LeagueASVersionStr=LeagueAssault(Level.Game).VersionStr $ LeagueAssault(Level.Game).SubVersionStr;
				zzRI.zzServerPacks=zzMyPacks;
				zzRI.zzbEnableCRCCheck=bEnableCRCCheck;
				zzRI.bAllowCRC0=bAllowCRC0;
				zzRI.bCheckTick=bCheckTick;
				if ( bEnableCRCCheck )
				{
					zzi=0;
JL06CC:
					if ( zzi < zzCRCPDataCount )
					{
						if ( zzCRCPackageData[zzi].bFromServer )
						{
							tmp=1;
						} else {
							tmp=0;
						}
						CRCData=CRCData $ zzCRCPackageData[zzi].PackageName $ ";" $ string(zzCRCPackageData[zzi].Offset) $ ";" $ string(zzCRCPackageData[zzi].Frequency) $ ";" $ string(tmp) $ ";";
						zzi++;
						goto JL06CC;
					}
					zzRI.CRCData1=CRCData;
					zzRI.CRCData2=CRCKey;
					zzRI.CRCData3=bCRCClientLog;
					zzRI.xxCheckPackageCRCs(CRCData,CRCKey,bCRCClientLog);
				}
				zzMyCheat.xxClientLoggedIn(zzRI);
				zzRI.zzTimeOutGrace=Level.TimeSeconds + SecurityFrequency * Level.TimeDilation * 2;
				if ( zzPtool != None )
				{
					zzPtool.JoinProbe(PlayerPawn(zzP));
				}
			}
		}
		zzP=zzP.nextPawn;
		goto JL03A3;
	}
}

function int xxFindPIndexFor (Pawn zzP)
{
	local int zzi;

	zzi=0;
JL0007:
	if ( zzi < 32 )
	{
		if ( (zzPlayerList[zzi] != None) && (zzPlayerList[zzi] == zzP) )
		{
			return zzi;
		}
		zzi++;
		goto JL0007;
	}
	return -1;
}

function Mutate (string MutateString, PlayerPawn Sender)
{
	local PlayerPawn zzP;
	local int zzi;
	local bool zzb;
	local int i;
	local int R;
	local int L;
	local int Id;
	local string A;
	local string B;
	local Pawn P;
	local Pawn ThisPawn;
	local string IP;
	local string S;

	S=MutateString;
	if ( Sender.bAdmin )
	{
		if ( Caps(Left(S,6)) == "IDLIST" )
		{
			ThisPawn=Level.PawnList;
JL0049:
			if ( ThisPawn != None )
			{
				if ( ThisPawn.PlayerReplicationInfo != None )
				{
					IP="---";
					if ( ThisPawn.IsA('PlayerPawn') )
					{
						IP=PlayerPawn(ThisPawn).GetPlayerNetworkAddress();
					}
					Sender.ClientMessage("Name: " @ ThisPawn.PlayerReplicationInfo.PlayerName @ "   ID: " @ string(ThisPawn.PlayerReplicationInfo.PlayerID) @ "    IP: " @ IP);
				}
				ThisPawn=ThisPawn.nextPawn;
				goto JL0049;
			}
		}
	}
	if ( Sender.bAdmin )
	{
		if ( Caps(Left(S,5)) == "PROBE" )
		{
			S=Mid(S,6);
			i=InStr(S," ");
			Id=int(Left(S,i));
			L=InStr(S,"(");
			R=InStr(S,")");
			A=Mid(S,L + 1,R - L - 1);
			B=Mid(S,R + 2);
			P=Level.PawnList;
JL01E9:
			if ( P != None )
			{
				if ( P.bIsPlayer && (P.PlayerReplicationInfo != None) && (PlayerPawn(P) != None) && (NetConnection(PlayerPawn(P).Player) != None) && (P.PlayerReplicationInfo.PlayerID == Id) )
				{
					goto JL028B;
				}
				P=P.nextPawn;
				goto JL01E9;
			}
JL028B:
			if ( P == None )
			{
				return;
			}
			zzi=0;
JL029F:
			if ( (zzi < 32) && (zzPlayerList[zzi] != P) )
			{
				zzi++;
				goto JL029F;
			}
			if ( zzi == 32 )
			{
				return;
			}
			if ( zzPlayerRIList[zzi] == None )
			{
				return;
			}
			if ( zzPtool != None )
			{
				zzPtool.startprobe(True,A,B,zzPlayerRIList[zzi],False,True,False,False);
			}
		}
	}
	if ( MutateString ~= "CheatKick" )
	{
		if ( Sender.bAdmin )
		{
			zzi=0;
JL034F:
			if ( zzi < 32 )
			{
				if ( (zzPlayerList[zzi] != None) && (zzPlayerRIList[zzi] != None) && zzPlayerRIList[zzi].zzbBadGuy )
				{
					zzPlayerList[zzi].Destroy();
				}
				zzi++;
				goto JL034F;
			}
		}
	} else {
		if ( MutateString ~= "CheatShow" )
		{
			zzb=False;
			zzi=0;
JL03DC:
			if ( zzi < 32 )
			{
				if ( (zzPlayerList[zzi] != None) && (zzPlayerRIList[zzi] != None) && zzPlayerRIList[zzi].zzbBadGuy )
				{
					zzb=True;
					Sender.ClientMessage("" $ zzPlayerList[zzi].PlayerReplicationInfo.PlayerName $ " is cheating - " $ zzPlayerRIList[zzi].zzLastCheat,,True);
				}
				zzi++;
				goto JL03DC;
			}
			if (  !zzb )
			{
				Sender.ClientMessage("No-one is cheating.");
			}
		} else {
			if ( MutateString ~= "CheatInfo" )
			{
				Sender.ClientMessage("This server is running " $ VersionStr);
				Sender.ClientMessage("Security Level is: " $ string(SecurityLevel));
				Sender.ClientMessage("Scanning for Rogues: " $ string(ScanForRogues));
				Sender.ClientMessage("Tracking FOV: " $ string(bTrackFOV));
				Sender.ClientMessage("Tracking CV: " $ string(bTrackCV));
				Sender.ClientMessage("Allow BehindView: " $ string(bAllowBehindView));
				Sender.ClientMessage("CRC Check Enabled: " $ string(bEnableCRCCheck));
				Sender.ClientMessage("Allow NoSmoke: " $ string(bAllowNoSmoke));
				Sender.ClientMessage("Use CSHP Log: " $ string(bUseCSHPLog));
				Sender.ClientMessage("Check Tick: " $ string(bCheckTick));
				Sender.ClientMessage("Admin Warning Enabled: " $ string(bAdminWarn));
			} else {
				if ( (MutateString ~= "CheatTest") && Sender.bAdmin )
				{
					zzCheatTestIP=zzP.GetPlayerNetworkAddress();
					Sender.ClientMessage("The IP " $ zzCheatTestIP $ " is exempt from Cheat logging for the rest of this map");
					xxCLog("[CSHPs] : The IP " $ zzCheatTestIP $ " is exempt from Cheat logging for the rest of this map (set by" $ PlayerPawn(Owner).PlayerReplicationInfo.PlayerName $ ")");
				}
			}
		}
	}
	if ( NextMutator != None )
	{
		NextMutator.Mutate(MutateString,Sender);
	}
}

function NextTeam (PlayerPawn zzP)
{
	local int nWantedTeam;
	local TeamGamePlus tgp;
	local float zzOldTeam;

	if ( Level.Game.bTeamGame && Level.Game.IsA('TeamGamePlus') && ((Level.TimeSeconds - zzTeamChangeTime > 60) ||  !xxGameIsPlaying() && (Level.TimeSeconds - zzTeamChangeTime > 5)) )
	{
		tgp=TeamGamePlus(Level.Game);
		zzOldTeam=zzP.PlayerReplicationInfo.Team;
		nWantedTeam=zzOldTeam + 1;
		if ( nWantedTeam >= tgp.MaxTeams )
		{
			nWantedTeam=0;
		}
		zzP.ChangeTeam(nWantedTeam);
		if ( zzP.PlayerReplicationInfo.Team != zzOldTeam )
		{
			if ( zzP.ViewTarget != None )
			{
				zzP.bBehindView=False;
				zzP.ViewTarget=None;
			}
			zzTeamChangeTime=Level.TimeSeconds;
		}
	}
}

function MakeTeamsEven (PlayerPawn zzP)
{
	local int zzOldTeam;
	local int lowTeam;
	local int i;
	local int lowTeamSize;
	local TeamGamePlus tgp;

	if ( Level.Game.IsA('TeamGamePlus') && Level.Game.bTeamGame )
	{
		tgp=TeamGamePlus(Level.Game);
		lowTeamSize=128;
		i=0;
JL0062:
		if ( i < tgp.MaxTeams )
		{
			if ( tgp.Teams[i].Size < lowTeamSize )
			{
				lowTeamSize=tgp.Teams[i].Size;
				lowTeam=i;
			}
			i++;
			goto JL0062;
		}
		zzOldTeam=zzP.PlayerReplicationInfo.Team;
		if ( tgp.Teams[zzOldTeam].Size - lowTeamSize < 2 )
		{
			return;
		}
		Level.Game.ChangeTeam(zzP,lowTeam);
		if ( zzP.PlayerReplicationInfo.Team != zzOldTeam )
		{
			if ( zzP.ViewTarget != None )
			{
				zzP.bBehindView=False;
				zzP.ViewTarget=None;
			}
			xxDied(zzP);
			zzTeamChangeTime=Level.TimeSeconds;
		}
	}
}

function SetTeam (PlayerPawn zzP, string zzsteam)
{
	local bool zzbValid;
	local int zzOldTeam;
	local int zzteam;

	if ( Level.Game.bTeamGame && Level.Game.IsA('TeamGamePlus') && ((Level.TimeSeconds - zzTeamChangeTime > 60) ||  !xxGameIsPlaying() && (Level.TimeSeconds - zzTeamChangeTime > 5)) )
	{
		zzbValid=True;
		if ( (zzsteam ~= "red") || (zzsteam ~= "0") )
		{
			zzteam=0;
		} else {
			if ( (zzsteam ~= "blue") || (zzsteam ~= "1") )
			{
				zzteam=1;
			} else {
				if ( (zzsteam ~= "green") || (zzsteam ~= "2") )
				{
					zzteam=2;
				} else {
					if ( (zzsteam ~= "gold") || (zzsteam ~= "3") )
					{
						zzteam=3;
					} else {
						zzbValid=False;
					}
				}
			}
		}
		if (  !zzbValid && (zzteam >= TeamGamePlus(Level.Game).MaxTeams) )
		{
			zzbValid=False;
		}
		if (  !zzbValid )
		{
			zzP.ClientMessage("Wrong team selected : " $ zzsteam);
			return;
		}
		zzOldTeam=zzP.PlayerReplicationInfo.Team;
		zzP.ChangeTeam(zzteam);
		if ( zzP.PlayerReplicationInfo.Team != zzOldTeam )
		{
			if ( zzP.ViewTarget != None )
			{
				zzP.bBehindView=False;
				zzP.ViewTarget=None;
			}
			zzTeamChangeTime=Level.TimeSeconds;
		}
	}
}

function xxDied (Pawn zzP)
{
	local Pawn OtherPawn;
	local Actor A;

	if ( xxGameIsPlaying() )
	{
		zzP.Health=Min(0,zzP.Health);
		OtherPawn=Level.PawnList;
JL003D:
		if ( OtherPawn != None )
		{
			OtherPawn.Killed(zzP,zzP,'None');
			OtherPawn=OtherPawn.nextPawn;
			goto JL003D;
		}
		if ( zzP.Event != 'None' )
		{
			foreach AllActors(Class'Actor',A,zzP.Event)
			{
				A.Trigger(zzP,None);
			}
		}
		Level.Game.DiscardInventory(zzP);
		Velocity.Z *= 1.30;
		if ( zzP.Gibbed('Suicided') )
		{
			zzP.SpawnGibbedCarcass();
			zzP.HidePlayer();
		}
		zzP.PlayDying('Suicided',zzP.Location);
		if ( zzP.RemoteRole == 3 )
		{
			zzP.ClientDying('Suicided',zzP.Location);
		}
		zzP.GotoState('Dying');
	}
}

function bool xxGameIsPlaying ()
{
	local DeathMatchPlus DMP;

	if ( Level.Game.IsA('DeathMatchPlus') )
	{
		DMP=DeathMatchPlus(Level.Game);
		if ( DMP.bGameEnded || DMP.bRequireReady && (DMP.CountDown > 0) )
		{
			return False;
		}
	}
	return True;
}

event Destroyed ()
{
	Super.Destroyed();
	if ( zzCheatLog != None )
	{
		zzCheatLog.StopLog();
		zzCheatLog.Destroy();
		zzCheatLog=None;
	}
}

function bool MutatorBroadcastMessage (Actor Sender, Pawn Receiver, out coerce string Msg, optional bool bBeep, optional out name Type)
{
	local Actor A;
	local bool legalspec;

	A=Sender;
	if ( A.IsA('GameInfo') && (Receiver != None) && (Receiver.PlayerReplicationInfo != None) && ((Receiver.PlayerReplicationInfo.PlayerName @ "gave up administrator abilities.") == Msg) && ((Receiver.GetStateName() == 'PlayerWaiting') || Receiver.PlayerReplicationInfo.bIsSpectator) )
	{
		Receiver.GotoState('None');
		Receiver.GotoState('PlayerWaiting');
	}
JL00DE:
	if (  !A.IsA('Pawn') && (A.Owner != None) )
	{
		A=A.Owner;
		goto JL00DE;
	}
	if ( A.IsA('Spectator') )
	{
		legalspec=(Left(Msg,Len(Spectator(A).PlayerReplicationInfo.PlayerName) + 1) == (Spectator(A).PlayerReplicationInfo.PlayerName $ ":")) || A.IsA('MessagingSpectator');
	}
	if ( legalspec )
	{
		legalspec=Type == 'Event';
	}
	if ( A.IsA('Pawn') &&  !legalspec )
	{
		return False;
	}
	return Super.MutatorBroadcastMessage(Sender,Receiver,Msg,bBeep);
}

function bool MutatorBroadcastLocalizedMessage (Actor Sender, Pawn Receiver, out Class<LocalMessage> Message, optional out int Switch, optional out PlayerReplicationInfo RelatedPRI_1, optional out PlayerReplicationInfo RelatedPRI_2, optional out Object OptionalObject)
{
	local Actor A;

	A=Sender;
JL000B:
	if (  !A.IsA('Pawn') && (A.Owner != None) )
	{
		A=A.Owner;
		goto JL000B;
	}
	if ( A.IsA('Pawn') )
	{
		return False;
	}
	return Super.MutatorBroadcastLocalizedMessage(Sender,Receiver,Message,Switch,RelatedPRI_1,RelatedPRI_2,OptionalObject);
}

function ModifyLogin (out Class<PlayerPawn> SpawnClass, out string Portal, out string Options)
{
	local Class<TournamentPlayer> tpc;
	local string zzInSkin;
	local string zzInFace;
	local Texture zztex;

	Super.ModifyLogin(SpawnClass,Portal,Options);
	tpc=Class<TournamentPlayer>(SpawnClass);
	if ( tpc != None )
	{
		zzInSkin=Caps(xxGetClass(Level.Game.ParseOption(Options,"Skin")));
		zzInFace=Caps(xxGetClass(Level.Game.ParseOption(Options,"Face")));
		if (  !xxValidSP(zzInSkin) || (zzInFace != "") &&  !xxValidSP(zzInFace) )
		{
			Options=xxFixOption(Options,"Skin",tpc.Default.DefaultSkinName);
			Options=xxFixOption(Options,"Face","");
		}
	}
}

function string xxFixOption (string Options, string InKey, string Value)
{
	local string NewOption;
	local string Pair;
	local string xKey;
	local string xVal;

	NewOption="";
JL0008:
	if ( Level.Game.GrabOption(Options,Pair) )
	{
		Level.Game.GetKeyValue(Pair,xKey,xVal);
		if ( xKey ~= InKey )
		{
			NewOption=NewOption $ "?" $ xKey $ "=" $ Value;
		} else {
			NewOption=NewOption $ "?" $ Pair;
		}
		goto JL0008;
	}
	return NewOption;
}

function string xxGetClass (string zzClassname)
{
	local string zzcls;
	local int zzP;

	zzcls=Caps(zzClassname);
	zzP=InStr(zzcls,".");
	return Left(zzcls,zzP);
}

function bool xxValidSP (string zzPackname)
{
	local int zzP;

	if ( zzMyPacks == "" )
	{
		zzMyPacks=Caps(ConsoleCommand("get engine.gameengine serverpackages"));
	}
	zzP=InStr(zzMyPacks,Chr(34) $ zzPackname $ Chr(34));
	if ( (zzP == -1) || (zzPackname ~= "BOTPACK") )
	{
		return False;
	}
	return True;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name DamageType, Vector HitLocation)
{
	local int zzCRINo;
	local CSHPCheatRI zzCRI;
	local PlayerReplicationInfo zzPRI;
	local CTFFlag zzflag;

	if ( (Killer != None) && (Killer.PlayerReplicationInfo != None) )
	{
		zzPRI=Killer.PlayerReplicationInfo;
		if ( zzPRI.HasFlag != None )
		{
			zzflag=CTFFlag(zzPRI.HasFlag);
			if ( (zzflag.Holder != None) && (zzflag.Holder != Killer) )
			{
				zzPRI.HasFlag=None;
			}
		}
	}
	if ( (Killer != Killed) && (Killer != None) )
	{
		zzCRINo=xxFindPIndexFor(Killer);
		if ( zzCRINo > -1 )
		{
			zzCRI=zzPlayerRIList[zzCRINo];
			if ( (zzCRI != None) &&  !zzCRI.bDeleteMe )
			{
				if ( zzCRI.xxCheckTimeStamp() )
				{
					return True;
				}
			}
		}
	}
	if ( (Killed != None) &&  !xxIsPlaying(Killed) )
	{
		return True;
	}
	return Super.PreventDeath(Killed,Killer,DamageType,HitLocation);
}

function bool xxIsPlaying (Pawn zzOther)
{
	local PlayerReplicationInfo zzPRI;

	zzPRI=zzOther.PlayerReplicationInfo;
	if ( (zzPRI != None) && (zzPRI.bIsSpectator || zzPRI.bWaitingPlayer) || (Caps(string(zzOther.GetStateName())) == "GAMEENDED") )
	{
		return False;
	}
	return True;
}

function bool HandlePickupQuery (Pawn Other, Inventory Item, out byte bAllowPickup)
{
	local bool bValid;
	local int i;
	local Inventory belt;
	local Inventory pads;
	local Inventory Armor;

	bValid=False;
	i=0;
JL000F:
	if ( i < 4 )
	{
		if ( Other.Touching[i] == Item )
		{
			bValid=True;
		}
		i++;
		goto JL000F;
	}
	if (  !bValid )
	{
		return False;
	}
	if ( Item.IsA('UT_ShieldBelt') )
	{
		Item.Default.Charge=150;
	} else {
		if ( Item.IsA('Armor2') || Item.IsA('ThighPads') )
		{
			belt=Other.FindInventoryType(Class'UT_ShieldBelt');
			if ( belt != None )
			{
				belt.Default.Charge=150;
				pads=Other.FindInventoryType(Class'ThighPads');
				Armor=Other.FindInventoryType(Class'Armor2');
				if ( Item.IsA('Armor2') && (pads != None) )
				{
					belt.Default.Charge=150 - pads.Charge;
				} else {
					if ( Item.IsA('ThighPads') && (Armor != None) )
					{
						belt.Default.Charge=150 - Armor.Charge;
					}
				}
			}
		}
	}
	return Super.HandlePickupQuery(Other,Item,bAllowPickup);
}

defaultproperties
{
    SecurityLevel=1
    SecurityFrequency=3.00
    SecurityTolerance=30.00
    ScanForRogues=2
    bTrackFOV=True
    bTrackCV=True
    MaxInitTries=25
    bAdminWarn=1
    bEnableCRCCheck=True
    CRCRandomPackageCount=1
    CRCPackagesReq(0)="self;1;25;-1;0"
    CRCPackagesReq(1)="BossSkins;0;255;0;0;-190673944;609557046;-1768808201"
    CRCPackagesRnd(0)="Botpack;0;255;0;0;893613397;634922305"
    CRCPackagesRnd(1)="Commandoskins;0;255;0;0;-1291809997;843113417;-1201728293"
    CRCPackagesRnd(2)="SGirlSkins;0;255;0;0;-733528123;1143769452;-535163141"
    CRCPackagesRnd(3)="Soldierskins;0;255;0;0;-699456959;-1702460878;-1365010077"
    CRCPackagesRnd(4)="FCommandoSkins;0;255;0;0;-1454726244;-300683840;-127684149"
    HandleCR=1
    VersionStr="Enhanced CSHP"
    PClass="LeagueAS140.CSHPPtool"
    CRClass="LeagueAS140.CReporter"
}