//================================================================================
// EmoteChildWindow.
//================================================================================
class EmoteChildWindow extends EmoteWindow;

var int OptionOffset;
var int MinOptions;
var EmoteWindow EmoteParent;
var int EmoticonCount;
var int OtherOffset[32];
var config int SubMenusVisible;

function Created ()
{
	local int i;
	local int j;
	local int W;
	local int H;
	local float XMod;
	local float YMod;
	local Color TextColor;

	H=Root.WinWidth / 4;
	W=H;
	if ( (W > 256) || (H > 256) )
	{
		W=256;
		H=256;
	}
	XMod=4.00 * W;
	YMod=3.00 * H;
	EmoteParent=EmoteWindow(ParentWindow);
	CurrentType=EmoteParent.CurrentType;
	EmoticonCount=EmoteParent.EmoticonCount;
	NumOptions=EmoticonCount - CurrentType * EmotesPerCategory;
	NumOptions=Max(0,NumOptions);
	NumOptions=Min(EmotesPerCategory,NumOptions);
	Super.Created();
	i=0;
JL00FF:
	if ( i < NumOptions )
	{
		if ( EmoteParent.GetEmote(CurrentType * EmotesPerCategory + i).bsimple )
		{
			OptionButtons[i].Text=":" $ EmoteParent.GetEmote(CurrentType * EmotesPerCategory + i).Code;
		} else {
			OptionButtons[i].Text=":" $ EmoteParent.GetEmote(CurrentType * EmotesPerCategory + i).Code $ ":";
		}
		i++;
		goto JL00FF;
	}
	TopButton.OverTexture=Texture'OrdersTopArrow';
	TopButton.UpTexture=Texture'OrdersTopArrow';
	TopButton.DownTexture=Texture'OrdersTopArrow';
	TopButton.WinLeft=0.00;
	BottomButton.OverTexture=Texture'OrdersBtmArrow';
	BottomButton.UpTexture=Texture'OrdersBtmArrow';
	BottomButton.DownTexture=Texture'OrdersBtmArrow';
	BottomButton.WinLeft=0.00;
	MinOptions=Min(SubMenusVisible,NumOptions);
	WinTop=196.00 / 768.00 * YMod + 32.00 / 768.00 * YMod * -1;
	WinLeft=256.00 / 1024.00 * XMod;
	WinWidth=256.00 / 1024.00 * XMod;
	WinHeight=32.00 / 768.00 * YMod * (MinOptions + 2);
	SetButtonTextures(CurrentType,True,False);
}

function BeforePaint (Canvas C, float X, float Y)
{
	local int W;
	local int H;
	local float XWidth;
	local float YHeight;
	local float XMod;
	local float YMod;
	local float XPos;
	local float YPos;
	local float YOffset;
	local float BottomTop;
	local float XL;
	local float YL;
	local Color TextColor;
	local int i;

	Super(UWindowWindow).BeforePaint(C,X,Y);
	W=Root.WinWidth / 4;
	H=W;
	if ( (W > 256) || (H > 256) )
	{
		W=256;
		H=256;
	}
	XMod=4.00 * W;
	YMod=3.00 * H;
	XWidth=256.00 / 1024.00 * XMod;
	YHeight=32.00 / 768.00 * YMod;
	TopButton.SetSize(XWidth,YHeight);
	TopButton.WinTop=0.00;
	TopButton.MyFont=Class'UTLadderStub'.GetStubClass().GetBigFont(Root);
	if ( OptionOffset > 0 )
	{
		TopButton.bDisabled=False;
	} else {
		TopButton.bDisabled=True;
	}
	i=0;
JL0159:
	if ( i < OptionOffset )
	{
		OptionButtons[i].HideWindow();
		i++;
		goto JL0159;
	}
	i=OptionOffset;
JL0192:
	if ( i < MinOptions + OptionOffset )
	{
		OptionButtons[i].ShowWindow();
		OptionButtons[i].SetSize(XWidth,YHeight);
		OptionButtons[i].WinLeft=0.00;
		OptionButtons[i].WinTop=32.00 / 768.00 * YMod * (i + 1 - OptionOffset);
		i++;
		goto JL0192;
	}
	i=MinOptions + OptionOffset;
JL024C:
	if ( i < NumOptions )
	{
		OptionButtons[i].HideWindow();
		i++;
		goto JL024C;
	}
	BottomButton.SetSize(XWidth,YHeight);
	BottomButton.WinTop=32.00 / 768.00 * YMod * (MinOptions + 1);
	BottomButton.MyFont=Class'UTLadderStub'.GetStubClass().GetBigFont(Root);
	if ( NumOptions > MinOptions + OptionOffset )
	{
		BottomButton.bDisabled=False;
	} else {
		BottomButton.bDisabled=True;
	}
}

function Paint (Canvas C, float X, float Y)
{
	local int i;

	Super.Paint(C,X,Y);
	i=0;
JL001C:
	if ( i < NumOptions )
	{
		OptionButtons[i].FadeFactor=FadeFactor / 100;
		i++;
		goto JL001C;
	}
}

function Notify (UWindowWindow B, byte E)
{
	local int i;

	switch (E)
	{
		case 11:
		case 2:
		GetPlayerOwner().PlaySound(Sound'SpeechWindowClick',3);
		i=0;
JL002C:
		if ( i < NumOptions )
		{
			if ( B == OptionButtons[i] )
			{
				if ( EmoteParent.GetEmote(CurrentType * EmotesPerCategory + i).bsimple )
				{
					GetPlayerOwner().ConsoleCommand("say :" $ EmoteParent.GetEmote(CurrentType * EmotesPerCategory + i).Code);
				} else {
					GetPlayerOwner().ConsoleCommand("say :" $ EmoteParent.GetEmote(CurrentType * EmotesPerCategory + i).Code $ ":");
				}
			}
			i++;
			goto JL002C;
		}
		if ( B == TopButton )
		{
			if ( NumOptions > SubMenusVisible )
			{
				if ( OptionOffset > 0 )
				{
					OptionOffset--;
				}
			}
		}
		if ( B == BottomButton )
		{
			if ( NumOptions > SubMenusVisible )
			{
				if ( NumOptions - OptionOffset > SubMenusVisible )
				{
					OptionOffset++;
				}
			}
		}
		SetButtonTextures(OptionOffset + CurrentType,True,False);
		break;
		default:
	}
}

defaultproperties
{
    SubMenusVisible=14
    bIsParentWindow=False
    ButtonClass=Class'EmoteButton'
    TopTexture=Texture'UTMenu.Skins.OrdersTop2'
    WindowTitle=""
}