//================================================================================
// EmoteButton.
//================================================================================
class EmoteButton extends SpeechButton;

var int EmotCurrentType;
var emoticon emot;

function Paint (Canvas C, float X, float Y)
{
	local int EmotParentType;
	local int EmotIndex;
	local float ScaleFactor;
	local float scalefactorx;
	local float scalefactory;
	local int ewidth;
	local int eheight;

	Super.Paint(C,X,Y);
	EmotParentType=EmoteChildWindow(ParentWindow).CurrentType;
	EmotIndex=EmotParentType * EmoteChildWindow(ParentWindow).EmotesPerCategory + Type;
	emot=EmoteChildWindow(ParentWindow).EmoteParent.GetEmote(EmotIndex);
	if ( emot != None )
	{
		scalefactorx=1.00;
		scalefactory=1.00;
		ewidth=emot.dim - 2 * emot.rx;
		eheight=emot.dim - 2 * emot.ry;
		if ( ewidth > WinWidth / 2 - 30 )
		{
			scalefactorx=(WinWidth / 2 - 30) / ewidth;
		}
		if ( eheight > WinHeight - 4 )
		{
			scalefactory=(WinHeight - 4) / eheight;
		}
		if ( scalefactorx < scalefactory )
		{
			ScaleFactor=scalefactorx;
		} else {
			ScaleFactor=scalefactory;
		}
		C.SetOrigin(WinLeft + ParentWindow.WinLeft,WinTop + ParentWindow.WinTop);
		C.SetPos(WinWidth * 3 / 4 - emot.dim * ScaleFactor / 2,WinHeight / 2 - emot.dim * ScaleFactor / 2);
		emot.DrawIcon(C,ScaleFactor);
	}
}