;UT Mirc Script v2.0.0.5 - TLL
; =====================================================
; Misc
; =====================================================
alias JST {
  ; JST(length,dir,char,text)
  ; Dir : 1-Left  2-Right
  VAR %F = $$1 - $len($4-)
  IF ($$2 == 1 ) {
    VAR %RES = $4- $+ $str( $chr($$3) , %F )
  }
  else  {
    VAR %RES = $str( $chr($$3) , %F ) $+ $4-
  }
  RETURN %res
}

; =====================================================
; Menus
; =====================================================
menu status {
  Configure UT Mirc:/UTM_CONFIG
  Query UT Server:/QS_UTPOPUP
  Echo own UT Status://UTM_WHERE_SAY -e -s
}

menu menubar {
  UTMirc
  .Configure UT Mirc:/UTM_CONFIG
  .Query UT Server:/QS_UTPOPUP
  .Reload UT Mirc:/.load -rs %UTM_PATH $+ utmirc20.mrc
  .-
  .Check UTMirc Homepage:/run http://phalanx.accao.net/utmirc.htm
}

menu channel {
  UTMirc
  .Check UT Status:/.notice # !wut
  .Send UT Status:/UTM_WHERE_SAY -n #
  .Query UT Server:/QS_UTPOPUP
  .Say where you're playing:/UTM_WHERE_SAY -s
  .-
  .Configure UT Mirc:/UTM_CONFIG

}

menu nicklist {
  UTMirc
  .Check UT Status:/.NOTICE $1 !wut
  .Send UT Status:/UTM_WHERE_SAY -n $1
}
; =====================================================
; Aliases
; =====================================================

alias UTM_WHERE {
  ; Sends message to origin
  ; Uses timer to work around the "strange" reply before trigger
  .timer_UTMWS -m 1 0 /UTM_WHERE_SAY $1-
}

alias UTM_WHERE_SAY {
  ; UTM_WHERE_SAY <-n|s|m|e> [destination]
  ; Switches : -n uses Notice to $2
  ;            -p uses OR Notice to $2 OR MSG to $2, depending on %UTM_PUN 
  ;            -s uses Say
  ;            -m uses Msg to $2
  ;            -s uses Echo to active

  ; Calls phrase builder
  VAR %FRASE = $UTM_WUT
  If ( $1 == -s ) || ( $len($2) == 0) {
    SAY %FRASE
  }
  else {
    If ( $1 == -n ) {
      .Notice $2 !tuw %FRASE
    }
    elseif ( $1 == -m) {
      MSG $2 %FRASE
    }
    elseif ( $1 == -e) {
      ECHO $2 %FRASE
    }
    elseif ( $1 == -p ) {
      If (%UTM_PUN == 1) {
        .Notice $2 !tuw %FRASE
      }
      else {
        MSG $2 %FRASE
      }
    }
  }
}

alias UTM_CHECKTIMER {
  ; !! Check this
  if $timer(_UTM).type != $null {
    HALT
  }
  ; Activates control timer
  .timer_UTM 1 %UTM_TIM /HALT
}

alias UTM_WUT {
  ; Call DLL
  VAR %RES = $dll( %UTM_DLL ,TLL_CheckUT,%UTM_SYS)
  IF %RES = 0 {
    VAR %FRASE = %UTM_NOTPLA
  }
  else {
    ; Tokenize
    VAR %UTHOST = $gettok(%RES,1,92)
    VAR %UTPORT = $gettok(%RES,2,92)
    VAR %UTMAP = $gettok(%RES,3,92)
    VAR %UTNAME = $gettok(%RES,4,92)

    VAR %FRASE = Check Unreal:// $+ %UTHOST $+ : $+ %UTPORT $+  $+ $chr(44) $+ $chr(32) $+ ( $+ %UTNAME at %UTMAP $+ )
  }
  Return %FRASE
}

alias UTM_CONFIG {
  Var %RV = $dialog(UTM_CFG,UTM_DlgConfig)
}

alias UTM_CHECKURL {
  VAR %X $pos($1,$chr(44) )
  IF (%X > 0 ) {
    %X = %X - 1
    VAR %PRM = $left( $1 , %X  )
  }
  else {
    VAR %PRM $1
  }

  If ( $left( %PRM , 9) != Unreal:// ) {
    %PRM = Unreal:// $+ %PRM
  }
  Return %PRM
}

alias UTM_OPEN {
  ; Tries to enforce the text
  Var %PRM $UTM_CHECKURL( $1 )
  run %PRM
}

alias UTM_GETPATH {
  ; Determines script location and sets some variables
  Var %SD $shortfn($scriptdir)

  SET %UTM_PATH %SD
  SET %UTM_DLL %SD $+ mirctll.dll
  SET %UTM_DRIVE $left(%UTM_PATH,2)
  SET %UTM_DIR $mid(%UTM_PATH,3)
}

alias UTM_CHECKVER {
  SET %UTM_VER $dll(%UTM_DLL,TLL_GetVer,NOT_USED)
  SET %UTM_SER 2.0.0.5
  If ( $1 == -s ) {
    ECHO -s UTMirc v $+ %UTM_SER - Checked mIRCTLL Version %UTM_VER
  }
}

; =====================================================
; Events
; =====================================================

on 1:LOAD:{
  UTM_GETPATH
  UTM_CONFIG
}

on 1:START:{
  UTM_GETPATH
  UTM_CHECKVER -s
}

on ^1:TEXT:!wut:#:{
  IF (%UTM_PUB = 1) {
    UTM_CHECKTIMER
    UTM_WHERE -p $chan
  }
}

on ^1:TEXT:!wut:?:{
  IF (%UTM_PRI = 1) {
    UTM_CHECKTIMER
    UTM_WHERE -m $nick
  }
}

on ^1:NOTICE:!wut:*:{
  IF (%UTM_NOT = 1 ) {
    UTM_CHECKTIMER
    UTM_WHERE_SAY -n $nick
    HALTDEF
  }
}

on ^1:NOTICE:!wutver:*:{
  IF (%UTM_NOT = 1 ) {
    UTM_CHECKTIMER
    UTM_CHECKVER 
    .Notice $nick !tuw %UTM_SER $+ , $+ %UTM_VER
    HALTDEF
  }
}

on ^1:NOTICE:!tuw*:*:{
  Var %FRASE  $+ $nick $+  reports : $2-
  If (%UTM_NOD == 1) {
    ECHO -a %FRASE
  }
  else {
    ECHO -s %FRASE
  }
  HALTDEF
}


; ====================================================

dialog UTM_DlgConfig  {
  ; --------------------------
  ; Configuration options
  ; 201 UT System dir path
  ; 202 System responds to public msg
  ; 203 System responds to private msg
  ; 204 System responds to special !wut notice
  ; 211 Timer delay
  ; 212 Trigger text
  ; --------------------------
  title "UTMirc 2.0 Configuration"
  size -1 -1 238 178

  option dbu

  icon 1, 4 4 20 20 , %UTM_PATH $+ UT.ico , 0, 0
  box "Client Info Configuration" , 951, 24 3 210 98

  text "UT System &Dir"   , 101,  34  16  40 11

  edit ""                 , 201,  76  14 150 11
  check "Pu&blic Enabled" , 202,  77  26  50 9
  check "Pri&vate Enabled", 203,  77  36  50 9
  check "&Notice  Enabled", 204,  77  46  50 9

  text "&Timer Delay"     , 102,  34  60  40 11
  edit ""                 , 211,  76  58  30 11, limit 2

  text "Public Output"    , 111,  34  74  40 11

  radio "&Public Message" , 205,  76  72  50 11, group push
  radio "&Public Notice"  , 206, 128  72  50 11, push

  text "Notice Output"    , 104,  34  86  40 11

  radio "&Status Window"  , 301,  76  85  50 11, group push
  radio "&Active Window"  , 302, 128  85  50 11, push

  box "Server Query Configuration" , 952, 24 104 210 28


  text "Query Output"     , 105,  34 116  40 11

  radio "&Status Window"  , 401,  76 114  50 11, group push
  radio "&Active Window"  , 402, 128 114  50 11, push
  radio "&Dedicated Window"  , 403, 180 114  50 11, push

  text "Error Msg"        , 999,  24 136 200 10, hide

  box "" , 953, 24 144 210 4
  link "Check UTMirc Homepage", 501, 24 150 200 16



  button "O&K"           , 901,  24 162 40 12, ok
  button "Cancel"        , 902, 194 162 40 12, cancel
}

;===========================

on 1:dialog:UTM_CFG:init:0: {
  ; Config Dialog Init
  ; Check and enforce defaults
  IF (%UTM_PUB = $null) SET %UTM_PUB 1
  IF (%UTM_PRI = $null) SET %UTM_PRI 1
  IF (%UTM_NOT = $null) SET %UTM_NOT 1

  IF (%UTM_TIM = $null) SET %UTM_TIM 3
  IF (%UTM_PUN = $null) SET %UTM_PUR 0

  IF (%UTM_NOD = $null) SET %UTM_NOD 0
  IF (%UTM_QSD = $null) SET %UTM_QSD 0
  IF (%UTM_QST = $null) SET %UTM_QST 8

  IF (%UTM_NOTPLA = $null) SET %UTM_NOTPLA Not playing right now

  did -a UTM_CFG 201 %UTM_SYS
  IF %UTM_PUB = 1 {
    DID -c UTM_CFG 202
  }
  else {
    DID -u UTM_CFG 202
  }
  IF %UTM_PRI = 1 {
    DID -c UTM_CFG 203
  }
  else {
    DID -u UTM_CFG 203
  }

  IF %UTM_NOT = 1 {
    DID -c UTM_CFG 204
  }
  else {
    DID -u UTM_CFG 204
  }

  IF %UTM_PUN = 1 {
    DID -c UTM_CFG 206
  }
  else {
    DID -c UTM_CFG 205
  }

  IF %UTM_NOD = 1 {
    DID -c UTM_CFG 302
  }
  else {
    DID -c UTM_CFG 301
  }

  IF (%UTM_QSD == 1) {
    DID -c UTM_CFG 402
  }
  elseif (%UTM_QSD == 2) {
    DID -c UTM_CFG 403
  }
  else {
    DID -c UTM_CFG 401
  }

  did -a UTM_CFG 211 %UTM_TIM
}

alias UTM_DLG_ERR {
  did -v UTM_CFG 999
  did -a UTM_CFG 999 $2-
  did -f UTM_CFG $1
  .timer_DERR -m 9 50 /UTM_FLASHERR
  beep 1 0
  HALT
}

alias UTM_FLASHERR {
  Var %X $timer(_DERR).reps
  If ( $isbit( %X , 1) == 1 ) {
    did -v UTM_CFG 999
  }
  else {
    did -h UTM_CFG 999
  }
}

on 1:dialog:UTM_CFG:sclick:901: {

  var %fname = $did(UTM_CFG,201)
  var %fname2 = %fname $+ \UnrealTournament.exe
  ; 1 - verifica path
  IF $exists( %fname2 ) = $false UTM_DLG_ERR 201 UnrealTournament.exe not found on above path!!! Please enter a valid path.

  ; 2 - Verifica time delay
  VAR %TIMX = $did(UTM_CFG,211)
  IF (%TIMX !isnum 1-99) UTM_DLG_ERR 211 Please enter a number between 1-99 for Timer Delay.

  ; Se chegar aqui, deve tar tudo bem

  SET %UTM_SYS %fname
  SET %UTM_PUB $did(UTM_CFG,202).state
  SET %UTM_PRI $did(UTM_CFG,203).state
  SET %UTM_NOT $did(UTM_CFG,204).state

  SET %UTM_TIM %TIMX

  IF ( $did(UTM_CFG,206).state == 1) {
    SET %UTM_PUN 1
  }
  else {
    SET %UTM_PUN 0
  }

  IF ( $did(UTM_CFG,302).state == 1) {
    SET %UTM_NOD 1
  }
  else {
    SET %UTM_NOD 0
  }
  ;===========
  IF ( $did(UTM_CFG,402).state == 1) {
    SET %UTM_QSD 1
  }
  elseif ( $did(UTM_CFG,403).state == 1) {
    SET %UTM_QSD 2
  }
  else {
    SET %UTM_QSD 0
  }
}

on 1:dialog:UTM_CFG:sclick:501: {
  run http://phalanx.accao.net/utmirc.htm
}


;=======================================

dialog UTM_DlgClick {
  title "UTMirc 2.0 Configuration"
  size -1 -1 164 40

  option dbu

  icon 1, 4 4 20 20 , %UTM_PATH $+ UT.ico , 0, 0

  text %UTM_CLKURL      ,   2,  30   8 130 11
  button "&Go Play"     , 101,  30  22  40 12, ok
  button "&Get Stats"   , 102,  74  22  40 12
  button "&Cancel"      , 103, 118  22  40 12, cancel
}

on 1:dialog:UTM_CLK:init:0: {

}

on 1:dialog:UTM_CLK:sclick:101: {
  UTM_OPEN %UTM_CLKURL
  Unset %UTM_CLKURL
}

on 1:dialog:UTM_CLK:sclick:102: {
  Var %X = $mid( %UTM_CLKURL , 10 )
  DIALOG -x UTM_CLK
  QS_UT %X
  Unset %UTM_CLKURL
}

on 1:dialog:UTM_CLK:sclick:103: {
  Unset %UTM_CLKURL
}

alias UTM_UTCLICK {
  Set %UTM_CLKURL $UTM_CHECKURL( $1 )
  ;!!debug echo -s %UTM_CLKURL
  Var %RV = $dialog(UTM_CLK,UTM_DlgClick)
}

;=======================================
On ^1:HOTLINK:*unreal*:*:{
  ;if ($1 == unreal) return
  ;halt
}

on 1:HOTLINK:*:*:{
  IF $left($1,9) == unreal:// {
    .timer_bogus 1 0 /UTM_UTCLICK $1
  }
}

; =====================================================
; QStat Server Query System
; =====================================================

alias QS_UT {
  ; Check if Timer is active
  if $timer(_QS).type != $null {
    ECHO 3 -a Waiting for previous request to complete... ( $timer(_QS).reps retries )
    GOTO Fim
  }
  ; Call batch file
  run -n %UTM_PATH $+ quns.bat $1 %UTM_DRIVE %UTM_DIR
  ; Try %UTM_QST times
  .timer_QS %UTM_QST 1 /QS_UT2
  :Fim
}

alias QS_UTPOPUP {
  Var %X $?="Enter server address"
  If ( %X != $null ) {
    QS_UT %X
  }
}

alias QS_UT2 {
  ; Check if file is done
  VAR %X = $readini %UTM_PATH $+ result.txt End End
  IF %X = 1 {
    .timer_QS off
    QS_UTSHOW
  }
  else {
    if ( $timer(_QS).reps < 0 ) {
      SET %QS_TIMER 1
      QS_UTSHOW
    }
  }
}

alias QS_UTSHOW {

  if (%UTM_QSD == 1 ) SET %QS_TGWIN -a
  elseif (%UTM_QSD == 2 ) SET %QS_TGWIN @QSUT
  else SET %QS_TGWIN -s

  If ( %QS_TGWIN == @QSUT ) {
    WINDOW -ak0 @QSUT 30 30 600 350
    CLEAR @QSUT
  }

  QS_OUTPUT $chr(160)

  VAR %SEPN 70
  If ( %QS_TIMER == 1 ) {
    QS_OUTPUT $str(-,%SEPN)
    QS_OUTPUT Query Script Timeout...
    Unset %QS_TIMER
    GOTO Final
  }

  QS_READFILE

  QS_OUTPUT Stats for 3Unreal:// $+ %QS_SERVADDR $+ 
  ; Check for host not found
  If (%QS_SERVNAME == HOSTNOTFOUND) {
    QS_OUTPUT $str(-,%SEPN)
    QS_OUTPUT Host not found
    GOTO Final
  }
  ; Check for timeout
  If (%QS_SERVNAME == TIMEOUT ) && (%QS_SERVPING == $null) {
    QS_OUTPUT $str(-,%SEPN)
    QS_OUTPUT Server Timeout...
    GOTO Final
  }

  QS_OUTPUT %QS_SERVNAME ( Ver  $+ %QS_SERVGAMEVER $+  )
  VAR %GLINE %QS_SERVGAME in %QS_SERVMAP $+ ,  $+ %QS_SERVPLAYERS $+ / $+ %QS_SERVMAXPLAYERS $+  players, Ping=  $+ %QS_SERVPING $+  $+
  QS_OUTPUT %GLINE
  %GLINE = $strip(%GLINE)
  %SEPN = $len(%GLINE)
  If ( %SEPN < 60) %SEPN = 60
  Var %GLINE MaxScore=  $+ %QS_SERVMAXSCORE $+  , Time Limit=  $+ %QS_SERVMAXTIME $+ 

  IF ( %QS_SERVMAXTEAMS != $null) && ( %QS_SERVMAXTEAMS > 1 ) {
    %GLINE = %GLINE $+ , Friendly Fire= $+  $+ %QS_SERVFFIRE
  }
  QS_OUTPUT %GLINE

  ;SET %QS_SERVGAMEVER $readini %QS_FN Server SERVGAMEVER



  QS_OUTPUT $str(-,%SEPN)
  If ( %QS_PLNUM < 1) {
    QS_OUTPUT No players...
    GOTO Final
  }
  QS_OUTPUT $chr(124) Team $+ $chr(160) $chr(124) $chr(160) $+ Ping $chr(124) Frags $chr(124) Name

  VAR %PLC 1
  VAR %HIS 0
  while (%PLC <= %QS_PLNUM ) {
    SET %P0 %QS_PL [ $+ [ %PLC ] ]

    ;VAR %X $gettok( %P0,2,33)
    Var %X $gettok( %P0,1,33)

    If ( %X == 0 ) SET %X 4Red
    elseif ( %X == 1 ) SET %X 2Blue
    elseif ( %X == 2 ) SET %X 3Green
    elseif ( %X == 3 ) SET %X 7Gold
    else { SET %X None }

    If ( %X == None ) {
      VAR %P1 $JST(5,1,160, [ %X ] )
    }
    else {
      VAR %P1 $JST(8,1,160, [ %X ] )
    }
    VAR %P2 $JST(5,2,160, $gettok( %P0,2,33) )
    VAR %P3 $JST(5,2,160, $gettok( %P0,3,33) )

    ;VAR %P4 $gettok( %P0,4-,33)
    ; Can't use gettok for last field... it trims leading chars equal to the token char... looks like a Mirc bug
    ; Work around
    %X = $pos(%P0,!,3)
    Inc %X
    Var %P4 = $mid(%P0,%X)

    QS_OUTPUT $chr(124) %P1 $chr(124) %P2 $chr(124) %P3 $chr(124) %P4

    INC %PLC
  }
  :FINAL
  QS_OUTPUT $str(-,%SEPN)
  QS_OUTPUT $chr(160)
  QS_UNSETVARS
}

alias QS_OUTPUT {
  ; Sends output
  ECHO %QS_TGWIN $1-
  ; If some_setup_var msg #some_channel_name $1-
}

alias QS_READFILE {
  ; Get file contents
  VAR %QS_FN %UTM_PATH $+ result.txt

  SET %QS_SERVNAME $readini %QS_FN Server SERVNAME
  SET %QS_SERVPING $readini %QS_FN Server SERVPING
  SET %QS_SERVPLAYERS $readini %QS_FN Server SERVPLAYERS
  SET %QS_SERVMAXPLAYERS $readini %QS_FN Server SERVMAXPLAYERS
  SET %QS_SERVMAP $readini %QS_FN Server SERVMAP
  SET %QS_SERVGAME $readini %QS_FN Server SERVGAME
  SET %QS_SERVADDR $readini %QS_FN Server SERVADDR
  SET %QS_SERVMAXTEAMS $readini %QS_FN Server SERVMAXTEAMS
  SET %QS_SERVMAXSCORE $readini %QS_FN Server SERVMAXSCORE
  SET %QS_SERVMAXTIME $readini %QS_FN Server SERVMAXTIME
  SET %QS_SERVTYPE $readini %QS_FN Server SERVTYPE
  SET %QS_SERVFFIRE $readini %QS_FN Server SERVFFIRE
  SET %QS_SERVGAMEVER $readini %QS_FN Server SERVGAMEVER

  If ( %QS_SERVMAXSCORE == $null) {
    SET %QS_SERVMAXSCORE N/A
  }

  If ( %QS_SERVMAXTIME == $null) {
    SET %QS_SERVMAXTIME N/A
  }

  SET %QS_PLNUM 0

  VAR %X $read -w[Players] %QS_FN
  If (%X == [Players]) {
    VAR %EOF 0
    VAR %L $readn
    %L = %L + 1
  }
  else {
    VAR %EOF 1
  }

  while (%EOF == 0) {
    VAR %S = $read -l $+ %L %QS_FN
    %L = %L + 1
    IF ( $left( %S, 4) != PLA= ) {
      %EOF = 1
    }
    else {
      %QS_PLNUM = %QS_PLNUM + 1
      SET %QS_PL [ $+ [ %QS_PLNUM ] ] $mid(%S,5)
    }
  }
  ; Sort players, by frag count
  Var %PLC 1
  While (%PLC < %QS_PLNUM ) {
    Var %P1 = %QS_PL [ $+ [ %PLC ] ]
    Var %PLC2 = %PLC + 1
    Var %P2 = %QS_PL [ $+ [ %PLC2  ] ]
    Var %X1 $gettok( %P1,3,33)
    Var %X2 $gettok( %P2,3,33)

    If ( %X1 < %X2 ) {
      SET %QS_PL [ $+ [ %PLC ] ] %P2
      SET %QS_PL [ $+ [ %PLC2 ] ] %P1
      If ( %PLC > 1) Dec %PLC
    }
    else {
      INC %PLC
    }
  }
  ; Then if Team Game, by Team
  IF ( %QS_SERVMAXTEAMS == $null) || ( %QS_SERVMAXTEAMS < 2 ) GOTO NOST
  Var %PLC 1
  While (%PLC < %QS_PLNUM ) {
    Var %P1 = %QS_PL [ $+ [ %PLC ] ]
    Var %PLC2 = %PLC + 1
    Var %P2 = %QS_PL [ $+ [ %PLC2  ] ]
    Var %X1 $gettok( %P1,1,33)
    Var %X2 $gettok( %P2,1,33)

    If ( %X1 < %X2 ) {
      SET %QS_PL [ $+ [ %PLC ] ] %P2
      SET %QS_PL [ $+ [ %PLC2 ] ] %P1
      If ( %PLC > 1) Dec %PLC
    }
    else {
      INC %PLC
    }
  }
  :NOST

}

alias QS_UNSETVARS {
  ; Unsets most variables
  UNSET %QS_SERV*
  UNSET %QS_PLNUM
  UNSET %QS_PL*
  UNSET %QS_TGWIN
}
