//=============================================================================
// UTEP_SniperRifle
// An Enhanced military redesign of a sniper rifle for UnrealTournament.
//=============================================================================
class UTEP_SniperRifle extends TournamentWeapon;

#exec TEXTURE IMPORT FILE=Textures\Scope.bmp MIPS=OFF LODSET=2
#exec TEXTURE IMPORT NAME=Crosshair FILE=TEXTURES\Crosshair.bmp MIPS=OFF FLAGS=2 LODSET=2
#exec AUDIO IMPORT FILE="Sounds\EWSniperFire.wav"

#exec TEXTURE IMPORT NAME=EWJRifle2 FILE=Textures\EWJRifle2.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=EWRifle2a FILE=Textures\EWRifle2a.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=EWRifle2b FILE=Textures\EWRifle2b.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=EWRifle2c FILE=Textures\EWRifle2c.bmp GROUP=Skins LODSET=2
#exec TEXTURE IMPORT NAME=EWRifle2d FILE=Textures\EWRifle2d.bmp GROUP=Skins LODSET=2

var(Display) Texture UTEPMultiSkin[8];

var int NumFire;
var name FireAnims[5];
var vector OwnerLocation;
var float StillTime, StillStart;

simulated event PostNetBeginPlay()
{
	local SniperHUDMutator crosshair;
	local PlayerPawn HUDOwner;

	Super.PostNetBeginPlay();

	// If owner is the local player, check that the HUD Mutator exists.
	// Also check for the presense of a bbPlayer (UTPure enabled)
	
	HUDOwner = PlayerPawn(Owner);
	if (HUDOwner != None && HUDOwner.IsA('bbPlayer') && HUDOwner.myHUD != None)
	{
		ForEach AllActors(Class'SniperHUDMutator', crosshair)
			break;
	if (crosshair == None)
		{
			crosshair = Spawn(Class'SniperHUDMutator', Owner);
			crosshair.RegisterHUDMutator();
			crosshair.HUDOwner = HUDOwner;
		}
	}
}

simulated function PostRender( canvas Canvas )
{
	local PlayerPawn P;
	local float Scale;
	
	Super.PostRender(Canvas);
	P = PlayerPawn(Owner);
	if ( (P != None) && (P.DesiredFOV != P.DefaultFOV) )
	{
		bOwnsCrossHair = true;
		
		// Outside Edge (blacked-out)
		Scale = Canvas.ClipX/256;
		Canvas.SetPos(0.5 * Canvas.ClipX - 128 * Scale, 0.5 * Canvas.ClipY - 128 * Scale );
		Canvas.Style = ERenderStyle.STY_Modulated;
		Canvas.DrawIcon(Texture'Scope', Scale);
		Scale = Canvas.ClipX/640;
		Canvas.Style = ERenderStyle.STY_Translucent;
		
		// Square
		Canvas.SetPos( 3*Canvas.ClipX/7, 3*Canvas.ClipY/7 );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/7, Canvas.ClipY/7, 0, 0, 256, 193 );

		// Top Line
		Canvas.SetPos( 200*Canvas.ClipX/401, Canvas.ClipY/229*(90-P.DesiredFOV)+0.6*Canvas.ClipY/28 );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/401, Canvas.ClipY/28, 0, 20, 3, 10 );

		// Bottom Line
		Canvas.SetPos( 200*Canvas.ClipX/401, 15.35*Canvas.ClipY/28 + Canvas.ClipY/229*P.DesiredFOV );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/401, Canvas.ClipY/28, 0, 20, 3, 10 );

		// Left Line
		Canvas.SetPos( Canvas.ClipX/229*(90-P.DesiredFOV)+0.6*Canvas.ClipX/28, 200*Canvas.ClipY/401 );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/28, Canvas.ClipY/401, 10, 0, 10, 3 );

		// Right Line
		Canvas.SetPos( 15.35*Canvas.ClipX/28 + Canvas.ClipX/229*P.DesiredFOV, 200*Canvas.ClipY/401 );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/28, Canvas.ClipY/401, 10, 0, 10, 3 );

		// dot
		Canvas.SetPos( 199.5*Canvas.ClipX/401, 199.5*Canvas.ClipY/401 );
		Canvas.DrawTile( Texture'Crosshair', 2*Canvas.ClipX/401, 2*Canvas.ClipY/401, 0, 202, 53, 53 );

		// Top Gradient
		Canvas.SetPos( 200*Canvas.ClipX/401, 4*Canvas.ClipY/9 );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/401, Canvas.ClipY/1360*(90-P.DesiredFOV), 129, 197, 3, 54 );

		// Left Gradient
		Canvas.SetPos( 4*Canvas.ClipX/9, 200*Canvas.ClipY/401 );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/1360*(90-P.DesiredFOV), Canvas.ClipY/401, 69, 200, 54, 3 );

		//Bottom Gradient
		Canvas.SetPos( 200*Canvas.ClipX/401, 5*Canvas.ClipY/9 - Canvas.ClipY/1360*(90-P.DesiredFOV) );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/401, Canvas.ClipY/1360*(90-P.DesiredFOV), 144, 199, 3, 54 );

		//Right Gradient
		Canvas.SetPos( 5*Canvas.ClipX/9 - Canvas.ClipX/1360*(90-P.DesiredFOV), 200*Canvas.ClipY/401 );
		Canvas.DrawTile( Texture'Crosshair', Canvas.ClipX/1360*(90-P.DesiredFOV), Canvas.ClipY/401, 163, 199, 54, 3 );

        // Magnification Display
		Canvas.SetPos( 202*Canvas.ClipX/417, 4*Canvas.ClipY/7 + Canvas.ClipY/417 );
		Canvas.Font = Font'Botpack.WhiteFont';
		Canvas.DrawColor.R = 255;
		Canvas.DrawColor.G = 0;
		Canvas.DrawColor.B = 0;
		Scale = P.DefaultFOV/P.DesiredFOV;
		Canvas.DrawText("x"$int(Scale)$"."$int(10 * Scale - 10 * int(Scale)));
	}
	else
		bOwnsCrossHair = false;
}

function float RateSelf( out int bUseAltMode )
{
	local float dist;

	if ( AmmoType.AmmoAmount <=0 )
		return -2;

	bUseAltMode = 0;
	if ( (Bot(Owner) != None) && Bot(Owner).bSniping )
		return AIRating + 1.15;
	if (  Pawn(Owner).Enemy != None )
	{
		dist = VSize(Pawn(Owner).Enemy.Location - Owner.Location);
		if ( dist > 1200 )
		{
			if ( dist > 2000 )
				return (AIRating + 0.75);
			return (AIRating + FMin(0.0001 * dist, 0.45)); 
		}
	}
	return AIRating;
}

simulated function PlayFiring()
{
	local int r;

	PlayOwnedSound(FireSound, SLOT_None, Pawn(Owner).SoundDampening*1.0);
	PlayAnim(FireAnims[Rand(5)],0.5 + 0.5 * FireAdjust, 0.05);

	if ( (PlayerPawn(Owner) != None) 
		&& (PlayerPawn(Owner).DesiredFOV == PlayerPawn(Owner).DefaultFOV) )
		bMuzzleFlash++;
}


simulated function bool ClientAltFire( float Value )
{
	GotoState('Zooming');
	return true;
}

function AltFire( float Value )
{
	ClientAltFire(Value);
}

///////////////////////////////////////////////////////
state NormalFire
{
	function EndState()
	{
		Super.EndState();
		OldFlashCount = FlashCount;
	}
		
Begin:
	FlashCount++;
}

function Timer()
{
	local actor targ;
	local float bestAim, bestDist;
	local vector FireDir;
	local Pawn P;

	bestAim = 0.95;
	P = Pawn(Owner);
	if ( P == None )
	{
		GotoState('');
		return;
	}
	if ( VSize(P.Location - OwnerLocation) < 6 )
		StillTime += FMin(2.0, Level.TimeSeconds - StillStart);

	else
		StillTime = 0;
	StillStart = Level.TimeSeconds;
	OwnerLocation = P.Location;
	FireDir = vector(P.ViewRotation);
	targ = P.PickTarget(bestAim, bestDist, FireDir, Owner.Location);
	if ( Pawn(targ) != None )
	{
		SetTimer(1 + 4 * FRand(), false);
		bPointing = true;
		Pawn(targ).WarnTarget(P, 200, FireDir);
	}
	else 
	{
		SetTimer(0.4 + 1.6 * FRand(), false);
		if ( (P.bFire == 0) && (P.bAltFire == 0) )
			bPointing = false;
	}
}	

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local UT_Shellcase s;

	s = Spawn(class'UT_ShellCase',, '', Owner.Location + CalcDrawOffset() + 30 * X + (2.8 * FireOffset.Y+5.0) * Y - Z * 1);
	if ( s != None ) 
	{
		s.DrawScale = 2.0;
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	}
	if (Other == Level) 
		Spawn(class'UT_HeavyWallHitEffect',,, HitLocation+HitNormal, Rotator(HitNormal));
	else if ( (Other != self) && (Other != Owner) && (Other != None) ) 
	{
		if ( Other.bIsPawn )
			Other.PlaySound(Sound 'ChunkHit',, 4.0,,100);
		if ( Other.bIsPawn && (HitLocation.Z - Other.Location.Z > 0.62 * Other.CollisionHeight) 
			&& (instigator.IsA('PlayerPawn') || (instigator.IsA('Bot') && !Bot(Instigator).bNovice)) )
			Other.TakeDamage(100, Pawn(Owner), HitLocation, 35000 * X, AltDamageType);
		else
			Other.TakeDamage(45,  Pawn(Owner), HitLocation, 30000.0*X, MyDamageType);	
		if ( !Other.bIsPawn && !Other.IsA('Carcass') )
			spawn(class'UT_SpriteSmokePuff',,,HitLocation+HitNormal*9);	
	}
}

function Finish()
{
	if ( (Pawn(Owner).bFire!=0) && (FRand() < 0.6) )
		Timer();
	Super.Finish();
}

function TraceFire( float Accuracy )
{
	local vector HitLocation, HitNormal, StartTrace, EndTrace, X,Y,Z, AimDir;
	local actor Other;
	local Pawn PawnOwner;

	PawnOwner = Pawn(Owner);

	Owner.MakeNoise(PawnOwner.SoundDampening);
	GetAxes(PawnOwner.ViewRotation,X,Y,Z);
	StartTrace = Owner.Location + PawnOwner.Eyeheight * Z; 
	AdjustedAim = PawnOwner.AdjustAim(1000000, StartTrace, 2*AimError, False, False);	
	X = vector(AdjustedAim);
	EndTrace = StartTrace + 10000 * X; 
	Other = PawnOwner.TraceShot(HitLocation,HitNormal,EndTrace,StartTrace);
	if ( VSize(HitLocation - StartTrace) > 250 )
			Spawn(class'UTEP_STracer',,, StartTrace + 0 * AimDir,rotator(EndTrace - StartTrace));
	ProcessTraceHit(Other, HitLocation, HitNormal, X,Y,Z);
}

state Idle
{
	function Fire( float Value )
	{
		if ( AmmoType == None )
		{
			// ammocheck
			GiveAmmo(Pawn(Owner));
		}
		if (AmmoType.UseAmmo(1))
		{
			GotoState('NormalFire');
			bCanClientFire = true;
			bPointing=True;
			if ( Owner.IsA('Bot') )
			{
				// simulate bot using zoom
				if ( Bot(Owner).bSniping && (FRand() < 0.65) )
					AimError = AimError/FClamp(StillTime, 1.0, 8.0);
				else if ( VSize(Owner.Location - OwnerLocation) < 6 )
					AimError = AimError/FClamp(0.5 * StillTime, 1.0, 3.0);
				else
					StillTime = 0;
			}
			Pawn(Owner).PlayRecoil(FiringSpeed);
			TraceFire(0.0);
			AimError = Default.AimError;
			ClientFire(Value);
		}
	}


	function BeginState()
	{
		bPointing = false;
		SetTimer(0.4 + 1.6 * FRand(), false);
		Super.BeginState();
	}

	function EndState()
	{	
		SetTimer(0.0, false);
		Super.EndState();
	}
	
Begin:
	bPointing=False;
	if ( AmmoType.AmmoAmount<=0 ) 
		Pawn(Owner).SwitchToBestWeapon();  //Goto Weapon that has Ammo
	if ( Pawn(Owner).bFire!=0 ) Fire(0.0);
	Disable('AnimEnd');
	PlayIdleAnim();
}

///////////////////////////////////////////////////////
state Zooming
{
	simulated function Tick(float DeltaTime)
	{
		if ( Pawn(Owner).bAltFire == 0 )
		{
			if ( (PlayerPawn(Owner) != None) && PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).StopZoom();
			SetTimer(0.0,False);
			GoToState('Idle');
		}
	}

	simulated function BeginState()
	{
		if ( Owner.IsA('PlayerPawn') )
		{
			if ( PlayerPawn(Owner).Player.IsA('ViewPort') )
				PlayerPawn(Owner).ToggleZoom();
			SetTimer(0.2,True);
		}
		else
		{
			Pawn(Owner).bFire = 1;
			Pawn(Owner).bAltFire = 0;
			Global.Fire(0);
		}
	}
}

///////////////////////////////////////////////////////////
simulated function PlayIdleAnim()
{
	if ( Mesh != PickupViewMesh )
		PlayAnim('Still',1.0, 0.05);
}

function PostBeginPlay()
{
	Super.PostBeginPlay();
}

state Pickup
{
	simulated function BeginState()
	{
		Super.BeginState();
		SetPickupSkins();
	}
}

simulated function SetOwnerDisplay()
{
	Super.SetOwnerDisplay();
	SetPickupSkins();
}

simulated function setHand(float Hand)
{
	Super.SetHand(Hand);
	SetPickupSkins();
}

simulated function BecomeItem()
{
	Super.BecomeItem();
	SetPickupSkins();
}

simulated function BecomePickup()
{
	Super.BecomePickup();
	SetPickupSkins();
}

simulated function RenderOverlays( canvas Canvas )
{
	if ( PlayerPawn(Owner) != None && PlayerPawn(Owner).ViewTarget == None && !PlayerPawn(Owner).bBehindView )
		SetViewSkins();
	Super.RenderOverlays(Canvas);
	SetPickupSkins();
}

simulated function SetPickupSkins()
{
	if ( Level.NetMode == NM_DedicatedServer )
		return;

	MultiSkins[0] = Default.MultiSkins[0];
	MultiSkins[1] = Default.MultiSkins[1];
	MultiSkins[2] = Default.MultiSkins[2];
	MultiSkins[3] = Default.MultiSkins[3];
	MultiSkins[4] = Default.MultiSkins[4];
	MultiSkins[5] = Default.MultiSkins[5];
	MultiSkins[6] = Default.MultiSkins[6];
}

simulated function SetViewSkins()
{
	if ( Level.NetMode == NM_DedicatedServer )
		return;
	if ( Owner == None )
		SetPickupSkins();

	MultiSkins[0] = UTEPMultiSkin[0];
	MultiSkins[1] = UTEPMultiSkin[1];
	MultiSkins[2] = UTEPMultiSkin[2];
	MultiSkins[3] = UTEPMultiSkin[3];
	MultiSkins[4] = UTEPMultiSkin[4];
	MultiSkins[5] = UTEPMultiSkin[5];
	MultiSkins[6] = UTEPMultiSkin[6];
}

defaultproperties
{
    FireAnims(0)=Fire
    FireAnims(1)=Fire2
    FireAnims(2)=Fire3
    FireAnims(3)=Fire4
    FireAnims(4)=Fire5
    UTEPMultiSkin(0)=Texture'EWRifle2a'
    UTEPMultiSkin(1)=Texture'EWRifle2b'
    UTEPMultiSkin(2)=Texture'EWRifle2c'
    UTEPMultiSkin(3)=Texture'EWRifle2d'
    WeaponDescription="Classification: Long Range Ballistic Sniper Rifle"
    AmmoName=Class'UTEP_BulletBox'
    PickupAmmoCount=8
    bInstantHit=True
    bAltInstantHit=True
    FiringSpeed=1.80
    FireOffset=(X=0.00,Y=-5.00,Z=-2.00),
    MyDamageType=shot
    AltDamageType=Decapitated
    shakemag=400.00
    shaketime=0.15
    shakevert=8.00
    AIRating=0.54
    RefireRate=0.80
    AltRefireRate=0.30
    FireSound=Sound'EWSniperFire'
    SelectSound=Sound'UnrealI.Rifle.RiflePickup'
    DeathMessage="%k put a bullet through %o's head."
    NameColor=(R=0,G=0,B=255,A=0),
    bDrawMuzzleFlash=True
    MuzzleScale=1.00
    FlashY=0.11
    FlashO=0.01
    FlashC=0.03
    FlashLength=0.01
    FlashS=256
    MFTexture=Texture'Botpack.Rifle.MuzzleFlash2'
    AutoSwitchPriority=5
    InventoryGroup=10
    PickupMessage="You picked up a Sniper Rifle."
    ItemName="Sniper Rifle"
    PlayerViewOffset=(X=5.00,Y=-1.60,Z=-1.70),
    PlayerViewMesh=LodMesh'Botpack.Rifle2m'
    PlayerViewScale=2.00
    BobDamping=0.98
    PickupViewMesh=LodMesh'Botpack.RiflePick'
    ThirdPersonMesh=LodMesh'Botpack.RifleHand'
    StatusIcon=Texture'Botpack.Icons.UseRifle'
    bMuzzleFlashParticles=True
    MuzzleFlashStyle=3
    MuzzleFlashMesh=LodMesh'Botpack.muzzsr3'
    MuzzleFlashScale=0.10
    MuzzleFlashTexture=Texture'Botpack.Skins.Muzzy3'
    PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
    Icon=Texture'Botpack.Icons.UseRifle'
    Rotation=(Pitch=0,Yaw=0,Roll=-1536),
    Mesh=LodMesh'Botpack.RiflePick'
    bNoSmooth=False
    MultiSkins(0)=Texture'EWJRifle2'
    MultiSkins(1)=Texture'EWJRifle2'
    MultiSkins(2)=Texture'EWJRifle2'
    MultiSkins(3)=Texture'EWJRifle2'
    CollisionRadius=32.00
    CollisionHeight=8.00
}
