//=============================================================================
// UTEP_STracer.
//=============================================================================
class UTEP_STracer extends Projectile;

simulated function PostBeginPlay()
{
	//log("Spawn"@self@"with role"@Role@"and netmode"@Level.netmode);
	Super.PostBeginPlay();
	Velocity = Speed * vector(Rotation);
	if ( Level.bDropDetail )
		LightType = LT_None;
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	Destroy();
}

simulated function ProcessTouch (Actor Other, vector HitLocation)
{
	If ( Other!=Instigator )
		Destroy();
}

defaultproperties
{
    speed=4000.00
    MaxSpeed=4000.00
    bReplicateInstigator=False
    RemoteRole=2
    LifeSpan=2.00
    Style=3
    Texture=FireTexture'UnrealShare.Effect1.FireEffect1u'
    Mesh=LodMesh'MiniTrace'
    DrawScale=1.15
    AmbientGlow=187
    bUnlit=True
    LightType=1
    LightEffect=13
    LightBrightness=255
    LightHue=30
    LightSaturation=69
    LightRadius=3
}
