//=============================================================================
// UTEP_BulletBox.
//=============================================================================
class UTEP_BulletBox extends TournamentAmmo;

#exec TEXTURE IMPORT NAME=EWBulletBoxT FILE=Textures\EWBulletBoxT.bmp GROUP=Skins LODSET=2 MIPMAPS=OFF

var(Display) Texture UTEPMultiSkin[8];

function PostBeginPlay()
{
	Super.PostBeginPlay();
}

state Pickup
{
	simulated function BeginState()
	{
		Super.BeginState();
		SetPickupSkins();
	}
}

simulated function SetOwnerDisplay()
{
	Super.SetOwnerDisplay();
	SetPickupSkins();
}

simulated function BecomeItem()
{
	Super.BecomeItem();
	SetPickupSkins();
}

simulated function BecomePickup()
{
	Super.BecomePickup();
	SetPickupSkins();
}

simulated function RenderOverlays( canvas Canvas )
{
	if ( PlayerPawn(Owner) != None && PlayerPawn(Owner).ViewTarget == None && !PlayerPawn(Owner).bBehindView )
		SetViewSkins();
	Super.RenderOverlays(Canvas);
	SetPickupSkins();
}

simulated function SetPickupSkins()
{
	if ( Level.NetMode == NM_DedicatedServer )
		return;

	MultiSkins[0] = Default.MultiSkins[0];
	MultiSkins[1] = Default.MultiSkins[1];
	MultiSkins[2] = Default.MultiSkins[2];
	MultiSkins[3] = Default.MultiSkins[3];
	MultiSkins[4] = Default.MultiSkins[4];
	MultiSkins[5] = Default.MultiSkins[5];
	MultiSkins[6] = Default.MultiSkins[6];
}

simulated function SetViewSkins()
{
	if ( Level.NetMode == NM_DedicatedServer )
		return;
	if ( Owner == None )
		SetPickupSkins();

	MultiSkins[0] = UTEPMultiSkin[0];
	MultiSkins[1] = UTEPMultiSkin[1];
	MultiSkins[2] = UTEPMultiSkin[2];
	MultiSkins[3] = UTEPMultiSkin[3];
	MultiSkins[4] = UTEPMultiSkin[4];
	MultiSkins[5] = UTEPMultiSkin[5];
	MultiSkins[6] = UTEPMultiSkin[6];
}

defaultproperties
{
    AmmoAmount=10
    MaxAmmo=50
    UsedInWeaponSlot(9)=1
    PickupMessage="You got a box of Sniper Rifle ammo."
    ItemName="Box of UTEW Rifle Rounds"
    PickupViewMesh=LodMesh'Botpack.BulletBoxM'
    MaxDesireability=0.24
    Icon=Texture'UnrealI.Icons.I_RIFLEAmmo'
    Mesh=LodMesh'Botpack.BulletBoxM'
    MultiSkins(0)=Texture'EWBulletBoxT'
    MultiSkins(1)=Texture'EWBulletBoxT'
    MultiSkins(2)=Texture'EWBulletBoxT'
    MultiSkins(3)=Texture'EWBulletBoxT'
    CollisionRadius=15.00
    CollisionHeight=10.00
    bCollideActors=True
}
